/* ease-image-element.c generated by valac, the Vala compiler
 * generated from ease-image-element.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
typedef struct _EaseElementPrivate EaseElementPrivate;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_ACTOR_CONTEXT (ease_actor_context_get_type ())

#define EASE_TYPE_ACTOR (ease_actor_get_type ())
#define EASE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ACTOR, EaseActor))
#define EASE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ACTOR, EaseActorClass))
#define EASE_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ACTOR))
#define EASE_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ACTOR))
#define EASE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ACTOR, EaseActorClass))

typedef struct _EaseActor EaseActor;
typedef struct _EaseActorClass EaseActorClass;

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;
typedef struct _EaseMediaElementPrivate EaseMediaElementPrivate;

#define EASE_TYPE_IMAGE_ELEMENT (ease_image_element_get_type ())
#define EASE_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElement))
#define EASE_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))
#define EASE_IS_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IS_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IMAGE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))

typedef struct _EaseImageElement EaseImageElement;
typedef struct _EaseImageElementClass EaseImageElementClass;
typedef struct _EaseImageElementPrivate EaseImageElementPrivate;

#define EASE_TYPE_IMAGE_ACTOR (ease_image_actor_get_type ())
#define EASE_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActor))
#define EASE_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))
#define EASE_IS_IMAGE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IS_IMAGE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ACTOR))
#define EASE_IMAGE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ACTOR, EaseImageActorClass))

typedef struct _EaseImageActor EaseImageActor;
typedef struct _EaseImageActorClass EaseImageActorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
typedef struct _Block7Data Block7Data;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

typedef enum  {
	EASE_ACTOR_CONTEXT_PRESENTATION,
	EASE_ACTOR_CONTEXT_EDITOR,
	EASE_ACTOR_CONTEXT_INSPECTOR
} EaseActorContext;

struct _EaseElement {
	GObject parent_instance;
	EaseElementPrivate * priv;
};

struct _EaseElementClass {
	GObjectClass parent_class;
	void (*signals) (EaseElement* self);
	JsonObject* (*to_json) (EaseElement* self);
	void (*to_html) (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
	char** (*claim_media) (EaseElement* self, int* result_length1);
	char* (*html_render) (EaseElement* self, EaseHTMLExporter* exporter);
	void (*cairo_render) (EaseElement* self, cairo_t* context, GError** error);
	EaseActor* (*actor) (EaseElement* self, EaseActorContext c);
	GtkWidget* (*inspector_widget) (EaseElement* self);
	GList* (*tool_items) (EaseElement* self);
	gboolean (*set_color) (EaseElement* self, ClutterColor* c);
	ClutterColor* (*get_color) (EaseElement* self);
};

struct _EaseMediaElement {
	EaseElement parent_instance;
	EaseMediaElementPrivate * priv;
};

struct _EaseMediaElementClass {
	EaseElementClass parent_class;
};

struct _EaseImageElement {
	EaseMediaElement parent_instance;
	EaseImageElementPrivate * priv;
};

struct _EaseImageElementClass {
	EaseMediaElementClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	EaseImageElement * self;
	GtkFileChooserButton* file_b;
};


static gpointer ease_image_element_parent_class = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
GType ease_actor_context_get_type (void) G_GNUC_CONST;
GType ease_actor_get_type (void) G_GNUC_CONST;
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_image_element_get_type (void) G_GNUC_CONST;
enum  {
	EASE_IMAGE_ELEMENT_DUMMY_PROPERTY
};
#define EASE_IMAGE_ELEMENT_UI_FILE_PATH "inspector-element-image.ui"
EaseMediaElement* ease_media_element_construct (GType object_type);
void ease_element_signals (EaseElement* self);
EaseImageElement* ease_image_element_new (void);
EaseImageElement* ease_image_element_construct (GType object_type);
EaseMediaElement* ease_media_element_construct_from_json (GType object_type, JsonObject* obj);
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj);
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj);
EaseImageActor* ease_image_actor_new (EaseImageElement* e, EaseActorContext c);
EaseImageActor* ease_image_actor_construct (GType object_type, EaseImageElement* e, EaseActorContext c);
GType ease_image_actor_get_type (void) G_GNUC_CONST;
static EaseActor* ease_image_element_real_actor (EaseElement* base, EaseActorContext c);
char* ease_data_path (const char* path);
#define EASE_TEMP_UI_DIR "ui"
const char* ease_media_element_get_source_filename (EaseMediaElement* self);
EaseUndoAction* ease_undo_action_new (GObject* obj, const char* prop);
EaseUndoAction* ease_undo_action_construct (GType object_type, GObject* obj, const char* prop);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_undo_action_get_type (void) G_GNUC_CONST;
void ease_undo_action_add (EaseUndoAction* self, GObject* obj, const char* prop);
GType ease_slide_get_type (void) G_GNUC_CONST;
EaseSlide* ease_element_get_parent (EaseElement* self);
GType ease_document_get_type (void) G_GNUC_CONST;
EaseDocument* ease_slide_get_parent (EaseSlide* self);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
void ease_media_element_set_filename (EaseMediaElement* self, const char* value);
void ease_media_element_set_source_filename (EaseMediaElement* self, const char* value);
void ease_error_dialog (const char* title, const char* message);
static void _lambda23_ (GtkFileChooserButton* button, Block7Data* _data7_);
static void __lambda23__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
static void _lambda24_ (GObject* obj, GParamSpec* spec, Block7Data* _data7_);
static void __lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static GtkWidget* ease_image_element_real_inspector_widget (EaseElement* base);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
float ease_element_get_width (EaseElement* self);
float ease_element_get_height (EaseElement* self);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
const char* ease_media_element_get_filename (EaseMediaElement* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
const char* ease_document_get_path (EaseDocument* self);
static char* ease_image_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter);
static void ease_image_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error);



#line 29 "ease-image-element.vala"
EaseImageElement* ease_image_element_construct (GType object_type) {
#line 271 "ease-image-element.c"
	EaseImageElement * self;
#line 29 "ease-image-element.vala"
	self = (EaseImageElement*) ease_media_element_construct (object_type);
#line 31 "ease-image-element.vala"
	ease_element_signals ((EaseElement*) self);
#line 277 "ease-image-element.c"
	return self;
}


#line 29 "ease-image-element.vala"
EaseImageElement* ease_image_element_new (void) {
#line 29 "ease-image-element.vala"
	return ease_image_element_construct (EASE_TYPE_IMAGE_ELEMENT);
#line 286 "ease-image-element.c"
}


#line 34 "ease-image-element.vala"
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj) {
#line 292 "ease-image-element.c"
	EaseImageElement * self;
#line 34 "ease-image-element.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 36 "ease-image-element.vala"
	self = (EaseImageElement*) ease_media_element_construct_from_json (object_type, obj);
#line 298 "ease-image-element.c"
	return self;
}


#line 34 "ease-image-element.vala"
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj) {
#line 34 "ease-image-element.vala"
	return ease_image_element_construct_from_json (EASE_TYPE_IMAGE_ELEMENT, obj);
#line 307 "ease-image-element.c"
}


#line 39 "ease-image-element.vala"
static EaseActor* ease_image_element_real_actor (EaseElement* base, EaseActorContext c) {
#line 313 "ease-image-element.c"
	EaseImageElement * self;
	EaseActor* result = NULL;
	self = (EaseImageElement*) base;
	result = (EaseActor*) g_object_ref_sink (ease_image_actor_new (self, c));
#line 41 "ease-image-element.vala"
	return result;
#line 320 "ease-image-element.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 61 "ease-image-element.vala"
static void _lambda23_ (GtkFileChooserButton* button, Block7Data* _data7_) {
#line 331 "ease-image-element.c"
	EaseImageElement * self;
	GError * _inner_error_;
	EaseUndoAction* action;
	self = _data7_->self;
#line 61 "ease-image-element.vala"
	g_return_if_fail (button != NULL);
#line 338 "ease-image-element.c"
	_inner_error_ = NULL;
#line 63 "ease-image-element.vala"
	action = ease_undo_action_new ((GObject*) self, "filename");
#line 64 "ease-image-element.vala"
	ease_undo_action_add (action, (GObject*) self, "source-filename");
#line 344 "ease-image-element.c"
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
#line 67 "ease-image-element.vala"
		_tmp2_ = (_tmp1_ = ease_document_add_media_file (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self)), _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _data7_->file_b), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 353 "ease-image-element.c"
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
#line 67 "ease-image-element.vala"
		ease_media_element_set_filename ((EaseMediaElement*) self, _tmp3_ = _tmp2_);
#line 359 "ease-image-element.c"
		_g_free0 (_tmp3_);
#line 68 "ease-image-element.vala"
		ease_media_element_set_source_filename ((EaseMediaElement*) self, _tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _data7_->file_b));
#line 363 "ease-image-element.c"
		_g_free0 (_tmp4_);
#line 69 "ease-image-element.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) action);
#line 367 "ease-image-element.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 73 "ease-image-element.vala"
			ease_error_dialog (_ ("Error Inserting Image"), e->message);
#line 378 "ease-image-element.c"
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (action);
}


#line 61 "ease-image-element.vala"
static void __lambda23__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
#line 395 "ease-image-element.c"
	_lambda23_ (_sender, self);
}


#line 77 "ease-image-element.vala"
static void _lambda24_ (GObject* obj, GParamSpec* spec, Block7Data* _data7_) {
#line 402 "ease-image-element.c"
	EaseImageElement * self;
	self = _data7_->self;
#line 77 "ease-image-element.vala"
	g_return_if_fail (obj != NULL);
#line 77 "ease-image-element.vala"
	g_return_if_fail (spec != NULL);
#line 78 "ease-image-element.vala"
	gtk_file_chooser_set_filename ((GtkFileChooser*) _data7_->file_b, ease_media_element_get_source_filename ((EaseMediaElement*) self));
#line 411 "ease-image-element.c"
}


#line 77 "ease-image-element.vala"
static void __lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 417 "ease-image-element.c"
	_lambda24_ (_sender, pspec, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->file_b);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 44 "ease-image-element.vala"
static GtkWidget* ease_image_element_real_inspector_widget (EaseElement* base) {
#line 439 "ease-image-element.c"
	EaseImageElement * self;
	GtkWidget* result = NULL;
	GError * _inner_error_;
	Block7Data* _data7_;
	GtkBuilder* builder;
	GObject* _tmp2_;
	GObject* _tmp3_;
	self = (EaseImageElement*) base;
	_inner_error_ = NULL;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
#line 46 "ease-image-element.vala"
	builder = gtk_builder_new ();
#line 454 "ease-image-element.c"
	{
		char* _tmp1_;
		char* _tmp0_;
#line 49 "ease-image-element.vala"
		gtk_builder_add_from_file (builder, _tmp1_ = ease_data_path (_tmp0_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_IMAGE_ELEMENT_UI_FILE_PATH, NULL)), &_inner_error_);
#line 460 "ease-image-element.c"
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 52 "ease-image-element.vala"
			g_error ("ease-image-element.vala:52: Error loading UI: %s", e->message);
#line 476 "ease-image-element.c"
			_g_error_free0 (e);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block7_data_unref (_data7_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 55 "ease-image-element.vala"
	gtk_builder_connect_signals (builder, self);
#line 490 "ease-image-element.c"
	_data7_->file_b = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "file-button"), GTK_IS_FILE_CHOOSER_BUTTON (_tmp2_) ? ((GtkFileChooserButton*) _tmp2_) : NULL));
#line 59 "ease-image-element.vala"
	gtk_file_chooser_set_filename ((GtkFileChooser*) _data7_->file_b, ease_media_element_get_source_filename ((EaseMediaElement*) self));
#line 61 "ease-image-element.vala"
	g_signal_connect_data (_data7_->file_b, "file-set", (GCallback) __lambda23__gtk_file_chooser_button_file_set, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 77 "ease-image-element.vala"
	g_signal_connect_data ((GObject*) self, "notify::source-filename", (GCallback) __lambda24__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 498 "ease-image-element.c"
	result = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "root"), GTK_IS_WIDGET (_tmp3_) ? ((GtkWidget*) _tmp3_) : NULL));
	_g_object_unref0 (builder);
	block7_data_unref (_data7_);
#line 82 "ease-image-element.vala"
	return result;
#line 504 "ease-image-element.c"
	_g_object_unref0 (builder);
	block7_data_unref (_data7_);
}


#line 85 "ease-image-element.vala"
static char* ease_image_element_real_html_render (EaseElement* base, EaseHTMLExporter* exporter) {
#line 512 "ease-image-element.c"
	EaseImageElement * self;
	char* result = NULL;
	char* html;
	char* _tmp0_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp12_;
	char* _tmp11_;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp16_;
	char* _tmp15_;
	char* _tmp14_;
	char* _tmp13_;
	char* _tmp17_;
	char* _tmp23_;
	char* _tmp22_;
	char* _tmp21_;
	char* _tmp20_;
	char* _tmp19_;
	char* _tmp18_;
	self = (EaseImageElement*) base;
#line 85 "ease-image-element.vala"
	g_return_val_if_fail (exporter != NULL, NULL);
#line 88 "ease-image-element.vala"
	html = g_strdup ("<img class=\"image element\" ");
#line 91 "ease-image-element.vala"
	html = (_tmp0_ = g_strconcat (html, "style=\"", NULL), _g_free0 (html), _tmp0_);
#line 92 "ease-image-element.vala"
	html = (_tmp4_ = g_strconcat (html, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("left:", _tmp1_ = g_strdup_printf ("%g", ease_element_get_x ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp4_);
#line 549 "ease-image-element.c"
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
#line 93 "ease-image-element.vala"
	html = (_tmp8_ = g_strconcat (html, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (" top:", _tmp5_ = g_strdup_printf ("%g", ease_element_get_y ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp8_);
#line 555 "ease-image-element.c"
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
#line 94 "ease-image-element.vala"
	html = (_tmp12_ = g_strconcat (html, _tmp11_ = g_strconcat (_tmp10_ = g_strconcat (" width:", _tmp9_ = g_strdup_printf ("%g", ease_element_get_width ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp12_);
#line 561 "ease-image-element.c"
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp9_);
#line 95 "ease-image-element.vala"
	html = (_tmp16_ = g_strconcat (html, _tmp15_ = g_strconcat (_tmp14_ = g_strconcat (" height:", _tmp13_ = g_strdup_printf ("%g", ease_element_get_height ((EaseElement*) self)), NULL), "px;", NULL), NULL), _g_free0 (html), _tmp16_);
#line 567 "ease-image-element.c"
	_g_free0 (_tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp13_);
#line 96 "ease-image-element.vala"
	html = (_tmp17_ = g_strconcat (html, " position: absolute;\" ", NULL), _g_free0 (html), _tmp17_);
#line 99 "ease-image-element.vala"
	html = (_tmp23_ = g_strconcat (html, _tmp22_ = g_strconcat (_tmp21_ = g_strconcat (_tmp20_ = g_strconcat (_tmp19_ = g_strconcat ("src=\"", _tmp18_ = ease_html_exporter_get_basename (exporter), NULL), " ", NULL), ease_media_element_get_filename ((EaseMediaElement*) self), NULL), "\" alt=\"Image\" />", NULL), NULL), _g_free0 (html), _tmp23_);
#line 575 "ease-image-element.c"
	_g_free0 (_tmp22_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp18_);
#line 103 "ease-image-element.vala"
	ease_html_exporter_copy_file (exporter, ease_media_element_get_filename ((EaseMediaElement*) self), ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))));
#line 583 "ease-image-element.c"
	result = html;
#line 105 "ease-image-element.vala"
	return result;
#line 587 "ease-image-element.c"
}


#line 111 "ease-image-element.vala"
static void ease_image_element_real_cairo_render (EaseElement* base, cairo_t* context, GError** error) {
#line 593 "ease-image-element.c"
	EaseImageElement * self;
	GError * _inner_error_;
	char* filename;
	GdkPixbuf* pixbuf;
	self = (EaseImageElement*) base;
#line 111 "ease-image-element.vala"
	g_return_if_fail (context != NULL);
#line 601 "ease-image-element.c"
	_inner_error_ = NULL;
#line 113 "ease-image-element.vala"
	filename = g_build_path ("/", ease_document_get_path (ease_slide_get_parent (ease_element_get_parent ((EaseElement*) self))), ease_media_element_get_filename ((EaseMediaElement*) self), NULL);
#line 116 "ease-image-element.vala"
	pixbuf = gdk_pixbuf_new_from_file_at_scale (filename, (gint) ease_element_get_width ((EaseElement*) self), (gint) ease_element_get_height ((EaseElement*) self), FALSE, &_inner_error_);
#line 607 "ease-image-element.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filename);
		return;
	}
#line 121 "ease-image-element.vala"
	gdk_cairo_set_source_pixbuf (context, pixbuf, (double) 0, (double) 0);
#line 123 "ease-image-element.vala"
	cairo_rectangle (context, (double) 0, (double) 0, (double) ease_element_get_width ((EaseElement*) self), (double) ease_element_get_height ((EaseElement*) self));
#line 124 "ease-image-element.vala"
	cairo_fill (context);
#line 619 "ease-image-element.c"
	_g_object_unref0 (pixbuf);
	_g_free0 (filename);
}


static void ease_image_element_class_init (EaseImageElementClass * klass) {
	ease_image_element_parent_class = g_type_class_peek_parent (klass);
	EASE_ELEMENT_CLASS (klass)->actor = ease_image_element_real_actor;
	EASE_ELEMENT_CLASS (klass)->inspector_widget = ease_image_element_real_inspector_widget;
	EASE_ELEMENT_CLASS (klass)->html_render = ease_image_element_real_html_render;
	EASE_ELEMENT_CLASS (klass)->cairo_render = ease_image_element_real_cairo_render;
}


static void ease_image_element_instance_init (EaseImageElement * self) {
}


GType ease_image_element_get_type (void) {
	static volatile gsize ease_image_element_type_id__volatile = 0;
	if (g_once_init_enter (&ease_image_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseImageElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_image_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseImageElement), 0, (GInstanceInitFunc) ease_image_element_instance_init, NULL };
		GType ease_image_element_type_id;
		ease_image_element_type_id = g_type_register_static (EASE_TYPE_MEDIA_ELEMENT, "EaseImageElement", &g_define_type_info, 0);
		g_once_init_leave (&ease_image_element_type_id__volatile, ease_image_element_type_id);
	}
	return ease_image_element_type_id__volatile;
}




