/* ease-close-confirm-dialog.c generated by valac, the Vala compiler
 * generated from ease-close-confirm-dialog.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define EASE_TYPE_CLOSE_CONFIRM_DIALOG (ease_close_confirm_dialog_get_type ())
#define EASE_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialog))
#define EASE_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))
#define EASE_IS_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_IS_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_CLOSE_CONFIRM_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))

typedef struct _EaseCloseConfirmDialog EaseCloseConfirmDialog;
typedef struct _EaseCloseConfirmDialogClass EaseCloseConfirmDialogClass;
typedef struct _EaseCloseConfirmDialogPrivate EaseCloseConfirmDialogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _EaseCloseConfirmDialog {
	GtkDialog parent_instance;
	EaseCloseConfirmDialogPrivate * priv;
};

struct _EaseCloseConfirmDialogClass {
	GtkDialogClass parent_class;
};


static gpointer ease_close_confirm_dialog_parent_class = NULL;

GType ease_close_confirm_dialog_get_type (void) G_GNUC_CONST;
enum  {
	EASE_CLOSE_CONFIRM_DIALOG_DUMMY_PROPERTY
};
#define EASE_CLOSE_CONFIRM_DIALOG_TOP_FORMAT "<b><big>%s</big></b>"
static char* ease_close_confirm_dialog_top_label_text (const char* filename);
static char* ease_close_confirm_dialog_bottom_label_text (gint seconds);
EaseCloseConfirmDialog* ease_close_confirm_dialog_new (const char* filename, gint seconds);
EaseCloseConfirmDialog* ease_close_confirm_dialog_construct (GType object_type, const char* filename, gint seconds);



#line 36 "ease-close-confirm-dialog.vala"
EaseCloseConfirmDialog* ease_close_confirm_dialog_construct (GType object_type, const char* filename, gint seconds) {
#line 71 "ease-close-confirm-dialog.c"
	EaseCloseConfirmDialog * self;
	GtkImage* image;
	GtkLabel* top_label;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* bottom_label;
	GtkVBox* vbox;
	GtkHBox* hbox;
	GtkWidget* _tmp4_;
#line 36 "ease-close-confirm-dialog.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 85 "ease-close-confirm-dialog.c"
	self = g_object_newv (object_type, 0, NULL);
#line 38 "ease-close-confirm-dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _ ("Save before closing?"));
#line 39 "ease-close-confirm-dialog.vala"
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
#line 42 "ease-close-confirm-dialog.vala"
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_DIALOG));
#line 44 "ease-close-confirm-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) image, 0.5f, (float) 0);
#line 47 "ease-close-confirm-dialog.vala"
	top_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
#line 48 "ease-close-confirm-dialog.vala"
	g_object_set (top_label, "wrap", TRUE, NULL);
#line 49 "ease-close-confirm-dialog.vala"
	gtk_label_set_use_markup (top_label, TRUE);
#line 50 "ease-close-confirm-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) top_label, (float) 0, 0.5f);
#line 51 "ease-close-confirm-dialog.vala"
	gtk_label_set_selectable (top_label, TRUE);
#line 52 "ease-close-confirm-dialog.vala"
	g_object_set ((GtkWidget*) top_label, "can-focus", FALSE, NULL);
#line 53 "ease-close-confirm-dialog.vala"
	gtk_label_set_markup (top_label, _tmp1_ = g_strdup_printf (EASE_CLOSE_CONFIRM_DIALOG_TOP_FORMAT, _tmp0_ = ease_close_confirm_dialog_top_label_text (filename)));
#line 109 "ease-close-confirm-dialog.c"
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 56 "ease-close-confirm-dialog.vala"
	bottom_label = (_tmp3_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp2_ = ease_close_confirm_dialog_bottom_label_text (seconds))), _g_free0 (_tmp2_), _tmp3_);
#line 57 "ease-close-confirm-dialog.vala"
	g_object_set (bottom_label, "wrap", TRUE, NULL);
#line 58 "ease-close-confirm-dialog.vala"
	gtk_misc_set_alignment ((GtkMisc*) bottom_label, (float) 0, 0.5f);
#line 59 "ease-close-confirm-dialog.vala"
	gtk_label_set_selectable (bottom_label, TRUE);
#line 60 "ease-close-confirm-dialog.vala"
	g_object_set ((GtkWidget*) bottom_label, "can-focus", FALSE, NULL);
#line 63 "ease-close-confirm-dialog.vala"
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 12));
#line 64 "ease-close-confirm-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) top_label, FALSE, FALSE, (guint) 0);
#line 65 "ease-close-confirm-dialog.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_label, FALSE, FALSE, (guint) 0);
#line 68 "ease-close-confirm-dialog.vala"
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 12));
#line 69 "ease-close-confirm-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
#line 70 "ease-close-confirm-dialog.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
#line 71 "ease-close-confirm-dialog.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
#line 73 "ease-close-confirm-dialog.vala"
	gtk_box_pack_start ((_tmp4_ = gtk_dialog_get_content_area ((GtkDialog*) self), GTK_IS_BOX (_tmp4_) ? ((GtkBox*) _tmp4_) : NULL), (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
#line 74 "ease-close-confirm-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) hbox);
#line 77 "ease-close-confirm-dialog.vala"
	gtk_dialog_add_buttons ((GtkDialog*) self, _ ("Close _without Saving"), GTK_RESPONSE_NO, "gtk-cancel", GTK_RESPONSE_CANCEL, "gtk-save", GTK_RESPONSE_YES, NULL);
#line 81 "ease-close-confirm-dialog.vala"
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_YES);
#line 144 "ease-close-confirm-dialog.c"
	_g_object_unref0 (image);
	_g_object_unref0 (top_label);
	_g_object_unref0 (bottom_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	return self;
}


#line 36 "ease-close-confirm-dialog.vala"
EaseCloseConfirmDialog* ease_close_confirm_dialog_new (const char* filename, gint seconds) {
#line 36 "ease-close-confirm-dialog.vala"
	return ease_close_confirm_dialog_construct (EASE_TYPE_CLOSE_CONFIRM_DIALOG, filename, seconds);
#line 158 "ease-close-confirm-dialog.c"
}


#line 90 "ease-close-confirm-dialog.vala"
static char* ease_close_confirm_dialog_bottom_label_text (gint seconds) {
#line 164 "ease-close-confirm-dialog.c"
	char* result = NULL;
	gint hours;
#line 92 "ease-close-confirm-dialog.vala"
	seconds = MAX (1, seconds);
#line 94 "ease-close-confirm-dialog.vala"
	if (seconds < 55) {
#line 171 "ease-close-confirm-dialog.c"
		result = g_strdup_printf (ngettext ("If you don't save, changes from the last second will be permanently lo" \
"st.", "If you don't save, changes from the last %i seconds will be permanentl" \
"y lost.", (gulong) seconds), seconds);
#line 96 "ease-close-confirm-dialog.vala"
		return result;
#line 175 "ease-close-confirm-dialog.c"
	}
#line 98 "ease-close-confirm-dialog.vala"
	if (seconds < 75) {
#line 179 "ease-close-confirm-dialog.c"
		result = g_strdup (_ ("If you don't save, changes from the last minute will be permanently lo" \
"st."));
#line 100 "ease-close-confirm-dialog.vala"
		return result;
#line 183 "ease-close-confirm-dialog.c"
	}
#line 102 "ease-close-confirm-dialog.vala"
	if (seconds < 110) {
#line 187 "ease-close-confirm-dialog.c"
		result = g_strdup_printf (ngettext ("If you don't save, changes from the last minute and %i second will be " \
"permanently lost.", "If you don't save, changes from the last minute and %i seconds will be" \
" permanently lost.", (gulong) (seconds - 60)), seconds - 60);
#line 104 "ease-close-confirm-dialog.vala"
		return result;
#line 191 "ease-close-confirm-dialog.c"
	}
#line 106 "ease-close-confirm-dialog.vala"
	if (seconds < 3600) {
#line 195 "ease-close-confirm-dialog.c"
		result = g_strdup_printf (ngettext ("If you don't save, changes from the last %i minute will be permanently" \
" lost.", "If you don't save, changes from the last %i minutes will be permanentl" \
"y lost.", (gulong) (seconds / 60)), seconds / 60);
#line 108 "ease-close-confirm-dialog.vala"
		return result;
#line 199 "ease-close-confirm-dialog.c"
	}
#line 110 "ease-close-confirm-dialog.vala"
	if (seconds < 7200) {
#line 203 "ease-close-confirm-dialog.c"
		gint minutes;
#line 112 "ease-close-confirm-dialog.vala"
		minutes = (seconds - 3600) / 60;
#line 113 "ease-close-confirm-dialog.vala"
		if (minutes < 5) {
#line 209 "ease-close-confirm-dialog.c"
			result = g_strdup (_ ("If you don't save, changes from the last hour will be permanently lost" \
"."));
#line 115 "ease-close-confirm-dialog.vala"
			return result;
#line 213 "ease-close-confirm-dialog.c"
		}
		result = g_strdup_printf (ngettext ("If you don't save, changes from the last hour and %i minute will be pe" \
"rmanently lost.", "If you don't save, changes from the last hour and %i minutes will be p" \
"ermanently lost.", (gulong) minutes), minutes);
#line 117 "ease-close-confirm-dialog.vala"
		return result;
#line 218 "ease-close-confirm-dialog.c"
	}
#line 120 "ease-close-confirm-dialog.vala"
	hours = seconds / 3600;
#line 222 "ease-close-confirm-dialog.c"
	result = g_strdup_printf (ngettext ("If you don't save, changes from the last %i hour will be permanently l" \
"ost.", "If you don't save, changes from the last %i hours will be permanently " \
"lost.", (gulong) hours), hours);
#line 121 "ease-close-confirm-dialog.vala"
	return result;
#line 226 "ease-close-confirm-dialog.c"
}


#line 130 "ease-close-confirm-dialog.vala"
static char* ease_close_confirm_dialog_top_label_text (const char* filename) {
#line 232 "ease-close-confirm-dialog.c"
	char* result = NULL;
#line 130 "ease-close-confirm-dialog.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 236 "ease-close-confirm-dialog.c"
	result = g_strdup_printf (_ ("Save changes to \"%s\" before closing?"), filename);
#line 132 "ease-close-confirm-dialog.vala"
	return result;
#line 240 "ease-close-confirm-dialog.c"
}


static void ease_close_confirm_dialog_class_init (EaseCloseConfirmDialogClass * klass) {
	ease_close_confirm_dialog_parent_class = g_type_class_peek_parent (klass);
}


static void ease_close_confirm_dialog_instance_init (EaseCloseConfirmDialog * self) {
}


GType ease_close_confirm_dialog_get_type (void) {
	static volatile gsize ease_close_confirm_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&ease_close_confirm_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseCloseConfirmDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_close_confirm_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseCloseConfirmDialog), 0, (GInstanceInitFunc) ease_close_confirm_dialog_instance_init, NULL };
		GType ease_close_confirm_dialog_type_id;
		ease_close_confirm_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "EaseCloseConfirmDialog", &g_define_type_info, 0);
		g_once_init_leave (&ease_close_confirm_dialog_type_id__volatile, ease_close_confirm_dialog_type_id);
	}
	return ease_close_confirm_dialog_type_id__volatile;
}




