/* ease-dialogs.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-dialogs.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdarg.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_DIALOG_TYPE_DIALOG_CODE (ease_dialog_dialog_code_get_type ())
typedef struct _Block5Data Block5Data;

typedef void (*EaseDialogFileChooserDialogExtension) (GtkFileChooserDialog* d, void* user_data);
typedef enum  {
	EASE_DIALOG_DIALOG_CODE_ACCEPT,
	EASE_DIALOG_DIALOG_CODE_REJECT,
	EASE_DIALOG_DIALOG_CODE_REINVOKE
} EaseDialogDialogCode;

typedef EaseDialogDialogCode (*EaseDialogFileChooserDialogVerify) (GtkFileChooserDialog* d, void* user_data);
struct _Block5Data {
	int _ref_count_;
	GtkWindow* modal;
};



#define EASE_DIALOG_VERIFY_EASE_SECONDARY _ ("The specified filename does not end with a \".ease\" extension. Would " \
"you like to append one?")
#define EASE_DIALOG_VERIFY_EASE_PRIMARY _ ("Append .ease?")
#define EASE_DIALOG_VERIFY_OVERWRITE_TITLE _ ("Replace %s?")
#define EASE_DIALOG_VERIFY_OVERWRITE_FMT _ ("A file named %s already exists. Do you want to replace it?")
#define EASE_DIALOG_VERIFY_OVERWRITE_SECONDARY_FMT _ ("This file already exists in the directory \"%s\". Overwriting it will " \
"replace its contents.")
GtkResponseType ease_dialog_message (GtkMessageType message_type, const char* title, const char* main_text, const char* secondary_text, GtkWindow* modal, GtkResponseType default_response, ...);
GtkResponseType ease_dialog_question (const char* title, const char* main_text, const char* secondary_text, GtkWindow* modal, GtkResponseType default_response, ...);
char* ease_dialog_open (const char* title, GtkWindow* modal);
char* ease_dialog_open_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
char* ease_dialog_open_document (GtkWindow* modal);
static void _lambda74_ (GtkFileChooserDialog* dialog);
static void __lambda74__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
char* ease_dialog_save (const char* title, GtkWindow* modal);
GType ease_dialog_dialog_code_get_type (void) G_GNUC_CONST;
char* ease_dialog_save_real (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target, EaseDialogFileChooserDialogVerify verify, void* verify_target);
char* ease_dialog_save_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target);
char* ease_dialog_save_verified (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target, EaseDialogFileChooserDialogVerify verify, void* verify_target);
char* ease_dialog_save_document (const char* title, GtkWindow* modal);
static void _lambda75_ (GtkFileChooserDialog* dialog);
static void __lambda75__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
static EaseDialogDialogCode _lambda76_ (GtkFileChooserDialog* dialog, Block5Data* _data5_);
static EaseDialogDialogCode __lambda76__ease_dialog_file_chooser_dialog_verify (GtkFileChooserDialog* d, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



/**
 * Displays a message dialog.
 *
 * The varargs provide text or stock IDs for buttons. These should be
 * paired with a Gtk.ResponseType. The list must be terminated with null.
 *
 * @param message_type The GtkMessageType for the dialog.
 * @param title The title of the dialog.
 * @param main_text The large text displayed on the dialog.
 * @param secondary_text The secondary (small) text on the dialog.
 * @param modal A window that the dialog should be modal for.
 * @param default_response The default response for the dialog.
 */
#line 46 "ease-dialogs.vala"
GtkResponseType ease_dialog_message (GtkMessageType message_type, const char* title, const char* main_text, const char* secondary_text, GtkWindow* modal, GtkResponseType default_response, ...) {
#line 97 "ease-dialogs.c"
	GtkResponseType result = 0;
	GtkMessageDialog* dialog;
	gboolean _tmp0_;
	va_list l;
	GtkResponseType ret;
#line 46 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, 0);
#line 46 "ease-dialogs.vala"
	g_return_val_if_fail (main_text != NULL, 0);
#line 46 "ease-dialogs.vala"
	g_return_val_if_fail (secondary_text != NULL, 0);
#line 52 "ease-dialogs.vala"
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new_with_markup (modal, GTK_DIALOG_MODAL, message_type, 0, NULL, NULL));
#line 57 "ease-dialogs.vala"
	g_object_set (dialog, "use-markup", (g_object_set (dialog, "secondary-use-markup", TRUE, NULL), (g_object_get (dialog, "secondary-use-markup", &_tmp0_, NULL), _tmp0_)), NULL);
#line 58 "ease-dialogs.vala"
	g_object_set (dialog, "text", main_text, NULL);
#line 59 "ease-dialogs.vala"
	g_object_set (dialog, "secondary-text", secondary_text, NULL);
#line 117 "ease-dialogs.c"
	va_start (l, default_response);
#line 63 "ease-dialogs.vala"
	while (TRUE) {
#line 121 "ease-dialogs.c"
		char* button;
		GtkResponseType type;
#line 66 "ease-dialogs.vala"
		button = g_strdup (va_arg (l, char*));
#line 67 "ease-dialogs.vala"
		if (button == NULL) {
#line 128 "ease-dialogs.c"
			_g_free0 (button);
#line 67 "ease-dialogs.vala"
			break;
#line 132 "ease-dialogs.c"
		}
#line 68 "ease-dialogs.vala"
		type = va_arg (l, GtkResponseType);
#line 71 "ease-dialogs.vala"
		gtk_dialog_add_button ((GtkDialog*) dialog, button, (gint) type);
#line 138 "ease-dialogs.c"
		_g_free0 (button);
	}
#line 75 "ease-dialogs.vala"
	gtk_dialog_set_default_response ((GtkDialog*) dialog, (gint) default_response);
#line 78 "ease-dialogs.vala"
	ret = (GtkResponseType) gtk_dialog_run ((GtkDialog*) dialog);
#line 79 "ease-dialogs.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 147 "ease-dialogs.c"
	result = ret;
	va_end (l);
	_g_object_unref0 (dialog);
#line 80 "ease-dialogs.vala"
	return result;
#line 153 "ease-dialogs.c"
}


/**
 * Displays a question dialog.
 *
 * The varargs provide text or stock IDs for buttons. These should be
 * paired with a Gtk.ResponseType. The list must be terminated with null.
 *
 * @param title The title of the dialog.
 * @param main_text The large text displayed on the dialog.
 * @param secondary_text The secondary (small) text on the dialog.
 * @param modal A window that the dialog should be modal for.
 * @param default_response The default response for the dialog.
 */
#line 95 "ease-dialogs.vala"
GtkResponseType ease_dialog_question (const char* title, const char* main_text, const char* secondary_text, GtkWindow* modal, GtkResponseType default_response, ...) {
#line 171 "ease-dialogs.c"
	GtkResponseType result = 0;
	GtkMessageDialog* dialog;
	gboolean _tmp0_;
	va_list l;
	GtkResponseType ret;
#line 95 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, 0);
#line 95 "ease-dialogs.vala"
	g_return_val_if_fail (main_text != NULL, 0);
#line 95 "ease-dialogs.vala"
	g_return_val_if_fail (secondary_text != NULL, 0);
#line 100 "ease-dialogs.vala"
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new_with_markup (modal, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, 0, NULL, NULL));
#line 105 "ease-dialogs.vala"
	g_object_set (dialog, "use-markup", (g_object_set (dialog, "secondary-use-markup", TRUE, NULL), (g_object_get (dialog, "secondary-use-markup", &_tmp0_, NULL), _tmp0_)), NULL);
#line 106 "ease-dialogs.vala"
	g_object_set (dialog, "text", main_text, NULL);
#line 107 "ease-dialogs.vala"
	g_object_set (dialog, "secondary-text", secondary_text, NULL);
#line 191 "ease-dialogs.c"
	va_start (l, default_response);
#line 111 "ease-dialogs.vala"
	while (TRUE) {
#line 195 "ease-dialogs.c"
		char* button;
		GtkResponseType type;
#line 114 "ease-dialogs.vala"
		button = g_strdup (va_arg (l, char*));
#line 115 "ease-dialogs.vala"
		if (button == NULL) {
#line 202 "ease-dialogs.c"
			_g_free0 (button);
#line 115 "ease-dialogs.vala"
			break;
#line 206 "ease-dialogs.c"
		}
#line 116 "ease-dialogs.vala"
		type = va_arg (l, GtkResponseType);
#line 119 "ease-dialogs.vala"
		gtk_dialog_add_button ((GtkDialog*) dialog, button, (gint) type);
#line 212 "ease-dialogs.c"
		_g_free0 (button);
	}
#line 123 "ease-dialogs.vala"
	gtk_dialog_set_default_response ((GtkDialog*) dialog, (gint) default_response);
#line 126 "ease-dialogs.vala"
	ret = (GtkResponseType) gtk_dialog_run ((GtkDialog*) dialog);
#line 127 "ease-dialogs.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 221 "ease-dialogs.c"
	result = ret;
	va_end (l);
	_g_object_unref0 (dialog);
#line 128 "ease-dialogs.vala"
	return result;
#line 227 "ease-dialogs.c"
}


/**
 * Displays an "Open" dialog with the specified title. Returns null if
 * cancelled, otherwise returns the selected path.
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 */
#line 138 "ease-dialogs.vala"
char* ease_dialog_open (const char* title, GtkWindow* modal) {
#line 240 "ease-dialogs.c"
	char* result = NULL;
#line 138 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 244 "ease-dialogs.c"
	result = ease_dialog_open_ext (title, modal, NULL, NULL);
#line 140 "ease-dialogs.vala"
	return result;
#line 248 "ease-dialogs.c"
}


/**
 * Displays an "Open" dialog with the specified title. The
 * {@link FileChooserDialogExtension} can be used to modify the
 * dialog before it is displayed. Returns null if cancelled, otherwise
 * returns the selected path.
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 * @param ext A function to modify the dialog before it is displayed.
 */
#line 153 "ease-dialogs.vala"
char* ease_dialog_open_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target) {
#line 264 "ease-dialogs.c"
	char* result = NULL;
	GtkFileChooserDialog* dialog;
#line 153 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 156 "ease-dialogs.vala"
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (title, modal, GTK_FILE_CHOOSER_ACTION_OPEN, "gtk-cancel", GTK_RESPONSE_CANCEL, "gtk-open", GTK_RESPONSE_ACCEPT, NULL));
#line 163 "ease-dialogs.vala"
	if (ext != NULL) {
#line 163 "ease-dialogs.vala"
		ext (dialog, ext_target);
#line 275 "ease-dialogs.c"
	}
#line 165 "ease-dialogs.vala"
	if (gtk_dialog_run ((GtkDialog*) dialog) == GTK_RESPONSE_ACCEPT) {
#line 279 "ease-dialogs.c"
		char* name;
#line 167 "ease-dialogs.vala"
		name = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog);
#line 168 "ease-dialogs.vala"
		gtk_object_destroy ((GtkObject*) dialog);
#line 285 "ease-dialogs.c"
		result = name;
		_g_object_unref0 (dialog);
#line 169 "ease-dialogs.vala"
		return result;
#line 290 "ease-dialogs.c"
	}
#line 171 "ease-dialogs.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 294 "ease-dialogs.c"
	result = NULL;
	_g_object_unref0 (dialog);
#line 172 "ease-dialogs.vala"
	return result;
#line 299 "ease-dialogs.c"
}


/**
 * Displays an "Open" dialog for an Ease {@link Document}. Returns null if
 * cancelled, otherwise returns the selected path.
 *
 * @param modal The window that the dialog should be modal for.
 */
#line 183 "ease-dialogs.vala"
static void _lambda74_ (GtkFileChooserDialog* dialog) {
#line 311 "ease-dialogs.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 183 "ease-dialogs.vala"
	g_return_if_fail (dialog != NULL);
#line 185 "ease-dialogs.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 186 "ease-dialogs.vala"
	gtk_file_filter_add_pattern (filter, "*.ease");
#line 187 "ease-dialogs.vala"
	gtk_file_filter_set_name (filter, _ ("Ease Presentations"));
#line 188 "ease-dialogs.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 191 "ease-dialogs.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 192 "ease-dialogs.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 193 "ease-dialogs.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 194 "ease-dialogs.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 332 "ease-dialogs.c"
	_g_object_unref0 (filter);
}


#line 183 "ease-dialogs.vala"
static void __lambda74__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 339 "ease-dialogs.c"
	_lambda74_ (d);
}


#line 181 "ease-dialogs.vala"
char* ease_dialog_open_document (GtkWindow* modal) {
#line 346 "ease-dialogs.c"
	char* result = NULL;
	result = ease_dialog_open_ext (_ ("Open Document"), modal, __lambda74__ease_dialog_file_chooser_dialog_extension, NULL);
#line 183 "ease-dialogs.vala"
	return result;
#line 351 "ease-dialogs.c"
}


/**
 * Displays an "Save" dialog with the specified title. Returns null if
 * cancelled, otherwise returns the selected path.
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 */
#line 205 "ease-dialogs.vala"
char* ease_dialog_save (const char* title, GtkWindow* modal) {
#line 364 "ease-dialogs.c"
	char* result = NULL;
#line 205 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 368 "ease-dialogs.c"
	result = ease_dialog_save_real (title, modal, NULL, NULL, NULL, NULL);
#line 207 "ease-dialogs.vala"
	return result;
#line 372 "ease-dialogs.c"
}


/**
 * Displays an "Save" dialog with the specified title. The
 * {@link FileChooserDialogExtension} can be used to modify the
 * dialog before it is displayed. Returns null if cancelled, otherwise
 * returns the selected path.
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 * @param ext A function to modify the dialog before it is displayed.
 */
#line 220 "ease-dialogs.vala"
char* ease_dialog_save_ext (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target) {
#line 388 "ease-dialogs.c"
	char* result = NULL;
#line 220 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 392 "ease-dialogs.c"
	result = ease_dialog_save_real (title, modal, ext, ext_target, NULL, NULL);
#line 223 "ease-dialogs.vala"
	return result;
#line 396 "ease-dialogs.c"
}


/**
 * Displays an "Save" dialog with the specified title. The
 * {@link FileChooserDialogExtension} can be used to modify the
 * dialog before it is displayed. Upon completion, a
 * {@link FileChooserDialogVerify} can be used to modify the return value
 * of the dialog. Returns null if cancelled, otherwise returns the selected
 * path (with any modifications).
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 * @param ext A function to modify the dialog before it is displayed.
 * @param verify A function to verify the dialog's return path.
 */
#line 239 "ease-dialogs.vala"
char* ease_dialog_save_verified (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target, EaseDialogFileChooserDialogVerify verify, void* verify_target) {
#line 415 "ease-dialogs.c"
	char* result = NULL;
#line 239 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 419 "ease-dialogs.c"
	result = ease_dialog_save_real (title, modal, ext, ext_target, verify, verify_target);
#line 243 "ease-dialogs.vala"
	return result;
#line 423 "ease-dialogs.c"
}


/**
 * Displays an "Save" dialog for an Ease {@link Document}. Returns null if
 * cancelled, otherwise returns the selected path. The title parameter
 * is provided to differentiate between "Save", "Save as", etc.
 *
 * @param title The dialog's title.
 * @param modal The window that the dialog should be modal for.
 */
#line 259 "ease-dialogs.vala"
static void _lambda75_ (GtkFileChooserDialog* dialog) {
#line 437 "ease-dialogs.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 259 "ease-dialogs.vala"
	g_return_if_fail (dialog != NULL);
#line 261 "ease-dialogs.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 262 "ease-dialogs.vala"
	gtk_file_filter_add_pattern (filter, "*.ease");
#line 263 "ease-dialogs.vala"
	gtk_file_filter_set_name (filter, _ ("Ease Presentations"));
#line 264 "ease-dialogs.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 267 "ease-dialogs.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 268 "ease-dialogs.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 269 "ease-dialogs.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 270 "ease-dialogs.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 458 "ease-dialogs.c"
	_g_object_unref0 (filter);
}


#line 259 "ease-dialogs.vala"
static void __lambda75__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 465 "ease-dialogs.c"
	_lambda75_ (d);
}


#line 274 "ease-dialogs.vala"
static EaseDialogDialogCode _lambda76_ (GtkFileChooserDialog* dialog, Block5Data* _data5_) {
#line 472 "ease-dialogs.c"
	EaseDialogDialogCode result = 0;
	char* _tmp0_;
	char* _tmp1_;
	char* filename;
	gboolean has_suffix;
	char* _tmp3_;
	gboolean _tmp4_;
#line 274 "ease-dialogs.vala"
	g_return_val_if_fail (dialog != NULL, 0);
#line 276 "ease-dialogs.vala"
	filename = (_tmp1_ = g_path_get_basename (_tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog)), _g_free0 (_tmp0_), _tmp1_);
#line 279 "ease-dialogs.vala"
	has_suffix = g_str_has_suffix (filename, ".ease");
#line 282 "ease-dialogs.vala"
	if (!has_suffix) {
#line 488 "ease-dialogs.c"
		GtkResponseType code;
#line 285 "ease-dialogs.vala"
		code = ease_dialog_question (EASE_DIALOG_VERIFY_EASE_PRIMARY, EASE_DIALOG_VERIFY_EASE_PRIMARY, EASE_DIALOG_VERIFY_EASE_SECONDARY, _data5_->modal, GTK_RESPONSE_YES, _ ("Don't append .ease"), GTK_RESPONSE_NO, "gtk-cancel", GTK_RESPONSE_CANCEL, _ ("Append .ease"), GTK_RESPONSE_YES, NULL, NULL);
#line 299 "ease-dialogs.vala"
		switch (code) {
#line 494 "ease-dialogs.c"
			case GTK_RESPONSE_CANCEL:
			{
				result = EASE_DIALOG_DIALOG_CODE_REJECT;
				_g_free0 (filename);
#line 302 "ease-dialogs.vala"
				return result;
#line 501 "ease-dialogs.c"
			}
			case GTK_RESPONSE_YES:
			{
				char* _tmp2_;
#line 306 "ease-dialogs.vala"
				gtk_file_chooser_set_current_name ((GtkFileChooser*) dialog, _tmp2_ = g_strconcat (filename, ".ease", NULL));
#line 508 "ease-dialogs.c"
				_g_free0 (_tmp2_);
#line 307 "ease-dialogs.vala"
				break;
#line 512 "ease-dialogs.c"
			}
		}
	}
#line 312 "ease-dialogs.vala"
	if ((_tmp4_ = g_file_test (_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), G_FILE_TEST_EXISTS), _g_free0 (_tmp3_), _tmp4_)) {
#line 518 "ease-dialogs.c"
		gint components_length1;
		gint _components_size_;
		char** _tmp9_;
		char* _tmp5_;
		char* _tmp6_;
		char** _tmp7_;
		char** _tmp8_;
		char** components;
		char* folder;
		char* _tmp10_;
		char* _tmp11_;
		char* bname;
		char* _tmp12_;
		char* _tmp13_;
		char* _tmp14_;
		char* _tmp15_;
		char* _tmp16_;
		GtkResponseType _tmp17_;
		GtkResponseType code;
		components = (_tmp9_ = (_tmp8_ = _tmp7_ = g_strsplit (_tmp6_ = g_path_get_dirname (_tmp5_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog)), "/", 0), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp8_), components_length1 = _vala_array_length (_tmp7_), _components_size_ = components_length1, _tmp9_);
#line 316 "ease-dialogs.vala"
		folder = g_strdup (components[components_length1 - 1]);
#line 317 "ease-dialogs.vala"
		bname = (_tmp11_ = g_path_get_basename (_tmp10_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog)), _g_free0 (_tmp10_), _tmp11_);
#line 320 "ease-dialogs.vala"
		code = (_tmp17_ = ease_dialog_message (GTK_MESSAGE_WARNING, _tmp12_ = g_strdup_printf (EASE_DIALOG_VERIFY_OVERWRITE_TITLE, bname), _tmp13_ = g_strdup_printf (EASE_DIALOG_VERIFY_OVERWRITE_FMT, bname), _tmp14_ = g_strdup_printf (EASE_DIALOG_VERIFY_OVERWRITE_SECONDARY_FMT, folder), _data5_->modal, GTK_RESPONSE_YES, _tmp15_ = g_strdup_printf (_ ("Don't overwrite %s"), bname), GTK_RESPONSE_NO, "gtk-cancel", GTK_RESPONSE_CANCEL, _tmp16_ = g_strdup_printf (_ ("Overwrite %s"), bname), GTK_RESPONSE_YES, NULL, NULL), _g_free0 (_tmp16_), _g_free0 (_tmp15_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _g_free0 (_tmp12_), _tmp17_);
#line 336 "ease-dialogs.vala"
		switch (code) {
#line 547 "ease-dialogs.c"
			case GTK_RESPONSE_CANCEL:
			{
				result = EASE_DIALOG_DIALOG_CODE_REJECT;
				_g_free0 (bname);
				_g_free0 (folder);
				components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (filename);
#line 339 "ease-dialogs.vala"
				return result;
#line 557 "ease-dialogs.c"
			}
			case GTK_RESPONSE_YES:
			{
				result = EASE_DIALOG_DIALOG_CODE_ACCEPT;
				_g_free0 (bname);
				_g_free0 (folder);
				components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (filename);
#line 342 "ease-dialogs.vala"
				return result;
#line 568 "ease-dialogs.c"
			}
			default:
			{
				result = EASE_DIALOG_DIALOG_CODE_REINVOKE;
				_g_free0 (bname);
				_g_free0 (folder);
				components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (filename);
#line 345 "ease-dialogs.vala"
				return result;
#line 579 "ease-dialogs.c"
			}
		}
		_g_free0 (bname);
		_g_free0 (folder);
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = EASE_DIALOG_DIALOG_CODE_ACCEPT;
	_g_free0 (filename);
#line 350 "ease-dialogs.vala"
	return result;
#line 590 "ease-dialogs.c"
}


#line 274 "ease-dialogs.vala"
static EaseDialogDialogCode __lambda76__ease_dialog_file_chooser_dialog_verify (GtkFileChooserDialog* d, gpointer self) {
#line 596 "ease-dialogs.c"
	EaseDialogDialogCode result;
	result = _lambda76_ (d, self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->modal);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 255 "ease-dialogs.vala"
char* ease_dialog_save_document (const char* title, GtkWindow* modal) {
#line 624 "ease-dialogs.c"
	char* result = NULL;
	Block5Data* _data5_;
#line 255 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 629 "ease-dialogs.c"
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->modal = _g_object_ref0 (modal);
	result = ease_dialog_save_verified (title, _data5_->modal, __lambda75__ease_dialog_file_chooser_dialog_extension, NULL, __lambda76__ease_dialog_file_chooser_dialog_verify, _data5_);
	block5_data_unref (_data5_);
#line 257 "ease-dialogs.vala"
	return result;
#line 637 "ease-dialogs.c"
}


#line 354 "ease-dialogs.vala"
char* ease_dialog_save_real (const char* title, GtkWindow* modal, EaseDialogFileChooserDialogExtension ext, void* ext_target, EaseDialogFileChooserDialogVerify verify, void* verify_target) {
#line 643 "ease-dialogs.c"
	char* result = NULL;
	GtkFileChooserDialog* dialog;
	EaseDialogDialogCode code;
	char* path;
#line 354 "ease-dialogs.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 358 "ease-dialogs.vala"
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (title, modal, GTK_FILE_CHOOSER_ACTION_SAVE, "gtk-save", GTK_RESPONSE_ACCEPT, "gtk-cancel", GTK_RESPONSE_CANCEL, NULL, NULL));
#line 367 "ease-dialogs.vala"
	if (ext != NULL) {
#line 367 "ease-dialogs.vala"
		ext (dialog, ext_target);
#line 656 "ease-dialogs.c"
	}
#line 370 "ease-dialogs.vala"
	code = EASE_DIALOG_DIALOG_CODE_ACCEPT;
#line 660 "ease-dialogs.c"
	{
		gboolean _tmp0_;
#line 371 "ease-dialogs.vala"
		_tmp0_ = TRUE;
#line 371 "ease-dialogs.vala"
		while (TRUE) {
#line 371 "ease-dialogs.vala"
			if (!_tmp0_) {
#line 396 "ease-dialogs.vala"
				if (!(code != EASE_DIALOG_DIALOG_CODE_ACCEPT)) {
#line 396 "ease-dialogs.vala"
					break;
#line 673 "ease-dialogs.c"
				}
			}
#line 371 "ease-dialogs.vala"
			_tmp0_ = FALSE;
#line 374 "ease-dialogs.vala"
			if (gtk_dialog_run ((GtkDialog*) dialog) != GTK_RESPONSE_ACCEPT) {
#line 376 "ease-dialogs.vala"
				gtk_object_destroy ((GtkObject*) dialog);
#line 682 "ease-dialogs.c"
				result = NULL;
				_g_object_unref0 (dialog);
#line 377 "ease-dialogs.vala"
				return result;
#line 687 "ease-dialogs.c"
			}
#line 381 "ease-dialogs.vala"
			gtk_widget_hide ((GtkWidget*) dialog);
#line 384 "ease-dialogs.vala"
			if (verify != NULL) {
#line 384 "ease-dialogs.vala"
				code = verify (dialog, verify_target);
#line 695 "ease-dialogs.c"
			}
#line 387 "ease-dialogs.vala"
			if (code == EASE_DIALOG_DIALOG_CODE_REJECT) {
#line 389 "ease-dialogs.vala"
				gtk_object_destroy ((GtkObject*) dialog);
#line 701 "ease-dialogs.c"
				result = NULL;
				_g_object_unref0 (dialog);
#line 390 "ease-dialogs.vala"
				return result;
#line 706 "ease-dialogs.c"
			}
#line 394 "ease-dialogs.vala"
			if (code == EASE_DIALOG_DIALOG_CODE_REINVOKE) {
#line 394 "ease-dialogs.vala"
				gtk_window_present ((GtkWindow*) dialog);
#line 712 "ease-dialogs.c"
			}
		}
	}
#line 399 "ease-dialogs.vala"
	path = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog);
#line 400 "ease-dialogs.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 720 "ease-dialogs.c"
	result = path;
	_g_object_unref0 (dialog);
#line 401 "ease-dialogs.vala"
	return result;
#line 725 "ease-dialogs.c"
}


/**
 * Enumerates the possible behaviors a {@link FileChooserDialogVerify} can
 * request.
 */
GType ease_dialog_dialog_code_get_type (void) {
	static volatile gsize ease_dialog_dialog_code_type_id__volatile = 0;
	if (g_once_init_enter (&ease_dialog_dialog_code_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_DIALOG_DIALOG_CODE_ACCEPT, "EASE_DIALOG_DIALOG_CODE_ACCEPT", "accept"}, {EASE_DIALOG_DIALOG_CODE_REJECT, "EASE_DIALOG_DIALOG_CODE_REJECT", "reject"}, {EASE_DIALOG_DIALOG_CODE_REINVOKE, "EASE_DIALOG_DIALOG_CODE_REINVOKE", "reinvoke"}, {0, NULL, NULL}};
		GType ease_dialog_dialog_code_type_id;
		ease_dialog_dialog_code_type_id = g_enum_register_static ("EaseDialogDialogCode", values);
		g_once_init_leave (&ease_dialog_dialog_code_type_id__volatile, ease_dialog_dialog_code_type_id);
	}
	return ease_dialog_dialog_code_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




