/* ease-core-0.4.vapi generated by valac 0.10.0, do not modify. */

[CCode (cprefix = "Ease", lower_case_cprefix = "ease_")]
namespace Ease {
	[CCode (cprefix = "EaseArchiver", lower_case_cprefix = "ease_archiver_")]
	namespace Archiver {
	}
	[CCode (cprefix = "EaseDialog", lower_case_cprefix = "ease_dialog_")]
	namespace Dialog {
		[CCode (cheader_filename = "ease-core.h")]
		public class Progress : GLib.Object {
			public Progress (string title, bool cancellable, double max, Gtk.Window? modal);
			public void add (double val);
			public void add_fraction (double val);
			public void destroy ();
			public void @set (double val);
			public void set_fraction (double val);
			public void set_label (string? str);
			public void show ();
			public Progress.with_image (string title, bool cancellable, double max, Gtk.Window? modal, Gtk.Image image);
		}
		[CCode (cprefix = "EASE_DIALOG_DIALOG_CODE_", cheader_filename = "ease-core.h")]
		public enum DialogCode {
			ACCEPT,
			REJECT,
			REINVOKE
		}
		[CCode (cheader_filename = "ease-core.h")]
		public delegate void FileChooserDialogExtension (Gtk.FileChooserDialog d);
		[CCode (cheader_filename = "ease-core.h")]
		public delegate Ease.Dialog.DialogCode FileChooserDialogVerify (Gtk.FileChooserDialog d);
		[CCode (cheader_filename = "ease-core.h")]
		public static Gtk.ResponseType message (Gtk.MessageType message_type, string title, string main_text, string secondary_text, Gtk.Window? modal, Gtk.ResponseType default_response, ...);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? open (string title, Gtk.Window? modal);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? open_document (Gtk.Window? modal);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? open_ext (string title, Gtk.Window? modal, Ease.Dialog.FileChooserDialogExtension? ext);
		[CCode (cheader_filename = "ease-core.h")]
		public static Gtk.ResponseType question (string title, string main_text, string secondary_text, Gtk.Window? modal, Gtk.ResponseType default_response, ...);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? save (string title, Gtk.Window? modal);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? save_document (string title, Gtk.Window? modal);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? save_ext (string title, Gtk.Window? modal, Ease.Dialog.FileChooserDialogExtension ext);
		[CCode (cheader_filename = "ease-core.h")]
		public static string? save_verified (string title, Gtk.Window? modal, Ease.Dialog.FileChooserDialogExtension ext, Ease.Dialog.FileChooserDialogVerify verify);
	}
	[CCode (cprefix = "EasePlugin", lower_case_cprefix = "ease_plugin_")]
	namespace Plugin {
		[CCode (cheader_filename = "ease-core.h")]
		public class ImportMedia : GLib.Object {
			public string file_link;
			public string thumb_link;
			public string title;
			public ImportMedia ();
		}
		[CCode (cheader_filename = "ease-core.h")]
		public abstract class ImportService : GLib.Object {
			[CCode (cprefix = "EASE_PLUGIN_IMPORT_SERVICE_COLUMN_", cheader_filename = "ease-core.h")]
			public enum Column {
				PIXBUF,
				TEXT,
				IMPORT_MEDIA
			}
			public ImportService ();
			public void add_media (Ease.Plugin.ImportMedia media);
			public abstract Rest.ProxyCall create_call (Rest.Proxy proxy, string search);
			public abstract Rest.Proxy create_proxy ();
			public virtual Gtk.Widget? extra_widget ();
			public abstract void parse_data (string data);
			public void run (string search);
			public signal void loading_complete ();
			public signal void loading_progress (double progress);
			public signal Gtk.IconView loading_started ();
			public signal void no_results ();
			public signal void proxy_call_complete ();
			public signal void started ();
		}
	}
	[CCode (cprefix = "EaseTransformations", lower_case_cprefix = "ease_transformations_")]
	namespace Transformations {
		[CCode (cheader_filename = "ease-core.h")]
		public static Gdk.Color clutter_color_to_gdk_color (Clutter.Color color);
		[CCode (cheader_filename = "ease-core.h")]
		public static Clutter.Color gdk_color_to_clutter_color (Gdk.Color color);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class Actor : Clutter.Group {
		protected Clutter.Actor contents;
		public Ease.ActorContext context;
		public weak Ease.Element element;
		public bool is_background;
		public Actor (Ease.Element e, Ease.ActorContext c);
		public void autosize (Clutter.Actor actor);
		public virtual void edit (Gtk.Widget sender);
		public virtual void end_edit (Gtk.Widget sender);
		public void reposition ();
		public void resize (float w_change, float h_change, bool proportional);
		public void translate (float x_change, float y_change);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class AnimatedZoomSlider : Ease.ZoomSlider, Clutter.Animatable {
		public AnimatedZoomSlider (Gtk.Adjustment adjustment, int[] button_values);
		protected override void change_zoom (double value);
		public bool animate { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Background : GLib.Object {
		public Background ();
		public void cairo_render (Cairo.Context cr, int width, int height, string path) throws GLib.Error;
		public Background.default_gradient ();
		public Background.from_json (Json.Object obj);
		public void set_cairo (Cairo.Context cr, int width, int height, string path);
		public Json.Object to_json ();
		public Background.white ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class BackgroundWidget : Gtk.Alignment {
		public BackgroundWidget (Ease.Background bg, Ease.Element e);
		public BackgroundWidget.for_slide (Ease.Slide s);
		public bool use_alpha { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class CairoActor : Ease.Actor {
		public CairoActor (Ease.Element e, Ease.ActorContext ctx);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class CairoElement : Ease.Element {
		public CairoElement ();
		public override Ease.Actor actor (Ease.ActorContext ctx);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Color : GLib.Object {
		public Color ();
		public Ease.Color copy ();
		public Color.from_clutter (Clutter.Color color);
		public Color.from_gdk (Gdk.Color color);
		public Color.from_string (string str);
		public Color.rgb (double r, double g, double b);
		public Color.rgba (double r, double g, double b, double a);
		public void set_cairo (Cairo.Context cr);
		public string to_string ();
		public Ease.UndoAction undo_action ();
		public double alpha { get; set; }
		public uint16 alpha16 { get; set; }
		public uint8 alpha8 { get; set; }
		public static Ease.Color black { owned get; }
		public double blue { get; set; }
		public uint16 blue16 { get; set; }
		public uint8 blue8 { get; set; }
		public Clutter.Color clutter { get; set; }
		public Gdk.Color gdk { get; set; }
		public double green { get; set; }
		public uint16 green16 { get; set; }
		public uint8 green8 { get; set; }
		public double red { get; set; }
		public uint16 red16 { get; set; }
		public uint8 red8 { get; set; }
		public static Ease.Color white { owned get; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Document : GLib.Object, Ease.UndoSource {
		public const int COL_PIXBUF;
		public const int COL_PIXBUF_DYNAMIC;
		public const int COL_SLIDE;
		public const int COL_TITLE;
		public const string DEFAULT_SLIDE;
		public const string THEME_PATH;
		public Document ();
		public string add_media_file (string file) throws GLib.Error;
		public void add_slide (int index, Ease.Slide slide);
		public void append_slide (Ease.Slide s);
		public void cairo_render (Cairo.Surface surface) throws GLib.Error;
		public void export_as_html (Gtk.Window window);
		public void export_as_pdf (Gtk.Window? win);
		public void export_as_postscript (Gtk.Window? win);
		public Document.from_saved (string file_path) throws GLib.Error;
		public Document.from_theme (Ease.Theme doc_theme, int w, int h) throws GLib.Error;
		public Ease.Slide get_slide (int index);
		public bool has_next_slide (Ease.Slide slide);
		public int index_of (Ease.Slide slide);
		public Ease.Slide remove_slide (Ease.Slide slide);
		public void to_json (Gtk.Window? window) throws GLib.Error;
		public float aspect { get; }
		public string filename { get; set; }
		public int height { get; set; }
		public int length { get; }
		public string path { get; set; }
		public Ease.IterableListStore slides { get; }
		public Ease.Theme theme { get; set; }
		public int width { get; set; }
		public signal void slide_added (Ease.Slide slide, int index);
		public signal void slide_deleted (Ease.Slide slide, int index);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class Element : GLib.Object, Ease.UndoSource {
		public Element ();
		public abstract Ease.Actor actor (Ease.ActorContext c);
		public virtual void cairo_free_cache ();
		public abstract void cairo_render (Cairo.Context context) throws GLib.Error;
		public virtual void cairo_render_small (Cairo.Context context) throws GLib.Error;
		public virtual string[] claim_media ();
		public Element.from_json (Json.Object obj);
		public virtual Clutter.Color? get_color ();
		public Gtk.Widget get_inspector_widget ();
		public virtual float get_minimum_height ();
		public virtual float get_minimum_width ();
		protected abstract string html_render (Ease.HTMLExporter exporter);
		public abstract Gtk.Widget inspector_widget ();
		public virtual bool set_color (Clutter.Color c);
		public virtual void signals ();
		public virtual Json.Object to_json ();
		public virtual GLib.List<Gtk.ToolItem>? tool_items ();
		public Element.with_owner (Ease.Slide owner);
		public string element_type { get; set; }
		public bool has_been_edited { get; set; }
		public float height { get; set; }
		public string identifier { get; set; }
		public float width { get; set; }
		public float x { get; set; }
		public float y { get; set; }
		public signal void changed ();
		public signal void position_changed ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Gradient : GLib.Object {
		public Gradient (Ease.Color start_color, Ease.Color end_color);
		public void cairo_render_rect (Cairo.Context cr, int width, int height);
		public Ease.Gradient copy ();
		public void flip ();
		public Gradient.from_string (string str);
		public Gradient.mirrored (Ease.Color start_color, Ease.Color end_color);
		public Gradient.radial (Ease.Color start_color, Ease.Color end_color);
		public void set_cairo (Cairo.Context cr, int width, int height);
		public string to_string ();
		public double angle { get; set; }
		public static Ease.Gradient default_background { owned get; }
		public Ease.Color end { get; set; }
		public Ease.GradientType mode { get; set; }
		public Ease.Color start { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class HTMLExporter : GLib.Object {
		public const string HEADER;
		public HTMLExporter ();
		public void add_progress (double amount);
		public void copy_file (string end_path, string base_path);
		public string copy_rendered (string rendered);
		public void finish ();
		public bool request_path (Gtk.Window win);
		public string basename { owned get; }
		public string path { get; set; }
		public int render_index { get; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Image : GLib.Object {
		public Image ();
		public void set_cairo (Cairo.Context cr, int width, int height, string path);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class ImageActor : Ease.Actor {
		public ImageActor (Ease.ImageElement e, Ease.ActorContext c);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class ImageElement : Ease.MediaElement {
		public ImageElement ();
		public override void cairo_free_cache ();
		public override void cairo_render (Cairo.Context context) throws GLib.Error;
		public override void cairo_render_small (Cairo.Context context) throws GLib.Error;
		public override string html_render (Ease.HTMLExporter exporter);
		public override Gtk.Widget inspector_widget ();
		public override void signals ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class IterableListStore : Gtk.ListStore, Ease.IterableTreeModel {
		public IterableListStore (GLib.Type[] types);
		public int size { get; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class MediaElement : Ease.Element {
		public MediaElement ();
		public override string[] claim_media ();
		public override void signals ();
		public string filename { get; set; }
		public string full_filename { owned get; }
		public string source_filename { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class PdfActor : Ease.Actor {
		public PdfActor (Ease.PdfElement e, Ease.ActorContext c);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class PdfElement : Ease.MediaElement {
		public PdfElement (string filename);
		public override Ease.Actor actor (Ease.ActorContext c);
		public override void cairo_render (Cairo.Context context) throws GLib.Error;
		public override string html_render (Ease.HTMLExporter exporter);
		public override Gtk.Widget inspector_widget ();
		public override void signals ();
		public override Json.Object to_json ();
		public bool allow_flipping { get; set; }
		public int displayed_page { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class ShapeElement : Ease.CairoElement {
		public ShapeElement (Ease.ShapeType type);
		public override void cairo_render (Cairo.Context cr);
		public override string[] claim_media ();
		public ShapeElement.from_json (Json.Object obj);
		public override string html_render (Ease.HTMLExporter exporter);
		public override Gtk.Widget inspector_widget ();
		public override void signals ();
		public override Json.Object to_json ();
		public Ease.ShapeType shape_type { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Slide : GLib.Object, Ease.UndoSource {
		[CCode (ref_function = "ease_slide_iterator_ref", unref_function = "ease_slide_iterator_unref", cheader_filename = "ease-core.h")]
		public class Iterator {
			public Iterator (Ease.Slide slide);
			public Ease.Element @get ();
			public bool next ();
		}
		public const string IMAGE_TYPE;
		public const string PDF_TYPE;
		public const string SHAPE_TYPE;
		public const string VIDEO_TYPE;
		public Slide ();
		public void add (int index, Ease.Element e);
		public void append (Ease.Element e);
		public void cairo_render (Cairo.Context context) throws GLib.Error;
		public void cairo_render_background (Cairo.Context cr, int w, int h) throws GLib.Error;
		public void cairo_render_sized (Cairo.Context context, int w, int h) throws GLib.Error;
		public void cairo_render_small (Cairo.Context context);
		public Ease.Element element_at (int i);
		public int index_of (Ease.Element e);
		public Ease.Slide.Iterator iterator ();
		public void lower (Ease.Element element);
		public void lower_bottom (Ease.Element element);
		public void raise (Ease.Element element);
		public void raise_top (Ease.Element element);
		public void remove (Ease.Element e);
		public void remove_at (int index);
		public void to_html (ref string html, Ease.HTMLExporter exporter, double amount, int index);
		public Slide.with_owner (Ease.Document owner);
		public double advance_delay { get; set; }
		public float aspect { get; }
		public bool automatically_advance { get; set; }
		public Ease.Background background { get; set; }
		public string background_abs { owned get; }
		public int count { get; }
		public int height { get; }
		public string master { get; set; }
		public Ease.Slide? next { owned get; }
		public Ease.Slide? previous { owned get; }
		public Ease.Transition transition { get; set; }
		public uint transition_msecs { get; set; }
		public double transition_time { get; set; }
		public Ease.TransitionVariant variant { get; set; }
		public int width { get; }
		public signal void background_changed (Ease.Slide self);
		public signal void changed (Ease.Slide self);
		public signal void element_added (Ease.Slide self, Ease.Element element, int index);
		public signal void element_removed (Ease.Slide self, Ease.Element element, int index);
		public signal void element_reordered (Ease.Slide self, Ease.Element element);
		public signal void request_advance (Ease.Element sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Temp : GLib.Object {
		public const string IMG_DIR;
		public const string TEMP_DIR;
		public const string THEME_DIR;
		public const string UI_DIR;
		public Temp ();
		public static void clean ();
		public static bool exists (int dir, string tmp);
		public static string request () throws GLib.Error;
		public static string request_str (string str) throws GLib.Error;
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class TextActor : Ease.Actor {
		public TextActor (Ease.TextElement e, Ease.ActorContext c);
		public override void edit (Gtk.Widget sender);
		public override void end_edit (Gtk.Widget sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class TextElement : Ease.Element {
		public TextElement ();
		public override Ease.Actor actor (Ease.ActorContext c);
		public override void cairo_render (Cairo.Context context) throws GLib.Error;
		public override Clutter.Color? get_color ();
		protected override string html_render (Ease.HTMLExporter exporter);
		public override Gtk.Widget inspector_widget ();
		[CCode (instance_pos = -1)]
		public void on_inspector_alignment (Gtk.Widget sender);
		public override bool set_color (Clutter.Color c);
		public void text_align_from_string (string str);
		public string text_align_to_string ();
		public void text_size_from_string (string str);
		public string text_size_to_string ();
		public void text_style_from_string (string str);
		public string text_style_to_string ();
		public void text_variant_from_string (string str);
		public string text_variant_to_string ();
		public void text_weight_from_string (string str);
		public string text_weight_to_string ();
		public Ease.Color color { get; set; }
		public string display_text { get; }
		public Pango.FontDescription font_description { owned get; set; }
		public string text { get; set; }
		public Pango.Alignment text_align { get; set; }
		public string text_font { get; set; }
		public int text_size { get; set; }
		public Pango.Style text_style { get; set; }
		public Pango.Variant text_variant { get; set; }
		public int text_weight { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Theme : GLib.Object {
		public string title;
		public const string AUTHOR_TEXT;
		public const string BACKGROUND;
		public const string BACKGROUND_COLOR;
		public const string BACKGROUND_GRADIENT;
		public const string BACKGROUND_IMAGE;
		public const string BACKGROUND_IMAGE_FILL;
		public const string BACKGROUND_IMAGE_SOURCE;
		public const string CONTENT;
		public const string CONTENT_DUAL;
		public const string CONTENT_DUAL_HEADER;
		public const string CONTENT_HEADER;
		public const string CONTENT_MEDIA;
		public const string CONTENT_TEXT;
		public const string CUSTOM_MEDIA;
		public const string CUSTOM_TEXT;
		public const string ELEMENT_TYPE;
		public const string EMPTY;
		public const string E_IDENTIFIER;
		public const string GRAD_LINEAR;
		public const string GRAD_LINEAR_MIRRORED;
		public const string GRAD_RADIAL;
		public const string HAS_BEEN_EDITED;
		public const string HEADER_TEXT;
		public const string HEIGHT;
		public const string IMAGE_ASPECT;
		public const string IMAGE_ORIGINAL;
		public const string IMAGE_STRETCH;
		public const string JSON_PATH;
		public const string[] MASTER_SLIDES;
		public const string MEDIA;
		public const string MEDIA_FILENAME;
		public const string MEDIA_HEADER;
		public const string MEDIA_SOURCE_FILENAME;
		public const string PAD_BOTTOM;
		public const string PAD_LEFT;
		public const string PAD_RIGHT;
		public const string PAD_TOP;
		public const string PDF_ALLOW_FLIPPING;
		public const string PDF_DEFAULT_PAGE;
		public const string SHAPE_TYPE;
		public const string S_IDENTIFIER;
		public const string TEXT_ALIGN;
		public const string TEXT_COLOR;
		public const string TEXT_FONT;
		public const string TEXT_SIZE;
		public const string TEXT_STYLE;
		public const string TEXT_TEXT;
		public const string TEXT_VARIANT;
		public const string TEXT_WEIGHT;
		public const string TITLE;
		public const string TITLE_TEXT;
		public const string VIDEO_END_ACTION;
		public const string VIDEO_END_CONTINUE;
		public const string VIDEO_END_LOOP;
		public const string VIDEO_END_STOP;
		public const string VIDEO_MUTE;
		public const string VIDEO_PLAY_AUTO;
		public const string WIDTH;
		public const string X;
		public const string Y;
		public Theme (string dir_path);
		public void copy_media (string target) throws GLib.Error;
		public Ease.Theme copy_to_path (string copy_to) throws GLib.Error;
		public Ease.TextElement create_custom_text ();
		public Ease.Slide? create_slide (string master, int width, int height);
		public Theme.json (string json_path);
		public static string master_description (string master);
		public static string master_from_description (string desc);
		public static string master_mnemonic_description (string master);
		public string path { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class UndoAction : Ease.UndoItem {
		public UndoAction (GLib.Object obj, string prop);
		public void add (GLib.Object obj, string prop);
		public override Ease.UndoItem apply ();
		public void combine (Ease.UndoAction action);
		public override bool contains (GLib.Object? obj);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class UndoController : GLib.Object {
		public UndoController ();
		public void add_action (Ease.UndoItem action);
		public bool can_redo ();
		public bool can_undo ();
		public void clear_redo ();
		public void redo ();
		public void undo ();
		public static bool enable_debug { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class UndoItem : GLib.Object {
		public UndoItem ();
		public abstract Ease.UndoItem apply ();
		public virtual bool contains (GLib.Object? obj);
		public signal void applied (Ease.UndoAction sender);
		public signal void pre_apply (Ease.UndoAction sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class VideoActor : Ease.Actor, Clutter.Media {
		public VideoActor (Ease.VideoElement e, Ease.ActorContext c);
		public double get_audio_volume ();
		public double get_buffer_fill ();
		public bool get_can_seek ();
		public double get_duration ();
		public bool get_playing ();
		public double get_progress ();
		public unowned string get_subtitle_font_name ();
		public unowned string get_subtitle_uri ();
		public unowned string get_uri ();
		public void set_audio_volume (double volume);
		public void set_filename (string filename);
		public void set_playing (bool playing);
		public void set_progress (double progress);
		public void set_subtitle_font_name (string font_name);
		public void set_subtitle_uri (string uri);
		public void set_uri (string uri);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class VideoElement : Ease.MediaElement {
		public VideoElement ();
		public override Ease.Actor actor (Ease.ActorContext c);
		public override void cairo_render (Cairo.Context context) throws GLib.Error;
		public override string html_render (Ease.HTMLExporter exporter);
		public override Gtk.Widget inspector_widget ();
		public override Json.Object to_json ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class ZoomSlider : Gtk.Alignment {
		public int[] values;
		public ZoomSlider (Gtk.Adjustment adjustment, int[] button_values);
		protected virtual void change_zoom (double value);
		public double get_value ();
		public void zoom_in ();
		public void zoom_out ();
		public Gtk.Adjustment adjustment { get; set; }
		public bool buttons_shown { get; set; }
		public int digits { get; set; }
		public double sliderpos { get; set; }
		public Gtk.UpdateType update_policy { get; set; }
		public Gtk.PositionType value_pos { get; set; }
		public signal void value_changed ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public interface IterableTreeModel : Gtk.TreeModel {
		[CCode (ref_function = "ease_iterable_tree_model_iterator_ref", unref_function = "ease_iterable_tree_model_iterator_unref", cheader_filename = "ease-core.h")]
		public class Iterator {
			public Iterator (Ease.IterableTreeModel self);
			public Gtk.TreeIter @get ();
			public bool next ();
		}
		public Gtk.TreeIter index (int index);
		public Ease.IterableTreeModel.Iterator iterator ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public interface UndoSource : GLib.Object {
		protected void forward (Ease.UndoItem action);
		protected void listen (Ease.UndoSource source);
		protected void silence (Ease.UndoSource source);
		protected signal void forwarded (Ease.UndoItem action);
		public signal void undo (Ease.UndoItem action);
	}
	[CCode (cprefix = "EASE_ACTOR_CONTEXT_", cheader_filename = "ease-core.h")]
	public enum ActorContext {
		PRESENTATION,
		EDITOR,
		INSPECTOR
	}
	[CCode (cprefix = "EASE_BACKGROUND_TYPE_", cheader_filename = "ease-core.h")]
	public enum BackgroundType {
		COLOR,
		GRADIENT,
		IMAGE;
		public string to_string ();
		public static Ease.BackgroundType from_string (string str);
		public string description ();
		public const Ease.BackgroundType[] TYPES;
	}
	[CCode (cprefix = "EASE_GRADIENT_TYPE_", cheader_filename = "ease-core.h")]
	public enum GradientType {
		LINEAR,
		LINEAR_MIRRORED,
		RADIAL;
		public string to_string ();
		public static Ease.GradientType from_string (string str);
		public string description ();
		public static Gtk.ListStore list_store ();
	}
	[CCode (cprefix = "EASE_HANDLE_POSITION_", cheader_filename = "ease-core.h")]
	public enum HandlePosition {
		TOP_LEFT,
		TOP_RIGHT,
		TOP,
		LEFT,
		RIGHT,
		BOTTOM_LEFT,
		BOTTOM_RIGHT,
		BOTTOM
	}
	[CCode (cprefix = "EASE_KEY_", cheader_filename = "ease-core.h")]
	public enum Key {
		UP,
		DOWN,
		LEFT,
		RIGHT,
		BACKSPACE,
		DELETE,
		ESCAPE,
		SPACE,
		ENTER
	}
	[CCode (cprefix = "EASE_SHAPE_TYPE_", cheader_filename = "ease-core.h")]
	public enum ShapeType {
		RECTANGLE,
		OVAL;
	}
	[CCode (cprefix = "EASE_TRANSITION_", cheader_filename = "ease-core.h")]
	public enum Transition {
		NONE,
		FADE,
		SLIDE,
		DROP,
		PIVOT,
		FLIP,
		REVOLVING_DOOR,
		REVEAL,
		FALL,
		SLATS,
		OPEN_DOOR,
		EXPLODE,
		ASSEMBLE,
		ZOOM,
		PANEL,
		INTERSPERSE_CONTENTS,
		SPIN_CONTENTS,
		SPRING_CONTENTS,
		SWING_CONTENTS,
		SLIDE_CONTENTS,
		ZOOM_CONTENTS;
		public static Gtk.ListStore model ();
		public Gtk.ListStore variant_model ();
		public static Ease.Transition from_string (string str);
		public Ease.TransitionVariant[] variants ();
		public string get_name ();
	}
	[CCode (cprefix = "EASE_TRANSITION_VARIANT_", cheader_filename = "ease-core.h")]
	public enum TransitionVariant {
		LEFT,
		RIGHT,
		UP,
		DOWN,
		BOTTOM,
		TOP,
		CENTER,
		TOP_LEFT,
		TOP_RIGHT,
		BOTTOM_LEFT,
		BOTTOM_RIGHT,
		TOP_TO_BOTTOM,
		BOTTOM_TO_TOP,
		LEFT_TO_RIGHT,
		RIGHT_TO_LEFT,
		IN,
		OUT;
		public static Ease.TransitionVariant from_string (string str);
		public string get_name ();
	}
	[CCode (cheader_filename = "ease-core.h")]
	public delegate void RecursiveDirAction (string path, string full_path);
	[CCode (cheader_filename = "ease-core.h")]
	public static string absolute_path (string path);
	[CCode (cheader_filename = "ease-core.h")]
	public static Gee.LinkedList<string> data_contents ();
	[CCode (cheader_filename = "ease-core.h")]
	public static Gee.LinkedList<string> data_contents_folder (string folder);
	[CCode (cheader_filename = "ease-core.h")]
	public static string? data_path (string path);
	[CCode (cheader_filename = "ease-core.h")]
	public static void error_dialog (string title, string message);
	[CCode (cheader_filename = "ease-core.h")]
	public static void recursive_copy (string from_dir, string to_dir) throws GLib.Error;
	[CCode (cheader_filename = "ease-core.h")]
	public static void recursive_delete (string path) throws GLib.Error;
	[CCode (cheader_filename = "ease-core.h")]
	public static void recursive_directory (string directory, Ease.RecursiveDirAction? directory_action, Ease.RecursiveDirAction? file_action) throws GLib.Error;
	[CCode (cheader_filename = "ease-core.h")]
	public static void recursive_directory_after (string directory, Ease.RecursiveDirAction? directory_action, Ease.RecursiveDirAction? file_action) throws GLib.Error;
	[CCode (cheader_filename = "ease-core.h")]
	public static Clutter.Color theme_clutter_color (string color);
	[CCode (cheader_filename = "ease-core.h")]
	public static Gdk.Color? theme_color (string color);
	[CCode (cheader_filename = "ease-core.h")]
	public static Gtk.Window widget_window (Gtk.Widget widg);
}
[CCode (cprefix = "Source", lower_case_cprefix = "source_")]
namespace Source {
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class BaseGroup : Gtk.Alignment {
		protected Gtk.Alignment header_align;
		protected Gtk.Alignment items_align;
		public BaseGroup (string title);
		public void add_item (Source.Item item);
		public signal void clicked (Source.Item sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public abstract class BaseView : Gtk.Alignment {
		protected Gtk.Alignment bin;
		protected Source.List list;
		public BaseView ();
		public void add_group (Source.BaseGroup group);
		public int list_width_request { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class ExpandableGroup : Source.BaseGroup {
		public ExpandableGroup (string title, bool expanded);
		public bool expanded { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Group : Source.BaseGroup {
		public Group (string title);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class Item : Gtk.HBox {
		protected Gtk.Alignment right_align;
		public Gtk.Widget widget;
		public const Gtk.IconSize ICON_SIZE;
		public Item (string text, Gtk.Image img, Gtk.Widget? widg);
		public Item.from_stock (string item, Gtk.Widget? widg);
		public Item.from_stock_icon (string text, string item, Gtk.Widget? widg);
		public Item.from_stock_text (string item, Gtk.Image img, Gtk.Widget? widg);
		public void select ();
		public bool selected { get; set; }
		public signal void clicked (Source.Item sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class List : Gtk.Alignment {
		public const int GROUP_PADDING;
		public const int PADDING;
		public List (Gtk.Bin linked_bin);
		public void add_group (Source.BaseGroup group);
		public signal void clicked (Source.Item sender);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class NumberItem : Source.Item {
		public NumberItem (string text, Gtk.Image img, Gtk.Widget? widg);
		public NumberItem.from_stock (string item, Gtk.Widget? widg);
		public NumberItem.from_stock_icon (string text, string item, Gtk.Widget? widg);
		public NumberItem.from_stock_text (string item, Gtk.Image img, Gtk.Widget? widg);
		public int notification { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class PaneView : Source.BaseView {
		public PaneView (bool with_separator);
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class SpinnerItem : Source.Item {
		public SpinnerItem (string text, Gtk.Image img, Gtk.Widget? widg);
		public SpinnerItem.from_stock (string item, Gtk.Widget? widg);
		public SpinnerItem.from_stock_icon (string text, string item, Gtk.Widget? widg);
		public SpinnerItem.from_stock_text (string item, Gtk.Image img, Gtk.Widget? widg);
		public void start ();
		public void stop ();
		public bool spinning { get; set; }
	}
	[CCode (cheader_filename = "ease-core.h")]
	public class View : Source.BaseView {
		public View ();
	}
}
