/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-

   eel-background-style.h: Style subclass used by EelBackground.

   Copyright (C) 2001 Bent Spoon Software

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
  
   Authors: Darin Adler <darin@bentspoon.com>
*/

#ifndef EEL_BACKGROUND_STYLE_H
#define EEL_BACKGROUND_STYLE_H

#include <eel/eel-background.h>

typedef struct EelBackgroundStyle EelBackgroundStyle;
typedef struct EelBackgroundStyleClass EelBackgroundStyleClass;

#define EEL_TYPE_BACKGROUND_STYLE \
	(eel_background_style_get_type ())
#define EEL_BACKGROUND_STYLE(obj) \
	(GTK_CHECK_CAST ((obj), EEL_TYPE_BACKGROUND_STYLE, EelBackgroundStyle))
#define EEL_BACKGROUND_STYLE_CLASS(klass) \
	(GTK_CHECK_CLASS_CAST ((klass), EEL_TYPE_BACKGROUND_STYLE, EelBackgroundStyleClass))
#define EEL_IS_BACKGROUND_STYLE(obj) \
	(GTK_CHECK_TYPE ((obj), EEL_TYPE_BACKGROUND_STYLE))
#define EEL_IS_BACKGROUND_STYLE_CLASS(klass) \
	(GTK_CHECK_CLASS_TYPE ((klass), EEL_TYPE_BACKGROUND_STYLE))

GtkType             eel_background_style_get_type (void);
EelBackgroundStyle *eel_background_style_new      (GtkStyle      *base_style,
						   EelBackground *background);

typedef struct EelBackgroundStyleDetails EelBackgroundStyleDetails;

struct EelBackgroundStyle
{
	GtkStyle parent;
	EelBackgroundStyleDetails *details;
};

struct EelBackgroundStyleClass
{
	GtkStyleClass parent_class;
};

#endif /* EEL_BACKGROUND_STYLE_H */
