
#include <e-data-book.h>
#include "e-data-book-enumtypes.h"

/* enumerations from "e-data-book-types.h" */
GType
e_data_book_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { 0, "E_DATA_BOOK_STATUS_SUCCESS", "success" },
      { 1, "E_DATA_BOOK_STATUS_BUSY", "busy" },
      { 2, "E_DATA_BOOK_STATUS_REPOSITORY_OFFLINE", "repository-offline" },
      { 3, "E_DATA_BOOK_STATUS_PERMISSION_DENIED", "permission-denied" },
      { 4, "E_DATA_BOOK_STATUS_CONTACT_NOT_FOUND", "contact-not-found" },
      { 5, "E_DATA_BOOK_STATUS_CONTACTID_ALREADY_EXISTS", "contactid-already-exists" },
      { 6, "E_DATA_BOOK_STATUS_AUTHENTICATION_FAILED", "authentication-failed" },
      { 7, "E_DATA_BOOK_STATUS_AUTHENTICATION_REQUIRED", "authentication-required" },
      { 8, "E_DATA_BOOK_STATUS_UNSUPPORTED_FIELD", "unsupported-field" },
      { 9, "E_DATA_BOOK_STATUS_UNSUPPORTED_AUTHENTICATION_METHOD", "unsupported-authentication-method" },
      { 10, "E_DATA_BOOK_STATUS_TLS_NOT_AVAILABLE", "tls-not-available" },
      { 11, "E_DATA_BOOK_STATUS_NO_SUCH_BOOK", "no-such-book" },
      { 12, "E_DATA_BOOK_STATUS_BOOK_REMOVED", "book-removed" },
      { 13, "E_DATA_BOOK_STATUS_OFFLINE_UNAVAILABLE", "offline-unavailable" },
      { 14, "E_DATA_BOOK_STATUS_SEARCH_SIZE_LIMIT_EXCEEDED", "search-size-limit-exceeded" },
      { 15, "E_DATA_BOOK_STATUS_SEARCH_TIME_LIMIT_EXCEEDED", "search-time-limit-exceeded" },
      { 16, "E_DATA_BOOK_STATUS_INVALID_QUERY", "invalid-query" },
      { 17, "E_DATA_BOOK_STATUS_QUERY_REFUSED", "query-refused" },
      { 18, "E_DATA_BOOK_STATUS_COULD_NOT_CANCEL", "could-not-cancel" },
      { 19, "E_DATA_BOOK_STATUS_OTHER_ERROR", "other-error" },
      { 20, "E_DATA_BOOK_STATUS_INVALID_SERVER_VERSION", "invalid-server-version" },
      { 21, "E_DATA_BOOK_STATUS_NO_SPACE", "no-space" },
      { 22, "E_DATA_BOOK_STATUS_INVALID_ARG", "invalid-arg" },
      { 23, "E_DATA_BOOK_STATUS_NOT_SUPPORTED", "not-supported" },
      { 24, "E_DATA_BOOK_STATUS_NOT_OPENED", "not-opened" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("EDataBookStatus", values);
  }
  return etype;
}

