/* kf-persona-store.c generated by valac 0.9.5.24-4b16, the Vala compiler
 * generated from kf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
typedef struct _FolksBackendsKfPersonaStorePrivate FolksBackendsKfPersonaStorePrivate;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _FolksBackendsKfPersonaStorePrepareData FolksBackendsKfPersonaStorePrepareData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _FolksBackendsKfPersonaStoreRemovePersonaData FolksBackendsKfPersonaStoreRemovePersonaData;
typedef struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData FolksBackendsKfPersonaStoreAddPersonaFromDetailsData;
typedef struct _FolksBackendsKfPersonaStoreSaveKeyFileData FolksBackendsKfPersonaStoreSaveKeyFileData;

struct _FolksBackendsKfPersonaStore {
	FolksPersonaStore parent_instance;
	FolksBackendsKfPersonaStorePrivate * priv;
};

struct _FolksBackendsKfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _FolksBackendsKfPersonaStorePrivate {
	GHashTable* _personas;
	GFile* file;
	GKeyFile* key_file;
	guint first_unused_id;
	char* _type_id;
	char* _display_name;
	char* _id;
};

struct _FolksBackendsKfPersonaStorePrepareData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	char* filename;
	GKeyFile* _tmp0_;
	char* contents;
	gsize length;
	char* _tmp1_;
	char* _tmp2_;
	GError * e1;
	GFile* parent_dir;
	GFileOutputStream* stream;
	GError * e2;
	char** groups;
	gsize _tmp3_;
	gint groups_length1;
	gint _groups_size_;
	char** _tmp4_;
	FolksBackendsKfPersona* persona;
	char** persona_id_collection;
	int persona_id_collection_length1;
	int persona_id_it;
	char* persona_id;
	GList* _tmp5_;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreRemovePersonaData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	FolksPersona* persona;
	GList* personas;
	GError * e;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GValue val;
	GHashTable* im_addresses;
	gboolean _tmp0_;
	char* persona_id;
	FolksBackendsKfPersona* persona;
	GList* personas;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreSaveKeyFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	char* key_file_data;
	char* _tmp0_;
	GError * e;
	GError * _inner_error_;
};


static gpointer folks_backends_kf_persona_store_parent_class = NULL;

GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStorePrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID,
	FOLKS_BACKENDS_KF_PERSONA_STORE_DISPLAY_NAME,
	FOLKS_BACKENDS_KF_PERSONA_STORE_ID,
	FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS
};
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file);
static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* data);
FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const char* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const char* id, FolksPersonaStore* store);
static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* data);
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static void _g_list_free_g_object_unref (GList* self);
static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_backends_kf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data);
static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data);
static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* data);
static void folks_backends_kf_persona_store_finalize (GObject* obj);
static void folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_backends_kf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * different groups in the key file given by `key_file`.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file) {
	FolksBackendsKfPersonaStore * self;
	char* _tmp0_;
	GFile* _tmp1_;
	GHashTable* _tmp2_;
	g_return_val_if_fail (key_file != NULL, NULL);
	self = (FolksBackendsKfPersonaStore*) folks_persona_store_construct (object_type);
	folks_persona_store_set_type_id ((FolksPersonaStore*) self, "key-file");
	folks_persona_store_set_id ((FolksPersonaStore*) self, _tmp0_ = g_file_get_basename (key_file));
	_g_free0 (_tmp0_);
	folks_persona_store_set_display_name ((FolksPersonaStore*) self, folks_persona_store_get_id ((FolksPersonaStore*) self));
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_FULL);
	self->priv->file = (_tmp1_ = _g_object_ref0 (key_file), _g_object_unref0 (self->priv->file), _tmp1_);
	self->priv->_personas = (_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->_personas), _tmp2_);
	return self;
}


FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file) {
	return folks_backends_kf_persona_store_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, key_file);
}


static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data) {
	FolksBackendsKfPersonaStorePrepareData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksBackendsKfPersonaStorePrepareData, data);
}


static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStorePrepareData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_prepare_data_free);
	_data_->self = g_object_ref (self);
	folks_backends_kf_persona_store_real_prepare_co (_data_);
}


static void folks_backends_kf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStorePrepareData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_real_prepare_co (data);
}


static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
	}
	_state_0:
	data->filename = g_file_get_path (data->self->priv->file);
	data->self->priv->key_file = (data->_tmp0_ = g_key_file_new (), _g_key_file_free0 (data->self->priv->key_file), data->_tmp0_);
	while (TRUE) {
		{
			data->contents = NULL;
			data->length = (gsize) 0;
			data->_tmp1_ = NULL;
			data->_state_ = 1;
			g_file_load_contents_async (data->self->priv->file, NULL, folks_backends_kf_persona_store_prepare_ready, data);
			return FALSE;
			_state_1:
			g_file_load_contents_finish (data->self->priv->file, data->_res_, &data->_tmp1_, &data->length, NULL, &data->_inner_error_);
			data->contents = (data->_tmp2_ = data->_tmp1_, _g_free0 (data->contents), data->_tmp2_);
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->contents);
				goto __catch3_g_error;
			}
			if (data->length > 0) {
				g_key_file_load_from_data (data->self->priv->key_file, data->contents, data->length, G_KEY_FILE_KEEP_COMMENTS, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->contents);
					goto __catch3_g_error;
				}
			}
			_g_free0 (data->contents);
			break;
		}
		goto __finally3;
		__catch3_g_error:
		{
			data->e1 = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				if (!g_error_matches (data->e1, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					g_warning ("The relationship key file '%s' could not be " "loaded: %s", data->filename, data->e1->message);
					g_signal_emit_by_name ((FolksPersonaStore*) data->self, "removed");
					_g_error_free0 (data->e1);
					_g_free0 (data->filename);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				_g_error_free0 (data->e1);
			}
		}
		__finally3:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		{
			data->parent_dir = g_file_get_parent (data->self->priv->file);
			g_file_make_directory_with_parents (data->parent_dir, NULL, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->parent_dir);
				goto __catch4_g_error;
			}
			data->_state_ = 2;
			g_file_create_async (data->self->priv->file, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, data);
			return FALSE;
			_state_2:
			data->stream = g_file_create_finish (data->self->priv->file, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->parent_dir);
				goto __catch4_g_error;
			}
			data->_state_ = 3;
			g_output_stream_close_async ((GOutputStream*) data->stream, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, data);
			return FALSE;
			_state_3:
			g_output_stream_close_finish ((GOutputStream*) data->stream, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->stream);
				_g_object_unref0 (data->parent_dir);
				goto __catch4_g_error;
			}
			_g_object_unref0 (data->stream);
			_g_object_unref0 (data->parent_dir);
		}
		goto __finally4;
		__catch4_g_error:
		{
			data->e2 = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				if (!g_error_matches (data->e2, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					g_warning ("The relationship key file '%s' could not be " "created: %s", data->filename, data->e2->message);
					g_signal_emit_by_name ((FolksPersonaStore*) data->self, "removed");
					_g_error_free0 (data->e2);
					_g_free0 (data->filename);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				_g_error_free0 (data->e2);
			}
		}
		__finally4:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->groups = (data->_tmp4_ = g_key_file_get_groups (data->self->priv->key_file, &data->_tmp3_), data->groups_length1 = data->_tmp3_, data->_groups_size_ = data->groups_length1, data->_tmp4_);
	{
		data->persona_id_collection = data->groups;
		data->persona_id_collection_length1 = data->groups_length1;
		for (data->persona_id_it = 0; data->persona_id_it < data->groups_length1; data->persona_id_it = data->persona_id_it + 1) {
			data->persona_id = g_strdup (data->persona_id_collection[data->persona_id_it]);
			{
				if (atoi (data->persona_id) == data->self->priv->first_unused_id) {
					data->self->priv->first_unused_id++;
				}
				data->persona = folks_backends_kf_persona_new (data->self->priv->key_file, data->persona_id, (FolksPersonaStore*) data->self);
				g_hash_table_insert (data->self->priv->_personas, g_strdup (folks_persona_get_iid ((FolksPersona*) data->persona)), _g_object_ref0 (data->persona));
				_g_object_unref0 (data->persona);
				_g_free0 (data->persona_id);
			}
		}
	}
	if (g_hash_table_size (data->self->priv->_personas) > 0) {
		g_signal_emit_by_name ((FolksPersonaStore*) data->self, "personas-changed", data->_tmp5_ = g_hash_table_get_values (data->self->priv->_personas), NULL, NULL, NULL, FOLKS_GROUPS_CHANGE_REASON_NONE);
		_g_list_free0 (data->_tmp5_);
	}
	data->groups = (_vala_array_free (data->groups, data->groups_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data->filename);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	g_object_unref (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreRemovePersonaData, data);
}


static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_remove_persona_data_free);
	_data_->self = g_object_ref (self);
	_data_->persona = _g_object_ref0 (persona);
	folks_backends_kf_persona_store_real_remove_persona_co (_data_);
}


static void folks_backends_kf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreRemovePersonaData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_real_remove_persona_co (data);
}


/**
   * {@inheritDoc}
   */
static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 4:
		goto _state_4;
	}
	_state_0:
	{
		g_key_file_remove_group (data->self->priv->key_file, folks_persona_get_display_id (data->persona), &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch5_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->_state_ = 4;
		folks_backends_kf_persona_store_save_key_file (data->self, folks_backends_kf_persona_store_remove_persona_ready, data);
		return FALSE;
		_state_4:
		folks_backends_kf_persona_store_save_key_file_finish (data->self, data->_res_);
		data->personas = NULL;
		data->personas = g_list_prepend (data->personas, _g_object_ref0 (data->persona));
		g_signal_emit_by_name ((FolksPersonaStore*) data->self, "personas-changed", NULL, data->personas, NULL, NULL, 0);
		__g_list_free_g_object_unref0 (data->personas);
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			_g_error_free0 (data->e);
		}
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data;
	data = _data;
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_add_persona_from_details_data_free);
	_data_->self = g_object_ref (self);
	_data_->details = _g_hash_table_ref0 (details);
	folks_backends_kf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_backends_kf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void folks_backends_kf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_real_add_persona_from_details_co (data);
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->val = *((GValue*) g_hash_table_lookup (data->details, "im-addresses"));
	data->im_addresses = (GHashTable*) g_value_get_boxed (&data->val);
	if (data->im_addresses == NULL) {
		data->_tmp0_ = TRUE;
	} else {
		data->_tmp0_ = g_hash_table_size (data->im_addresses) == 0;
	}
	if (data->_tmp0_) {
		data->_inner_error_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, "persona store (%s, %s) requires the following details:\n" "    im-addresses (provided: '%p')\n", folks_persona_store_get_type_id ((FolksPersonaStore*) data->self), folks_persona_store_get_id ((FolksPersonaStore*) data->self), data->im_addresses);
		{
			if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	data->persona_id = g_strdup_printf ("%u", data->self->priv->first_unused_id);
	data->self->priv->first_unused_id++;
	data->persona = folks_backends_kf_persona_new (data->self->priv->key_file, data->persona_id, (FolksPersonaStore*) data->self);
	g_hash_table_insert (data->self->priv->_personas, g_strdup (folks_persona_get_iid ((FolksPersona*) data->persona)), _g_object_ref0 (data->persona));
	folks_imable_set_im_addresses ((FolksIMable*) data->persona, data->im_addresses);
	data->personas = NULL;
	data->personas = g_list_prepend (data->personas, _g_object_ref0 (data->persona));
	g_signal_emit_by_name ((FolksPersonaStore*) data->self, "personas-changed", data->personas, NULL, NULL, NULL, FOLKS_GROUPS_CHANGE_REASON_NONE);
	data->result = (FolksPersona*) data->persona;
	__g_list_free_g_object_unref0 (data->personas);
	_g_free0 (data->persona_id);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__g_list_free_g_object_unref0 (data->personas);
	_g_object_unref0 (data->persona);
	_g_free0 (data->persona_id);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (FolksBackendsKfPersonaStoreSaveKeyFileData, data);
}


void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreSaveKeyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_save_key_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_save_key_file_data_free);
	_data_->self = g_object_ref (self);
	folks_backends_kf_persona_store_save_key_file_co (_data_);
}


void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	folks_backends_kf_persona_store_save_key_file_co (data);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 5:
		goto _state_5;
	}
	_state_0:
	data->key_file_data = g_key_file_to_data (data->self->priv->key_file, NULL, NULL);
	{
		data->_state_ = 5;
		g_file_replace_contents_async (data->self->priv->file, data->key_file_data, (gsize) string_get_length (data->key_file_data), NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, folks_backends_kf_persona_store_save_key_file_ready, data);
		return FALSE;
		_state_5:
		g_file_replace_contents_finish (data->self->priv->file, data->_res_, NULL, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("kf-persona-store.vala:226: Could not write updated key file '%s': %s", data->_tmp0_ = g_file_get_path (data->self->priv->file), data->e->message);
			_g_free0 (data->_tmp0_);
			_g_error_free0 (data->e);
		}
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_free0 (data->key_file_data);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static const char* folks_backends_kf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const char* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_type_id;
	return result;
}


static void folks_backends_kf_persona_store_real_set_type_id (FolksPersonaStore* base, const char* value) {
	FolksBackendsKfPersonaStore* self;
	char* _tmp0_;
	self = (FolksBackendsKfPersonaStore*) base;
	self->priv->_type_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_id), _tmp0_);
	g_object_notify ((GObject *) self, "type-id");
}


static const char* folks_backends_kf_persona_store_real_get_display_name (FolksPersonaStore* base) {
	const char* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_display_name;
	return result;
}


static void folks_backends_kf_persona_store_real_set_display_name (FolksPersonaStore* base, const char* value) {
	FolksBackendsKfPersonaStore* self;
	char* _tmp0_;
	self = (FolksBackendsKfPersonaStore*) base;
	self->priv->_display_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_display_name), _tmp0_);
	g_object_notify ((GObject *) self, "display-name");
}


static const char* folks_backends_kf_persona_store_real_get_id (FolksPersonaStore* base) {
	const char* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_id;
	return result;
}


static void folks_backends_kf_persona_store_real_set_id (FolksPersonaStore* base, const char* value) {
	FolksBackendsKfPersonaStore* self;
	char* _tmp0_;
	self = (FolksBackendsKfPersonaStore*) base;
	self->priv->_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_id), _tmp0_);
	g_object_notify ((GObject *) self, "id");
}


static GHashTable* folks_backends_kf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GHashTable* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = self->priv->_personas;
	return result;
}


static void folks_backends_kf_persona_store_class_init (FolksBackendsKfPersonaStoreClass * klass) {
	folks_backends_kf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = folks_backends_kf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = folks_backends_kf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = folks_backends_kf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = folks_backends_kf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = folks_backends_kf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = folks_backends_kf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_kf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->set_type_id = folks_backends_kf_persona_store_real_set_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_display_name = folks_backends_kf_persona_store_real_get_display_name;
	FOLKS_PERSONA_STORE_CLASS (klass)->set_display_name = folks_backends_kf_persona_store_real_set_display_name;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_id = folks_backends_kf_persona_store_real_get_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->set_id = folks_backends_kf_persona_store_real_set_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_kf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = folks_backends_kf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_backends_kf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_DISPLAY_NAME, "display-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_ID, "id");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS, "personas");
}


static void folks_backends_kf_persona_store_instance_init (FolksBackendsKfPersonaStore * self) {
	self->priv = FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->first_unused_id = (guint) 0;
}


static void folks_backends_kf_persona_store_finalize (GObject* obj) {
	FolksBackendsKfPersonaStore * self;
	self = FOLKS_BACKENDS_KF_PERSONA_STORE (obj);
	_g_hash_table_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->file);
	_g_key_file_free0 (self->priv->key_file);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_backends_kf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single simple key file. It will
 * create a {@link Persona} for each of the groups in the key file.
 */
GType folks_backends_kf_persona_store_get_type (void) {
	static volatile gsize folks_backends_kf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersonaStore), 0, (GInstanceInitFunc) folks_backends_kf_persona_store_instance_init, NULL };
		GType folks_backends_kf_persona_store_type_id;
		folks_backends_kf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsKfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_kf_persona_store_type_id__volatile, folks_backends_kf_persona_store_type_id);
	}
	return folks_backends_kf_persona_store_type_id__volatile;
}


static void folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersonaStore * self;
	self = FOLKS_BACKENDS_KF_PERSONA_STORE (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_DISPLAY_NAME:
		g_value_set_string (value, folks_persona_store_get_display_name ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_ID:
		g_value_set_string (value, folks_persona_store_get_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS:
		g_value_set_boxed (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_backends_kf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersonaStore * self;
	self = FOLKS_BACKENDS_KF_PERSONA_STORE (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID:
		folks_persona_store_set_type_id ((FolksPersonaStore*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_DISPLAY_NAME:
		folks_persona_store_set_display_name ((FolksPersonaStore*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_ID:
		folks_persona_store_set_id ((FolksPersonaStore*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




