/* folks.vapi generated by valac 0.10.0, do not modify. */

[CCode (cprefix = "Folks", lower_case_cprefix = "folks_")]
namespace Folks {
	[CCode (cprefix = "FolksDebug", lower_case_cprefix = "folks_debug_")]
	namespace Debug {
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class Backend : GLib.Object {
		public Backend ();
		public abstract async void prepare () throws GLib.Error;
		public abstract bool is_prepared { get; }
		public abstract string name { get; set; }
		public abstract GLib.HashTable<string,Folks.PersonaStore> persona_stores { get; set; }
		public signal void persona_store_added (Folks.PersonaStore store);
		public signal void persona_store_removed (Folks.PersonaStore store);
	}
	[CCode (cheader_filename = "folks.h")]
	public class BackendStore : GLib.Object {
		public void add_backend (Folks.Backend backend);
		public static Folks.BackendStore dup ();
		public Folks.Backend? get_backend_by_name (string name);
		public Gee.Collection<Folks.Backend> list_backends ();
		public async void load_backends () throws GLib.Error;
		public GLib.List<Folks.Backend> enabled_backends { owned get; set; }
		public signal void backend_available (Folks.Backend backend);
	}
	[CCode (cheader_filename = "folks.h")]
	public class Individual : GLib.Object, Folks.Aliasable, Folks.Avatar, Folks.Favourite, Folks.Groupable, Folks.Presence {
		public Individual (GLib.List<Folks.Persona>? personas);
		public unowned string get_alias ();
		public GLib.HashTable<string,bool> get_groups ();
		public unowned string get_presence_message ();
		public Folks.PresenceType get_presence_type ();
		public bool is_online ();
		public string id { get; set; }
		public bool is_user { get; set; }
		public GLib.List<Folks.Persona> personas { get; set; }
		public Folks.TrustLevel trust_level { get; set; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed);
		public signal void removed (Folks.Individual? replacement_individual);
	}
	[CCode (cheader_filename = "folks.h")]
	public class IndividualAggregator : GLib.Object {
		public IndividualAggregator ();
		public async Folks.Persona? add_persona_from_details (Folks.Individual? parent, string persona_store_type, string persona_store_id, GLib.HashTable<string,GLib.Value?> details) throws Folks.IndividualAggregatorError;
		public async void link_personas (void* _personas) throws Folks.IndividualAggregatorError;
		public async void prepare () throws GLib.Error;
		public async void remove_individual (Folks.Individual individual) throws GLib.Error;
		public async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public async void unlink_individual (Folks.Individual individual) throws GLib.Error;
		public GLib.HashTable<string,Folks.Individual> individuals { get; set; }
		public bool is_prepared { get; }
		public Folks.Individual user { get; set; }
		public signal void individuals_changed (GLib.List<Folks.Individual>? added, GLib.List<Folks.Individual>? removed, string? message, Folks.Persona? actor, Folks.Groupable.ChangeReason reason);
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class Persona : GLib.Object {
		[CCode (cheader_filename = "folks.h")]
		public delegate void LinkablePropertyCallback (string link);
		public Persona ();
		public static string build_uid (string backend_name, string persona_store_id, string persona_id);
		public virtual void linkable_property_to_links (string prop_name, Folks.Persona.LinkablePropertyCallback callback);
		public static void split_uid (string uid, out string backend_name, out string persona_store_id, out string persona_id);
		public string display_id { get; construct; }
		public string iid { get; construct; }
		public bool is_user { get; construct; }
		public string[] linkable_properties { get; set; }
		public Folks.PersonaStore store { get; construct; }
		public string uid { get; construct; }
	}
	[CCode (cheader_filename = "folks.h")]
	public abstract class PersonaStore : GLib.Object {
		public PersonaStore ();
		public abstract async Folks.Persona? add_persona_from_details (GLib.HashTable<string,GLib.Value?> details) throws Folks.PersonaStoreError;
		public virtual async void flush ();
		public abstract async void prepare () throws GLib.Error;
		public abstract async void remove_persona (Folks.Persona persona) throws GLib.Error;
		public abstract string display_name { get; set; }
		public abstract string id { get; set; }
		public abstract bool is_prepared { get; }
		public bool is_writeable { get; set; }
		public abstract GLib.HashTable<string,Folks.Persona> personas { get; }
		public Folks.PersonaStoreTrust trust_level { get; set; }
		public abstract string type_id { get; set; }
		public signal void personas_changed (GLib.List<Folks.Persona>? added, GLib.List<Folks.Persona>? removed, string? message, Folks.Persona? actor, Folks.Groupable.ChangeReason reason);
		public signal void removed ();
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Aliasable : GLib.Object {
		public abstract string alias { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Avatar : GLib.Object {
		public abstract GLib.File avatar { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Favourite : GLib.Object {
		public abstract bool is_favourite { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Groupable : GLib.Object {
		[CCode (cprefix = "FOLKS_GROUPABLE_CHANGE_REASON_", cheader_filename = "folks.h")]
		public enum ChangeReason {
			NONE,
			OFFLINE,
			KICKED,
			BUSY,
			INVITED,
			BANNED,
			ERROR,
			INVALID_MEMBER,
			NO_ANSWER,
			RENAMED,
			PERMISSION_DENIED,
			SEPARATED
		}
		public abstract async void change_group (string group, bool is_member) throws GLib.Error;
		public abstract GLib.HashTable<string,bool> groups { get; set; }
		public signal void group_changed (string group, bool is_member);
	}
	[CCode (cheader_filename = "folks.h")]
	public interface IMable : GLib.Object {
		public static string normalise_im_address (string im_address, string protocol);
		public abstract GLib.HashTable<string,GLib.GenericArray<string>> im_addresses { get; set; }
	}
	[CCode (cheader_filename = "folks.h")]
	public interface Presence : GLib.Object {
		public bool is_online ();
		public static int typecmp (Folks.PresenceType type_a, Folks.PresenceType type_b);
		public abstract string presence_message { get; set; }
		public abstract Folks.PresenceType presence_type { get; set; }
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_TRUST_", cheader_filename = "folks.h")]
	public enum PersonaStoreTrust {
		NONE,
		PARTIAL,
		FULL
	}
	[CCode (cprefix = "FOLKS_PRESENCE_TYPE_", cheader_filename = "folks.h")]
	public enum PresenceType {
		UNSET,
		OFFLINE,
		AVAILABLE,
		AWAY,
		EXTENDED_AWAY,
		HIDDEN,
		BUSY,
		UNKNOWN,
		ERROR
	}
	[CCode (cprefix = "FOLKS_TRUST_LEVEL_", cheader_filename = "folks.h")]
	public enum TrustLevel {
		NONE,
		PERSONAS
	}
	[CCode (cprefix = "FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_", cheader_filename = "folks.h")]
	public errordomain IndividualAggregatorError {
		STORE_NOT_FOUND,
		ADD_FAILED,
		NO_WRITEABLE_STORE,
		STORE_OFFLINE,
	}
	[CCode (cprefix = "FOLKS_PERSONA_STORE_ERROR_", cheader_filename = "folks.h")]
	public errordomain PersonaStoreError {
		INVALID_ARGUMENT,
		CREATE_FAILED,
		UNSUPPORTED_ON_USER,
		STORE_OFFLINE,
	}
}
