/* backend-store.c generated by valac 0.11.7, the Vala compiler
 * generated from backend-store.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *          Travis Reitter <travis.reitter@collabora.co.uk>
 *
 * This file was originally part of Rygel.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;
typedef struct _FolksBackendStorePrivate FolksBackendStorePrivate;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _FolksBackendStorePrepareData FolksBackendStorePrepareData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksBackendStoreLoadBackendsData FolksBackendStoreLoadBackendsData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendStoreBackendLoadIfNeededData FolksBackendStoreBackendLoadIfNeededData;
typedef struct _FolksBackendStoreBackendUnloadIfNeededData FolksBackendStoreBackendUnloadIfNeededData;
typedef struct _FolksBackendStoreEnableBackendData FolksBackendStoreEnableBackendData;
typedef struct _FolksBackendStoreDisableBackendData FolksBackendStoreDisableBackendData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _FolksBackendStoreGetModulesFromDirData FolksBackendStoreGetModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _FolksBackendStoreGetFileInfoData FolksBackendStoreGetFileInfoData;
typedef struct _FolksBackendStoreLoadDisabledBackendNamesData FolksBackendStoreLoadDisabledBackendNamesData;
typedef struct _FolksBackendStoreSaveKeyFileData FolksBackendStoreSaveKeyFileData;

struct _FolksBackendStore {
	GObject parent_instance;
	FolksBackendStorePrivate * priv;
};

struct _FolksBackendStoreClass {
	GObjectClass parent_class;
};

struct _FolksBackendStorePrivate {
	GeeHashMap* _backend_hash;
	GeeHashMap* _prepared_backends;
	GFile* _config_file;
	GKeyFile* _backends_key_file;
	GeeHashMap* _modules;
	gboolean _is_prepared;
	FolksDebug* _debug;
};

typedef void (*FolksBackendStoreModuleFinalizeFunc) (FolksBackendStore* store);
struct _FolksBackendStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
};

struct _FolksBackendStoreLoadBackendsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gboolean _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _backend_existing_it;
	gboolean _tmp5_;
	gpointer _tmp6_;
	FolksBackend* backend_existing;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* path;
	gchar* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* modules;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** path_split;
	gint path_split_length1;
	gint _path_split_size_;
	gchar** subpath_collection;
	int subpath_collection_length1;
	int subpath_it;
	const gchar* subpath;
	GFile* _tmp13_;
	GFile* file;
	gboolean is_file;
	gboolean is_dir;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* cur_modules;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	GeeIterator* _entry_it;
	gboolean _tmp21_;
	gpointer _tmp22_;
	GeeMapEntry* entry;
	gconstpointer _tmp23_;
	gconstpointer _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	GeeIterator* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _module_it;
	gboolean _tmp29_;
	gpointer _tmp30_;
	GFile* module;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	GeeIterator* _tmp33_;
	GeeIterator* _tmp34_;
	GeeIterator* _backend_it;
	gboolean _tmp35_;
	gpointer _tmp36_;
	FolksBackend* backend;
};

struct _FolksBackendStoreBackendLoadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * e;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_;
};

struct _FolksBackendStoreBackendUnloadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	gboolean result;
	gboolean unloaded;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	FolksBackend* backend_existing;
	GError * e;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};

struct _FolksBackendStoreEnableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gchar* name;
};

struct _FolksBackendStoreDisableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gchar* name;
};

struct _FolksBackendStoreGetModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GFile* dir;
	GeeHashMap* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* attributes;
	GList* infos;
	GFileEnumerator* _tmp3_;
	GFileEnumerator* enumerator;
	GList* _tmp4_;
	GList* _tmp5_;
	GError * _error_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* modules_final;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp10_;
	GFileInfo* info;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* file;
	GFileType _tmp13_;
	GFileType file_type;
	const gchar* _tmp14_;
	const gchar* content_type;
	gboolean _tmp15_;
	gboolean is_symlink;
	gchar* _tmp16_;
	gchar* mime;
	GeeHashMap* _tmp17_;
	GeeHashMap* modules;
	GeeSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeIterator* _tmp20_;
	GeeIterator* _tmp21_;
	GeeIterator* _entry_it;
	gboolean _tmp22_;
	gpointer _tmp23_;
	GeeMapEntry* entry;
	gconstpointer _tmp24_;
	gconstpointer _tmp25_;
	gboolean _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError * _inner_error_;
};

typedef void (*FolksBackendStoreModuleInitFunc) (FolksBackendStore* store);
struct _FolksBackendStoreGetFileInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gboolean is_file;
	gboolean is_dir;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError * _error_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFileType _tmp8_;
	GFileType _tmp9_;
	GError * _inner_error_;
};

struct _FolksBackendStoreLoadDisabledBackendNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GFile* file;
	const gchar* _tmp0_;
	const gchar* path;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GKeyFile* _tmp9_;
	gchar* contents;
	gsize length;
	gchar* _tmp10_;
	gsize _tmp11_;
	GError * e1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError * _inner_error_;
};

struct _FolksBackendStoreSaveKeyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gchar* _tmp0_;
	gchar* key_file_data;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GError * e;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_;
};


static gpointer folks_backend_store_parent_class = NULL;
static FolksBackendStore* folks_backend_store__instance;
static FolksBackendStore* folks_backend_store__instance = NULL;
extern gchar* folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
gchar* folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = NULL;

GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKEND_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_BACKEND_STORE, FolksBackendStorePrivate))
enum  {
	FOLKS_BACKEND_STORE_DUMMY_PROPERTY,
	FOLKS_BACKEND_STORE_ENABLED_BACKENDS,
	FOLKS_BACKEND_STORE_IS_PREPARED
};
FolksBackendStore* folks_backend_store_dup (void);
static FolksBackendStore* folks_backend_store_new (void);
static FolksBackendStore* folks_backend_store_construct (GType object_type);
FolksDebug* folks_debug_dup (const gchar* debug_flags);
void _folks_debug_register_domain (FolksDebug* self, const gchar* domain);
static void folks_backend_store_prepare_data_free (gpointer _data);
void folks_backend_store_prepare (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_prepare_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_prepare_co (FolksBackendStorePrepareData* data);
static void _folks_backend_store_load_disabled_backend_names (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void folks_backend_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backend_store_load_backends_data_free (gpointer _data);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* data);
static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean _folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_get_file_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_get_file_info_finish (GAsyncResult* _res_, gboolean* is_file, gboolean* is_dir);
static void _folks_backend_store_get_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GeeHashMap* _folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_load_module_from_file (FolksBackendStore* self, GFile* file);
static void _folks_backend_store_backend_load_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_backend_load_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* data);
static gboolean _folks_backend_store_backend_is_enabled (FolksBackendStore* self, const gchar* name);
const gchar* folks_backend_get_name (FolksBackend* self);
void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
static void _folks_backend_store_backend_load_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* data);
void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
static void _folks_backend_store_backend_unload_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend);
FolksBackend* folks_backend_store_dup_backend_by_name (FolksBackendStore* self, const gchar* name);
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self);
static void folks_backend_store_enable_backend_data_free (gpointer _data);
void folks_backend_store_enable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_enable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* data);
static void _folks_backend_store_save_key_file (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_save_key_file_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void folks_backend_store_enable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backend_store_disable_backend_data_free (gpointer _data);
void folks_backend_store_disable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_disable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* data);
static void folks_backend_store_disable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_get_modules_from_dir_data_free (gpointer _data);
static gboolean _folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* data);
static void _folks_backend_store_get_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _folks_backend_store_get_file_info_data_free (gpointer _data);
static gboolean _folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* data);
static void _folks_backend_store_get_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_data_free (gpointer _data);
static gboolean _folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* data);
static void _folks_backend_store_load_disabled_backend_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_save_key_file_data_free (gpointer _data);
static gboolean _folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* data);
static void _folks_backend_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GList* folks_backend_store_dup_enabled_backends (FolksBackendStore* self);
static void folks_backend_store_set_enabled_backends (FolksBackendStore* self, GList* value);
gboolean folks_backend_store_get_is_prepared (FolksBackendStore* self);
static void folks_backend_store_set_is_prepared (FolksBackendStore* self, gboolean value);
static void folks_backend_store_finalize (GObject* obj);
static void _vala_folks_backend_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backend_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * Create a new BackendStore.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendStore* folks_backend_store_dup (void) {
	FolksBackendStore* result = NULL;
	FolksBackendStore* _tmp1_;
	if (folks_backend_store__instance == NULL) {
		FolksBackendStore* _tmp0_ = NULL;
		FolksBackendStore* new_instance;
		_tmp0_ = folks_backend_store_new ();
		new_instance = _tmp0_;
		folks_backend_store__instance = new_instance;
		result = new_instance;
		return result;
	}
	_tmp1_ = _g_object_ref0 (folks_backend_store__instance);
	result = _tmp1_;
	return result;
}


static FolksBackendStore* folks_backend_store_construct (GType object_type) {
	FolksBackendStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	FolksDebug* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	self = (FolksBackendStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_getenv ("FOLKS_DEBUG");
	_tmp1_ = folks_debug_dup (_tmp0_);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp1_;
	_folks_debug_register_domain (self->priv->_debug, G_LOG_DOMAIN);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, NULL);
	_g_object_unref0 (self->priv->_modules);
	self->priv->_modules = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL);
	_g_object_unref0 (self->priv->_backend_hash);
	self->priv->_backend_hash = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL);
	_g_object_unref0 (self->priv->_prepared_backends);
	self->priv->_prepared_backends = _tmp4_;
	return self;
}


static FolksBackendStore* folks_backend_store_new (void) {
	return folks_backend_store_construct (FOLKS_TYPE_BACKEND_STORE);
}


static void folks_backend_store_prepare_data_free (gpointer _data) {
	FolksBackendStorePrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStorePrepareData, data);
}


void folks_backend_store_prepare (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStorePrepareData* _data_;
	_data_ = g_slice_new0 (FolksBackendStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backend_store_prepare_co (_data_);
}


void folks_backend_store_prepare_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the BackendStore for use.
   *
   * This must only ever be called before {@link BackendStore.load_backends} is
   * called for the first time. If it isn't called explicitly,
   * {@link BackendStore.load_backends} will call it.
   *
   * @since 0.3.0
   */
static void folks_backend_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStorePrepareData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backend_store_prepare_co (data);
}


static gboolean folks_backend_store_prepare_co (FolksBackendStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	_folks_backend_store_load_disabled_backend_names (data->self, folks_backend_store_prepare_ready, data);
	return FALSE;
	_state_1:
	_folks_backend_store_load_disabled_backend_names_finish (data->self, data->_res_);
	if (data->self->priv->_is_prepared == TRUE) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->self->priv->_is_prepared = TRUE;
	g_object_notify ((GObject*) data->self, "is-prepared");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backend_store_load_backends_data_free (gpointer _data) {
	FolksBackendStoreLoadBackendsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreLoadBackendsData, data);
}


void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadBackendsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_load_backends);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_load_backends_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backend_store_load_backends_co (_data_);
}


void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendStoreLoadBackendsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Find, load, and prepare all backends which are not disabled.
   *
   * Backends will be searched for in the path given by the `FOLKS_BACKEND_PATH`
   * environment variable, if it's set. If it's not set, backends will be
   * searched for in a path set at compilation time.
   */
static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backend_store_load_backends_co (data);
}


static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_module_supported ();
	g_assert (data->_tmp0_);
	data->_state_ = 1;
	folks_backend_store_prepare (data->self, folks_backend_store_load_backends_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->self, data->_res_);
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = gee_map_get_values ((GeeMap*) data->self->priv->_backend_hash);
		data->_tmp2_ = data->_tmp1_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_iterable_iterator ((GeeIterable*) data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		_g_object_unref0 (data->_tmp2_);
		data->_backend_existing_it = data->_tmp4_;
		while (TRUE) {
			data->_tmp5_ = gee_iterator_next (data->_backend_existing_it);
			if (!data->_tmp5_) {
				break;
			}
			data->_tmp6_ = NULL;
			data->_tmp6_ = gee_iterator_get (data->_backend_existing_it);
			data->backend_existing = (FolksBackend*) data->_tmp6_;
			data->_state_ = 2;
			_folks_backend_store_backend_unload_if_needed (data->self, data->backend_existing, folks_backend_store_load_backends_ready, data);
			return FALSE;
			_state_2:
			_folks_backend_store_backend_unload_if_needed_finish (data->self, data->_res_);
			_g_object_unref0 (data->backend_existing);
		}
		_g_object_unref0 (data->_backend_existing_it);
	}
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_getenv ("FOLKS_BACKEND_PATH");
	data->_tmp8_ = g_strdup (data->_tmp7_);
	data->path = data->_tmp8_;
	if (data->path == NULL) {
		data->_tmp9_ = g_strdup (BACKEND_DIR);
		_g_free0 (data->path);
		data->path = data->_tmp9_;
		g_debug ("Using built-in backend dir '%s' (override with " "environment variable FOLKS_BACKEND_PATH)", data->path);
	} else {
		g_debug ("Using environment variable FOLKS_BACKEND_PATH = " "'%s' to look for backends", data->path);
	}
	data->_tmp10_ = NULL;
	data->_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	data->modules = data->_tmp10_;
	data->_tmp12_ = NULL;
	data->_tmp12_ = data->_tmp11_ = g_strsplit (data->path, ":", 0);
	data->path_split = data->_tmp12_;
	data->path_split_length1 = _vala_array_length (data->_tmp11_);
	data->_path_split_size_ = _vala_array_length (data->_tmp11_);
	{
		data->subpath_collection = data->path_split;
		data->subpath_collection_length1 = data->path_split_length1;
		for (data->subpath_it = 0; data->subpath_it < data->path_split_length1; data->subpath_it = data->subpath_it + 1) {
			data->subpath = data->subpath_collection[data->subpath_it];
			{
				data->_tmp13_ = NULL;
				data->_tmp13_ = g_file_new_for_path (data->subpath);
				data->file = data->_tmp13_;
				g_assert (data->file != NULL);
				data->_state_ = 3;
				_folks_backend_store_get_file_info (data->file, folks_backend_store_load_backends_ready, data);
				return FALSE;
				_state_3:
				_folks_backend_store_get_file_info_finish (data->_res_, &data->_tmp14_, &data->_tmp15_);
				data->is_file = data->_tmp14_;
				data->is_dir = data->_tmp15_;
				if (data->is_file) {
					gee_abstract_map_set ((GeeAbstractMap*) data->modules, data->subpath, data->file);
				} else {
					if (data->is_dir) {
						data->_state_ = 4;
						_folks_backend_store_get_modules_from_dir (data->self, data->file, folks_backend_store_load_backends_ready, data);
						return FALSE;
						_state_4:
						data->_tmp16_ = NULL;
						data->_tmp16_ = _folks_backend_store_get_modules_from_dir_finish (data->self, data->_res_);
						data->cur_modules = data->_tmp16_;
						{
							data->_tmp17_ = NULL;
							data->_tmp17_ = gee_map_get_entries ((GeeMap*) data->cur_modules);
							data->_tmp18_ = data->_tmp17_;
							data->_tmp19_ = NULL;
							data->_tmp19_ = gee_iterable_iterator ((GeeIterable*) data->_tmp18_);
							data->_tmp20_ = data->_tmp19_;
							_g_object_unref0 (data->_tmp18_);
							data->_entry_it = data->_tmp20_;
							while (TRUE) {
								data->_tmp21_ = gee_iterator_next (data->_entry_it);
								if (!data->_tmp21_) {
									break;
								}
								data->_tmp22_ = NULL;
								data->_tmp22_ = gee_iterator_get (data->_entry_it);
								data->entry = (GeeMapEntry*) data->_tmp22_;
								data->_tmp23_ = NULL;
								data->_tmp23_ = gee_map_entry_get_key (data->entry);
								data->_tmp24_ = NULL;
								data->_tmp24_ = gee_map_entry_get_value (data->entry);
								gee_abstract_map_set ((GeeAbstractMap*) data->modules, (const gchar*) data->_tmp23_, (GFile*) data->_tmp24_);
								_g_object_unref0 (data->entry);
							}
							_g_object_unref0 (data->_entry_it);
						}
						_g_object_unref0 (data->cur_modules);
					} else {
						g_critical ("FOLKS_BACKEND_PATH component '%s' is not a regular " "file or directory; ignoring...", data->subpath);
						g_assert_not_reached ();
					}
				}
				_g_object_unref0 (data->file);
			}
		}
	}
	{
		data->_tmp25_ = NULL;
		data->_tmp25_ = gee_map_get_values ((GeeMap*) data->modules);
		data->_tmp26_ = data->_tmp25_;
		data->_tmp27_ = NULL;
		data->_tmp27_ = gee_iterable_iterator ((GeeIterable*) data->_tmp26_);
		data->_tmp28_ = data->_tmp27_;
		_g_object_unref0 (data->_tmp26_);
		data->_module_it = data->_tmp28_;
		while (TRUE) {
			data->_tmp29_ = gee_iterator_next (data->_module_it);
			if (!data->_tmp29_) {
				break;
			}
			data->_tmp30_ = NULL;
			data->_tmp30_ = gee_iterator_get (data->_module_it);
			data->module = (GFile*) data->_tmp30_;
			_folks_backend_store_load_module_from_file (data->self, data->module);
			_g_object_unref0 (data->module);
		}
		_g_object_unref0 (data->_module_it);
	}
	{
		data->_tmp31_ = NULL;
		data->_tmp31_ = gee_map_get_values ((GeeMap*) data->self->priv->_backend_hash);
		data->_tmp32_ = data->_tmp31_;
		data->_tmp33_ = NULL;
		data->_tmp33_ = gee_iterable_iterator ((GeeIterable*) data->_tmp32_);
		data->_tmp34_ = data->_tmp33_;
		_g_object_unref0 (data->_tmp32_);
		data->_backend_it = data->_tmp34_;
		while (TRUE) {
			data->_tmp35_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp35_) {
				break;
			}
			data->_tmp36_ = NULL;
			data->_tmp36_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp36_;
			data->_state_ = 5;
			_folks_backend_store_backend_load_if_needed (data->self, data->backend, folks_backend_store_load_backends_ready, data);
			return FALSE;
			_state_5:
			_folks_backend_store_backend_load_if_needed_finish (data->self, data->_res_);
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	data->path_split = (_vala_array_free (data->path_split, data->path_split_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->modules);
	_g_free0 (data->path);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_backend_load_if_needed_data_free (gpointer _data) {
	FolksBackendStoreBackendLoadIfNeededData* data;
	data = _data;
	_g_object_unref0 (data->backend);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreBackendLoadIfNeededData, data);
}


static void _folks_backend_store_backend_load_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreBackendLoadIfNeededData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_backend_load_if_needed);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_backend_load_if_needed_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->backend = _g_object_ref0 (backend);
	_folks_backend_store_backend_load_if_needed_co (_data_);
}


static void _folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_backend_load_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreBackendLoadIfNeededData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_backend_load_if_needed_co (data);
}


static gboolean _folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_get_name (data->backend);
	data->_tmp1_ = _folks_backend_store_backend_is_enabled (data->self, data->_tmp0_);
	if (data->_tmp1_) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_get_name (data->backend);
		data->_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) data->self->priv->_prepared_backends, data->_tmp2_);
		if (!data->_tmp3_) {
			data->_state_ = 1;
			folks_backend_prepare (data->backend, _folks_backend_store_backend_load_if_needed_ready, data);
			return FALSE;
			_state_1:
			folks_backend_prepare_finish (data->backend, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			data->_tmp4_ = NULL;
			data->_tmp4_ = folks_backend_get_name (data->backend);
			g_debug ("backend-store.vala:272: New backend '%s' prepared", data->_tmp4_);
			data->_tmp5_ = NULL;
			data->_tmp5_ = folks_backend_get_name (data->backend);
			gee_abstract_map_set ((GeeAbstractMap*) data->self->priv->_prepared_backends, data->_tmp5_, data->backend);
			g_signal_emit_by_name (data->self, "backend-available", data->backend);
			goto __finally0;
			__catch0_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				data->_tmp6_ = NULL;
				data->_tmp6_ = _ ("Error preparing Backend '%s': %s");
				data->_tmp7_ = NULL;
				data->_tmp7_ = folks_backend_get_name (data->backend);
				g_warning (data->_tmp6_, data->_tmp7_, data->e->message);
				_g_error_free0 (data->e);
			}
			__finally0:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_backend_unload_if_needed_data_free (gpointer _data) {
	FolksBackendStoreBackendUnloadIfNeededData* data;
	data = _data;
	_g_object_unref0 (data->backend);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreBackendUnloadIfNeededData, data);
}


static void _folks_backend_store_backend_unload_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreBackendUnloadIfNeededData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_backend_unload_if_needed);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_backend_unload_if_needed_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->backend = _g_object_ref0 (backend);
	_folks_backend_store_backend_unload_if_needed_co (_data_);
}


static gboolean _folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	gboolean result;
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void _folks_backend_store_backend_unload_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreBackendUnloadIfNeededData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_backend_unload_if_needed_co (data);
}


static gboolean _folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->unloaded = FALSE;
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_get_name (data->backend);
	data->_tmp1_ = _folks_backend_store_backend_is_enabled (data->self, data->_tmp0_);
	if (!data->_tmp1_) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_get_name (data->backend);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) data->self->priv->_backend_hash, data->_tmp2_);
		data->backend_existing = (FolksBackend*) data->_tmp3_;
		if (data->backend_existing != NULL) {
			data->_state_ = 1;
			folks_backend_unprepare (data->backend_existing, _folks_backend_store_backend_unload_if_needed_ready, data);
			return FALSE;
			_state_1:
			folks_backend_unprepare_finish (data->backend_existing, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			goto __finally1;
			__catch1_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				data->_tmp4_ = NULL;
				data->_tmp4_ = folks_backend_get_name (data->backend);
				g_warning ("backend-store.vala:302: Error unpreparing Backend '%s': %s", data->_tmp4_, data->e->message);
				_g_error_free0 (data->e);
			}
			__finally1:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->backend_existing);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->_tmp5_ = NULL;
			data->_tmp5_ = folks_backend_get_name (data->backend_existing);
			gee_abstract_map_unset ((GeeAbstractMap*) data->self->priv->_prepared_backends, data->_tmp5_, NULL);
			data->unloaded = TRUE;
		}
		_g_object_unref0 (data->backend_existing);
	}
	data->result = data->unloaded;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
   * Add a new {@link Backend} to the BackendStore.
   *
   * @param backend the {@link Backend} to add
   */
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend) {
	const gchar* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	FolksBackend* backend_existing;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = folks_backend_get_name (backend);
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_backend_hash, _tmp0_);
	backend_existing = (FolksBackend*) _tmp1_;
	if (backend_existing != NULL) {
		_tmp2_ = backend_existing != backend;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		folks_backend_unprepare (backend_existing, NULL, NULL);
		_tmp3_ = folks_backend_get_name (backend_existing);
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_prepared_backends, _tmp3_, NULL);
	}
	_tmp4_ = folks_backend_get_name (backend);
	_folks_debug_register_domain (self->priv->_debug, _tmp4_);
	_tmp5_ = folks_backend_get_name (backend);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_backend_hash, _tmp5_, backend);
	_g_object_unref0 (backend_existing);
}


static gboolean _folks_backend_store_backend_is_enabled (FolksBackendStore* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean all_others_enabled;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean enabled;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	all_others_enabled = TRUE;
	_tmp0_ = g_key_file_get_boolean (self->priv->_backends_key_file, folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS, "enabled", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch2_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	all_others_enabled = _tmp1_;
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError * e;
		gboolean _tmp2_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			_tmp2_ = !g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			const gchar* _tmp3_ = NULL;
			if (all_others_enabled) {
				_tmp3_ = "enabled";
			} else {
				_tmp3_ = "disabled";
			}
			g_warning ("Couldn't determine whether to enable or disable " "backends not listed in backend key file. Defaulting to %s.", _tmp3_);
		} else {
			const gchar* _tmp4_ = NULL;
			if (all_others_enabled) {
				_tmp4_ = "Enabling";
			} else {
				_tmp4_ = "Disabling";
			}
			g_debug ("No catch-all entry in the backend key file. %s " "unlisted backends.", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	enabled = TRUE;
	_tmp5_ = g_key_file_get_boolean (self->priv->_backends_key_file, name, "enabled", &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch3_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	enabled = _tmp6_;
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError * e;
		gboolean _tmp7_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		}
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			if (all_others_enabled) {
				_tmp8_ = "Enabling";
			} else {
				_tmp8_ = "Disabling";
			}
			g_debug ("Found no entry for backend '%s'.enabled in backend " "keyfile. %s according to '%s' setting.", name, _tmp8_, folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS);
			enabled = all_others_enabled;
		} else {
			gboolean _tmp9_ = FALSE;
			if (!g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp9_ = !g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				g_warning ("Couldn't check enabled state of backend '%s': %s\n" "Disabling backend.", name, e->message);
				enabled = FALSE;
			}
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = enabled;
	return result;
}


/**
   * Get a backend from the store by name. If a backend is returned, its
   * reference count is increased.
   *
   * @param name the backend name to retrieve
   * @return the backend, or `null` if none could be found
   *
   * @since 0.3.5
   */
FolksBackend* folks_backend_store_dup_backend_by_name (FolksBackendStore* self, const gchar* name) {
	FolksBackend* result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_backend_hash, name);
	result = (FolksBackend*) _tmp0_;
	return result;
}


/**
   * List the currently loaded backends.
   *
   * @return a list of the backends currently in the BackendStore
   */
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self) {
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->_backend_hash);
	result = _tmp0_;
	return result;
}


static void folks_backend_store_enable_backend_data_free (gpointer _data) {
	FolksBackendStoreEnableBackendData* data;
	data = _data;
	_g_free0 (data->name);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreEnableBackendData, data);
}


void folks_backend_store_enable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreEnableBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_enable_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_enable_backend_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->name = g_strdup (name);
	folks_backend_store_enable_backend_co (_data_);
}


void folks_backend_store_enable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Enable a backend.
   *
   * Mark a backend as enabled, such that the BackendStore will always attempt
   * to load it when {@link BackendStore.load_backends} is called. This will
   * not load the backend if it's not currently loaded.
   *
   * @param name the name of the backend to enable
   * @since 0.3.2
   */
static void folks_backend_store_enable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreEnableBackendData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backend_store_enable_backend_co (data);
}


static gboolean folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_key_file_set_boolean (data->self->priv->_backends_key_file, data->name, "enabled", TRUE);
	data->_state_ = 1;
	_folks_backend_store_save_key_file (data->self, folks_backend_store_enable_backend_ready, data);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backend_store_disable_backend_data_free (gpointer _data) {
	FolksBackendStoreDisableBackendData* data;
	data = _data;
	_g_free0 (data->name);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreDisableBackendData, data);
}


void folks_backend_store_disable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreDisableBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_disable_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_disable_backend_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->name = g_strdup (name);
	folks_backend_store_disable_backend_co (_data_);
}


void folks_backend_store_disable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Disable a backend.
   *
   * Mark a backend as disabled, such that it won't be loaded even when the
   * client application is restarted. This will not remove the backend if it's
   * already loaded.
   *
   * @param name the name of the backend to disable
   * @since 0.3.2
   */
static void folks_backend_store_disable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreDisableBackendData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_backend_store_disable_backend_co (data);
}


static gboolean folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_key_file_set_boolean (data->self->priv->_backends_key_file, data->name, "enabled", FALSE);
	data->_state_ = 1;
	_folks_backend_store_save_key_file (data->self, folks_backend_store_disable_backend_ready, data);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_get_modules_from_dir_data_free (gpointer _data) {
	FolksBackendStoreGetModulesFromDirData* data;
	data = _data;
	_g_object_unref0 (data->dir);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreGetModulesFromDirData, data);
}


static void _folks_backend_store_get_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreGetModulesFromDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_get_modules_from_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_get_modules_from_dir_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->dir = _g_object_ref0 (dir);
	_folks_backend_store_get_modules_from_dir_co (_data_);
}


static GeeHashMap* _folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	GeeHashMap* result;
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _folks_backend_store_get_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreGetModulesFromDirData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_get_modules_from_dir_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_path (data->dir);
	data->_tmp1_ = data->_tmp0_;
	g_debug ("backend-store.vala:451: Searching for modules in folder '%s' ..", data->_tmp1_);
	_g_free0 (data->_tmp1_);
	data->_tmp2_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	data->attributes = data->_tmp2_;
	data->_state_ = 1;
	g_file_enumerate_children_async (data->dir, data->attributes, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
	data->enumerator = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	data->_state_ = 2;
	g_file_enumerator_next_files_async (data->enumerator, G_MAXINT, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, data);
	return FALSE;
	_state_2:
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
	data->_tmp5_ = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->enumerator);
		goto __catch4_g_error;
	}
	__g_list_free__g_object_unref0_0 (data->infos);
	data->infos = data->_tmp5_;
	_g_object_unref0 (data->enumerator);
	goto __finally4;
	__catch4_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp6_ = NULL;
		data->_tmp6_ = _ ("Error listing contents of folder '%s': %s");
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_file_get_path (data->dir);
		data->_tmp8_ = data->_tmp7_;
		g_critical (data->_tmp6_, data->_tmp8_, data->_error_->message);
		_g_free0 (data->_tmp8_);
		data->result = NULL;
		_g_error_free0 (data->_error_);
		__g_list_free__g_object_unref0_0 (data->infos);
		_g_free0 (data->attributes);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally4:
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->infos);
		_g_free0 (data->attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp9_ = NULL;
	data->_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL);
	data->modules_final = data->_tmp9_;
	{
		data->info_collection = data->infos;
		for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
			data->_tmp10_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
			data->info = data->_tmp10_;
			{
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_file_info_get_name (data->info);
				data->_tmp12_ = NULL;
				data->_tmp12_ = g_file_get_child (data->dir, data->_tmp11_);
				data->file = data->_tmp12_;
				data->_tmp13_ = g_file_info_get_file_type (data->info);
				data->file_type = data->_tmp13_;
				data->_tmp14_ = NULL;
				data->_tmp14_ = g_file_info_get_content_type (data->info);
				data->content_type = data->_tmp14_;
				data->_tmp15_ = g_file_info_get_is_symlink (data->info);
				data->is_symlink = data->_tmp15_;
				data->_tmp16_ = NULL;
				data->_tmp16_ = g_content_type_get_mime_type (data->content_type);
				data->mime = data->_tmp16_;
				if (data->file_type == G_FILE_TYPE_DIRECTORY) {
					data->_state_ = 3;
					_folks_backend_store_get_modules_from_dir (data->self, data->file, _folks_backend_store_get_modules_from_dir_ready, data);
					return FALSE;
					_state_3:
					data->_tmp17_ = NULL;
					data->_tmp17_ = _folks_backend_store_get_modules_from_dir_finish (data->self, data->_res_);
					data->modules = data->_tmp17_;
					{
						data->_tmp18_ = NULL;
						data->_tmp18_ = gee_map_get_entries ((GeeMap*) data->modules);
						data->_tmp19_ = data->_tmp18_;
						data->_tmp20_ = NULL;
						data->_tmp20_ = gee_iterable_iterator ((GeeIterable*) data->_tmp19_);
						data->_tmp21_ = data->_tmp20_;
						_g_object_unref0 (data->_tmp19_);
						data->_entry_it = data->_tmp21_;
						while (TRUE) {
							data->_tmp22_ = gee_iterator_next (data->_entry_it);
							if (!data->_tmp22_) {
								break;
							}
							data->_tmp23_ = NULL;
							data->_tmp23_ = gee_iterator_get (data->_entry_it);
							data->entry = (GeeMapEntry*) data->_tmp23_;
							data->_tmp24_ = NULL;
							data->_tmp24_ = gee_map_entry_get_key (data->entry);
							data->_tmp25_ = NULL;
							data->_tmp25_ = gee_map_entry_get_value (data->entry);
							gee_abstract_map_set ((GeeAbstractMap*) data->modules_final, (const gchar*) data->_tmp24_, (GFile*) data->_tmp25_);
							_g_object_unref0 (data->entry);
						}
						_g_object_unref0 (data->_entry_it);
					}
					_g_object_unref0 (data->modules);
				} else {
					if (g_strcmp0 (data->mime, "application/x-sharedlib") == 0) {
						data->_tmp26_ = !data->is_symlink;
					} else {
						data->_tmp26_ = FALSE;
					}
					if (data->_tmp26_) {
						data->_tmp27_ = NULL;
						data->_tmp27_ = g_file_get_path (data->file);
						data->_tmp28_ = data->_tmp27_;
						gee_abstract_map_set ((GeeAbstractMap*) data->modules_final, data->_tmp28_, data->file);
						_g_free0 (data->_tmp28_);
					} else {
						if (data->mime == NULL) {
							data->_tmp29_ = NULL;
							data->_tmp29_ = _ ("The content type of '%s' could not be determined. Have you installed s" \
"hared-mime-info?");
							data->_tmp30_ = NULL;
							data->_tmp30_ = g_file_get_path (data->file);
							data->_tmp31_ = data->_tmp30_;
							g_warning (data->_tmp29_, data->_tmp31_);
							_g_free0 (data->_tmp31_);
						}
					}
				}
				_g_free0 (data->mime);
				_g_object_unref0 (data->file);
				_g_object_unref0 (data->info);
			}
		}
	}
	data->_tmp32_ = NULL;
	data->_tmp32_ = g_file_get_path (data->dir);
	data->_tmp33_ = data->_tmp32_;
	g_debug ("backend-store.vala:511: Finished searching for modules in folder '%s'", data->_tmp33_);
	_g_free0 (data->_tmp33_);
	data->result = data->modules_final;
	__g_list_free__g_object_unref0_0 (data->infos);
	_g_free0 (data->attributes);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->modules_final);
	__g_list_free__g_object_unref0_0 (data->infos);
	_g_free0 (data->attributes);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_load_module_from_file (FolksBackendStore* self, GFile* file) {
	gchar* _tmp0_ = NULL;
	gchar* file_path;
	gboolean _tmp1_;
	GModule* _tmp2_ = NULL;
	GModule* module;
	void* function = NULL;
	void* _tmp5_ = NULL;
	gboolean _tmp6_;
	FolksBackendStoreModuleInitFunc module_init;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	file_path = _tmp0_;
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->_modules, file_path);
	if (_tmp1_) {
		_g_free0 (file_path);
		return;
	}
	_tmp2_ = g_module_open (file_path, G_MODULE_BIND_LOCAL);
	module = _tmp2_;
	if (module == NULL) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = _ ("Failed to load module from path '%s': %s");
		_tmp4_ = g_module_error ();
		g_warning (_tmp3_, file_path, _tmp4_);
		_g_module_close0 (module);
		_g_free0 (file_path);
		return;
	}
	_tmp6_ = g_module_symbol (module, "module_init", &_tmp5_);
	function = _tmp5_;
	if (!_tmp6_) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = _ ("Failed to find entry point function '%s' in '%s': %s");
		_tmp8_ = g_module_error ();
		g_warning (_tmp7_, "module_init", file_path, _tmp8_);
		_g_module_close0 (module);
		_g_free0 (file_path);
		return;
	}
	module_init = (FolksBackendStoreModuleInitFunc) function;
	g_assert (module_init != NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_modules, file_path, module);
	g_module_make_resident (module);
	module_init (self);
	_tmp9_ = g_module_name (module);
	g_debug ("backend-store.vala:562: Loaded module source: '%s'", _tmp9_);
	_g_module_close0 (module);
	_g_free0 (file_path);
}


static void _folks_backend_store_get_file_info_data_free (gpointer _data) {
	FolksBackendStoreGetFileInfoData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_slice_free (FolksBackendStoreGetFileInfoData, data);
}


static void _folks_backend_store_get_file_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreGetFileInfoData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _folks_backend_store_get_file_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_get_file_info_data_free);
	_data_->file = _g_object_ref0 (file);
	_folks_backend_store_get_file_info_co (_data_);
}


static void _folks_backend_store_get_file_info_finish (GAsyncResult* _res_, gboolean* is_file, gboolean* is_dir) {
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*is_file = _data_->is_file;
	*is_dir = _data_->is_dir;
}


static void _folks_backend_store_get_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreGetFileInfoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_get_file_info_co (data);
}


static gboolean _folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->is_file = FALSE;
	data->is_dir = FALSE;
	data->_state_ = 1;
	g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_file_info_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_g_object_unref0 (data->file_info);
	data->file_info = data->_tmp1_;
	goto __finally5;
	__catch5_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (g_error_matches (data->_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			data->_tmp2_ = NULL;
			data->_tmp2_ = _ ("File or directory '%s' does not exist.");
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_file_get_path (data->file);
			data->_tmp4_ = data->_tmp3_;
			g_critical (data->_tmp2_, data->_tmp4_);
			_g_free0 (data->_tmp4_);
		} else {
			data->_tmp5_ = NULL;
			data->_tmp5_ = _ ("Failed to get content type for '%s'.");
			data->_tmp6_ = NULL;
			data->_tmp6_ = g_file_get_path (data->file);
			data->_tmp7_ = data->_tmp6_;
			g_critical (data->_tmp5_, data->_tmp7_);
			_g_free0 (data->_tmp7_);
		}
		_g_error_free0 (data->_error_);
		_g_object_unref0 (data->file_info);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp8_ = g_file_info_get_file_type (data->file_info);
	data->is_file = data->_tmp8_ == G_FILE_TYPE_REGULAR;
	data->_tmp9_ = g_file_info_get_file_type (data->file_info);
	data->is_dir = data->_tmp9_ == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (data->file_info);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_load_disabled_backend_names_data_free (gpointer _data) {
	FolksBackendStoreLoadDisabledBackendNamesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreLoadDisabledBackendNamesData, data);
}


static void _folks_backend_store_load_disabled_backend_names (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadDisabledBackendNamesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_load_disabled_backend_names);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_load_disabled_backend_names_data_free);
	_data_->self = _g_object_ref0 (self);
	_folks_backend_store_load_disabled_backend_names_co (_data_);
}


static void _folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_load_disabled_backend_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadDisabledBackendNamesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_load_disabled_backend_names_co (data);
}


static gboolean _folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_getenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH");
	data->path = data->_tmp0_;
	if (data->path == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_get_user_data_dir ();
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_file_new_for_path (data->_tmp1_);
		_g_object_unref0 (data->file);
		data->file = data->_tmp2_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_file_get_child (data->file, "folks");
		_g_object_unref0 (data->file);
		data->file = data->_tmp3_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_file_get_child (data->file, "backends.ini");
		_g_object_unref0 (data->file);
		data->file = data->_tmp4_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_file_get_path (data->file);
		data->_tmp6_ = data->_tmp5_;
		g_debug ("Using built-in backends key file '%s' (override with " "environment variable FOLKS_BACKEND_STORE_KEY_FILE_PATH)", data->_tmp6_);
		_g_free0 (data->_tmp6_);
	} else {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_file_new_for_path (data->path);
		_g_object_unref0 (data->file);
		data->file = data->_tmp7_;
		g_debug ("Using environment variable " "FOLKS_BACKEND_STORE_KEY_FILE_PATH = '%s' to load the backends " "key file.", data->path);
	}
	data->_tmp8_ = _g_object_ref0 (data->file);
	_g_object_unref0 (data->self->priv->_config_file);
	data->self->priv->_config_file = data->_tmp8_;
	data->_tmp9_ = NULL;
	data->_tmp9_ = g_key_file_new ();
	_g_key_file_free0 (data->self->priv->_backends_key_file);
	data->self->priv->_backends_key_file = data->_tmp9_;
	data->contents = NULL;
	data->length = (gsize) 0;
	data->_tmp10_ = NULL;
	data->_state_ = 1;
	g_file_load_contents_async (data->file, NULL, _folks_backend_store_load_disabled_backend_names_ready, data);
	return FALSE;
	_state_1:
	g_file_load_contents_finish (data->file, data->_res_, &data->_tmp10_, &data->_tmp11_, NULL, &data->_inner_error_);
	_g_free0 (data->contents);
	data->contents = data->_tmp10_;
	data->length = data->_tmp11_;
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->contents);
		goto __catch6_g_error;
	}
	if (data->length > 0) {
		g_key_file_load_from_data (data->self->priv->_backends_key_file, data->contents, data->length, G_KEY_FILE_KEEP_COMMENTS, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->contents);
			goto __catch6_g_error;
		}
	}
	_g_free0 (data->contents);
	goto __finally6;
	__catch6_g_error:
	{
		data->e1 = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (!g_error_matches (data->e1, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			data->_tmp12_ = NULL;
			data->_tmp12_ = g_file_get_path (data->file);
			data->_tmp13_ = data->_tmp12_;
			g_warning ("backend-store.vala:645: The backends key file '%s' could not be loaded" \
": %s", data->_tmp13_, data->e1->message);
			_g_free0 (data->_tmp13_);
			_g_error_free0 (data->e1);
			_g_object_unref0 (data->file);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_error_free0 (data->e1);
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _folks_backend_store_save_key_file_data_free (gpointer _data) {
	FolksBackendStoreSaveKeyFileData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendStoreSaveKeyFileData, data);
}


static void _folks_backend_store_save_key_file (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = g_slice_new0 (FolksBackendStoreSaveKeyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_save_key_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_save_key_file_data_free);
	_data_->self = _g_object_ref0 (self);
	_folks_backend_store_save_key_file_co (_data_);
}


static void _folks_backend_store_save_key_file_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreSaveKeyFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_folks_backend_store_save_key_file_co (data);
}


static gboolean _folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_key_file_to_data (data->self->priv->_backends_key_file, NULL, NULL);
	data->key_file_data = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_get_path (data->self->priv->_config_file);
	data->_tmp2_ = data->_tmp1_;
	g_debug ("backend-store.vala:656: Saving backend key file '%s'.", data->_tmp2_);
	_g_free0 (data->_tmp2_);
	data->_tmp3_ = strlen (data->key_file_data);
	data->_state_ = 1;
	g_file_replace_contents_async (data->self->priv->_config_file, data->key_file_data, (gsize) data->_tmp3_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, _folks_backend_store_save_key_file_ready, data);
	return FALSE;
	_state_1:
	g_file_replace_contents_finish (data->self->priv->_config_file, data->_res_, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_file_get_path (data->self->priv->_config_file);
		data->_tmp5_ = data->_tmp4_;
		g_warning ("backend-store.vala:673: Could not write updated backend key file '%s':" \
" %s", data->_tmp5_, data->e->message);
		_g_free0 (data->_tmp5_);
		_g_error_free0 (data->e);
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_free0 (data->key_file_data);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


GList* folks_backend_store_dup_enabled_backends (FolksBackendStore* self) {
	GList* result;
	GList* backends;
	g_return_val_if_fail (self != NULL, NULL);
	backends = NULL;
	{
		GeeCollection* _tmp0_ = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _backend_it;
		_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->_prepared_backends);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_backend_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksBackend* backend;
			FolksBackend* _tmp6_;
			_tmp4_ = gee_iterator_next (_backend_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_backend_it);
			backend = (FolksBackend*) _tmp5_;
			_tmp6_ = _g_object_ref0 (backend);
			backends = g_list_prepend (backends, _tmp6_);
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	result = backends;
	return result;
}


static void folks_backend_store_set_enabled_backends (FolksBackendStore* self, GList* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "enabled-backends");
}


gboolean folks_backend_store_get_is_prepared (FolksBackendStore* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_prepared;
	return result;
}


static void folks_backend_store_set_is_prepared (FolksBackendStore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "is-prepared");
}


static void folks_backend_store_class_init (FolksBackendStoreClass * klass) {
	gchar* _tmp0_;
	folks_backend_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backend_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backend_store_finalize;
	/**
	   * The list of backends visible to this store which have not been explicitly
	   * disabled.
	   *
	   * This list will be empty before {@link BackendStore.load_backends} has been
	   * called.
	   *
	   * The backends in this list have been prepared and are ready to use.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_ENABLED_BACKENDS, g_param_spec_pointer ("enabled-backends", "enabled-backends", "enabled-backends", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether {@link BackendStore.prepare} has successfully completed for this
	   * store.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when a backend has been added to the BackendStore.
	   *
	   * This will not be emitted until after {@link BackendStore.load_backends}
	   * has been called.
	   *
	   * {@link Backend}s referenced in this signal are also included in
	   * {@link BackendStore.enabled_backends}.
	   *
	   * @param backend the new {@link Backend}
	   */
	g_signal_new ("backend_available", FOLKS_TYPE_BACKEND_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_BACKEND);
	_tmp0_ = g_strdup ("all-others");
	folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = _tmp0_;
}


static void folks_backend_store_instance_init (FolksBackendStore * self) {
	self->priv = FOLKS_BACKEND_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
}


static void folks_backend_store_finalize (GObject* obj) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (obj);
	{
		GeeCollection* _tmp0_ = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _module_it;
		_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->_modules);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_module_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			GModule* module;
			void* func = NULL;
			void* _tmp6_ = NULL;
			gboolean _tmp7_;
			_tmp4_ = gee_iterator_next (_module_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_module_it);
			module = (GModule*) _tmp5_;
			_tmp7_ = g_module_symbol (module, "module_finalize", &_tmp6_);
			func = _tmp6_;
			if (_tmp7_) {
				FolksBackendStoreModuleFinalizeFunc module_finalize;
				module_finalize = (FolksBackendStoreModuleFinalizeFunc) func;
				module_finalize (self);
			}
		}
		_g_object_unref0 (_module_it);
	}
	folks_backend_store__instance = NULL;
	_g_object_unref0 (self->priv->_backend_hash);
	_g_object_unref0 (self->priv->_prepared_backends);
	_g_object_unref0 (self->priv->_config_file);
	_g_key_file_free0 (self->priv->_backends_key_file);
	_g_object_unref0 (self->priv->_modules);
	_g_object_unref0 (self->priv->_debug);
	G_OBJECT_CLASS (folks_backend_store_parent_class)->finalize (obj);
}


/**
 * Responsible for backend loading.
 *
 * The BackendStore manages the set of available Folks backends. The
 * {@link BackendStore.load_backends} function loads all compatible and enabled
 * backends and the {@link BackendStore.backend_available} signal notifies when
 * these backends are ready.
 */
GType folks_backend_store_get_type (void) {
	static volatile gsize folks_backend_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backend_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendStore), 0, (GInstanceInitFunc) folks_backend_store_instance_init, NULL };
		GType folks_backend_store_type_id;
		folks_backend_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackendStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backend_store_type_id__volatile, folks_backend_store_type_id);
	}
	return folks_backend_store_type_id__volatile;
}


static void _vala_folks_backend_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (object);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS:
		g_value_set_pointer (value, folks_backend_store_dup_enabled_backends (self));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backend_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (object);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS:
		folks_backend_store_set_enabled_backends (self, g_value_get_pointer (value));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED:
		folks_backend_store_set_is_prepared (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



