/* phone-details.c generated by valac 0.12.0, the Vala compiler
 * generated from phone-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PHONE_DETAILS (folks_phone_details_get_type ())
#define FOLKS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails))
#define FOLKS_IS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_DETAILS))
#define FOLKS_PHONE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetailsIface))

typedef struct _FolksPhoneDetails FolksPhoneDetails;
typedef struct _FolksPhoneDetailsIface FolksPhoneDetailsIface;

#define FOLKS_TYPE_FIELD_DETAILS (folks_field_details_get_type ())
#define FOLKS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetails))
#define FOLKS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))
#define FOLKS_IS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_IS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))

typedef struct _FolksFieldDetails FolksFieldDetails;
typedef struct _FolksFieldDetailsClass FolksFieldDetailsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FolksPhoneDetailsIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_phone_numbers) (FolksPhoneDetails* self);
	void (*set_phone_numbers) (FolksPhoneDetails* self, GeeSet* value);
};



GType folks_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_details_get_type (void) G_GNUC_CONST;
gboolean folks_phone_details_numbers_equal (const gchar* number1, const gchar* number2);
gchar* folks_phone_details_drop_extension (const gchar* number);
gchar* folks_phone_details_normalise_number (const gchar* number);
gboolean folks_phone_details_is_extension_digit (const gchar* digit);
gboolean folks_phone_details_is_valid_digit (const gchar* digit);
gboolean folks_phone_details_is_common_delimiter (const gchar* digit);
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle);
GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self);
void folks_phone_details_set_phone_numbers (FolksPhoneDetails* self, GeeSet* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* FOLKS_PHONE_DETAILS__extension_chars[6] = {"p", "P", "w", "W", "x", "X"};
static const gchar* FOLKS_PHONE_DETAILS__valid_digits[12] = {"#", "*", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
static const gchar* FOLKS_PHONE_DETAILS__common_delimiters[8] = {",", ".", "(", ")", "-", " ", "\t", "/"};

/**
   * Normalise and compare two phone numbers.
   * @since 0.5.0
   */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


gboolean folks_phone_details_numbers_equal (const gchar* number1, const gchar* number2) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* n1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* n2;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	g_return_val_if_fail (number1 != NULL, FALSE);
	g_return_val_if_fail (number2 != NULL, FALSE);
	_tmp0_ = folks_phone_details_normalise_number (number1);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_phone_details_drop_extension (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	n1 = _tmp3_;
	_tmp4_ = folks_phone_details_normalise_number (number2);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_phone_details_drop_extension (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	n2 = _tmp7_;
	_tmp9_ = strlen (n1);
	if (_tmp9_ >= 7) {
		gint _tmp10_;
		_tmp10_ = strlen (n2);
		_tmp8_ = _tmp10_ >= 7;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* n1_reduced;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* n2_reduced;
		_tmp11_ = strlen (n1);
		_tmp12_ = string_slice (n1, (glong) (-7), (glong) _tmp11_);
		n1_reduced = _tmp12_;
		_tmp13_ = strlen (n2);
		_tmp14_ = string_slice (n2, (glong) (-7), (glong) _tmp13_);
		n2_reduced = _tmp14_;
		g_debug ("phone-details.vala:65: [PhoneDetails.equal] Comparing %s with %s", n1_reduced, n2_reduced);
		result = g_strcmp0 (n1_reduced, n2_reduced) == 0;
		_g_free0 (n2_reduced);
		_g_free0 (n1_reduced);
		_g_free0 (n2);
		_g_free0 (n1);
		return result;
	}
	result = FALSE;
	_g_free0 (n2);
	_g_free0 (n1);
	return result;
}


/**
   * Normalise a given phone number.
   *
   * Typical normalisations:
   *
   *  - 1-800-123-4567 --> 18001234567
   *  - +1-800-123-4567 --> 18001234567
   *  - +1-800-123-4567P123 --> 18001234567P123
   *
   * @since 0.5.0
   */
gchar* folks_phone_details_normalise_number (const gchar* number) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* normalised_number;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = g_strdup ("");
	normalised_number = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gchar* _tmp3_ = NULL;
				gchar* digit;
				gboolean _tmp4_ = FALSE;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = strlen (number);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = string_slice (number, (glong) i, (glong) (i + 1));
				digit = _tmp3_;
				if (i == 0) {
					_tmp4_ = g_strcmp0 (digit, "+") == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_g_free0 (digit);
					continue;
				} else {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					_tmp6_ = folks_phone_details_is_extension_digit (digit);
					if (_tmp6_) {
						_tmp5_ = TRUE;
					} else {
						gboolean _tmp7_;
						_tmp7_ = folks_phone_details_is_valid_digit (digit);
						_tmp5_ = _tmp7_;
					}
					if (_tmp5_) {
						gchar* _tmp8_;
						_tmp8_ = g_strconcat (normalised_number, digit, NULL);
						_g_free0 (normalised_number);
						normalised_number = _tmp8_;
					} else {
						gboolean _tmp9_;
						_tmp9_ = folks_phone_details_is_common_delimiter (digit);
						if (_tmp9_) {
							_g_free0 (digit);
							continue;
						} else {
							g_debug ("phone-details.vala:110: [PhoneDetails.normalise] unknown digit: %s", digit);
						}
					}
				}
				_g_free0 (digit);
			}
		}
	}
	_tmp10_ = g_utf8_strup (normalised_number, (gssize) (-1));
	result = _tmp10_;
	_g_free0 (normalised_number);
	return result;
}


static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gboolean folks_phone_details_is_extension_digit (const gchar* digit) {
	gboolean result = FALSE;
	g_return_val_if_fail (digit != NULL, FALSE);
	result = _vala_string_array_contains (FOLKS_PHONE_DETAILS__extension_chars, G_N_ELEMENTS (FOLKS_PHONE_DETAILS__extension_chars), digit);
	return result;
}


gboolean folks_phone_details_is_valid_digit (const gchar* digit) {
	gboolean result = FALSE;
	g_return_val_if_fail (digit != NULL, FALSE);
	result = _vala_string_array_contains (FOLKS_PHONE_DETAILS__valid_digits, G_N_ELEMENTS (FOLKS_PHONE_DETAILS__valid_digits), digit);
	return result;
}


gboolean folks_phone_details_is_common_delimiter (const gchar* digit) {
	gboolean result = FALSE;
	g_return_val_if_fail (digit != NULL, FALSE);
	result = _vala_string_array_contains (FOLKS_PHONE_DETAILS__common_delimiters, G_N_ELEMENTS (FOLKS_PHONE_DETAILS__common_delimiters), digit);
	return result;
}


/**
   * Returns the given number without it's extension (if any).
   *
   * @since 0.5.0
   */
static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* folks_phone_details_drop_extension (const gchar* number) {
	gchar* result = NULL;
	gchar* _tmp7_;
	g_return_val_if_fail (number != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < G_N_ELEMENTS (FOLKS_PHONE_DETAILS__extension_chars))) {
					break;
				}
				_tmp1_ = string_index_of (number, FOLKS_PHONE_DETAILS__extension_chars[i], 0);
				if (_tmp1_ >= 0) {
					gchar** _tmp2_;
					gchar** _tmp3_ = NULL;
					gchar** _tmp4_;
					gint _tmp4__length1;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp3_ = _tmp2_ = g_strsplit (number, FOLKS_PHONE_DETAILS__extension_chars[i], 0);
					_tmp4_ = _tmp3_;
					_tmp4__length1 = _vala_array_length (_tmp2_);
					_tmp5_ = g_strdup (_tmp4_[0]);
					_tmp6_ = _tmp5_;
					_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
					result = _tmp6_;
					return result;
				}
			}
		}
	}
	_tmp7_ = g_strdup (number);
	result = _tmp7_;
	return result;
}


GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self) {
	return FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->get_phone_numbers (self);
}


void folks_phone_details_set_phone_numbers (FolksPhoneDetails* self, GeeSet* value) {
	FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->set_phone_numbers (self, value);
}


static void folks_phone_details_base_init (FolksPhoneDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The phone numbers of the contact.
		   *
		   * A list of phone numbers associated to the contact.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * Interface for classes that can provide a phone number, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
GType folks_phone_details_get_type (void) {
	static volatile gsize folks_phone_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_phone_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPhoneDetailsIface), (GBaseInitFunc) folks_phone_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_phone_details_type_id;
		folks_phone_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPhoneDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_phone_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_phone_details_type_id__volatile, folks_phone_details_type_id);
	}
	return folks_phone_details_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



