/* backend.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/e-book-client.h>
#include <gee.h>
#include <libedataserver/e-account.h>
#include <libedataserver/e-source.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	GList* _e_contacts;
	GList* _contacts;
	ESourceGroup* _source_group;
	ESource* _source;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GList* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* uid;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* _tmp2_;
	EContact* contact;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	gchar* added_uid;
	EBookClient* _tmp5_;
	EContact* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define EDS_TEST_BACKEND_address_book_uri "local://test"
EdsTestBackend* eds_test_backend_new (void);
EdsTestBackend* eds_test_backend_construct (GType object_type);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self);
static void _eds_test_backend_prepare_source (EdsTestBackend* self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s);
static void _vala_EContactAddress_free (EContactAddress* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


EdsTestBackend* eds_test_backend_construct (GType object_type) {
	EdsTestBackend* self = NULL;
	self = (EdsTestBackend*) g_type_create_instance (object_type);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
	self->priv->_e_contacts = NULL;
	return self;
}


EdsTestBackend* eds_test_backend_new (void) {
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
	_g_object_unref0 (c);
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->updated_data);
	_eds_test_backend_unref0 (_data_->self);
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
	return self ? eds_test_backend_ref (self) : NULL;
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
	GeeHashMap* _tmp2_;
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
	_tmp0_ = _eds_test_backend_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_pos;
	_data_->contact_pos = _tmp1_;
	_tmp2_ = updated_data;
	_g_object_unref0 (_data_->updated_data);
	_data_->updated_data = _tmp2_;
	eds_test_backend_update_contact_co (_data_);
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	eds_test_backend_update_contact_co (_data_);
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
	_data_->_tmp1_ = _data_->contact_pos;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
	_data_->uid = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
		_data_->_tmp5_ = _data_->uid;
		_data_->_tmp6_ = NULL;
		_data_->_state_ = 1;
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
		return FALSE;
		_state_1:
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		_data_->contact = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->contact;
		_data_->_tmp8_ = _data_->updated_data;
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
		_data_->_tmp10_ = _data_->contact;
		_data_->_state_ = 2;
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
		return FALSE;
		_state_2:
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		g_warning ("backend.vala:67: Couldn't update contact\n");
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->contact);
		_g_free0 (_data_->uid);
		_g_object_unref0 (_data_->updated_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->contact);
	_g_free0 (_data_->uid);
	_g_object_unref0 (_data_->updated_data);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
	_eds_test_backend_unref0 (_data_->self);
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
	_tmp0_ = _eds_test_backend_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_pos;
	_data_->contact_pos = _tmp1_;
	eds_test_backend_remove_contact_co (_data_);
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	eds_test_backend_remove_contact_co (_data_);
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
	_data_->_tmp1_ = _data_->contact_pos;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_list_nth_data (_data_->_tmp0_, (guint) _data_->_tmp1_);
	_data_->_tmp3_ = g_strdup ((const gchar*) _data_->_tmp2_);
	_data_->uid = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
		_data_->_tmp5_ = _data_->uid;
		_data_->_tmp6_ = NULL;
		_data_->_state_ = 1;
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
		return FALSE;
		_state_1:
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		_data_->contact = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
		_data_->_tmp8_ = _data_->contact;
		_data_->_state_ = 2;
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
		return FALSE;
		_state_2:
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		g_warning ("backend.vala:82: Couldn't remove contact\n");
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->contact);
		_g_free0 (_data_->uid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->contact);
	_g_free0 (_data_->uid);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void eds_test_backend_reset (EdsTestBackend* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	self->priv->_contacts = NULL;
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
	self->priv->_e_contacts = NULL;
}


void eds_test_backend_set_up (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		ESource* _tmp0_;
		EBookClient* _tmp1_;
		EBookClient* _tmp2_;
		EBookClient* _tmp3_;
		EBookClient* _tmp4_;
		EBookClient* _tmp5_;
		ESource* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_eds_test_backend_prepare_source (self);
		_tmp0_ = self->priv->_source;
		_tmp1_ = e_book_client_new (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp3_ = _tmp2_;
		_g_object_unref0 (self->priv->_addressbook);
		self->priv->_addressbook = _tmp3_;
		_tmp4_ = self->priv->_addressbook;
		e_client_open_sync ((EClient*) _tmp4_, FALSE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp5_ = self->priv->_addressbook;
		_tmp6_ = e_client_get_source ((EClient*) _tmp5_);
		_tmp7_ = e_source_peek_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->_addressbook_name);
		self->priv->_addressbook_name = _tmp8_;
		_tmp9_ = self->priv->_addressbook_name;
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp9_, TRUE);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("backend.vala:107: Unable to create test data: %s\n", _tmp11_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self) {
	gchar* _tmp0_;
	gchar* base_uri;
	const gchar* _tmp1_;
	ESourceGroup* _tmp2_;
	ESource* _tmp3_;
	ESourceGroup* _tmp4_;
	ESource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("local:");
	base_uri = _tmp0_;
	_tmp1_ = base_uri;
	_tmp2_ = e_source_group_new ("Test", _tmp1_);
	_g_object_unref0 (self->priv->_source_group);
	self->priv->_source_group = _tmp2_;
	_tmp3_ = e_source_new ("Test", EDS_TEST_BACKEND_address_book_uri);
	_g_object_unref0 (self->priv->_source);
	self->priv->_source = _tmp3_;
	_tmp4_ = self->priv->_source_group;
	_tmp5_ = self->priv->_source;
	_tmp6_ = e_source_group_add_source (_tmp4_, _tmp5_, -1);
	if (_tmp6_) {
		{
			ESourceList* sl = NULL;
			ESourceList* _tmp7_ = NULL;
			ESourceList* _tmp8_;
			ESourceGroup* _tmp9_;
			ESourceList* _tmp10_;
			e_book_client_get_sources (&_tmp7_, &_inner_error_);
			_g_object_unref0 (sl);
			sl = _tmp7_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (sl);
				goto __catch3_g_error;
			}
			_tmp8_ = sl;
			_tmp9_ = self->priv->_source_group;
			e_source_list_add_group (_tmp8_, _tmp9_, 0);
			_tmp10_ = sl;
			e_source_list_sync (_tmp10_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (sl);
				goto __catch3_g_error;
			}
			_g_object_unref0 (sl);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (base_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (base_uri);
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
	_eds_test_backend_unref0 (_data_->self);
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
	_tmp0_ = _eds_test_backend_ref0 (self);
	_data_->self = _tmp0_;
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
	_data_->_tmp0_ = _data_->self->priv->_contacts;
	{
		_data_->c_collection = _data_->_tmp0_;
		_data_->c_it = NULL;
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
			_data_->c = _data_->_tmp1_;
			{
				_data_->_tmp2_ = e_contact_new ();
				_data_->contact = _data_->_tmp2_;
				_data_->_tmp3_ = _data_->contact;
				_data_->_tmp4_ = _data_->c;
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
				{
					_data_->_tmp5_ = _data_->self->priv->_addressbook;
					_data_->_tmp6_ = _data_->contact;
					_data_->_tmp7_ = NULL;
					_data_->_state_ = 1;
					e_book_client_add_contact (_data_->_tmp5_, _data_->_tmp6_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
					return FALSE;
					_state_1:
					e_book_client_add_contact_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp7_, &_data_->_inner_error_);
					_g_free0 (_data_->added_uid);
					_data_->added_uid = _data_->_tmp7_;
					if (_data_->_inner_error_ != NULL) {
						_g_free0 (_data_->added_uid);
						goto __catch4_g_error;
					}
					_data_->_tmp8_ = _data_->added_uid;
					_data_->added_uid = NULL;
					_data_->self->priv->_e_contacts = g_list_prepend (_data_->self->priv->_e_contacts, _data_->_tmp8_);
					_g_free0 (_data_->added_uid);
				}
				goto __finally4;
				__catch4_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp9_ = _data_->e;
					_data_->_tmp10_ = _data_->_tmp9_->message;
					g_warning ("backend.vala:151: Couldn't add contact: %s\n", _data_->_tmp10_);
					_g_error_free0 (_data_->e);
				}
				__finally4:
				if (_data_->_inner_error_ != NULL) {
					_g_object_unref0 (_data_->contact);
					_g_object_unref0 (_data_->c);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (_data_->contact);
				_g_object_unref0 (_data_->c);
			}
		}
	}
	_data_->self->priv->_e_contacts = g_list_reverse (_data_->self->priv->_e_contacts);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
	g_boxed_free (e_contact_photo_get_type (), self);
}


static void _vala_EContactName_free (EContactName* self) {
	g_boxed_free (e_contact_name_get_type (), self);
}


static void _vala_EContactAddress_free (EContactAddress* self) {
	g_boxed_free (e_contact_address_get_type (), self);
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name;
	EContactName* _tmp0_;
	EContactName* contact_name;
	gchar* _tmp1_;
	gchar* contact_field_name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint min_len;
	gboolean _tmp182_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	g_return_if_fail (c != NULL);
	added_contact_name = FALSE;
	_tmp0_ = e_contact_name_new ();
	contact_name = _tmp0_;
	_tmp1_ = g_strdup ("contact_name");
	contact_field_name = _tmp1_;
	_tmp2_ = contact_field_name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	min_len = _tmp4_;
	{
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_;
		GeeIterator* _k_it;
		_tmp5_ = c;
		_tmp6_ = gee_map_get_keys ((GeeMap*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_k_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* k;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gboolean _tmp25_;
			_tmp11_ = _k_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _k_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			k = (gchar*) _tmp14_;
			_tmp16_ = k;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = min_len;
			if (_tmp18_ > _tmp19_) {
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp20_ = k;
				_tmp21_ = min_len;
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = contact_field_name;
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
				_g_free0 (_tmp23_);
			} else {
				_tmp15_ = FALSE;
			}
			_tmp25_ = _tmp15_;
			if (_tmp25_) {
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_ = NULL;
				GValue* _tmp29_;
				GValue _tmp30_;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* v;
				const gchar* _tmp34_;
				gint _tmp35_ = 0;
				_tmp26_ = c;
				_tmp27_ = k;
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
				_tmp29_ = (GValue*) _tmp28_;
				_tmp30_ = *_tmp29_;
				_tmp31_ = g_value_get_string (&_tmp30_);
				_tmp32_ = g_strdup (_tmp31_);
				_tmp33_ = _tmp32_;
				__vala_GValue_free0 (_tmp29_);
				v = _tmp33_;
				_tmp34_ = k;
				_tmp35_ = string_index_of (_tmp34_, "family", 0);
				if (_tmp35_ >= 0) {
					EContactName* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp36_ = contact_name;
					_tmp37_ = v;
					_tmp38_ = g_strdup (_tmp37_);
					_g_free0 (_tmp36_->family);
					_tmp36_->family = _tmp38_;
				} else {
					const gchar* _tmp39_;
					gint _tmp40_ = 0;
					_tmp39_ = k;
					_tmp40_ = string_index_of (_tmp39_, "given", 0);
					if (_tmp40_ >= 0) {
						EContactName* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = contact_name;
						_tmp42_ = v;
						_tmp43_ = g_strdup (_tmp42_);
						_g_free0 (_tmp41_->given);
						_tmp41_->given = _tmp43_;
					} else {
						const gchar* _tmp44_;
						gint _tmp45_ = 0;
						_tmp44_ = k;
						_tmp45_ = string_index_of (_tmp44_, "additional", 0);
						if (_tmp45_ >= 0) {
							EContactName* _tmp46_;
							const gchar* _tmp47_;
							gchar* _tmp48_;
							_tmp46_ = contact_name;
							_tmp47_ = v;
							_tmp48_ = g_strdup (_tmp47_);
							_g_free0 (_tmp46_->additional);
							_tmp46_->additional = _tmp48_;
						} else {
							const gchar* _tmp49_;
							gint _tmp50_ = 0;
							_tmp49_ = k;
							_tmp50_ = string_index_of (_tmp49_, "prefixes", 0);
							if (_tmp50_ >= 0) {
								EContactName* _tmp51_;
								const gchar* _tmp52_;
								gchar* _tmp53_;
								_tmp51_ = contact_name;
								_tmp52_ = v;
								_tmp53_ = g_strdup (_tmp52_);
								_g_free0 (_tmp51_->prefixes);
								_tmp51_->prefixes = _tmp53_;
							} else {
								const gchar* _tmp54_;
								gint _tmp55_ = 0;
								_tmp54_ = k;
								_tmp55_ = string_index_of (_tmp54_, "suffixes", 0);
								if (_tmp55_ >= 0) {
									EContactName* _tmp56_;
									const gchar* _tmp57_;
									gchar* _tmp58_;
									_tmp56_ = contact_name;
									_tmp57_ = v;
									_tmp58_ = g_strdup (_tmp57_);
									_g_free0 (_tmp56_->suffixes);
									_tmp56_->suffixes = _tmp58_;
								}
							}
						}
					}
				}
				added_contact_name = TRUE;
				_g_free0 (v);
			} else {
				const gchar* _tmp59_;
				_tmp59_ = k;
				if (g_strcmp0 (_tmp59_, "avatar") == 0) {
					GeeHashMap* _tmp60_;
					const gchar* _tmp61_;
					gpointer _tmp62_ = NULL;
					GValue* _tmp63_;
					GValue _tmp64_;
					const gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* v;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
					GFile* file;
					_tmp60_ = c;
					_tmp61_ = k;
					_tmp62_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp60_, _tmp61_);
					_tmp63_ = (GValue*) _tmp62_;
					_tmp64_ = *_tmp63_;
					_tmp65_ = g_value_get_string (&_tmp64_);
					_tmp66_ = g_strdup (_tmp65_);
					_tmp67_ = _tmp66_;
					__vala_GValue_free0 (_tmp63_);
					v = _tmp67_;
					_tmp68_ = v;
					_tmp69_ = g_file_new_for_path (_tmp68_);
					file = _tmp69_;
					{
						GFile* _tmp70_;
						guint8* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						EContactPhoto* _tmp73_;
						EContactPhoto* cp;
						EContactPhoto* _tmp74_;
						EContactPhoto* _tmp75_;
						guint8* _tmp76_;
						gint _tmp76__length1;
						EContact* _tmp77_;
						EContactField _tmp78_ = 0;
						EContactPhoto* _tmp79_;
						_tmp70_ = file;
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
						photo_content = (g_free (photo_content), NULL);
						photo_content = _tmp71_;
						photo_content_length1 = _tmp72_;
						_photo_content_size_ = photo_content_length1;
						if (_inner_error_ != NULL) {
							goto __catch5_g_error;
						}
						_tmp73_ = e_contact_photo_new ();
						cp = _tmp73_;
						_tmp74_ = cp;
						_tmp74_->type = E_CONTACT_PHOTO_TYPE_INLINED;
						_tmp75_ = cp;
						_tmp76_ = photo_content;
						_tmp76__length1 = photo_content_length1;
						e_contact_photo_set_inlined (_tmp75_, _tmp76_, (gsize) _tmp76__length1);
						_tmp77_ = contact;
						_tmp78_ = e_contact_field_id ("photo");
						_tmp79_ = cp;
						e_contact_set (_tmp77_, _tmp78_, _tmp79_);
						__vala_EContactPhoto_free0 (cp);
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp80_;
						GError* _tmp81_;
						const gchar* _tmp82_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp80_ = v;
						_tmp81_ = e;
						_tmp82_ = _tmp81_->message;
						g_warning ("backend.vala:212: \n\nCan't load avatar %s: %s\n\n", _tmp80_, _tmp82_);
						_g_error_free0 (e);
					}
					__finally5:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						photo_content = (g_free (photo_content), NULL);
						_g_free0 (v);
						_g_free0 (k);
						_g_object_unref0 (_k_it);
						_g_free0 (contact_field_name);
						__vala_EContactName_free0 (contact_name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
					photo_content = (g_free (photo_content), NULL);
					_g_free0 (v);
				} else {
					const gchar* _tmp83_;
					_tmp83_ = k;
					if (g_strcmp0 (_tmp83_, "im_addresses") == 0) {
						GeeHashMap* _tmp84_;
						const gchar* _tmp85_;
						gpointer _tmp86_ = NULL;
						GValue* _tmp87_;
						GValue _tmp88_;
						const gchar* _tmp89_ = NULL;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* v;
						const gchar* _tmp92_;
						GeeHashMap* _tmp93_ = NULL;
						GeeHashMap* addresses;
						_tmp84_ = c;
						_tmp85_ = k;
						_tmp86_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp84_, _tmp85_);
						_tmp87_ = (GValue*) _tmp86_;
						_tmp88_ = *_tmp87_;
						_tmp89_ = g_value_get_string (&_tmp88_);
						_tmp90_ = g_strdup (_tmp89_);
						_tmp91_ = _tmp90_;
						__vala_GValue_free0 (_tmp87_);
						v = _tmp91_;
						_tmp92_ = v;
						_tmp93_ = _eds_test_backend_parse_addrs (self, _tmp92_);
						addresses = _tmp93_;
						{
							GeeHashMap* _tmp94_;
							GeeSet* _tmp95_;
							GeeSet* _tmp96_;
							GeeSet* _tmp97_;
							GeeIterator* _tmp98_ = NULL;
							GeeIterator* _tmp99_;
							GeeIterator* _addr_it;
							_tmp94_ = addresses;
							_tmp95_ = gee_map_get_keys ((GeeMap*) _tmp94_);
							_tmp96_ = _tmp95_;
							_tmp97_ = _tmp96_;
							_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
							_tmp99_ = _tmp98_;
							_g_object_unref0 (_tmp97_);
							_addr_it = _tmp99_;
							while (TRUE) {
								GeeIterator* _tmp100_;
								gboolean _tmp101_ = FALSE;
								GeeIterator* _tmp102_;
								gpointer _tmp103_ = NULL;
								gchar* addr;
								GeeHashMap* _tmp104_;
								const gchar* _tmp105_;
								gpointer _tmp106_ = NULL;
								gchar* proto;
								EContact* _tmp107_;
								const gchar* _tmp108_;
								EContactField _tmp109_ = 0;
								const gchar* _tmp110_;
								_tmp100_ = _addr_it;
								_tmp101_ = gee_iterator_next (_tmp100_);
								if (!_tmp101_) {
									break;
								}
								_tmp102_ = _addr_it;
								_tmp103_ = gee_iterator_get (_tmp102_);
								addr = (gchar*) _tmp103_;
								_tmp104_ = addresses;
								_tmp105_ = addr;
								_tmp106_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp104_, _tmp105_);
								proto = (gchar*) _tmp106_;
								_tmp107_ = contact;
								_tmp108_ = proto;
								_tmp109_ = e_contact_field_id (_tmp108_);
								_tmp110_ = addr;
								e_contact_set (_tmp107_, _tmp109_, _tmp110_);
								_g_free0 (proto);
								_g_free0 (addr);
							}
							_g_object_unref0 (_addr_it);
						}
						_g_object_unref0 (addresses);
						_g_free0 (v);
					} else {
						const gchar* _tmp111_;
						const gchar* _tmp112_;
						_tmp111_ = k;
						_tmp112_ = EDSF_PERSONA_address_fields[0];
						if (g_strcmp0 (_tmp111_, _tmp112_) == 0) {
							GeeHashMap* _tmp113_;
							const gchar* _tmp114_;
							gpointer _tmp115_ = NULL;
							GValue* _tmp116_;
							GValue _tmp117_;
							GObject* _tmp118_ = NULL;
							FolksPostalAddressFieldDetails* _tmp119_;
							FolksPostalAddressFieldDetails* _tmp120_;
							FolksPostalAddressFieldDetails* pa_fd;
							FolksPostalAddressFieldDetails* _tmp121_;
							gconstpointer _tmp122_;
							FolksPostalAddress* _tmp123_;
							FolksPostalAddress* _tmp124_;
							FolksPostalAddress* pa;
							EContactAddress* _tmp125_;
							EContactAddress* address;
							EContactAddress* _tmp126_;
							FolksPostalAddress* _tmp127_;
							const gchar* _tmp128_;
							const gchar* _tmp129_;
							gchar* _tmp130_;
							EContactAddress* _tmp131_;
							FolksPostalAddress* _tmp132_;
							const gchar* _tmp133_;
							const gchar* _tmp134_;
							gchar* _tmp135_;
							EContactAddress* _tmp136_;
							FolksPostalAddress* _tmp137_;
							const gchar* _tmp138_;
							const gchar* _tmp139_;
							gchar* _tmp140_;
							EContactAddress* _tmp141_;
							FolksPostalAddress* _tmp142_;
							const gchar* _tmp143_;
							const gchar* _tmp144_;
							gchar* _tmp145_;
							EContactAddress* _tmp146_;
							FolksPostalAddress* _tmp147_;
							const gchar* _tmp148_;
							const gchar* _tmp149_;
							gchar* _tmp150_;
							EContactAddress* _tmp151_;
							FolksPostalAddress* _tmp152_;
							const gchar* _tmp153_;
							const gchar* _tmp154_;
							gchar* _tmp155_;
							EContactAddress* _tmp156_;
							FolksPostalAddress* _tmp157_;
							const gchar* _tmp158_;
							const gchar* _tmp159_;
							gchar* _tmp160_;
							EContactAddress* _tmp161_;
							FolksPostalAddress* _tmp162_;
							const gchar* _tmp163_;
							const gchar* _tmp164_;
							gchar* _tmp165_;
							EContact* _tmp166_;
							const gchar* _tmp167_;
							EContactField _tmp168_ = 0;
							EContactAddress* _tmp169_;
							_tmp113_ = c;
							_tmp114_ = k;
							_tmp115_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp113_, _tmp114_);
							_tmp116_ = (GValue*) _tmp115_;
							_tmp117_ = *_tmp116_;
							_tmp118_ = g_value_get_object (&_tmp117_);
							_tmp119_ = _g_object_ref0 (FOLKS_POSTAL_ADDRESS_FIELD_DETAILS (_tmp118_));
							_tmp120_ = _tmp119_;
							__vala_GValue_free0 (_tmp116_);
							pa_fd = _tmp120_;
							_tmp121_ = pa_fd;
							_tmp122_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp121_);
							_tmp123_ = _tmp122_;
							_tmp124_ = _g_object_ref0 (FOLKS_POSTAL_ADDRESS ((FolksPostalAddress*) _tmp123_));
							pa = _tmp124_;
							_tmp125_ = e_contact_address_new ();
							address = _tmp125_;
							_tmp126_ = address;
							_tmp127_ = pa;
							_tmp128_ = folks_postal_address_get_po_box (_tmp127_);
							_tmp129_ = _tmp128_;
							_tmp130_ = g_strdup (_tmp129_);
							_g_free0 (_tmp126_->po);
							_tmp126_->po = _tmp130_;
							_tmp131_ = address;
							_tmp132_ = pa;
							_tmp133_ = folks_postal_address_get_extension (_tmp132_);
							_tmp134_ = _tmp133_;
							_tmp135_ = g_strdup (_tmp134_);
							_g_free0 (_tmp131_->ext);
							_tmp131_->ext = _tmp135_;
							_tmp136_ = address;
							_tmp137_ = pa;
							_tmp138_ = folks_postal_address_get_street (_tmp137_);
							_tmp139_ = _tmp138_;
							_tmp140_ = g_strdup (_tmp139_);
							_g_free0 (_tmp136_->street);
							_tmp136_->street = _tmp140_;
							_tmp141_ = address;
							_tmp142_ = pa;
							_tmp143_ = folks_postal_address_get_locality (_tmp142_);
							_tmp144_ = _tmp143_;
							_tmp145_ = g_strdup (_tmp144_);
							_g_free0 (_tmp141_->locality);
							_tmp141_->locality = _tmp145_;
							_tmp146_ = address;
							_tmp147_ = pa;
							_tmp148_ = folks_postal_address_get_region (_tmp147_);
							_tmp149_ = _tmp148_;
							_tmp150_ = g_strdup (_tmp149_);
							_g_free0 (_tmp146_->region);
							_tmp146_->region = _tmp150_;
							_tmp151_ = address;
							_tmp152_ = pa;
							_tmp153_ = folks_postal_address_get_postal_code (_tmp152_);
							_tmp154_ = _tmp153_;
							_tmp155_ = g_strdup (_tmp154_);
							_g_free0 (_tmp151_->code);
							_tmp151_->code = _tmp155_;
							_tmp156_ = address;
							_tmp157_ = pa;
							_tmp158_ = folks_postal_address_get_country (_tmp157_);
							_tmp159_ = _tmp158_;
							_tmp160_ = g_strdup (_tmp159_);
							_g_free0 (_tmp156_->country);
							_tmp156_->country = _tmp160_;
							_tmp161_ = address;
							_tmp162_ = pa;
							_tmp163_ = folks_postal_address_get_address_format (_tmp162_);
							_tmp164_ = _tmp163_;
							_tmp165_ = g_strdup (_tmp164_);
							_g_free0 (_tmp161_->address_format);
							_tmp161_->address_format = _tmp165_;
							_tmp166_ = contact;
							_tmp167_ = k;
							_tmp168_ = e_contact_field_id (_tmp167_);
							_tmp169_ = address;
							e_contact_set (_tmp166_, _tmp168_, _tmp169_);
							__vala_EContactAddress_free0 (address);
							_g_object_unref0 (pa);
							_g_object_unref0 (pa_fd);
						} else {
							GeeHashMap* _tmp170_;
							const gchar* _tmp171_;
							gpointer _tmp172_ = NULL;
							GValue* _tmp173_;
							GValue _tmp174_;
							const gchar* _tmp175_ = NULL;
							gchar* _tmp176_;
							gchar* _tmp177_;
							gchar* v;
							EContact* _tmp178_;
							const gchar* _tmp179_;
							EContactField _tmp180_ = 0;
							const gchar* _tmp181_;
							_tmp170_ = c;
							_tmp171_ = k;
							_tmp172_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp170_, _tmp171_);
							_tmp173_ = (GValue*) _tmp172_;
							_tmp174_ = *_tmp173_;
							_tmp175_ = g_value_get_string (&_tmp174_);
							_tmp176_ = g_strdup (_tmp175_);
							_tmp177_ = _tmp176_;
							__vala_GValue_free0 (_tmp173_);
							v = _tmp177_;
							_tmp178_ = contact;
							_tmp179_ = k;
							_tmp180_ = e_contact_field_id (_tmp179_);
							_tmp181_ = v;
							e_contact_set (_tmp178_, _tmp180_, _tmp181_);
							_g_free0 (v);
						}
					}
				}
			}
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	_tmp182_ = added_contact_name;
	if (_tmp182_) {
		EContact* _tmp183_;
		EContactField _tmp184_ = 0;
		EContactName* _tmp185_;
		_tmp183_ = contact;
		_tmp184_ = e_contact_field_id ("name");
		_tmp185_ = contact_name;
		e_contact_set (_tmp183_, _tmp184_, _tmp185_);
	}
	_g_free0 (contact_field_name);
	__vala_EContactName_free0 (contact_name);
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
	{
		EBookClient* _tmp0_;
		gboolean _tmp1_ = FALSE;
		gboolean ret;
		gboolean _tmp2_;
		_tmp0_ = self->priv->_addressbook;
		_tmp1_ = e_client_remove_sync ((EClient*) _tmp0_, NULL, &_inner_error_);
		ret = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp2_ = ret;
		if (_tmp2_ == FALSE) {
			const gchar* _tmp3_;
			_tmp3_ = self->priv->_addressbook_name;
			g_warning ("backend.vala:264: remove() addressbook returned false on %s\n", _tmp3_);
		}
		_g_object_unref0 (self->priv->_addressbook);
		self->priv->_addressbook = NULL;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->_addressbook_name;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("backend.vala:272: Unable to remove addressbook %s because: %s\n", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GeeHashMap* _eds_test_backend_parse_addrs (EdsTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (addr_s != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp0_;
	_tmp1_ = addr_s;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
	im_addrs = _tmp3_;
	im_addrs_length1 = _vala_array_length (_tmp2_);
	_im_addrs_size_ = im_addrs_length1;
	_tmp4_ = im_addrs;
	_tmp4__length1 = im_addrs_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp4_;
		a_collection_length1 = _tmp4__length1;
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
			gchar* _tmp5_;
			gchar* a = NULL;
			_tmp5_ = g_strdup (a_collection[a_it]);
			a = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp6_ = a;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
				info = _tmp8_;
				info_length1 = _vala_array_length (_tmp7_);
				_info_size_ = info_length1;
				_tmp9_ = info;
				_tmp9__length1 = info_length1;
				_tmp10_ = _tmp9_[0];
				_tmp11_ = g_strdup (_tmp10_);
				proto = _tmp11_;
				_tmp12_ = info;
				_tmp12__length1 = info_length1;
				_tmp13_ = _tmp12_[1];
				_tmp14_ = g_strdup (_tmp13_);
				addr = _tmp14_;
				_tmp15_ = ret;
				_tmp16_ = addr;
				addr = NULL;
				_tmp17_ = _tmp16_;
				_tmp18_ = proto;
				proto = NULL;
				_tmp19_ = _tmp18_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (addr);
				_g_free0 (proto);
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	result = ret;
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void eds_test_value_backend_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void eds_test_value_backend_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		eds_test_backend_unref (value->data[0].v_pointer);
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = eds_test_backend_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer eds_test_value_get_backend (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
	return value->data[0].v_pointer;
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		eds_test_backend_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		eds_test_backend_unref (old);
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		eds_test_backend_unref (old);
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
	EDS_TEST_BACKEND_CLASS (klass)->finalize = eds_test_backend_finalize;
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
	self = EDS_TEST_BACKEND (obj);
	_g_free0 (self->priv->_addressbook_name);
	_g_object_unref0 (self->priv->_addressbook);
	__g_list_free__g_free0_0 (self->priv->_e_contacts);
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
	_g_object_unref0 (self->priv->_source_group);
	_g_object_unref0 (self->priv->_source);
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



