/* tr-backend.c generated by valac 0.13.3, the Vala compiler
 * generated from tr-backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/folks-tracker.h>


#define FOLKS_BACKENDS_TR_TYPE_BACKEND (folks_backends_tr_backend_get_type ())
#define FOLKS_BACKENDS_TR_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackend))
#define FOLKS_BACKENDS_TR_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendClass))
#define FOLKS_BACKENDS_TR_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND))
#define FOLKS_BACKENDS_TR_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_TR_TYPE_BACKEND))
#define FOLKS_BACKENDS_TR_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendClass))

typedef struct _FolksBackendsTrBackend FolksBackendsTrBackend;
typedef struct _FolksBackendsTrBackendClass FolksBackendsTrBackendClass;
typedef struct _FolksBackendsTrBackendPrivate FolksBackendsTrBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsTrBackendPrepareData FolksBackendsTrBackendPrepareData;
typedef struct _FolksBackendsTrBackendUnprepareData FolksBackendsTrBackendUnprepareData;

struct _FolksBackendsTrBackend {
	FolksBackend parent_instance;
	FolksBackendsTrBackendPrivate * priv;
};

struct _FolksBackendsTrBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsTrBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsTrBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTrBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_;
};

struct _FolksBackendsTrBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsTrBackend* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _persona_store_it;
	GeeIterator* _tmp6_;
	gboolean _tmp7_;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FolksPersonaStore* persona_store;
	FolksPersonaStore* _tmp10_;
	GeeHashMap* _tmp11_;
};


static gpointer folks_backends_tr_backend_parent_class = NULL;

GType folks_backends_tr_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_TR_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_TR_TYPE_BACKEND, FolksBackendsTrBackendPrivate))
enum  {
	FOLKS_BACKENDS_TR_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_TR_BACKEND_NAME,
	FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED
};
FolksBackendsTrBackend* folks_backends_tr_backend_new (void);
FolksBackendsTrBackend* folks_backends_tr_backend_construct (GType object_type);
static void folks_backends_tr_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_tr_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_tr_backend_real_prepare_co (FolksBackendsTrBackendPrepareData* _data_);
static void _folks_backends_tr_backend_add_default_persona_store (FolksBackendsTrBackend* self);
static void folks_backends_tr_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_tr_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_tr_backend_real_unprepare_co (FolksBackendsTrBackendUnprepareData* _data_);
static void _folks_backends_tr_backend_store_removed_cb (FolksBackendsTrBackend* self, FolksPersonaStore* store);
static void __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_tr_backend_finalize (GObject* obj);
static void _vala_folks_backends_tr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
FolksBackendsTrBackend* folks_backends_tr_backend_construct (GType object_type) {
	FolksBackendsTrBackend * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	self = (FolksBackendsTrBackend*) folks_backend_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return self;
}


FolksBackendsTrBackend* folks_backends_tr_backend_new (void) {
	return folks_backends_tr_backend_construct (FOLKS_BACKENDS_TR_TYPE_BACKEND);
}


static void folks_backends_tr_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsTrBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsTrBackendPrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_tr_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTrBackend * self;
	FolksBackendsTrBackendPrepareData* _data_;
	FolksBackendsTrBackend* _tmp0_;
	self = (FolksBackendsTrBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTrBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tr_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tr_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_tr_backend_real_prepare_co (_data_);
}


static void folks_backends_tr_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTrBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   */
static gboolean folks_backends_tr_backend_real_prepare_co (FolksBackendsTrBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp1_) {
				_folks_backends_tr_backend_add_default_persona_store (_data_->self);
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
			}
		}
		__finally0:
		{
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_tr_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsTrBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsTrBackendUnprepareData, _data_);
}


static void folks_backends_tr_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsTrBackend * self;
	FolksBackendsTrBackendUnprepareData* _data_;
	FolksBackendsTrBackend* _tmp0_;
	self = (FolksBackendsTrBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsTrBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_tr_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_tr_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_tr_backend_real_unprepare_co (_data_);
}


static void folks_backends_tr_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsTrBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_tr_backend_real_unprepare_co (FolksBackendsTrBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_persona_stores;
		_data_->_tmp1_ = gee_map_get_values ((GeeMap*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp3_);
		_data_->_persona_store_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_persona_store_it;
			_data_->_tmp7_ = FALSE;
			_data_->_tmp7_ = gee_iterator_next (_data_->_tmp6_);
			if (!_data_->_tmp7_) {
				break;
			}
			_data_->_tmp8_ = _data_->_persona_store_it;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->persona_store = (FolksPersonaStore*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->persona_store;
			g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", _data_->_tmp10_);
			_g_object_unref0 (_data_->persona_store);
		}
		_g_object_unref0 (_data_->_persona_store_it);
	}
	_data_->_tmp11_ = _data_->self->priv->_persona_stores;
	gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp11_);
	g_object_notify ((GObject*) _data_->self, "persona-stores");
	_data_->self->priv->_is_prepared = FALSE;
	g_object_notify ((GObject*) _data_->self, "is-prepared");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Add a the default Persona Store.
   */
static void __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_tr_backend_store_removed_cb (self, _sender);
}


static void _folks_backends_tr_backend_add_default_persona_store (FolksBackendsTrBackend* self) {
	TrfPersonaStore* _tmp0_;
	TrfPersonaStore* store;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = trf_persona_store_new ();
	store = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp3_, (FolksPersonaStore*) store);
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_object_notify ((GObject*) self, "persona-stores");
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	_g_object_unref0 (store);
}


static void _folks_backends_tr_backend_store_removed_cb (FolksBackendsTrBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	guint _tmp1_ = 0U;
	FolksPersonaStore* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_backends_tr_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp2_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp2_);
	_tmp3_ = folks_backend_get_persona_stores ((FolksBackend*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	gee_map_unset (_tmp4_, _tmp7_, NULL);
}


static const gchar* folks_backends_tr_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsTrBackend* self;
	self = (FolksBackendsTrBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_tr_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsTrBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsTrBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_tr_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsTrBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsTrBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static void folks_backends_tr_backend_class_init (FolksBackendsTrBackendClass * klass) {
	folks_backends_tr_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsTrBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_tr_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_tr_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_tr_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_tr_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_tr_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_tr_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_tr_backend_real_get_is_prepared;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_tr_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_tr_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED, "is-prepared");
}


static void folks_backends_tr_backend_instance_init (FolksBackendsTrBackend * self) {
	self->priv = FOLKS_BACKENDS_TR_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_tr_backend_finalize (GObject* obj) {
	FolksBackendsTrBackend * self;
	self = FOLKS_BACKENDS_TR_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	G_OBJECT_CLASS (folks_backends_tr_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to Tracker and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_tr_backend_get_type (void) {
	static volatile gsize folks_backends_tr_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_tr_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsTrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_tr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsTrBackend), 0, (GInstanceInitFunc) folks_backends_tr_backend_instance_init, NULL };
		GType folks_backends_tr_backend_type_id;
		folks_backends_tr_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsTrBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_tr_backend_type_id__volatile, folks_backends_tr_backend_type_id);
	}
	return folks_backends_tr_backend_type_id__volatile;
}


static void _vala_folks_backends_tr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsTrBackend * self;
	self = FOLKS_BACKENDS_TR_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_TR_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TR_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_TR_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



