/* object-cache.c generated by valac 0.13.3, the Vala compiler
 * generated from object-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define FOLKS_TYPE_OBJECT_CACHE (folks_object_cache_get_type ())
#define FOLKS_OBJECT_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_OBJECT_CACHE, FolksObjectCache))
#define FOLKS_OBJECT_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_OBJECT_CACHE, FolksObjectCacheClass))
#define FOLKS_IS_OBJECT_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_OBJECT_CACHE))
#define FOLKS_IS_OBJECT_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_OBJECT_CACHE))
#define FOLKS_OBJECT_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_OBJECT_CACHE, FolksObjectCacheClass))

typedef struct _FolksObjectCache FolksObjectCache;
typedef struct _FolksObjectCacheClass FolksObjectCacheClass;
typedef struct _FolksObjectCachePrivate FolksObjectCachePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _FolksObjectCacheLoadObjectsData FolksObjectCacheLoadObjectsData;
typedef struct _FolksObjectCacheStoreObjectsData FolksObjectCacheStoreObjectsData;
typedef struct _FolksObjectCacheClearCacheData FolksObjectCacheClearCacheData;
typedef struct _FolksObjectCacheCreateCacheDirectoryData FolksObjectCacheCreateCacheDirectoryData;

struct _FolksObjectCache {
	GObject parent_instance;
	FolksObjectCachePrivate * priv;
};

struct _FolksObjectCacheClass {
	GObjectClass parent_class;
	GVariantType* (*get_serialised_object_type) (FolksObjectCache* self);
	guint8 (*get_serialised_object_version) (FolksObjectCache* self);
	GVariant* (*serialise_object) (FolksObjectCache* self, gconstpointer object);
	gpointer (*deserialise_object) (FolksObjectCache* self, GVariant* variant);
};

struct _FolksObjectCachePrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gchar* _type_id;
	gchar* _id;
	GFile* _cache_directory;
	GFile* _cache_file;
};

struct _FolksObjectCacheLoadObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksObjectCache* self;
	GCancellable* cancellable;
	GeeSet* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GFile* _tmp5_;
	GCancellable* _tmp6_;
	guint8* _tmp7_;
	gint _tmp8_;
	GError* e;
	GError* _tmp9_;
	GError* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	guint8 _tmp26_;
	guint8 wrapper_version;
	guint8* _tmp27_;
	gint _tmp27__length1;
	guint8 _tmp28_;
	guint8 object_version;
	guint8 _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	guint8 _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* _tmp35_;
	gint _tmp35__length1;
	guint8* variant_data;
	gint variant_data_length1;
	gint _variant_data_size_;
	guint8 _tmp36_;
	guint8 _tmp37_;
	GVariantType* _tmp38_;
	GVariantType* variant_type;
	const GVariantType* _tmp39_;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8* _tmp41_;
	gint _tmp41__length1;
	guint8* _tmp42_;
	gint _tmp42__length1;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GVariant* variant;
	GVariant* _tmp45_;
	gboolean _tmp46_;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GVariant* _tmp50_;
	GVariant* _tmp51_;
	GVariant* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* type_id;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GFile* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	GVariant* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* id;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	GFile* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	GVariant* _tmp76_;
	GVariant* _tmp77_;
	GVariant* objects_variant;
	GeeHashSet* _tmp78_;
	GeeHashSet* objects;
	guint i;
	gboolean _tmp79_;
	gboolean _tmp80_;
	guint _tmp81_;
	guint _tmp82_;
	GVariant* _tmp83_;
	gsize _tmp84_;
	GVariant* _tmp85_;
	guint _tmp86_;
	GVariant* _tmp87_;
	GVariant* object_variant;
	GVariant* _tmp88_;
	gpointer _tmp89_;
	gpointer object;
	GeeHashSet* _tmp90_;
	gconstpointer _tmp91_;
	GError * _inner_error_;
};

struct _FolksObjectCacheStoreObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksObjectCache* self;
	GeeSet* objects;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* child_type;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GVariant** _tmp9_;
	GVariant** children;
	gint children_length1;
	gint _children_size_;
	guint i;
	GeeSet* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _object_it;
	GeeIterator* _tmp12_;
	gboolean _tmp13_;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	gpointer object;
	GVariant** _tmp16_;
	gint _tmp16__length1;
	guint _tmp17_;
	gconstpointer _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	guint8 wrapper_version;
	guint8 _tmp21_;
	guint8 object_version;
	const gchar* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	const gchar* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	const GVariantType* _tmp28_;
	GVariant** _tmp29_;
	gint _tmp29__length1;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GVariant** _tmp32_;
	GVariant** _tmp33_;
	gint _tmp33__length1;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	GVariant* variant;
	GVariant* _tmp37_;
	const GVariantType* _tmp38_;
	guint8 _tmp39_;
	guint8 _tmp40_;
	GVariantType* _tmp41_;
	GVariantType* _tmp42_;
	gboolean _tmp43_;
	GVariant* _tmp44_;
	gsize _tmp45_;
	guint8* _tmp46_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp47_;
	gint _tmp47__length1;
	guint8 _tmp48_;
	guint8 _tmp49_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	guint8 _tmp51_;
	guint8 _tmp52_;
	GVariant* _tmp53_;
	guint8* _tmp54_;
	gint _tmp54__length1;
	guint8* _tmp55_;
	gint _tmp55__length1;
	GFile* _tmp56_;
	guint8* _tmp57_;
	gint _tmp57__length1;
	guint8* _tmp58_;
	gint _tmp58__length1;
	GCancellable* _tmp59_;
	GError* e;
	GError* _tmp60_;
	GError* e2;
	GFile* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GError* _tmp64_;
	const gchar* _tmp65_;
	GError* _tmp66_;
	GFile* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GError* _tmp70_;
	const gchar* _tmp71_;
	GError * _inner_error_;
};

struct _FolksObjectCacheClearCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksObjectCache* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GError* e;
	GError * _inner_error_;
};

struct _FolksObjectCacheCreateCacheDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksObjectCache* self;
	GFile* _tmp0_;
	GError* e;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};


static gpointer folks_object_cache_parent_class = NULL;

GType folks_object_cache_get_type (void) G_GNUC_CONST;
#define FOLKS_OBJECT_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_OBJECT_CACHE, FolksObjectCachePrivate))
enum  {
	FOLKS_OBJECT_CACHE_DUMMY_PROPERTY,
	FOLKS_OBJECT_CACHE_T_TYPE,
	FOLKS_OBJECT_CACHE_T_DUP_FUNC,
	FOLKS_OBJECT_CACHE_T_DESTROY_FUNC
};
#define FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION ((guint8) 1)
#define FOLKS_OBJECT_CACHE__HEADER_WIDTH ((gsize) 8)
GVariantType* folks_object_cache_get_serialised_object_type (FolksObjectCache* self);
static GVariantType* folks_object_cache_real_get_serialised_object_type (FolksObjectCache* self);
guint8 folks_object_cache_get_serialised_object_version (FolksObjectCache* self);
static guint8 folks_object_cache_real_get_serialised_object_version (FolksObjectCache* self);
GVariant* folks_object_cache_serialise_object (FolksObjectCache* self, gconstpointer object);
static GVariant* folks_object_cache_real_serialise_object (FolksObjectCache* self, gconstpointer object);
gpointer folks_object_cache_deserialise_object (FolksObjectCache* self, GVariant* variant);
static gpointer folks_object_cache_real_deserialise_object (FolksObjectCache* self, GVariant* variant);
FolksObjectCache* folks_object_cache_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* type_id, const gchar* id);
static void folks_object_cache_load_objects_data_free (gpointer _data);
void folks_object_cache_load_objects (FolksObjectCache* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeSet* folks_object_cache_load_objects_finish (FolksObjectCache* self, GAsyncResult* _res_);
static gboolean folks_object_cache_load_objects_co (FolksObjectCacheLoadObjectsData* _data_);
static void folks_object_cache_load_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_object_cache_clear_cache (FolksObjectCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_object_cache_clear_cache_finish (FolksObjectCache* self, GAsyncResult* _res_);
static GVariantType* _folks_object_cache_get_cache_file_variant_type (FolksObjectCache* self, guint8 wrapper_version, guint8 object_version);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void folks_object_cache_store_objects_data_free (gpointer _data);
void folks_object_cache_store_objects (FolksObjectCache* self, GeeSet* objects, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_object_cache_store_objects_finish (FolksObjectCache* self, GAsyncResult* _res_);
static gboolean folks_object_cache_store_objects_co (FolksObjectCacheStoreObjectsData* _data_);
static void folks_object_cache_store_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_object_cache_create_cache_directory (FolksObjectCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_object_cache_create_cache_directory_finish (FolksObjectCache* self, GAsyncResult* _res_, GError** error);
static void folks_object_cache_clear_cache_data_free (gpointer _data);
static gboolean folks_object_cache_clear_cache_co (FolksObjectCacheClearCacheData* _data_);
static void _folks_object_cache_create_cache_directory_data_free (gpointer _data);
static gboolean _folks_object_cache_create_cache_directory_co (FolksObjectCacheCreateCacheDirectoryData* _data_);
static void folks_object_cache_finalize (GObject* obj);
static void _vala_folks_object_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_object_cache_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Get the {@link GLib.VariantType} of the serialised form of an object stored
   * in this cache.
   *
   * If a smooth upgrade path is needed in future due to cache file format
   * changes, this may be modified to take a version parameter.
   *
   * @since 0.6.0
   */
static GVariantType* folks_object_cache_real_get_serialised_object_type (FolksObjectCache* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_get_serialised_object_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GVariantType* folks_object_cache_get_serialised_object_type (FolksObjectCache* self) {
	return FOLKS_OBJECT_CACHE_GET_CLASS (self)->get_serialised_object_type (self);
}


/**
   * Get the version of the variant type returned by
   * {@link ObjectCache.get_serialised_object_type}. This must be incremented
   * every time the variant type changes so that old cache files aren't
   * misinterpreted.
   *
   * @since 0.6.0
   */
static guint8 folks_object_cache_real_get_serialised_object_version (FolksObjectCache* self) {
	g_return_val_if_fail (self != NULL, 0U);
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_get_serialised_object_version'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0U;
}


guint8 folks_object_cache_get_serialised_object_version (FolksObjectCache* self) {
	return FOLKS_OBJECT_CACHE_GET_CLASS (self)->get_serialised_object_version (self);
}


/**
   * Serialise the given `object` to a {@link GLib.Variant} and return the
   * variant. The variant must be of the type returned by
   * {@link ObjectCache.get_serialised_object_type}.
   *
   * @param object the object to serialise
   * @return serialised form of `object`
   *
   * @since 0.6.0
   */
static GVariant* folks_object_cache_real_serialise_object (FolksObjectCache* self, gconstpointer object) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_serialise_object'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GVariant* folks_object_cache_serialise_object (FolksObjectCache* self, gconstpointer object) {
	return FOLKS_OBJECT_CACHE_GET_CLASS (self)->serialise_object (self, object);
}


/**
   * Deserialise the given `variant` to a new instance of an object. The variant
   * is guaranteed to have the type returned by
   * {@link ObjectCache.get_serialised_object_type}.
   *
   * @param variant the serialised form to deserialise
   * @return the deserialised object
   *
   * @since 0.6.0
   */
static gpointer folks_object_cache_real_deserialise_object (FolksObjectCache* self, GVariant* variant) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_deserialise_object'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer folks_object_cache_deserialise_object (FolksObjectCache* self, GVariant* variant) {
	return FOLKS_OBJECT_CACHE_GET_CLASS (self)->deserialise_object (self, variant);
}


/**
   * Create a new cache instance using the given type ID and ID. This is
   * protected as the `type_id` will typically be set statically by subclasses.
   *
   * @param type_id A string identifying the type of object being cached. This
   * has to be suitable for use as a directory name; i.e. lower case,
   * hyphen-separated.
   * @param id A string identifying the particular cache instance. This will
   * form the file name of the cache file, but will be escaped beforehand, so
   * can be an arbitrary non-empty string.
   * @return A new cache instance
   *
   * @since 0.6.0
   */
FolksObjectCache* folks_object_cache_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* type_id, const gchar* id) {
	FolksObjectCache * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GFile* _tmp18_ = NULL;
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	self = (FolksObjectCache*) g_object_new (object_type, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = id;
	g_assert (g_strcmp0 (_tmp0_, "") != 0);
	_tmp1_ = type_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_type_id);
	self->priv->_type_id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp4_;
	_tmp5_ = type_id;
	_tmp6_ = id;
	g_debug ("object-cache.vala:124: Creating object cache for type ID '%s' with ID " \
"'%s'.", _tmp5_, _tmp6_);
	_tmp7_ = g_get_user_cache_dir ();
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_child (_tmp9_, "folks");
	_tmp11_ = _tmp10_;
	_tmp12_ = type_id;
	_tmp13_ = g_file_get_child (_tmp11_, _tmp12_);
	_g_object_unref0 (self->priv->_cache_directory);
	self->priv->_cache_directory = _tmp13_;
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	_tmp14_ = self->priv->_cache_directory;
	_tmp15_ = id;
	_tmp16_ = g_uri_escape_string (_tmp15_, "", FALSE);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_get_child (_tmp14_, _tmp17_);
	_g_object_unref0 (self->priv->_cache_file);
	self->priv->_cache_file = _tmp18_;
	_g_free0 (_tmp17_);
	return self;
}


static void folks_object_cache_load_objects_data_free (gpointer _data) {
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheLoadObjectsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void folks_object_cache_load_objects (FolksObjectCache* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksObjectCacheLoadObjectsData* _data_;
	FolksObjectCache* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (FolksObjectCacheLoadObjectsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_object_cache_load_objects);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_object_cache_load_objects_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	folks_object_cache_load_objects_co (_data_);
}


GeeSet* folks_object_cache_load_objects_finish (FolksObjectCache* self, GAsyncResult* _res_) {
	GeeSet* result;
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Load a set of objects from the cache and return them as a new set. If the
   * cache file doesn't exist, `null` will be returned. An empty set will be
   * returned if the cache file existed but was empty (i.e. was stored with
   * an empty set originally).
   *
   * Loading the objects can be cancelled using `cancellable`. If it is, `null`
   * will be returned.
   *
   * If any errors are encountered while loading the objects, warnings will be
   * logged as appropriate and `null` will be returned.
   *
   * @param cancellable A {@link GLib.Cancellable} for the operation, or `null`.
   * @return A set of objects from the cache, or `null`.
   *
   * @since 0.6.0
   */
static void folks_object_cache_load_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_object_cache_load_objects_co (_data_);
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean folks_object_cache_load_objects_co (FolksObjectCacheLoadObjectsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("object-cache.vala:154: Loading cache (type ID '%s', ID '%s') from file" \
" '%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->data_length1 = 0;
	_data_->_data_size_ = 0;
	{
		_data_->_tmp5_ = _data_->self->priv->_cache_file;
		_data_->_tmp6_ = _data_->cancellable;
		_data_->_tmp7_ = NULL;
		_data_->_tmp8_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp5_, _data_->_tmp6_, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp7_, &_data_->_tmp8_, NULL, &_data_->_inner_error_);
		_data_->data = (g_free (_data_->data), NULL);
		_data_->data = _data_->_tmp7_;
		_data_->data_length1 = _data_->_tmp8_;
		_data_->_data_size_ = _data_->data_length1;
		if (_data_->_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->e;
		if (g_error_matches (_data_->_tmp9_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
		} else {
			_data_->_tmp10_ = _data_->e;
			if (g_error_matches (_data_->_tmp10_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_data_->_tmp11_ = _data_->self->priv->_cache_file;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = g_file_get_path (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->e;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_debug ("object-cache.vala:172: Couldn't load cache file '%s': %s", _data_->_tmp13_, _data_->_tmp15_);
				_g_free0 (_data_->_tmp13_);
			} else {
				_data_->_tmp16_ = _data_->self->priv->_cache_file;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = g_file_get_path (_data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp19_ = _data_->e;
				_data_->_tmp20_ = _data_->_tmp19_->message;
				g_warning ("object-cache.vala:177: Couldn't load cache file '%s': %s", _data_->_tmp18_, _data_->_tmp20_);
				_g_free0 (_data_->_tmp18_);
			}
		}
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally27:
	if (_data_->_inner_error_ != NULL) {
		_data_->data = (g_free (_data_->data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->data;
	_data_->_tmp21__length1 = _data_->data_length1;
	if (((gsize) _data_->_tmp21__length1) < FOLKS_OBJECT_CACHE__HEADER_WIDTH) {
		_data_->_tmp22_ = _data_->self->priv->_cache_file;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		g_warning ("object-cache.vala:187: Cache file '%s' was too small. The file was del" \
"eted.", _data_->_tmp24_);
		_g_free0 (_data_->_tmp24_);
		_data_->_state_ = 2;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_2:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->data;
	_data_->_tmp25__length1 = _data_->data_length1;
	_data_->_tmp26_ = _data_->_tmp25_[0];
	_data_->wrapper_version = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->data;
	_data_->_tmp27__length1 = _data_->data_length1;
	_data_->_tmp28_ = _data_->_tmp27_[1];
	_data_->object_version = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->wrapper_version;
	if (_data_->_tmp29_ != FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION) {
		_data_->_tmp30_ = _data_->self->priv->_cache_file;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = g_file_get_path (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = _data_->wrapper_version;
		g_warning ("Cache file '%s' was version %u of the file format, " "but only version %u is supported. The file was deleted.", _data_->_tmp32_, _data_->_tmp33_, FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION);
		_g_free0 (_data_->_tmp32_);
		_data_->_state_ = 3;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_3:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->data;
	_data_->_tmp34__length1 = _data_->data_length1;
	_data_->_tmp35_ = _data_->data;
	_data_->_tmp35__length1 = _data_->data_length1;
	_data_->variant_data = _data_->_tmp34_ + FOLKS_OBJECT_CACHE__HEADER_WIDTH;
	_data_->variant_data_length1 = _data_->_tmp35__length1 - FOLKS_OBJECT_CACHE__HEADER_WIDTH;
	_data_->_variant_data_size_ = _data_->variant_data_length1;
	_data_->_tmp36_ = _data_->wrapper_version;
	_data_->_tmp37_ = _data_->object_version;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _folks_object_cache_get_cache_file_variant_type (_data_->self, _data_->_tmp36_, _data_->_tmp37_);
	_data_->variant_type = _data_->_tmp38_;
	_data_->_tmp39_ = _data_->variant_type;
	_data_->_tmp40_ = _data_->variant_data;
	_data_->_tmp40__length1 = _data_->variant_data_length1;
	_data_->_tmp41_ = _data_->data;
	_data_->_tmp41__length1 = _data_->data_length1;
	_data_->_tmp42_ = (_data_->_tmp41_ != NULL) ? _vala_array_dup1 (_data_->_tmp41_, _data_->_tmp41__length1) : ((gpointer) _data_->_tmp41_);
	_data_->_tmp42__length1 = _data_->_tmp41__length1;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = g_variant_new_from_data (_data_->_tmp39_, _data_->_tmp40_, _data_->_tmp40__length1, FALSE, g_free, _data_->_tmp42_);
	_data_->_tmp44_ = g_variant_ref_sink (_data_->_tmp43_);
	_data_->variant = _data_->_tmp44_;
	_data_->_tmp45_ = _data_->variant;
	_data_->_tmp46_ = FALSE;
	_data_->_tmp46_ = g_variant_is_normal_form (_data_->_tmp45_);
	if (_data_->_tmp46_ == FALSE) {
		_data_->_tmp47_ = _data_->self->priv->_cache_file;
		_data_->_tmp48_ = NULL;
		_data_->_tmp48_ = g_file_get_path (_data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		g_warning ("object-cache.vala:221: Cache file '%s' was corrupt and was deleted.", _data_->_tmp49_);
		_g_free0 (_data_->_tmp49_);
		_data_->_state_ = 4;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_4:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp50_ = _data_->variant;
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = g_variant_get_child_value (_data_->_tmp50_, (gsize) 0);
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = g_variant_get_string (_data_->_tmp52_, NULL);
	_data_->_tmp54_ = g_strdup (_data_->_tmp53_);
	_data_->_tmp55_ = _data_->_tmp54_;
	_g_variant_unref0 (_data_->_tmp52_);
	_data_->type_id = _data_->_tmp55_;
	_data_->_tmp56_ = _data_->type_id;
	_data_->_tmp57_ = _data_->self->priv->_type_id;
	if (g_strcmp0 (_data_->_tmp56_, _data_->_tmp57_) != 0) {
		_data_->_tmp58_ = _data_->self->priv->_cache_file;
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = g_file_get_path (_data_->_tmp58_);
		_data_->_tmp60_ = _data_->_tmp59_;
		_data_->_tmp61_ = _data_->type_id;
		_data_->_tmp62_ = _data_->self->priv->_type_id;
		g_warning ("Cache file '%s' had type ID '%s', but '%s' was expected." "The file was deleted.", _data_->_tmp60_, _data_->_tmp61_, _data_->_tmp62_);
		_g_free0 (_data_->_tmp60_);
		_data_->_state_ = 5;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_5:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_free0 (_data_->type_id);
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp63_ = _data_->variant;
	_data_->_tmp64_ = NULL;
	_data_->_tmp64_ = g_variant_get_child_value (_data_->_tmp63_, (gsize) 1);
	_data_->_tmp65_ = _data_->_tmp64_;
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = g_variant_get_string (_data_->_tmp65_, NULL);
	_data_->_tmp67_ = g_strdup (_data_->_tmp66_);
	_data_->_tmp68_ = _data_->_tmp67_;
	_g_variant_unref0 (_data_->_tmp65_);
	_data_->id = _data_->_tmp68_;
	_data_->_tmp69_ = _data_->id;
	_data_->_tmp70_ = _data_->self->priv->_id;
	if (g_strcmp0 (_data_->_tmp69_, _data_->_tmp70_) != 0) {
		_data_->_tmp71_ = _data_->self->priv->_cache_file;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = g_file_get_path (_data_->_tmp71_);
		_data_->_tmp73_ = _data_->_tmp72_;
		_data_->_tmp74_ = _data_->id;
		_data_->_tmp75_ = _data_->self->priv->_id;
		g_warning ("Cache file '%s' had ID '%s', but '%s' was expected." "The file was deleted.", _data_->_tmp73_, _data_->_tmp74_, _data_->_tmp75_);
		_g_free0 (_data_->_tmp73_);
		_data_->_state_ = 6;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_6:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_free0 (_data_->id);
		_g_free0 (_data_->type_id);
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp76_ = _data_->variant;
	_data_->_tmp77_ = NULL;
	_data_->_tmp77_ = g_variant_get_child_value (_data_->_tmp76_, (gsize) 2);
	_data_->objects_variant = _data_->_tmp77_;
	_data_->_tmp78_ = gee_hash_set_new (_data_->self->priv->t_type, (GBoxedCopyFunc) _data_->self->priv->t_dup_func, _data_->self->priv->t_destroy_func, NULL, NULL);
	_data_->objects = _data_->_tmp78_;
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp79_ = TRUE;
			while (TRUE) {
				_data_->_tmp80_ = _data_->_tmp79_;
				if (!_data_->_tmp80_) {
					_data_->_tmp81_ = _data_->i;
					_data_->i = _data_->_tmp81_ + 1;
				}
				_data_->_tmp79_ = FALSE;
				_data_->_tmp82_ = _data_->i;
				_data_->_tmp83_ = _data_->objects_variant;
				_data_->_tmp84_ = 0UL;
				_data_->_tmp84_ = g_variant_n_children (_data_->_tmp83_);
				if (!(((gsize) _data_->_tmp82_) < _data_->_tmp84_)) {
					break;
				}
				_data_->_tmp85_ = _data_->objects_variant;
				_data_->_tmp86_ = _data_->i;
				_data_->_tmp87_ = NULL;
				_data_->_tmp87_ = g_variant_get_child_value (_data_->_tmp85_, (gsize) _data_->_tmp86_);
				_data_->object_variant = _data_->_tmp87_;
				_data_->_tmp88_ = _data_->object_variant;
				_data_->_tmp89_ = NULL;
				_data_->_tmp89_ = folks_object_cache_deserialise_object (_data_->self, _data_->_tmp88_);
				_data_->object = _data_->_tmp89_;
				_data_->_tmp90_ = _data_->objects;
				_data_->_tmp91_ = _data_->object;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp90_, _data_->_tmp91_);
				((_data_->object == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->object = (_data_->self->priv->t_destroy_func (_data_->object), NULL));
				_g_variant_unref0 (_data_->object_variant);
			}
		}
	}
	_data_->result = (GeeSet*) _data_->objects;
	_g_variant_unref0 (_data_->objects_variant);
	_g_free0 (_data_->id);
	_g_free0 (_data_->type_id);
	_g_variant_unref0 (_data_->variant);
	_g_variant_type_free0 (_data_->variant_type);
	_data_->data = (g_free (_data_->data), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->objects);
	_g_variant_unref0 (_data_->objects_variant);
	_g_free0 (_data_->id);
	_g_free0 (_data_->type_id);
	_g_variant_unref0 (_data_->variant);
	_g_variant_type_free0 (_data_->variant_type);
	_data_->data = (g_free (_data_->data), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_object_cache_store_objects_data_free (gpointer _data) {
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->objects);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheStoreObjectsData, _data_);
}


void folks_object_cache_store_objects (FolksObjectCache* self, GeeSet* objects, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksObjectCacheStoreObjectsData* _data_;
	FolksObjectCache* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (FolksObjectCacheStoreObjectsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_object_cache_store_objects);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_object_cache_store_objects_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = objects;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->objects = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	folks_object_cache_store_objects_co (_data_);
}


void folks_object_cache_store_objects_finish (FolksObjectCache* self, GAsyncResult* _res_) {
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Store a set of objects to the cache file, overwriting any existing set of
   * objects in the cache, or creating the cache file from scratch if it didn't
   * previously exist.
   *
   * Storing the objects can be cancelled using `cancellable`. If it is, the
   * cache will be left in a consistent state, but may be storing the old set
   * of objects or the new set.
   *
   * @param objects A set of objects to store. This may be empty, but may not
   * be `null`.
   * @param cancellable A {@link GLib.Cancellable} for the operation, or `null`.
   *
   * @since 0.6.0
   */
static void folks_object_cache_store_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_object_cache_store_objects_co (_data_);
}


static gboolean folks_object_cache_store_objects_co (FolksObjectCacheStoreObjectsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("object-cache.vala:286: Storing cache (type ID '%s', ID '%s') to file '" \
"%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = folks_object_cache_get_serialised_object_type (_data_->self);
	_data_->child_type = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->objects;
	_data_->_tmp7_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_new0 (GVariant*, _data_->_tmp8_ + 1);
	_data_->children = _data_->_tmp9_;
	_data_->children_length1 = _data_->_tmp8_;
	_data_->_children_size_ = _data_->children_length1;
	_data_->i = (guint) 0;
	{
		_data_->_tmp10_ = _data_->objects;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp10_);
		_data_->_object_it = _data_->_tmp11_;
		while (TRUE) {
			_data_->_tmp12_ = _data_->_object_it;
			_data_->_tmp13_ = FALSE;
			_data_->_tmp13_ = gee_iterator_next (_data_->_tmp12_);
			if (!_data_->_tmp13_) {
				break;
			}
			_data_->_tmp14_ = _data_->_object_it;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
			_data_->object = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->children;
			_data_->_tmp16__length1 = _data_->children_length1;
			_data_->_tmp17_ = _data_->i;
			_data_->i = _data_->_tmp17_ + 1;
			_data_->_tmp18_ = _data_->object;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = folks_object_cache_serialise_object (_data_->self, _data_->_tmp18_);
			_g_variant_unref0 (_data_->_tmp16_[_data_->_tmp17_]);
			_data_->_tmp16_[_data_->_tmp17_] = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->_tmp16_[_data_->_tmp17_];
			((_data_->object == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->object = (_data_->self->priv->t_destroy_func (_data_->object), NULL));
		}
		_g_object_unref0 (_data_->_object_it);
	}
	_data_->wrapper_version = FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION;
	_data_->_tmp21_ = 0U;
	_data_->_tmp21_ = folks_object_cache_get_serialised_object_version (_data_->self);
	_data_->object_version = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->self->priv->_type_id;
	_data_->_tmp23_ = g_variant_new_string (_data_->_tmp22_);
	_data_->_tmp24_ = g_variant_ref_sink (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->self->priv->_id;
	_data_->_tmp26_ = g_variant_new_string (_data_->_tmp25_);
	_data_->_tmp27_ = g_variant_ref_sink (_data_->_tmp26_);
	_data_->_tmp28_ = _data_->child_type;
	_data_->_tmp29_ = _data_->children;
	_data_->_tmp29__length1 = _data_->children_length1;
	_data_->_tmp30_ = g_variant_new_array (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp29__length1);
	_data_->_tmp31_ = g_variant_ref_sink (_data_->_tmp30_);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = g_new0 (GVariant*, 3 + 1);
	_data_->_tmp32_[0] = _data_->_tmp24_;
	_data_->_tmp32_[1] = _data_->_tmp27_;
	_data_->_tmp32_[2] = _data_->_tmp31_;
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp33__length1 = 3;
	_data_->_tmp34_ = g_variant_new_tuple (_data_->_tmp33_, 3);
	_data_->_tmp35_ = g_variant_ref_sink (_data_->_tmp34_);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp33_ = (_vala_array_free (_data_->_tmp33_, _data_->_tmp33__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->variant = _data_->_tmp36_;
	_data_->_tmp37_ = _data_->variant;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = g_variant_get_type (_data_->_tmp37_);
	_data_->_tmp39_ = _data_->wrapper_version;
	_data_->_tmp40_ = _data_->object_version;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _folks_object_cache_get_cache_file_variant_type (_data_->self, _data_->_tmp39_, _data_->_tmp40_);
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = FALSE;
	_data_->_tmp43_ = g_variant_type_equal (_data_->_tmp38_, _data_->_tmp42_);
	g_assert (_data_->_tmp43_);
	_g_variant_type_free0 (_data_->_tmp42_);
	_data_->_tmp44_ = _data_->variant;
	_data_->_tmp45_ = 0UL;
	_data_->_tmp45_ = g_variant_get_size (_data_->_tmp44_);
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = g_new0 (guint8, FOLKS_OBJECT_CACHE__HEADER_WIDTH + _data_->_tmp45_);
	_data_->data = _data_->_tmp46_;
	_data_->data_length1 = FOLKS_OBJECT_CACHE__HEADER_WIDTH + _data_->_tmp45_;
	_data_->_data_size_ = _data_->data_length1;
	_data_->_tmp47_ = _data_->data;
	_data_->_tmp47__length1 = _data_->data_length1;
	_data_->_tmp48_ = _data_->wrapper_version;
	_data_->_tmp47_[0] = _data_->_tmp48_;
	_data_->_tmp49_ = _data_->_tmp47_[0];
	_data_->_tmp50_ = _data_->data;
	_data_->_tmp50__length1 = _data_->data_length1;
	_data_->_tmp51_ = _data_->object_version;
	_data_->_tmp50_[1] = _data_->_tmp51_;
	_data_->_tmp52_ = _data_->_tmp50_[1];
	_data_->_tmp53_ = _data_->variant;
	_data_->_tmp54_ = _data_->data;
	_data_->_tmp54__length1 = _data_->data_length1;
	_data_->_tmp55_ = _data_->data;
	_data_->_tmp55__length1 = _data_->data_length1;
	g_variant_store (_data_->_tmp53_, _data_->_tmp54_ + FOLKS_OBJECT_CACHE__HEADER_WIDTH);
	while (TRUE) {
		{
			_data_->_tmp56_ = _data_->self->priv->_cache_file;
			_data_->_tmp57_ = _data_->data;
			_data_->_tmp57__length1 = _data_->data_length1;
			_data_->_tmp58_ = _data_->data;
			_data_->_tmp58__length1 = _data_->data_length1;
			_data_->_tmp59_ = _data_->cancellable;
			_data_->_state_ = 1;
			g_file_replace_contents_async (_data_->_tmp56_, (const gchar*) _data_->_tmp57_, (gsize) _data_->_tmp58__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, _data_->_tmp59_, folks_object_cache_store_objects_ready, _data_);
			return FALSE;
			_state_1:
			g_file_replace_contents_finish (_data_->_tmp56_, _data_->_res_, NULL, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch28_g_error;
			}
			break;
		}
		goto __finally28;
		__catch28_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp60_ = _data_->e;
			if (g_error_matches (_data_->_tmp60_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				{
					_data_->_state_ = 2;
					_folks_object_cache_create_cache_directory (_data_->self, folks_object_cache_store_objects_ready, _data_);
					return FALSE;
					_state_2:
					_folks_object_cache_create_cache_directory_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						goto __catch29_g_error;
					}
					_g_error_free0 (_data_->e);
					continue;
				}
				goto __finally29;
				__catch29_g_error:
				{
					_data_->e2 = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp61_ = _data_->self->priv->_cache_directory;
					_data_->_tmp62_ = NULL;
					_data_->_tmp62_ = g_file_get_path (_data_->_tmp61_);
					_data_->_tmp63_ = _data_->_tmp62_;
					_data_->_tmp64_ = _data_->e;
					_data_->_tmp65_ = _data_->_tmp64_->message;
					g_warning ("object-cache.vala:339: Couldn't create cache directory '%s': %s", _data_->_tmp63_, _data_->_tmp65_);
					_g_free0 (_data_->_tmp63_);
					_g_error_free0 (_data_->e2);
					_g_error_free0 (_data_->e);
					_data_->data = (g_free (_data_->data), NULL);
					_g_variant_unref0 (_data_->variant);
					_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
					_g_variant_type_free0 (_data_->child_type);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally29:
				_g_error_free0 (_data_->e);
				_g_error_free0 (_data_->e);
				_data_->data = (g_free (_data_->data), NULL);
				_g_variant_unref0 (_data_->variant);
				_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_type_free0 (_data_->child_type);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			} else {
				_data_->_tmp66_ = _data_->e;
				if (g_error_matches (_data_->_tmp66_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					_g_error_free0 (_data_->e);
					_data_->data = (g_free (_data_->data), NULL);
					_g_variant_unref0 (_data_->variant);
					_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
					_g_variant_type_free0 (_data_->child_type);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp67_ = _data_->self->priv->_cache_file;
			_data_->_tmp68_ = NULL;
			_data_->_tmp68_ = g_file_get_path (_data_->_tmp67_);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->_tmp70_ = _data_->e;
			_data_->_tmp71_ = _data_->_tmp70_->message;
			g_warning ("object-cache.vala:353: Couldn't write to cache file '%s', so deleting " \
"it: %s", _data_->_tmp69_, _data_->_tmp71_);
			_g_free0 (_data_->_tmp69_);
			_data_->_state_ = 3;
			folks_object_cache_clear_cache (_data_->self, folks_object_cache_store_objects_ready, _data_);
			return FALSE;
			_state_3:
			folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
			_g_error_free0 (_data_->e);
			_data_->data = (g_free (_data_->data), NULL);
			_g_variant_unref0 (_data_->variant);
			_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_variant_type_free0 (_data_->child_type);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally28:
		_data_->data = (g_free (_data_->data), NULL);
		_g_variant_unref0 (_data_->variant);
		_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_variant_type_free0 (_data_->child_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->data = (g_free (_data_->data), NULL);
	_g_variant_unref0 (_data_->variant);
	_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_variant_type_free0 (_data_->child_type);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_object_cache_clear_cache_data_free (gpointer _data) {
	FolksObjectCacheClearCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheClearCacheData, _data_);
}


void folks_object_cache_clear_cache (FolksObjectCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksObjectCacheClearCacheData* _data_;
	FolksObjectCache* _tmp0_;
	_data_ = g_slice_new0 (FolksObjectCacheClearCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_object_cache_clear_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_object_cache_clear_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_object_cache_clear_cache_co (_data_);
}


void folks_object_cache_clear_cache_finish (FolksObjectCache* self, GAsyncResult* _res_) {
	FolksObjectCacheClearCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Clear this cache object, deleting its backing file.
   *
   * @since 0.6.0
   */
static gboolean folks_object_cache_clear_cache_co (FolksObjectCacheClearCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("object-cache.vala:369: Clearing cache (type ID '%s', ID '%s'); deletin" \
"g file '%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	{
		_data_->_tmp5_ = _data_->self->priv->_cache_file;
		g_file_delete (_data_->_tmp5_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally30:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _g_variant_type_copy0 (gpointer self) {
	return self ? g_variant_type_copy (self) : NULL;
}


static GVariantType* _folks_object_cache_get_cache_file_variant_type (FolksObjectCache* self, guint8 wrapper_version, guint8 object_version) {
	GVariantType* result = NULL;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	const GVariantType* _tmp2_;
	GVariantType* _tmp3_;
	GVariantType* _tmp4_ = NULL;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType** _tmp7_ = NULL;
	GVariantType** _tmp8_;
	gint _tmp8__length1;
	GVariantType* _tmp9_;
	GVariantType* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_tmp1_ = _g_variant_type_copy0 (_tmp0_);
	_tmp2_ = G_VARIANT_TYPE_STRING;
	_tmp3_ = _g_variant_type_copy0 (_tmp2_);
	_tmp4_ = folks_object_cache_get_serialised_object_type (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_type_new_array (_tmp5_);
	_tmp7_ = g_new0 (GVariantType*, 3 + 1);
	_tmp7_[0] = _tmp1_;
	_tmp7_[1] = _tmp3_;
	_tmp7_[2] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	_tmp9_ = g_variant_type_new_tuple (_tmp8_, 3);
	_tmp10_ = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_variant_type_free), NULL);
	_g_variant_type_free0 (_tmp5_);
	result = _tmp10_;
	return result;
}


static void _folks_object_cache_create_cache_directory_data_free (gpointer _data) {
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheCreateCacheDirectoryData, _data_);
}


static void _folks_object_cache_create_cache_directory (FolksObjectCache* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	FolksObjectCache* _tmp0_;
	_data_ = g_slice_new0 (FolksObjectCacheCreateCacheDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_object_cache_create_cache_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_object_cache_create_cache_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_object_cache_create_cache_directory_co (_data_);
}


static void _folks_object_cache_create_cache_directory_finish (FolksObjectCache* self, GAsyncResult* _res_, GError** error) {
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean _folks_object_cache_create_cache_directory_co (FolksObjectCacheCreateCacheDirectoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_cache_directory;
		g_file_make_directory_with_parents (_data_->_tmp0_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp1_ = _data_->e;
		if (!g_error_matches (_data_->_tmp1_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp2_ = _data_->e;
			_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
			_data_->_inner_error_ = _data_->_tmp3_;
			_g_error_free0 (_data_->e);
			goto __finally31;
		}
		_g_error_free0 (_data_->e);
	}
	__finally31:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_object_cache_class_init (FolksObjectCacheClass * klass) {
	folks_object_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksObjectCachePrivate));
	FOLKS_OBJECT_CACHE_CLASS (klass)->get_serialised_object_type = folks_object_cache_real_get_serialised_object_type;
	FOLKS_OBJECT_CACHE_CLASS (klass)->get_serialised_object_version = folks_object_cache_real_get_serialised_object_version;
	FOLKS_OBJECT_CACHE_CLASS (klass)->serialise_object = folks_object_cache_real_serialise_object;
	FOLKS_OBJECT_CACHE_CLASS (klass)->deserialise_object = folks_object_cache_real_deserialise_object;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_object_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_object_cache_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_object_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void folks_object_cache_instance_init (FolksObjectCache * self) {
	self->priv = FOLKS_OBJECT_CACHE_GET_PRIVATE (self);
}


static void folks_object_cache_finalize (GObject* obj) {
	FolksObjectCache * self;
	self = FOLKS_OBJECT_CACHE (obj);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_cache_directory);
	_g_object_unref0 (self->priv->_cache_file);
	G_OBJECT_CLASS (folks_object_cache_parent_class)->finalize (obj);
}


/**
 * A generic abstract cache for sets of objects. This can be used by subclasses
 * to implement caching of homogeneous sets of objects. Subclasses simply have
 * to implement serialisation and deserialisation of the objects to and from
 * {@link GLib.Variant}s.
 *
 * It's intended that this class be used for providing caching layers for
 * {@link PersonaStore}s, for example.
 *
 * @since 0.6.0
 */
GType folks_object_cache_get_type (void) {
	static volatile gsize folks_object_cache_type_id__volatile = 0;
	if (g_once_init_enter (&folks_object_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksObjectCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_object_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksObjectCache), 0, (GInstanceInitFunc) folks_object_cache_instance_init, NULL };
		GType folks_object_cache_type_id;
		folks_object_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksObjectCache", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_object_cache_type_id__volatile, folks_object_cache_type_id);
	}
	return folks_object_cache_type_id__volatile;
}


static void _vala_folks_object_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksObjectCache * self;
	self = FOLKS_OBJECT_CACHE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_object_cache_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksObjectCache * self;
	self = FOLKS_OBJECT_CACHE (object);
	switch (property_id) {
		case FOLKS_OBJECT_CACHE_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case FOLKS_OBJECT_CACHE_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case FOLKS_OBJECT_CACHE_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



