/* backend.c generated by valac 0.13.3, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors :Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdio.h>
#include <gio/gio.h>
#include <folks/folks-tracker.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TEST_TYPE_BACKEND (tracker_test_backend_get_type ())
#define TRACKER_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackend))
#define TRACKER_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))
#define TRACKER_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TEST_TYPE_BACKEND))
#define TRACKER_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendClass))

typedef struct _TrackerTestBackend TrackerTestBackend;
typedef struct _TrackerTestBackendClass TrackerTestBackendClass;
typedef struct _TrackerTestBackendPrivate TrackerTestBackendPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerTestParamSpecBackend TrackerTestParamSpecBackend;

typedef enum  {
	TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED
} TrackerTestBackendSetupError;
#define TRACKER_TEST_BACKEND_SETUP_ERROR tracker_test_backend_setup_error_quark ()
struct _TrackerTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerTestBackendPrivate * priv;
};

struct _TrackerTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerTestBackend *self);
};

struct _TrackerTestBackendPrivate {
	gboolean _debug;
	GList* _contacts;
	TrackerSparqlConnection* _connection;
};

struct _TrackerTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer tracker_test_backend_parent_class = NULL;

GQuark tracker_test_backend_setup_error_quark (void);
gpointer tracker_test_backend_ref (gpointer instance);
void tracker_test_backend_unref (gpointer instance);
GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_test_value_set_backend (GValue* value, gpointer v_object);
void tracker_test_value_take_backend (GValue* value, gpointer v_object);
gpointer tracker_test_value_get_backend (const GValue* value);
GType tracker_test_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TEST_TYPE_BACKEND, TrackerTestBackendPrivate))
enum  {
	TRACKER_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define TRACKER_TEST_BACKEND_URN "urn:contact"
#define TRACKER_TEST_BACKEND_URLS "nco:urls"
TrackerTestBackend* tracker_test_backend_new (void);
TrackerTestBackend* tracker_test_backend_construct (GType object_type);
void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value);
void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c);
static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig);
void tracker_test_backend_tear_down (TrackerTestBackend* self);
void tracker_test_backend_reset (TrackerTestBackend* self);
void tracker_test_backend_set_up (TrackerTestBackend* self);
static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error);
static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error);
gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject);
static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query);
gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite);
gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id);
gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn);
gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c);
gboolean tracker_test_backend_get_debug (TrackerTestBackend* self);
static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact);
static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s);
static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1);
static void tracker_test_backend_finalize (TrackerTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark tracker_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("tracker_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
#line 34 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 131 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 34 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 34 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_list_free (self);
#line 140 "backend.c"
}


TrackerTestBackend* tracker_test_backend_construct (GType object_type) {
	TrackerTestBackend* self = NULL;
#line 38 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self = (TrackerTestBackend*) g_type_create_instance (object_type);
#line 40 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_test_backend_set_debug (self, FALSE);
#line 41 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 41 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = NULL;
#line 38 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return self;
#line 156 "backend.c"
}


TrackerTestBackend* tracker_test_backend_new (void) {
#line 38 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return tracker_test_backend_construct (TRACKER_TEST_TYPE_BACKEND);
#line 163 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 47 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 170 "backend.c"
}


void tracker_test_backend_add_contact (TrackerTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* contact;
	GeeHashMap* _tmp2_;
#line 44 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 44 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (c != NULL);
#line 46 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = c;
#line 46 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = _tracker_test_backend_copy_hash_map (self, _tmp0_);
#line 46 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	contact = _tmp1_;
#line 47 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = _g_object_ref0 (contact);
#line 47 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp2_);
#line 44 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (contact);
#line 195 "backend.c"
}


void tracker_test_backend_tear_down (TrackerTestBackend* self) {
#line 51 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 202 "backend.c"
}


void tracker_test_backend_reset (TrackerTestBackend* self) {
#line 56 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 58 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 58 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = NULL;
#line 213 "backend.c"
}


void tracker_test_backend_set_up (TrackerTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 62 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 221 "backend.c"
	{
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tracker_test_backend_setup_connection (self, &_inner_error_);
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_ != NULL) {
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 229 "backend.c"
				goto __catch0_tracker_test_backend_setup_error;
			}
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 66 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 238 "backend.c"
		}
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tracker_test_backend_add_contacts (self, &_inner_error_);
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_ != NULL) {
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 246 "backend.c"
				goto __catch0_tracker_test_backend_setup_error;
			}
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 67 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 255 "backend.c"
		}
	}
	goto __finally0;
	__catch0_tracker_test_backend_setup_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e = _inner_error_;
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 71 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp0_ = e;
#line 71 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = _tmp0_->message;
#line 71 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:71: unable to create test data: %s\n", _tmp1_);
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e);
#line 276 "backend.c"
	}
	__finally0:
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_inner_error_ != NULL) {
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_clear_error (&_inner_error_);
#line 64 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return;
#line 287 "backend.c"
	}
}


gboolean tracker_test_backend_update_contact (TrackerTestBackend* self, const gchar* contact_urn, const gchar* predicate, const gchar* literal_subject) {
	gboolean result = FALSE;
#line 78 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char delete_query_t[] = "DELETE { %s %s ?a } WHERE " "{ ?p a nco:PersonContact " " ; %s ?a . FILTER(?p = %s ) } ";
#line 81 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char update_query_t[] = "INSERT { %s %s '%s' } ";
#line 298 "backend.c"
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* delete_query;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* update_query;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
#line 75 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact_urn != NULL, FALSE);
#line 75 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (predicate != NULL, FALSE);
#line 75 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (literal_subject != NULL, FALSE);
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = contact_urn;
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = predicate;
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = predicate;
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = contact_urn;
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = g_strdup_printf (delete_query_t, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 83 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp4_;
#line 85 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = delete_query;
#line 85 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = _tracker_test_backend_do_update_query (self, _tmp5_);
#line 85 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp6_ == FALSE) {
#line 87 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:87: Couldn't delete the old triplet");
#line 88 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 88 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 88 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 348 "backend.c"
	}
#line 91 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = contact_urn;
#line 91 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = predicate;
#line 91 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = literal_subject;
#line 91 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strdup_printf (update_query_t, _tmp7_, _tmp8_, _tmp9_);
#line 91 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	update_query = _tmp10_;
#line 93 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = update_query;
#line 93 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 93 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 95 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:95: Couldn't insert the triplet");
#line 96 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 96 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (update_query);
#line 96 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 96 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 376 "backend.c"
	}
#line 99 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 99 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (update_query);
#line 99 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 99 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 386 "backend.c"
}


gboolean tracker_test_backend_update_favourite (TrackerTestBackend* self, const gchar* contact_urn, gboolean is_favourite) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* q;
	gboolean _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
#line 102 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 102 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact_urn != NULL, FALSE);
#line 104 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 104 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	q = _tmp0_;
#line 106 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = is_favourite;
#line 106 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp1_) {
#line 414 "backend.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 108 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = q;
#line 108 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = g_strconcat (_tmp2_, "INSERT { ", NULL);
#line 108 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 108 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		q = _tmp3_;
#line 425 "backend.c"
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 112 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = q;
#line 112 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = g_strconcat (_tmp4_, "DELETE { ", NULL);
#line 112 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 112 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		q = _tmp5_;
#line 437 "backend.c"
	}
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = q;
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = contact_urn;
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = g_strconcat (_tmp7_, " nao:hasTag nao:predefined-tag-favorite } ", NULL);
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = _tmp8_;
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	q = _tmp10_;
#line 114 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp9_);
#line 116 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = q;
#line 116 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 116 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 118 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:118: Couldn't change favourite status");
#line 119 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 119 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 119 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 469 "backend.c"
	}
#line 122 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 122 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 122 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 477 "backend.c"
}


gboolean tracker_test_backend_remove_contact (TrackerTestBackend* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* delete_query;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
#line 125 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (tracker_id != NULL, FALSE);
#line 127 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("DELETE { ?p a nco:PersonContact } ");
#line 127 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp0_;
#line 128 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = delete_query;
#line 128 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = g_strconcat (_tmp1_, "WHERE { ?p a nco:PersonContact . FILTER(tracker:id(?p) ", NULL);
#line 128 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 128 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp2_;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = delete_query;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = tracker_id;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = g_strconcat ("= ", _tmp4_, NULL);
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = _tmp5_;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = g_strconcat (_tmp6_, ") } ", NULL);
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = _tmp7_;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = g_strconcat (_tmp3_, _tmp8_, NULL);
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	delete_query = _tmp9_;
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp8_);
#line 129 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp6_);
#line 131 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = delete_query;
#line 131 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = _tracker_test_backend_do_update_query (self, _tmp10_);
#line 131 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp11_ == FALSE) {
#line 133 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:133: Couldn't delete the contact");
#line 134 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 134 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (delete_query);
#line 134 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 548 "backend.c"
	}
#line 137 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 137 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (delete_query);
#line 137 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 556 "backend.c"
}


gboolean tracker_test_backend_remove_triplet (TrackerTestBackend* self, const gchar* subject_urn, const gchar* pred, const gchar* object_urn) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	TrackerSparqlBuilder* _tmp8_;
	TrackerSparqlBuilder* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
#line 140 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 140 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (subject_urn != NULL, FALSE);
#line 140 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (pred != NULL, FALSE);
#line 140 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (object_urn != NULL, FALSE);
#line 143 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = tracker_sparql_builder_new_update ();
#line 143 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	builder = _tmp0_;
#line 144 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = builder;
#line 144 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_delete_open (_tmp1_, NULL);
#line 145 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = builder;
#line 145 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = subject_urn;
#line 145 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
#line 146 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = builder;
#line 146 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = pred;
#line 146 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
#line 147 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = builder;
#line 147 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = object_urn;
#line 147 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
#line 148 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = builder;
#line 148 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_delete_close (_tmp8_);
#line 150 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = builder;
#line 150 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = tracker_sparql_builder_get_result (_tmp9_);
#line 150 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = _tmp10_;
#line 150 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp12_ = _tracker_test_backend_do_update_query (self, _tmp11_);
#line 150 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp12_ == FALSE) {
#line 624 "backend.c"
		TrackerSparqlBuilder* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 152 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = builder;
#line 152 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = tracker_sparql_builder_get_result (_tmp13_);
#line 152 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = _tmp14_;
#line 152 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:152: Couldn't delete triplet with query: %s\n", _tmp15_);
#line 154 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 154 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (builder);
#line 154 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 642 "backend.c"
	}
#line 157 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 157 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (builder);
#line 157 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 650 "backend.c"
}


gboolean tracker_test_backend_insert_triplet (TrackerTestBackend* self, const gchar* subject_iri, const gchar* pred, const gchar* object_iri, const gchar* pred_b, const gchar* obj_literal_b, const gchar* pred_c, const gchar* obj_literal_c) {
	gboolean result = FALSE;
	TrackerSparqlBuilder* _tmp0_;
	TrackerSparqlBuilder* builder;
	TrackerSparqlBuilder* _tmp1_;
	TrackerSparqlBuilder* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlBuilder* _tmp4_;
	const gchar* _tmp5_;
	TrackerSparqlBuilder* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	TrackerSparqlBuilder* _tmp18_;
	TrackerSparqlBuilder* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
#line 160 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 160 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (subject_iri != NULL, FALSE);
#line 160 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (pred != NULL, FALSE);
#line 160 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (object_iri != NULL, FALSE);
#line 165 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = tracker_sparql_builder_new_update ();
#line 165 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	builder = _tmp0_;
#line 166 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = builder;
#line 166 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_insert_open (_tmp1_, NULL);
#line 167 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = builder;
#line 167 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = subject_iri;
#line 167 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_subject (_tmp2_, _tmp3_);
#line 168 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = builder;
#line 168 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = pred;
#line 168 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_predicate (_tmp4_, _tmp5_);
#line 169 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = builder;
#line 169 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = object_iri;
#line 169 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_object (_tmp6_, _tmp7_);
#line 171 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = pred_b;
#line 171 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp8_ != NULL) {
#line 710 "backend.c"
		TrackerSparqlBuilder* _tmp9_;
		const gchar* _tmp10_;
		TrackerSparqlBuilder* _tmp11_;
		const gchar* _tmp12_;
#line 173 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = builder;
#line 173 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = pred_b;
#line 173 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_predicate (_tmp9_, _tmp10_);
#line 174 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = builder;
#line 174 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = obj_literal_b;
#line 174 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_object_string (_tmp11_, _tmp12_);
#line 727 "backend.c"
	}
#line 177 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp13_ = pred_c;
#line 177 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp13_ != NULL) {
#line 733 "backend.c"
		TrackerSparqlBuilder* _tmp14_;
		const gchar* _tmp15_;
		TrackerSparqlBuilder* _tmp16_;
		const gchar* _tmp17_;
#line 179 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = builder;
#line 179 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = pred_c;
#line 179 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_predicate (_tmp14_, _tmp15_);
#line 180 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = builder;
#line 180 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = obj_literal_c;
#line 180 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_builder_object_string (_tmp16_, _tmp17_);
#line 750 "backend.c"
	}
#line 183 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp18_ = builder;
#line 183 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_sparql_builder_insert_close (_tmp18_);
#line 185 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp19_ = builder;
#line 185 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp20_ = tracker_sparql_builder_get_result (_tmp19_);
#line 185 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp21_ = _tmp20_;
#line 185 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp22_ = _tracker_test_backend_do_update_query (self, _tmp21_);
#line 185 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp22_ == FALSE) {
#line 766 "backend.c"
		TrackerSparqlBuilder* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
#line 187 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp23_ = builder;
#line 187 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp24_ = tracker_sparql_builder_get_result (_tmp23_);
#line 187 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp25_ = _tmp24_;
#line 187 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:187: Couldn't insert triplet with query: %s\n", _tmp25_);
#line 189 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		result = FALSE;
#line 189 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (builder);
#line 189 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return result;
#line 784 "backend.c"
	}
#line 192 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = TRUE;
#line 192 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (builder);
#line 192 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 792 "backend.c"
}


static gboolean _tracker_test_backend_do_update_query (TrackerTestBackend* self, const gchar* query) {
	gboolean result = FALSE;
	gboolean ret;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 195 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 197 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	ret = FALSE;
#line 199 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = self->priv->_debug;
#line 199 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp0_) {
#line 811 "backend.c"
		FILE* _tmp1_;
		const gchar* _tmp2_;
#line 201 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = stdout;
#line 201 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = query;
#line 201 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		fprintf (_tmp1_, "_do_update_query : %s\n", _tmp2_);
#line 820 "backend.c"
	}
	{
		TrackerSparqlConnection* _tmp3_;
		const gchar* _tmp4_;
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = self->priv->_connection;
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = query;
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_connection_update (_tmp3_, _tmp4_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_ != NULL) {
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 835 "backend.c"
				goto __catch1_tracker_sparql_error;
			}
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 840 "backend.c"
				goto __catch1_g_io_error;
			}
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 845 "backend.c"
				goto __catch1_g_dbus_error;
			}
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 206 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return FALSE;
#line 854 "backend.c"
		}
#line 207 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		ret = TRUE;
#line 858 "backend.c"
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 211 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = e1;
#line 211 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = _tmp5_->message;
#line 211 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:211: Problem getting connection : %s\n", _tmp6_);
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 878 "backend.c"
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 215 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp7_ = e2;
#line 215 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp8_ = _tmp7_->message;
#line 215 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:215: Problem saving data : %s\n", _tmp8_);
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 898 "backend.c"
	}
	goto __finally1;
	__catch1_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 219 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = e3;
#line 219 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = _tmp9_->message;
#line 219 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_warning ("backend.vala:219: Problem with the D-Bus connection : %s\n", _tmp10_);
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 918 "backend.c"
	}
	__finally1:
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_inner_error_ != NULL) {
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_clear_error (&_inner_error_);
#line 204 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return FALSE;
#line 929 "backend.c"
	}
#line 222 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 222 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 935 "backend.c"
}


static GeeHashMap* _tracker_test_backend_copy_hash_map (TrackerTestBackend* self, GeeHashMap* orig) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* copy;
#line 225 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 225 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (orig != NULL, NULL);
#line 228 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 228 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	copy = _tmp0_;
#line 951 "backend.c"
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _k_it;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = orig;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = gee_map_get_keys ((GeeMap*) _tmp1_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = _tmp2_;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = _tmp3_;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = _tmp5_;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_tmp4_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_k_it = _tmp6_;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		while (TRUE) {
#line 978 "backend.c"
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* k;
			GeeHashMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* v;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp7_ = _k_it;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (!_tmp8_) {
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				break;
#line 1003 "backend.c"
			}
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp9_ = _k_it;
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			k = (gchar*) _tmp10_;
#line 231 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp11_ = orig;
#line 231 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp12_ = k;
#line 231 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
#line 231 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			v = (gchar*) _tmp13_;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp14_ = copy;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp15_ = k;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp17_ = _tmp16_;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp18_ = v;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp20_ = _tmp19_;
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp17_, _tmp20_);
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp20_);
#line 232 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp17_);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (v);
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (k);
#line 1043 "backend.c"
		}
#line 229 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_k_it);
#line 1047 "backend.c"
	}
#line 234 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = copy;
#line 234 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 1053 "backend.c"
}


static void _tracker_test_backend_setup_connection (TrackerTestBackend* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 237 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 1061 "backend.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp0_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp1_ = _tmp0_;
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_ != NULL) {
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1073 "backend.c"
				goto __catch2_g_io_error;
			}
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1078 "backend.c"
				goto __catch2_tracker_sparql_error;
			}
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 1083 "backend.c"
				goto __catch2_g_dbus_error;
			}
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 1088 "backend.c"
				goto __catch2_g_spawn_error;
			}
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1097 "backend.c"
		}
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (self->priv->_connection);
#line 241 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		self->priv->_connection = _tmp1_;
#line 1103 "backend.c"
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 245 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp2_ = e1;
#line 245 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = _tmp2_->message;
#line 245 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp4_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp3_);
#line 245 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp4_;
#line 245 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 1126 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError* e2 = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 250 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp5_ = e2;
#line 250 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp6_ = _tmp5_->message;
#line 250 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp7_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp6_);
#line 250 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp7_;
#line 250 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 1150 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 255 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp8_ = e3;
#line 255 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp9_ = _tmp8_->message;
#line 255 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp9_);
#line 255 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp10_;
#line 255 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 1174 "backend.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_spawn_error:
	{
		GError* e4 = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e4 = _inner_error_;
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 260 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = e4;
#line 260 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = _tmp11_->message;
#line 260 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp12_);
#line 260 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp13_;
#line 260 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e4);
#line 1198 "backend.c"
		goto __finally2;
	}
	__finally2:
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_inner_error_ != NULL) {
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_propagate_error (error, _inner_error_);
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1210 "backend.c"
		} else {
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 239 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1218 "backend.c"
		}
	}
}


static void _tracker_test_backend_add_contacts (TrackerTestBackend* self, GError** error) {
	gchar* _tmp0_;
	gchar* query;
	GList* _tmp1_;
	GError * _inner_error_ = NULL;
#line 265 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 267 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 267 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	query = _tmp0_;
#line 269 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv->_contacts = g_list_reverse (self->priv->_contacts);
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = self->priv->_contacts;
#line 1239 "backend.c"
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		c_collection = _tmp1_;
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
#line 1247 "backend.c"
			GeeHashMap* _tmp2_;
			GeeHashMap* c = NULL;
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp2_ = _g_object_ref0 ((GeeHashMap*) c_it->data);
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			c = _tmp2_;
#line 1254 "backend.c"
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GeeHashMap* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp3_ = query;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp5_ = _tmp4_;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = c;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp7_ = _tracker_test_backend_get_insert_query (self, _tmp6_);
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = _tmp7_;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (query);
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				query = _tmp9_;
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp8_);
#line 272 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp5_);
#line 270 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_object_unref0 (c);
#line 1287 "backend.c"
			}
		}
	}
	{
		TrackerSparqlConnection* _tmp10_;
		const gchar* _tmp11_;
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp10_ = self->priv->_connection;
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp11_ = query;
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_sparql_connection_update (_tmp10_, _tmp11_, G_PRIORITY_DEFAULT, NULL, &_inner_error_);
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_ != NULL) {
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1304 "backend.c"
				goto __catch3_tracker_sparql_error;
			}
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1309 "backend.c"
				goto __catch3_g_io_error;
			}
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 1314 "backend.c"
				goto __catch3_g_dbus_error;
			}
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (query);
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 277 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1325 "backend.c"
		}
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e1 = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e1 = _inner_error_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 281 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = e1;
#line 281 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = _tmp12_->message;
#line 281 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Problem getting connection : %s\n", _tmp13_);
#line 281 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp14_;
#line 281 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e1);
#line 1349 "backend.c"
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e2 = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e2 = _inner_error_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 286 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = e2;
#line 286 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = _tmp15_->message;
#line 286 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Error fetching SPARQL connection handler : %s\n", _tmp16_);
#line 286 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp17_;
#line 286 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e2);
#line 1373 "backend.c"
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError* e3 = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		e3 = _inner_error_;
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = NULL;
#line 291 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp18_ = e3;
#line 291 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp19_ = _tmp18_->message;
#line 291 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp20_ = g_error_new (TRACKER_TEST_BACKEND_SETUP_ERROR, TRACKER_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED, "Could not connect to D-Bus service : %s\n", _tmp19_);
#line 291 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_inner_error_ = _tmp20_;
#line 291 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_error_free0 (e3);
#line 1397 "backend.c"
		goto __finally3;
	}
	__finally3:
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_inner_error_ != NULL) {
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (_inner_error_->domain == TRACKER_TEST_BACKEND_SETUP_ERROR) {
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (query);
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1411 "backend.c"
		} else {
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (query);
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			g_clear_error (&_inner_error_);
#line 275 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return;
#line 1421 "backend.c"
		}
	}
#line 265 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (query);
#line 1426 "backend.c"
}


static gchar* _tracker_test_backend_get_insert_query (TrackerTestBackend* self, GeeHashMap* contact) {
	gchar* result = NULL;
#line 298 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char q_photo_uri_t[] = " . <%s> a nfo:Image, " "nie:DataObject ; nie:url '%s' ; nie:title '%s' ";
#line 300 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char im_addr_t[] = " . <%s> a nco:IMAddress, " "nie:InformationElement; nco:imProtocol " "'%s' ; nco:imID '%s';   " "nco:imNickname '%s'; " "nco:imPresence nco:presence-status-available " " . <%smyimaccount> a nco:IMAccount; " "nco:imDisplayName '%s'; nco:hasIMContact " "<%s>  ";
#line 308 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char affl_t[] = " . <%smyaffiliation> a nco:Affiliation " " . <%smyaffiliation> nco:hasIMAddress " " <%s>  ";
#line 311 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char af_t[] = " . <affl:001> a nco:Affiliation; " "nco:title '%s'; nco:department '%s'; nco:role '%s' ";
#line 313 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	static const char postal_t[] = " . <affl:001> a nco:Affiliation ; " "nco:hasPostalAddress <postal:001> . " " <postal:001> a nco:PostalAddress ; " "nco:pobox '%s'; " "nco:district '%s'; " "nco:county '%s'; " "nco:locality '%s'; " "nco:postalcode '%s'; " "nco:streetAddress '%s'; " "nco:addressLocation '%s'; " "nco:extendedAddress '%s'; " "nco:country '%s'; " "nco:region '%s' ";
#line 1442 "backend.c"
	gchar* urn_contact = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp4_;
	gchar* photo_uri;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* q;
	GeeHashMap* addresses;
	gchar** phones;
	gint phones_length1;
	gint _phones_size_;
	gchar** emails;
	gint emails_length1;
	gint _emails_size_;
	gchar** urls;
	gint urls_length1;
	gint _urls_size_;
	gchar* _tmp10_;
	gchar* affiliation;
	gchar* _tmp11_;
	gchar* postal_address;
	const gchar* _tmp109_;
	gboolean _tmp117_ = FALSE;
	GeeHashMap* _tmp118_;
	gboolean _tmp122_;
	gboolean _tmp154_ = FALSE;
	gchar** _tmp155_;
	gint _tmp155__length1;
	gboolean _tmp157_;
	gboolean _tmp169_ = FALSE;
	gchar** _tmp170_;
	gint _tmp170__length1;
	gboolean _tmp172_;
	gboolean _tmp184_ = FALSE;
	gchar** _tmp185_;
	gint _tmp185__length1;
	gboolean _tmp187_;
	const gchar* _tmp201_;
	const gchar* _tmp215_;
	const gchar* _tmp243_;
	gchar* _tmp244_;
	gboolean _tmp245_;
#line 296 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 296 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (contact != NULL, NULL);
#line 328 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = contact;
#line 328 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp2_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, TRACKER_TEST_BACKEND_URN, &_tmp1_);
#line 328 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (urn_contact);
#line 328 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	urn_contact = _tmp1_;
#line 328 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp2_ == FALSE) {
#line 1504 "backend.c"
		gchar* _tmp3_;
#line 330 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp3_ = g_strdup ("_:x");
#line 330 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (urn_contact);
#line 330 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		urn_contact = _tmp3_;
#line 1512 "backend.c"
	}
#line 333 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = g_strdup ("");
#line 333 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	photo_uri = _tmp4_;
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp5_ = urn_contact;
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp6_ = g_strconcat ("INSERT { ", _tmp5_, NULL);
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp7_ = _tmp6_;
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp8_ = g_strconcat (_tmp7_, " a nco:PersonContact  ", NULL);
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp9_ = _tmp8_;
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (_tmp7_);
#line 334 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	q = _tmp9_;
#line 335 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	addresses = NULL;
#line 336 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	phones = NULL;
#line 336 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	phones_length1 = 0;
#line 336 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_phones_size_ = phones_length1;
#line 337 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	emails = NULL;
#line 337 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	emails_length1 = 0;
#line 337 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_emails_size_ = emails_length1;
#line 338 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	urls = NULL;
#line 338 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	urls_length1 = 0;
#line 338 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_urls_size_ = urls_length1;
#line 339 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp10_ = g_strdup ("");
#line 339 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	affiliation = _tmp10_;
#line 340 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp11_ = g_strdup ("");
#line 340 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	postal_address = _tmp11_;
#line 1560 "backend.c"
	{
		GeeHashMap* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _k_it;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp12_ = contact;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp13_ = gee_map_get_keys ((GeeMap*) _tmp12_);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp14_ = _tmp13_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp15_ = _tmp14_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp17_ = _tmp16_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_tmp15_);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_k_it = _tmp17_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		while (TRUE) {
#line 1587 "backend.c"
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* k;
			GeeHashMap* _tmp22_;
			const gchar* _tmp23_;
			gpointer _tmp24_ = NULL;
			gchar* v;
			const gchar* _tmp25_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* s;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
			gchar* _tmp108_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp18_ = _k_it;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp19_ = gee_iterator_next (_tmp18_);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (!_tmp19_) {
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				break;
#line 1618 "backend.c"
			}
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp20_ = _k_it;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp21_ = gee_iterator_get (_tmp20_);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			k = (gchar*) _tmp21_;
#line 344 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp22_ = contact;
#line 344 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp23_ = k;
#line 344 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp24_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp23_);
#line 344 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			v = (gchar*) _tmp24_;
#line 345 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp25_ = k;
#line 345 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			if (g_strcmp0 (_tmp25_, TRF_ONTOLOGY_DEFS_NCO_PHOTO) == 0) {
#line 1638 "backend.c"
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
#line 347 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp26_ = v;
#line 347 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp27_ = g_strdup (_tmp26_);
#line 347 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (photo_uri);
#line 347 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				photo_uri = _tmp27_;
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp28_ = v;
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp29_ = g_strconcat ("<", _tmp28_, NULL);
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp30_ = _tmp29_;
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp31_ = g_strconcat (_tmp30_, ">", NULL);
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (v);
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				v = _tmp31_;
#line 348 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp30_);
#line 1667 "backend.c"
			} else {
				const gchar* _tmp32_;
#line 350 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp32_ = k;
#line 350 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				if (g_strcmp0 (_tmp32_, TRF_ONTOLOGY_DEFS_NCO_IMADDRESS) == 0) {
#line 1674 "backend.c"
					const gchar* _tmp33_;
					GeeHashMap* _tmp34_ = NULL;
					gchar* _tmp35_;
					gchar* _tmp36_;
#line 352 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp33_ = v;
#line 352 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp34_ = _tracker_test_backend_parse_addrs (self, _tmp33_);
#line 352 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_object_unref0 (addresses);
#line 352 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					addresses = _tmp34_;
#line 353 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp35_ = g_strdup ("");
#line 353 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (k);
#line 353 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					k = _tmp35_;
#line 354 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp36_ = g_strdup ("");
#line 354 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (v);
#line 354 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					v = _tmp36_;
#line 1699 "backend.c"
					{
						GeeHashMap* _tmp37_;
						GeeSet* _tmp38_;
						GeeSet* _tmp39_;
						GeeSet* _tmp40_;
						GeeIterator* _tmp41_ = NULL;
						GeeIterator* _tmp42_;
						GeeIterator* _addr_it;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp37_ = addresses;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp38_ = gee_map_get_keys ((GeeMap*) _tmp37_);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp39_ = _tmp38_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp40_ = _tmp39_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp42_ = _tmp41_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_g_object_unref0 (_tmp40_);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_addr_it = _tmp42_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						while (TRUE) {
#line 1726 "backend.c"
							GeeIterator* _tmp43_;
							gboolean _tmp44_ = FALSE;
							GeeIterator* _tmp45_;
							gpointer _tmp46_ = NULL;
							gchar* addr;
							gchar* vtemp = NULL;
							gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp43_ = _addr_it;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp44_ = gee_iterator_next (_tmp43_);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							if (!_tmp44_) {
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								break;
#line 1753 "backend.c"
							}
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp45_ = _addr_it;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp46_ = gee_iterator_get (_tmp45_);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							addr = (gchar*) _tmp46_;
#line 358 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp47_ = g_strdup (" nco:hasAffiliation [ a nco:Affiliation ; ");
#line 358 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 358 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							vtemp = _tmp47_;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp48_ = vtemp;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp49_ = addr;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp50_ = g_strconcat ("nco:hasIMAddress <", _tmp49_, NULL);
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp51_ = _tmp50_;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp52_ = g_strconcat (_tmp51_, "> ] ", NULL);
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp53_ = _tmp52_;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp54_ = g_strconcat (_tmp48_, _tmp53_, NULL);
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							vtemp = _tmp54_;
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (_tmp53_);
#line 359 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (_tmp51_);
#line 360 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp55_ = v;
#line 360 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							if (g_strcmp0 (_tmp55_, "") != 0) {
#line 1793 "backend.c"
								const gchar* _tmp56_;
								gchar* _tmp57_;
#line 362 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp56_ = v;
#line 362 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp57_ = g_strconcat (_tmp56_, "; ", NULL);
#line 362 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_g_free0 (v);
#line 362 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								v = _tmp57_;
#line 1804 "backend.c"
							}
#line 364 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp58_ = v;
#line 364 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp59_ = vtemp;
#line 364 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
#line 364 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (v);
#line 364 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							v = _tmp60_;
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (vtemp);
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (addr);
#line 1820 "backend.c"
						}
#line 355 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_g_object_unref0 (_addr_it);
#line 1824 "backend.c"
					}
				} else {
					const gchar* _tmp61_;
#line 367 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp61_ = k;
#line 367 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					if (g_strcmp0 (_tmp61_, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP) == 0) {
#line 1832 "backend.c"
						const gchar* _tmp62_;
						gchar** _tmp63_;
						gchar** _tmp64_ = NULL;
						gchar* _tmp65_;
						gchar** _tmp66_;
						gint _tmp66__length1;
						gchar* _tmp67_ = NULL;
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp62_ = v;
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp64_ = _tmp63_ = g_strsplit (_tmp62_, ",", 0);
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						phones = _tmp64_;
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						phones_length1 = _vala_array_length (_tmp63_);
#line 369 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_phones_size_ = phones_length1;
#line 370 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp65_ = g_strdup ("");
#line 370 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_g_free0 (k);
#line 370 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						k = _tmp65_;
#line 371 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp66_ = phones;
#line 371 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp66__length1 = phones_length1;
#line 371 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp67_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp66_, _tmp66__length1);
#line 371 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_g_free0 (v);
#line 371 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						v = _tmp67_;
#line 1868 "backend.c"
					} else {
						const gchar* _tmp68_;
#line 374 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						_tmp68_ = k;
#line 374 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						if (g_strcmp0 (_tmp68_, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP) == 0) {
#line 1875 "backend.c"
							const gchar* _tmp69_;
							gchar** _tmp70_;
							gchar** _tmp71_ = NULL;
							gchar* _tmp72_;
							gchar** _tmp73_;
							gint _tmp73__length1;
							gchar* _tmp74_ = NULL;
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp69_ = v;
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp71_ = _tmp70_ = g_strsplit (_tmp69_, ",", 0);
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							emails = _tmp71_;
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							emails_length1 = _vala_array_length (_tmp70_);
#line 376 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_emails_size_ = emails_length1;
#line 377 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp72_ = g_strdup ("");
#line 377 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (k);
#line 377 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							k = _tmp72_;
#line 378 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp73_ = emails;
#line 378 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp73__length1 = emails_length1;
#line 378 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp74_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp73_, _tmp73__length1);
#line 378 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (v);
#line 378 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							v = _tmp74_;
#line 1911 "backend.c"
						} else {
							const gchar* _tmp75_;
#line 381 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp75_ = k;
#line 381 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							if (g_strcmp0 (_tmp75_, TRACKER_TEST_BACKEND_URLS) == 0) {
#line 1918 "backend.c"
								const gchar* _tmp76_;
								gchar** _tmp77_;
								gchar** _tmp78_ = NULL;
								gchar* _tmp79_;
								gchar** _tmp80_;
								gint _tmp80__length1;
								gchar* _tmp81_ = NULL;
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp76_ = v;
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp78_ = _tmp77_ = g_strsplit (_tmp76_, ",", 0);
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								urls = _tmp78_;
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								urls_length1 = _vala_array_length (_tmp77_);
#line 383 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_urls_size_ = urls_length1;
#line 384 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp79_ = g_strdup ("");
#line 384 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_g_free0 (k);
#line 384 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								k = _tmp79_;
#line 385 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp80_ = urls;
#line 385 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp80__length1 = urls_length1;
#line 385 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp81_ = _tracker_test_backend_build_relation (self, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION, _tmp80_, _tmp80__length1);
#line 385 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_g_free0 (v);
#line 385 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								v = _tmp81_;
#line 1954 "backend.c"
							} else {
								const gchar* _tmp82_;
#line 388 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								_tmp82_ = k;
#line 388 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
								if (g_strcmp0 (_tmp82_, TRF_ONTOLOGY_DEFS_NAO_TAG) == 0) {
#line 1961 "backend.c"
									gchar* _tmp83_;
#line 390 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
									_tmp83_ = g_strdup (TRF_ONTOLOGY_DEFS_NAO_FAVORITE);
#line 390 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
									_g_free0 (v);
#line 390 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
									v = _tmp83_;
#line 1969 "backend.c"
								} else {
									const gchar* _tmp84_;
#line 392 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
									_tmp84_ = k;
#line 392 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
									if (g_strcmp0 (_tmp84_, TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION) == 0) {
#line 1976 "backend.c"
										const gchar* _tmp85_;
										gchar* _tmp86_;
										gchar* _tmp87_;
#line 394 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_tmp85_ = v;
#line 394 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_tmp86_ = g_strdup (_tmp85_);
#line 394 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_g_free0 (affiliation);
#line 394 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										affiliation = _tmp86_;
#line 395 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_tmp87_ = g_strdup ("<affl:001>");
#line 395 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_g_free0 (v);
#line 395 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										v = _tmp87_;
#line 1994 "backend.c"
									} else {
										const gchar* _tmp88_;
#line 397 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										_tmp88_ = k;
#line 397 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
										if (g_strcmp0 (_tmp88_, TRF_ONTOLOGY_DEFS_NCO_GENDER) == 0) {
#line 2001 "backend.c"
										} else {
											const gchar* _tmp89_;
#line 401 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
											_tmp89_ = k;
#line 401 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
											if (g_strcmp0 (_tmp89_, TRF_ONTOLOGY_DEFS_NCO_POSTAL_ADDRESS) == 0) {
#line 2008 "backend.c"
												const gchar* _tmp90_;
												gchar* _tmp91_;
												gchar* _tmp92_;
												gchar* _tmp93_;
#line 403 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp90_ = v;
#line 403 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp91_ = g_strdup (_tmp90_);
#line 403 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_g_free0 (postal_address);
#line 403 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												postal_address = _tmp91_;
#line 404 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp92_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_HAS_AFFILIATION);
#line 404 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_g_free0 (k);
#line 404 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												k = _tmp92_;
#line 405 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp93_ = g_strdup ("<affl:001>");
#line 405 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_g_free0 (v);
#line 405 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												v = _tmp93_;
#line 2033 "backend.c"
											} else {
												const gchar* _tmp94_;
												gchar* _tmp95_;
												gchar* _tmp96_;
												gchar* _tmp97_;
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp94_ = v;
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp95_ = g_strconcat ("'", _tmp94_, NULL);
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp96_ = _tmp95_;
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_tmp97_ = g_strconcat (_tmp96_, "'", NULL);
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_g_free0 (v);
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												v = _tmp97_;
#line 409 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
												_g_free0 (_tmp96_);
#line 2053 "backend.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 412 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp98_ = q;
#line 412 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp99_ = g_strconcat (_tmp98_, "; ", NULL);
#line 412 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (q);
#line 412 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			q = _tmp99_;
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp100_ = k;
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp101_ = g_strconcat (_tmp100_, " ", NULL);
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp102_ = _tmp101_;
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp103_ = v;
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp105_ = _tmp104_;
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (_tmp102_);
#line 413 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			s = _tmp105_;
#line 414 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp106_ = q;
#line 414 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp107_ = s;
#line 414 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp108_ = g_strconcat (_tmp106_, _tmp107_, NULL);
#line 414 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (q);
#line 414 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			q = _tmp108_;
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (s);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (v);
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_free0 (k);
#line 2103 "backend.c"
		}
#line 342 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_object_unref0 (_k_it);
#line 2107 "backend.c"
	}
#line 417 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp109_ = photo_uri;
#line 417 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp109_, "") != 0) {
#line 2113 "backend.c"
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_;
		gchar* _tmp116_;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp110_ = q;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp111_ = photo_uri;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp112_ = photo_uri;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp113_ = photo_uri;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp114_ = g_strdup_printf (q_photo_uri_t, _tmp111_, _tmp112_, _tmp113_);
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp115_ = _tmp114_;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp116_ = g_strconcat (_tmp110_, _tmp115_, NULL);
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		q = _tmp116_;
#line 419 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp115_);
#line 2141 "backend.c"
	}
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp118_ = addresses;
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp118_ != NULL) {
#line 2147 "backend.c"
		GeeHashMap* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp119_ = addresses;
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp120_ = gee_map_get_size ((GeeMap*) _tmp119_);
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp121_ = _tmp120_;
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp117_ = _tmp121_ > 0;
#line 2159 "backend.c"
	} else {
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp117_ = FALSE;
#line 2163 "backend.c"
	}
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp122_ = _tmp117_;
#line 422 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp122_) {
#line 2169 "backend.c"
		{
			GeeHashMap* _tmp123_;
			GeeSet* _tmp124_;
			GeeSet* _tmp125_;
			GeeSet* _tmp126_;
			GeeIterator* _tmp127_ = NULL;
			GeeIterator* _tmp128_;
			GeeIterator* _addr_it;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp123_ = addresses;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp124_ = gee_map_get_keys ((GeeMap*) _tmp123_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp125_ = _tmp124_;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp126_ = _tmp125_;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp127_ = gee_iterable_iterator ((GeeIterable*) _tmp126_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp128_ = _tmp127_;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_object_unref0 (_tmp126_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_addr_it = _tmp128_;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			while (TRUE) {
#line 2196 "backend.c"
				GeeIterator* _tmp129_;
				gboolean _tmp130_ = FALSE;
				GeeIterator* _tmp131_;
				gpointer _tmp132_ = NULL;
				gchar* addr;
				GeeHashMap* _tmp133_;
				const gchar* _tmp134_;
				gpointer _tmp135_ = NULL;
				gchar* proto;
				const gchar* _tmp136_;
				const gchar* _tmp137_;
				const gchar* _tmp138_;
				const gchar* _tmp139_;
				const gchar* _tmp140_;
				const gchar* _tmp141_;
				const gchar* _tmp142_;
				gchar* _tmp143_ = NULL;
				gchar* q1;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				const gchar* _tmp146_;
				gchar* _tmp147_ = NULL;
				gchar* q2;
				const gchar* _tmp148_;
				const gchar* _tmp149_;
				const gchar* _tmp150_;
				gchar* _tmp151_ = NULL;
				gchar* _tmp152_;
				gchar* _tmp153_;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp129_ = _addr_it;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp130_ = gee_iterator_next (_tmp129_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				if (!_tmp130_) {
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					break;
#line 2234 "backend.c"
				}
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp131_ = _addr_it;
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp132_ = gee_iterator_get (_tmp131_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				addr = (gchar*) _tmp132_;
#line 426 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp133_ = addresses;
#line 426 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp134_ = addr;
#line 426 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp135_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp133_, _tmp134_);
#line 426 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				proto = (gchar*) _tmp135_;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp136_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp137_ = proto;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp138_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp139_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp140_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp141_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp142_ = addr;
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp143_ = g_strdup_printf (im_addr_t, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, _tmp142_);
#line 427 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				q1 = _tmp143_;
#line 430 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp144_ = addr;
#line 430 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp145_ = addr;
#line 430 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp146_ = addr;
#line 430 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp147_ = g_strdup_printf (affl_t, _tmp144_, _tmp145_, _tmp146_);
#line 430 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				q2 = _tmp147_;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp148_ = q;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp149_ = q1;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp150_ = q2;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp151_ = g_strdup_printf ("%s%s", _tmp149_, _tmp150_);
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp152_ = _tmp151_;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp153_ = g_strconcat (_tmp148_, _tmp152_, NULL);
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q);
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				q = _tmp153_;
#line 432 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp152_);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q2);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (q1);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (proto);
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (addr);
#line 2304 "backend.c"
			}
#line 424 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_g_object_unref0 (_addr_it);
#line 2308 "backend.c"
		}
	}
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp155_ = phones;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp155__length1 = phones_length1;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp155_ != NULL) {
#line 2317 "backend.c"
		gchar** _tmp156_;
		gint _tmp156__length1;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp156_ = phones;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp156__length1 = phones_length1;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp154_ = _tmp156__length1 > 0;
#line 2326 "backend.c"
	} else {
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp154_ = FALSE;
#line 2330 "backend.c"
	}
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp157_ = _tmp154_;
#line 436 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp157_) {
#line 2336 "backend.c"
		gchar** _tmp158_;
		gint _tmp158__length1;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp158_ = phones;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp158__length1 = phones_length1;
#line 2343 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp158_;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp158__length1;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp158__length1; p_it = p_it + 1) {
#line 2355 "backend.c"
				gchar* _tmp159_;
				gchar* p = NULL;
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp159_ = g_strdup (p_collection[p_it]);
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				p = _tmp159_;
#line 2362 "backend.c"
				{
					const gchar* _tmp160_;
					gchar* _tmp161_ = NULL;
					gchar* phone_urn;
					const gchar* _tmp162_;
					gchar* _tmp163_ = NULL;
					gchar* affl;
					const gchar* _tmp164_;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
					const gchar* _tmp167_;
					const gchar* _tmp168_;
#line 440 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp160_ = p;
#line 440 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp161_ = g_strdup_printf ("<phone:%s>", _tmp160_);
#line 440 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					phone_urn = _tmp161_;
#line 441 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp162_ = p;
#line 441 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp163_ = g_strdup_printf ("<%s>", _tmp162_);
#line 441 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					affl = _tmp163_;
#line 442 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp164_ = phone_urn;
#line 442 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp165_ = p;
#line 442 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp164_, "a", TRF_ONTOLOGY_DEFS_NCO_PHONE, TRF_ONTOLOGY_DEFS_NCO_PHONE_PROP, _tmp165_, NULL, NULL);
#line 444 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp166_ = affl;
#line 444 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp166_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
#line 445 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp167_ = affl;
#line 445 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp168_ = phone_urn;
#line 445 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp167_, TRF_ONTOLOGY_DEFS_NCO_HAS_PHONE, _tmp168_, NULL, NULL, NULL, NULL);
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (phone_urn);
#line 438 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2409 "backend.c"
				}
			}
		}
	}
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp170_ = emails;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp170__length1 = emails_length1;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp170_ != NULL) {
#line 2420 "backend.c"
		gchar** _tmp171_;
		gint _tmp171__length1;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp171_ = emails;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp171__length1 = emails_length1;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp169_ = _tmp171__length1 > 0;
#line 2429 "backend.c"
	} else {
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp169_ = FALSE;
#line 2433 "backend.c"
	}
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp172_ = _tmp169_;
#line 450 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp172_) {
#line 2439 "backend.c"
		gchar** _tmp173_;
		gint _tmp173__length1;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp173_ = emails;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp173__length1 = emails_length1;
#line 2446 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp173_;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp173__length1;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp173__length1; p_it = p_it + 1) {
#line 2458 "backend.c"
				gchar* _tmp174_;
				gchar* p = NULL;
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp174_ = g_strdup (p_collection[p_it]);
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				p = _tmp174_;
#line 2465 "backend.c"
				{
					const gchar* _tmp175_;
					gchar* _tmp176_ = NULL;
					gchar* email_urn;
					const gchar* _tmp177_;
					gchar* _tmp178_ = NULL;
					gchar* affl;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					const gchar* _tmp181_;
					const gchar* _tmp182_;
					const gchar* _tmp183_;
#line 454 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp175_ = p;
#line 454 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp176_ = g_strdup_printf ("<email:%s>", _tmp175_);
#line 454 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					email_urn = _tmp176_;
#line 455 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp177_ = p;
#line 455 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp178_ = g_strdup_printf ("<%s>", _tmp177_);
#line 455 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					affl = _tmp178_;
#line 456 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp179_ = email_urn;
#line 456 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp180_ = p;
#line 456 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp179_, "a", TRF_ONTOLOGY_DEFS_NCO_EMAIL, TRF_ONTOLOGY_DEFS_NCO_EMAIL_PROP, _tmp180_, NULL, NULL);
#line 458 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp181_ = affl;
#line 458 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp181_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, NULL, NULL, NULL, NULL);
#line 459 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp182_ = affl;
#line 459 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp183_ = email_urn;
#line 459 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp182_, TRF_ONTOLOGY_DEFS_NCO_HAS_EMAIL, _tmp183_, NULL, NULL, NULL, NULL);
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (email_urn);
#line 452 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2512 "backend.c"
				}
			}
		}
	}
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp185_ = urls;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp185__length1 = urls_length1;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp185_ != NULL) {
#line 2523 "backend.c"
		gchar** _tmp186_;
		gint _tmp186__length1;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp186_ = urls;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp186__length1 = urls_length1;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp184_ = _tmp186__length1 > 0;
#line 2532 "backend.c"
	} else {
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp184_ = FALSE;
#line 2536 "backend.c"
	}
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp187_ = _tmp184_;
#line 464 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp187_) {
#line 2542 "backend.c"
		gint i;
		gchar** _tmp188_;
		gint _tmp188__length1;
#line 466 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		i = 0;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp188_ = urls;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp188__length1 = urls_length1;
#line 2552 "backend.c"
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection = _tmp188_;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			p_collection_length1 = _tmp188__length1;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			for (p_it = 0; p_it < _tmp188__length1; p_it = p_it + 1) {
#line 2564 "backend.c"
				gchar* _tmp189_;
				gchar* p = NULL;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp189_ = g_strdup (p_collection[p_it]);
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				p = _tmp189_;
#line 2571 "backend.c"
				{
					gchar* _tmp190_;
					gchar* website_type;
					const gchar* _tmp191_;
					gchar* _tmp192_ = NULL;
					gchar* affl;
					gint _tmp193_;
					const gchar* _tmp197_;
					const gchar* _tmp198_;
					const gchar* _tmp199_;
					gint _tmp200_;
#line 469 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp190_ = g_strdup ("");
#line 469 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					website_type = _tmp190_;
#line 470 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp191_ = p;
#line 470 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp192_ = g_strdup_printf ("<%s>", _tmp191_);
#line 470 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					affl = _tmp192_;
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp193_ = i;
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					switch (_tmp193_ % 3) {
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						case 0:
#line 2599 "backend.c"
						{
							gchar* _tmp194_;
#line 474 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp194_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_WEBSITE);
#line 474 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 474 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp194_;
#line 475 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							break;
#line 2610 "backend.c"
						}
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						case 1:
#line 2614 "backend.c"
						{
							gchar* _tmp195_;
#line 477 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp195_ = g_strdup (TRF_ONTOLOGY_DEFS_NCO_BLOG);
#line 477 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 477 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp195_;
#line 478 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							break;
#line 2625 "backend.c"
						}
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						case 2:
#line 2629 "backend.c"
						{
							gchar* _tmp196_;
#line 480 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_tmp196_ = g_strdup ("nco:url");
#line 480 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							_g_free0 (website_type);
#line 480 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							website_type = _tmp196_;
#line 481 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
							break;
#line 2640 "backend.c"
						}
						default:
#line 471 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
						break;
#line 2645 "backend.c"
					}
#line 484 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp197_ = affl;
#line 484 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp198_ = website_type;
#line 484 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp199_ = p;
#line 484 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					tracker_test_backend_insert_triplet (self, _tmp197_, "a", TRF_ONTOLOGY_DEFS_NCO_AFFILIATION, _tmp198_, _tmp199_, NULL, NULL);
#line 486 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp200_ = i;
#line 486 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					i = _tmp200_ + 1;
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (affl);
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (website_type);
#line 467 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (p);
#line 2665 "backend.c"
				}
			}
		}
	}
#line 490 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp201_ = affiliation;
#line 490 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp201_, "") != 0) {
#line 2674 "backend.c"
		const gchar* _tmp202_;
		gchar** _tmp203_;
		gchar** _tmp204_ = NULL;
		gchar** role_info;
		gint role_info_length1;
		gint _role_info_size_;
		const gchar* _tmp205_;
		gchar** _tmp206_;
		gint _tmp206__length1;
		const gchar* _tmp207_;
		gchar** _tmp208_;
		gint _tmp208__length1;
		const gchar* _tmp209_;
		gchar** _tmp210_;
		gint _tmp210__length1;
		const gchar* _tmp211_;
		gchar* _tmp212_ = NULL;
		gchar* _tmp213_;
		gchar* _tmp214_;
#line 492 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp202_ = affiliation;
#line 492 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp204_ = _tmp203_ = g_strsplit (_tmp202_, ",", 0);
#line 492 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		role_info = _tmp204_;
#line 492 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		role_info_length1 = _vala_array_length (_tmp203_);
#line 492 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_role_info_size_ = role_info_length1;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp205_ = q;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp206_ = role_info;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp206__length1 = role_info_length1;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp207_ = _tmp206_[0];
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp208_ = role_info;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp208__length1 = role_info_length1;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp209_ = _tmp208_[1];
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp210_ = role_info;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp210__length1 = role_info_length1;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp211_ = _tmp210_[2];
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp212_ = g_strdup_printf (af_t, _tmp207_, _tmp209_, _tmp211_);
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp213_ = _tmp212_;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp214_ = g_strconcat (_tmp205_, _tmp213_, NULL);
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		q = _tmp214_;
#line 493 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp213_);
#line 490 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		role_info = (_vala_array_free (role_info, role_info_length1, (GDestroyNotify) g_free), NULL);
#line 2738 "backend.c"
	}
#line 496 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp215_ = postal_address;
#line 496 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (g_strcmp0 (_tmp215_, "") != 0) {
#line 2744 "backend.c"
		const gchar* _tmp216_;
		gchar** _tmp217_;
		gchar** _tmp218_ = NULL;
		gchar** postal_info;
		gint postal_info_length1;
		gint _postal_info_size_;
		const gchar* _tmp219_;
		gchar** _tmp220_;
		gint _tmp220__length1;
		const gchar* _tmp221_;
		gchar** _tmp222_;
		gint _tmp222__length1;
		const gchar* _tmp223_;
		gchar** _tmp224_;
		gint _tmp224__length1;
		const gchar* _tmp225_;
		gchar** _tmp226_;
		gint _tmp226__length1;
		const gchar* _tmp227_;
		gchar** _tmp228_;
		gint _tmp228__length1;
		const gchar* _tmp229_;
		gchar** _tmp230_;
		gint _tmp230__length1;
		const gchar* _tmp231_;
		gchar** _tmp232_;
		gint _tmp232__length1;
		const gchar* _tmp233_;
		gchar** _tmp234_;
		gint _tmp234__length1;
		const gchar* _tmp235_;
		gchar** _tmp236_;
		gint _tmp236__length1;
		const gchar* _tmp237_;
		gchar** _tmp238_;
		gint _tmp238__length1;
		const gchar* _tmp239_;
		gchar* _tmp240_ = NULL;
		gchar* _tmp241_;
		gchar* _tmp242_;
#line 498 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp216_ = postal_address;
#line 498 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp218_ = _tmp217_ = g_strsplit (_tmp216_, ":", 0);
#line 498 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		postal_info = _tmp218_;
#line 498 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		postal_info_length1 = _vala_array_length (_tmp217_);
#line 498 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_postal_info_size_ = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp219_ = q;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp220_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp220__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp221_ = _tmp220_[0];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp222_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp222__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp223_ = _tmp222_[1];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp224_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp224__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp225_ = _tmp224_[2];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp226_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp226__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp227_ = _tmp226_[3];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp228_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp228__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp229_ = _tmp228_[4];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp230_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp230__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp231_ = _tmp230_[5];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp232_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp232__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp233_ = _tmp232_[6];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp234_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp234__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp235_ = _tmp234_[7];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp236_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp236__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp237_ = _tmp236_[8];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp238_ = postal_info;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp238__length1 = postal_info_length1;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp239_ = _tmp238_[9];
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp240_ = g_strdup_printf (postal_t, _tmp221_, _tmp223_, _tmp225_, _tmp227_, _tmp229_, _tmp231_, _tmp233_, _tmp235_, _tmp237_, _tmp239_);
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp241_ = _tmp240_;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp242_ = g_strconcat (_tmp219_, _tmp241_, NULL);
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (q);
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		q = _tmp242_;
#line 499 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_g_free0 (_tmp241_);
#line 496 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		postal_info = (_vala_array_free (postal_info, postal_info_length1, (GDestroyNotify) g_free), NULL);
#line 2871 "backend.c"
	}
#line 505 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp243_ = q;
#line 505 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp244_ = g_strconcat (_tmp243_, " . }", NULL);
#line 505 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (q);
#line 505 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	q = _tmp244_;
#line 507 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp245_ = self->priv->_debug;
#line 507 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (_tmp245_) {
#line 2885 "backend.c"
		FILE* _tmp246_;
		const gchar* _tmp247_;
#line 509 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp246_ = stdout;
#line 509 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		_tmp247_ = q;
#line 509 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		fprintf (_tmp246_, "_get_insert_query : %s\n", _tmp247_);
#line 2894 "backend.c"
	}
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = q;
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (postal_address);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (affiliation);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	emails = (_vala_array_free (emails, emails_length1, (GDestroyNotify) g_free), NULL);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	phones = (_vala_array_free (phones, phones_length1, (GDestroyNotify) g_free), NULL);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (addresses);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (photo_uri);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_free0 (urn_contact);
#line 512 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 2916 "backend.c"
}


static GeeHashMap* _tracker_test_backend_parse_addrs (TrackerTestBackend* self, const gchar* addr_s) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* ret;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** im_addrs;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 515 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 515 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (addr_s != NULL, NULL);
#line 517 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 517 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	ret = _tmp0_;
#line 518 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = addr_s;
#line 518 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 518 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	im_addrs = _tmp3_;
#line 518 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 518 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4_ = im_addrs;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 2954 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		a_collection = _tmp4_;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 2966 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			a = _tmp5_;
#line 2973 "backend.c"
			{
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_ = NULL;
				gchar** info;
				gint info_length1;
				gint _info_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* proto;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* addr;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 522 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = a;
#line 522 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 522 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				info = _tmp8_;
#line 522 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 522 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_info_size_ = info_length1;
#line 523 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = info;
#line 523 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp9__length1 = info_length1;
#line 523 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 523 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 523 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				proto = _tmp11_;
#line 524 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp12_ = info;
#line 524 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp12__length1 = info_length1;
#line 524 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 524 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 524 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				addr = _tmp14_;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp15_ = ret;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp16_ = addr;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				addr = NULL;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp17_ = _tmp16_;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp18_ = proto;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				proto = NULL;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp19_ = _tmp18_;
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp19_);
#line 526 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp17_);
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (addr);
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (proto);
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 520 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (a);
#line 3054 "backend.c"
			}
		}
	}
#line 529 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 529 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 529 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3064 "backend.c"
}


static gchar* _tracker_test_backend_build_relation (TrackerTestBackend* self, const gchar* predicate, gchar** objects, int objects_length1) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 532 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 532 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (predicate != NULL, NULL);
#line 534 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = g_strdup ("");
#line 534 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	ret = _tmp0_;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1_ = objects;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp1__length1 = objects_length1;
#line 3086 "backend.c"
	{
		gchar** obj_collection = NULL;
		gint obj_collection_length1 = 0;
		gint _obj_collection_size_ = 0;
		gint obj_it = 0;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		obj_collection = _tmp1_;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		obj_collection_length1 = _tmp1__length1;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		for (obj_it = 0; obj_it < _tmp1__length1; obj_it = obj_it + 1) {
#line 3098 "backend.c"
			gchar* _tmp2_;
			gchar* obj = NULL;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			_tmp2_ = g_strdup (obj_collection[obj_it]);
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			obj = _tmp2_;
#line 3105 "backend.c"
			{
				gchar* vtemp1 = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp3_ = predicate;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp5_ = _tmp4_;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp6_ = g_strconcat (_tmp5_, " <", NULL);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp7_ = _tmp6_;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp8_ = obj;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp10_ = _tmp9_;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp11_ = g_strconcat (_tmp10_, "> ", NULL);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (vtemp1);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				vtemp1 = _tmp11_;
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp10_);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp7_);
#line 539 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (_tmp5_);
#line 540 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp12_ = ret;
#line 540 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				if (g_strcmp0 (_tmp12_, "") != 0) {
#line 3153 "backend.c"
					const gchar* _tmp13_;
					gchar* _tmp14_;
#line 542 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp13_ = ret;
#line 542 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_tmp14_ = g_strconcat (_tmp13_, "; ", NULL);
#line 542 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					_g_free0 (ret);
#line 542 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
					ret = _tmp14_;
#line 3164 "backend.c"
				}
#line 544 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp15_ = ret;
#line 544 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp16_ = vtemp1;
#line 544 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
#line 544 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (ret);
#line 544 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				ret = _tmp17_;
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (vtemp1);
#line 536 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
				_g_free0 (obj);
#line 3180 "backend.c"
			}
		}
	}
#line 547 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = ret;
#line 547 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3188 "backend.c"
}


gboolean tracker_test_backend_get_debug (TrackerTestBackend* self) {
	gboolean result;
	gboolean _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = self->priv->_debug;
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	result = _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return result;
#line 3203 "backend.c"
}


void tracker_test_backend_set_debug (TrackerTestBackend* self, gboolean value) {
	gboolean _tmp0_;
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (self != NULL);
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_tmp0_ = value;
#line 33 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv->_debug = _tmp0_;
#line 3215 "backend.c"
}


static void tracker_test_value_backend_init (GValue* value) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3222 "backend.c"
}


static void tracker_test_value_backend_free_value (GValue* value) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (value->data[0].v_pointer) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (value->data[0].v_pointer);
#line 3231 "backend.c"
	}
}


static void tracker_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		dest_value->data[0].v_pointer = tracker_test_backend_ref (src_value->data[0].v_pointer);
#line 3241 "backend.c"
	} else {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3245 "backend.c"
	}
}


static gpointer tracker_test_value_backend_peek_pointer (const GValue* value) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return value->data[0].v_pointer;
#line 3253 "backend.c"
}


static gchar* tracker_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3260 "backend.c"
		TrackerTestBackend* object;
		object = collect_values[0].v_pointer;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3267 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3271 "backend.c"
		}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = tracker_test_backend_ref (object);
#line 3275 "backend.c"
	} else {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3279 "backend.c"
	}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return NULL;
#line 3283 "backend.c"
}


static gchar* tracker_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (!object_p) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3294 "backend.c"
	}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (!value->data[0].v_pointer) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		*object_p = NULL;
#line 3300 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3304 "backend.c"
	} else {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		*object_p = tracker_test_backend_ref (value->data[0].v_pointer);
#line 3308 "backend.c"
	}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return NULL;
#line 3312 "backend.c"
}


GParamSpec* tracker_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerTestParamSpecBackend* spec;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TEST_TYPE_BACKEND), NULL);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3326 "backend.c"
}


gpointer tracker_test_value_get_backend (const GValue* value) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND), NULL);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return value->data[0].v_pointer;
#line 3335 "backend.c"
}


void tracker_test_value_set_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	old = value->data[0].v_pointer;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (v_object) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = v_object;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_ref (value->data[0].v_pointer);
#line 3355 "backend.c"
	} else {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3359 "backend.c"
	}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (old) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (old);
#line 3365 "backend.c"
	}
}


void tracker_test_value_take_backend (GValue* value, gpointer v_object) {
	TrackerTestBackend* old;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	old = value->data[0].v_pointer;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (v_object) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TEST_TYPE_BACKEND));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3384 "backend.c"
	} else {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3388 "backend.c"
	}
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (old) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		tracker_test_backend_unref (old);
#line 3394 "backend.c"
	}
}


static void tracker_test_backend_class_init (TrackerTestBackendClass * klass) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	tracker_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	TRACKER_TEST_BACKEND_CLASS (klass)->finalize = tracker_test_backend_finalize;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_type_class_add_private (klass, sizeof (TrackerTestBackendPrivate));
#line 3406 "backend.c"
}


static void tracker_test_backend_instance_init (TrackerTestBackend * self) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->priv = TRACKER_TEST_BACKEND_GET_PRIVATE (self);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self->ref_count = 1;
#line 3415 "backend.c"
}


static void tracker_test_backend_finalize (TrackerTestBackend* obj) {
	TrackerTestBackend * self;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	self = TRACKER_TEST_BACKEND (obj);
#line 34 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 35 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	_g_object_unref0 (self->priv->_connection);
#line 3427 "backend.c"
}


GType tracker_test_backend_get_type (void) {
	static volatile gsize tracker_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_test_value_backend_init, tracker_test_value_backend_free_value, tracker_test_value_backend_copy_value, tracker_test_value_backend_peek_pointer, "p", tracker_test_value_backend_collect_value, "p", tracker_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTestBackend), 0, (GInstanceInitFunc) tracker_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_test_backend_type_id;
		tracker_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_test_backend_type_id__volatile, tracker_test_backend_type_id);
	}
	return tracker_test_backend_type_id__volatile;
}


gpointer tracker_test_backend_ref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	return instance;
#line 3452 "backend.c"
}


void tracker_test_backend_unref (gpointer instance) {
	TrackerTestBackend* self;
	self = instance;
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		TRACKER_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 29 "/debian/rgs/devel/folks/tests/lib/tracker/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3465 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



