/* swf-persona-store.c generated by valac 0.13.4, the Vala compiler
 * generated from swf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gio/gio.h>


#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;
typedef struct _SwfPersonaStorePrivate SwfPersonaStorePrivate;

#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SwfPersonaStoreAddPersonaFromDetailsData SwfPersonaStoreAddPersonaFromDetailsData;
typedef struct _SwfPersonaStoreRemovePersonaData SwfPersonaStoreRemovePersonaData;
typedef struct _SwfPersonaStorePrepareData SwfPersonaStorePrepareData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SwfPersonaStore {
	FolksPersonaStore parent_instance;
	SwfPersonaStorePrivate * priv;
};

struct _SwfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _SwfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _is_quiescent;
	SwClientService* _service;
	SwClientContactView* _contact_view;
};

struct _SwfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	SwClientService* _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_;
};


static gpointer swf_persona_store_parent_class = NULL;
static gchar** swf_persona_store__always_writeable_properties;
static gint swf_persona_store__always_writeable_properties_length1;
static gchar** swf_persona_store__always_writeable_properties = NULL;
static gint swf_persona_store__always_writeable_properties_length1 = 0;
static gint _swf_persona_store__always_writeable_properties_size_ = 0;

GType swf_persona_store_get_type (void) G_GNUC_CONST;
GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA_STORE, SwfPersonaStorePrivate))
enum  {
	SWF_PERSONA_STORE_DUMMY_PROPERTY,
	SWF_PERSONA_STORE_TYPE_ID,
	SWF_PERSONA_STORE_CAN_ADD_PERSONAS,
	SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	SWF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	SWF_PERSONA_STORE_IS_PREPARED,
	SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	SWF_PERSONA_STORE_IS_QUIESCENT,
	SWF_PERSONA_STORE_PERSONAS
};
static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contact_view, gpointer self);
static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contact_view, gpointer self);
static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contact_view, gpointer self);
SwfPersonaStore* swf_persona_store_new (SwClientService* service);
SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service);
static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_);
static void swf_persona_store_real_remove_persona_data_free (gpointer _data);
static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_);
static void swf_persona_store_real_prepare_data_free (gpointer _data);
static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_);
static void _____lambda0_ (SwfPersonaStore* self, SwClientService* service, gchar** caps, int caps_length1, GError* _error_);
static void __lambda1_ (SwfPersonaStore* self, SwClientService* query, SwClientContactView* contact_view);
static void ___lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self);
static void ______lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self);
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
gchar* swf_persona_get_contact_id (SwContact* contact);
void swf_persona_update (SwfPersona* self, SwContact* contact);
static void swf_persona_store_finalize (GObject* obj);
static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_added_cb (self, contact_view);
}


static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_changed_cb (self, contact_view);
}


static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_removed_cb (self, contact_view);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * provided by the `service`.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service) {
	SwfPersonaStore * self = NULL;
	SwClientService* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SwClientService* _tmp2_;
	const gchar* _tmp3_ = NULL;
	SwClientService* _tmp4_;
	SwClientService* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = service;
	_tmp1_ = sw_client_service_get_display_name (_tmp0_);
	_tmp2_ = service;
	_tmp3_ = sw_client_service_get_name (_tmp2_);
	self = (SwfPersonaStore*) g_object_new (object_type, "display-name", _tmp1_, "id", _tmp3_, NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	_tmp4_ = service;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp6_;
	_tmp7_ = self->priv->_personas;
	_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp9_;
	return self;
}


SwfPersonaStore* swf_persona_store_new (SwClientService* service) {
	return swf_persona_store_construct (SWF_TYPE_PERSONA_STORE, service);
}


static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	SwfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	swf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* swf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_real_remove_persona_data_free (gpointer _data) {
	SwfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreRemovePersonaData, _data_);
}


static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreRemovePersonaData* _data_;
	SwfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	swf_persona_store_real_remove_persona_co (_data_);
}


static void swf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_real_prepare_data_free (gpointer _data) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStorePrepareData, _data_);
}


static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStorePrepareData* _data_;
	SwfPersonaStore* _tmp0_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	swf_persona_store_real_prepare_co (_data_);
}


static void swf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void __lambda1_ (SwfPersonaStore* self, SwClientService* query, SwClientContactView* contact_view) {
	SwClientContactView* _tmp0_;
	SwClientContactView* _tmp1_;
	SwClientContactView* _tmp2_;
	SwClientContactView* _tmp3_;
	SwClientContactView* _tmp4_;
	SwClientContactView* _tmp5_;
	SwClientContactView* _tmp6_;
	g_return_if_fail (query != NULL);
	_tmp0_ = contact_view;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = contact_view;
	g_signal_connect_object (_tmp1_, "contacts-added", (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self, 0);
	_tmp2_ = contact_view;
	g_signal_connect_object (_tmp2_, "contacts-changed", (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self, 0);
	_tmp3_ = contact_view;
	g_signal_connect_object (_tmp3_, "contacts-removed", (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self, 0);
	_tmp4_ = contact_view;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_contact_view);
	self->priv->_contact_view = _tmp5_;
	self->priv->_is_prepared = TRUE;
	g_object_notify ((GObject*) self, "is-prepared");
	self->priv->_is_quiescent = TRUE;
	g_object_notify ((GObject*) self, "is-quiescent");
	_tmp6_ = self->priv->_contact_view;
	sw_client_contact_view_start (_tmp6_);
}


static void ___lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self) {
	__lambda1_ (self, query, contact_view);
}


static void _____lambda0_ (SwfPersonaStore* self, SwClientService* service, gchar** caps, int caps_length1, GError* _error_) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	gboolean has_contacts;
	gboolean _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* parameters;
	SwClientService* _tmp7_;
	GHashTable* _tmp8_;
	g_return_if_fail (service != NULL);
	_tmp0_ = caps;
	_tmp0__length1 = caps_length1;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = caps;
	_tmp1__length1 = caps_length1;
	_tmp2_ = sw_client_service_has_cap (_tmp1_, "has-contacts-query-iface");
	has_contacts = _tmp2_;
	_tmp3_ = has_contacts;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, NULL, NULL);
	parameters = _tmp6_;
	_tmp7_ = self->priv->_service;
	_tmp8_ = parameters;
	sw_client_service_contacts_query_open_view (_tmp7_, "people", _tmp8_, ___lambda1__sw_client_service_contacts_query_open_view_callback, self);
	_g_hash_table_unref0 (parameters);
}


static void ______lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self) {
	_____lambda0_ (self, service, caps, -1, _error_);
}


static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp1_) {
				_data_->_tmp2_ = _data_->self->priv->_service;
				sw_client_service_get_static_capabilities (_data_->_tmp2_, ______lambda0__sw_client_service_get_capabilities_callback, _data_->self);
			}
		}
		__finally2:
		{
			_data_->_tmp3_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* added_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	added_personas = _tmp0_;
	_tmp1_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp1_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwContact* _tmp2_;
				SwfPersona* _tmp3_;
				SwfPersona* persona;
				GeeHashMap* _tmp4_;
				SwfPersona* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				SwfPersona* _tmp8_;
				GeeHashSet* _tmp9_;
				SwfPersona* _tmp10_;
				_tmp2_ = contact;
				_tmp3_ = swf_persona_new (self, _tmp2_);
				persona = _tmp3_;
				_tmp4_ = self->priv->_personas;
				_tmp5_ = persona;
				_tmp6_ = folks_persona_get_iid ((FolksPersona*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = persona;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp7_, _tmp8_);
				_tmp9_ = added_personas;
				_tmp10_ = persona;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
				_g_object_unref0 (persona);
			}
		}
	}
	_tmp11_ = added_personas;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		GeeHashSet* _tmp14_;
		_tmp14_ = added_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp14_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_tmp15_ = self->priv->_is_quiescent;
	if (_tmp15_ == FALSE) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
	_g_object_unref0 (added_personas);
}


static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp0_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwClientService* _tmp1_;
				const gchar* _tmp2_ = NULL;
				SwContact* _tmp3_;
				const gchar* _tmp4_;
				SwContact* _tmp5_;
				const gchar* _tmp6_;
				SwContact* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* iid;
				GeeHashMap* _tmp12_;
				const gchar* _tmp13_;
				gpointer _tmp14_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp15_;
				_tmp1_ = self->priv->_service;
				_tmp2_ = sw_client_service_get_name (_tmp1_);
				_tmp3_ = contact;
				_tmp4_ = _tmp3_->service;
				if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
					continue;
				}
				_tmp5_ = contact;
				_tmp6_ = _tmp5_->service;
				_tmp7_ = contact;
				_tmp8_ = swf_persona_get_contact_id (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _swf_persona_build_iid (_tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				iid = _tmp11_;
				_tmp12_ = self->priv->_personas;
				_tmp13_ = iid;
				_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
				persona = (SwfPersona*) _tmp14_;
				_tmp15_ = persona;
				if (_tmp15_ != NULL) {
					SwfPersona* _tmp16_;
					SwContact* _tmp17_;
					_tmp16_ = persona;
					_tmp17_ = contact;
					swf_persona_update (_tmp16_, _tmp17_);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
}


static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	removed_personas = _tmp0_;
	_tmp1_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp1_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwClientService* _tmp2_;
				const gchar* _tmp3_ = NULL;
				SwContact* _tmp4_;
				const gchar* _tmp5_;
				SwContact* _tmp6_;
				const gchar* _tmp7_;
				SwContact* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* iid;
				GeeHashMap* _tmp13_;
				const gchar* _tmp14_;
				gpointer _tmp15_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp16_;
				_tmp2_ = self->priv->_service;
				_tmp3_ = sw_client_service_get_name (_tmp2_);
				_tmp4_ = contact;
				_tmp5_ = _tmp4_->service;
				if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
					continue;
				}
				_tmp6_ = contact;
				_tmp7_ = _tmp6_->service;
				_tmp8_ = contact;
				_tmp9_ = swf_persona_get_contact_id (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _swf_persona_build_iid (_tmp7_, _tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				iid = _tmp12_;
				_tmp13_ = self->priv->_personas;
				_tmp14_ = iid;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
				persona = (SwfPersona*) _tmp15_;
				_tmp16_ = persona;
				if (_tmp16_ != NULL) {
					GeeHashSet* _tmp17_;
					SwfPersona* _tmp18_;
					GeeHashMap* _tmp19_;
					SwfPersona* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp17_ = removed_personas;
					_tmp18_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
					_tmp19_ = self->priv->_personas;
					_tmp20_ = persona;
					_tmp21_ = folks_persona_get_iid ((FolksPersona*) _tmp20_);
					_tmp22_ = _tmp21_;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp22_, NULL);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
	_tmp23_ = removed_personas;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		GeeHashSet* _tmp26_;
		_tmp26_ = removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp26_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (removed_personas);
}


static const gchar* swf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean swf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** swf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	SwfPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SwfPersonaStore*) base;
	_tmp0_ = swf_persona_store__always_writeable_properties;
	_tmp0__length1 = swf_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gboolean swf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* swf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	SwfPersonaStore* self;
	GeeMap* _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


static void swf_persona_store_class_init (SwfPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
	swf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = swf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = swf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = swf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = swf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = swf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = swf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = swf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = swf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = swf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = swf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = swf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = swf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = swf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = swf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = swf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_store_finalize;
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_PREPARED, "is-prepared");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, "always-writeable-properties");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_QUIESCENT, "is-quiescent");
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_PERSONAS, "personas");
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	swf_persona_store__always_writeable_properties = _tmp0_;
	swf_persona_store__always_writeable_properties_length1 = 0;
}


static void swf_persona_store_instance_init (SwfPersonaStore * self) {
	self->priv = SWF_PERSONA_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void swf_persona_store_finalize (GObject* obj) {
	SwfPersonaStore * self;
	SwClientContactView* _tmp0_;
	self = SWF_PERSONA_STORE (obj);
	_tmp0_ = self->priv->_contact_view;
	if (_tmp0_ != NULL) {
		SwClientContactView* _tmp1_;
		guint _tmp2_ = 0U;
		SwClientContactView* _tmp3_;
		guint _tmp4_ = 0U;
		SwClientContactView* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp1_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-added", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self);
		_tmp3_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-changed", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self);
		_tmp5_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-removed", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self);
	}
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->priv->_contact_view);
	G_OBJECT_CLASS (swf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single libsocialweb service.
 * It will create {@link Persona}s for each of the contacts known to that
 * service.
 */
GType swf_persona_store_get_type (void) {
	static volatile gsize swf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersonaStore), 0, (GInstanceInitFunc) swf_persona_store_instance_init, NULL };
		GType swf_persona_store_type_id;
		swf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "SwfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&swf_persona_store_type_id__volatile, swf_persona_store_type_id);
	}
	return swf_persona_store_type_id__volatile;
}


static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersonaStore * self;
	self = SWF_PERSONA_STORE (object);
	switch (property_id) {
		case SWF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case SWF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



