/* individual-aggregator.c generated by valac 0.13.4, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;

#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;

#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksIndividualAggregatorAddBackendData FolksIndividualAggregatorAddBackendData;
typedef struct _Block2Data Block2Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block6Data Block6Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;

#define FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS (folks_web_service_field_details_get_type ())
#define FOLKS_WEB_SERVICE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetails))
#define FOLKS_WEB_SERVICE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetailsClass))
#define FOLKS_IS_WEB_SERVICE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS))
#define FOLKS_IS_WEB_SERVICE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS))
#define FOLKS_WEB_SERVICE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetailsClass))

typedef struct _FolksWebServiceFieldDetails FolksWebServiceFieldDetails;
typedef struct _FolksWebServiceFieldDetailsClass FolksWebServiceFieldDetailsClass;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_WEB_SERVICE_DETAILS (folks_web_service_details_get_type ())
#define FOLKS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails))
#define FOLKS_IS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS))
#define FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetailsIface))

typedef struct _FolksWebServiceDetails FolksWebServiceDetails;
typedef struct _FolksWebServiceDetailsIface FolksWebServiceDetailsIface;

#define FOLKS_TYPE_LOCAL_ID_DETAILS (folks_local_id_details_get_type ())
#define FOLKS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails))
#define FOLKS_IS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS))
#define FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetailsIface))

typedef struct _FolksLocalIdDetails FolksLocalIdDetails;
typedef struct _FolksLocalIdDetailsIface FolksLocalIdDetailsIface;

#define FOLKS_TYPE_PERSONA_DETAIL (folks_persona_detail_get_type ())
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;
typedef struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData FolksIndividualAggregatorEnsureIndividualPropertyWriteableData;

/**
 * Errors from {@link IndividualAggregator}s.
 */
typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* _backend_store;
	GeeHashMap* _stores;
	FolksPersonaStore* _writeable_store;
	GeeHashSet* _backends;
	GHashTable* _link_map;
	gboolean _linking_enabled;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _prepare_pending;
	FolksDebug* _debug;
	gchar* _configured_writeable_store_type_id;
	gchar* _configured_writeable_store_id;
	guint _non_quiescent_persona_store_count;
	guint _non_quiescent_backend_count;
	gboolean _is_quiescent;
	GeeMap* _individuals;
	GeeMap* _individuals_ro;
	FolksIndividual* _user;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	FolksBackendStore* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

typedef enum  {
	FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_LOW,
	FOLKS_MATCH_RESULT_MEDIUM,
	FOLKS_MATCH_RESULT_HIGH,
	FOLKS_MATCH_RESULT_VERY_HIGH,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksIndividualAggregatorAddBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksBackend* backend;
	GeeHashSet* _tmp0_;
	FolksBackend* _tmp1_;
	gboolean _tmp2_;
	GeeHashSet* _tmp3_;
	FolksBackend* _tmp4_;
	FolksBackend* _tmp5_;
	FolksBackend* _tmp6_;
	FolksBackend* _tmp7_;
	FolksBackend* _tmp8_;
	GeeMap* _tmp9_;
	GeeMap* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _persona_store_it;
	GeeIterator* _tmp16_;
	gboolean _tmp17_;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	FolksPersonaStore* persona_store;
	FolksBackend* _tmp20_;
	FolksPersonaStore* _tmp21_;
};

struct _Block2Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	gchar* store_id;
	FolksPersonaStore* store;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;

struct _Block3Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GeeHashSet* candidate_inds;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	const gchar* prop_name;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
struct _Block5Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	FolksIndividual* individual;
};

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE,
	FOLKS_PERSONA_STORE_ERROR_READ_ONLY,
	FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED,
	FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	FolksPersonaStore* persona_store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* persona;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* details_copy;
	FolksPersonaStore* _tmp2_;
	GHashTable* _tmp3_;
	FolksPersona* _tmp4_;
	FolksPersona* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	FolksPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FolksPersonaStore* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* full_id;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	gboolean _tmp22_;
	FolksIndividual* _tmp23_;
	FolksPersona* _tmp24_;
	gboolean _tmp25_;
	FolksIndividual* _tmp26_;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	FolksPersona* _tmp29_;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	FolksIndividualAggregator * self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	FolksIndividual* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _p_it;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	FolksPersona* p;
	GeeHashSet* _tmp9_;
	FolksPersona* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _persona_it;
	GeeIterator* _tmp13_;
	gboolean _tmp14_;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	FolksPersona* persona;
	FolksPersona* _tmp17_;
	FolksPersonaStore* _tmp18_;
	FolksPersonaStore* _tmp19_;
	FolksPersona* _tmp20_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersona* _tmp3_;
	GError * _inner_error_;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksWebServiceDetailsIface {
	GTypeInterface parent_iface;
	void (*change_web_service_addresses) (FolksWebServiceDetails* self, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_web_service_addresses_finish) (FolksWebServiceDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_web_service_addresses) (FolksWebServiceDetails* self);
	void (*set_web_service_addresses) (FolksWebServiceDetails* self, GeeMultiMap* value);
};

struct _FolksLocalIdDetailsIface {
	GTypeInterface parent_iface;
	void (*change_local_ids) (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_local_ids_finish) (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_local_ids) (FolksLocalIdDetails* self);
	void (*set_local_ids) (FolksLocalIdDetails* self, GeeSet* value);
};

typedef enum  {
	FOLKS_PERSONA_DETAIL_INVALID = -1,
	FOLKS_PERSONA_DETAIL_ALIAS = 0,
	FOLKS_PERSONA_DETAIL_AVATAR,
	FOLKS_PERSONA_DETAIL_BIRTHDAY,
	FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_FULL_NAME,
	FOLKS_PERSONA_DETAIL_GENDER,
	FOLKS_PERSONA_DETAIL_IM_ADDRESSES,
	FOLKS_PERSONA_DETAIL_IS_FAVOURITE,
	FOLKS_PERSONA_DETAIL_LOCAL_IDS,
	FOLKS_PERSONA_DETAIL_NICKNAME,
	FOLKS_PERSONA_DETAIL_NOTES,
	FOLKS_PERSONA_DETAIL_PHONE_NUMBERS,
	FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_ROLES,
	FOLKS_PERSONA_DETAIL_STRUCTURED_NAME,
	FOLKS_PERSONA_DETAIL_URLS,
	FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES,
	FOLKS_PERSONA_DETAIL_GROUPS
} FolksPersonaDetail;

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	FolksPersonaStore* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GeeHashMultiMap* _tmp11_;
	GeeHashMultiMap* protocols_addrs_set;
	GeeHashMultiMap* _tmp12_;
	GeeHashMultiMap* web_service_addrs_set;
	GeeHashSet* _tmp13_;
	GeeHashSet* local_ids;
	GeeSet* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _persona_it;
	GeeIterator* _tmp16_;
	gboolean _tmp17_;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	FolksPersona* persona;
	FolksPersona* _tmp20_;
	FolksPersona* _tmp21_;
	FolksImDetails* _tmp22_;
	FolksImDetails* im_details;
	FolksImDetails* _tmp23_;
	GeeMultiMap* _tmp24_;
	GeeMultiMap* _tmp25_;
	GeeSet* _tmp26_;
	GeeSet* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _protocol_it;
	GeeIterator* _tmp30_;
	gboolean _tmp31_;
	GeeIterator* _tmp32_;
	gpointer _tmp33_;
	gchar* protocol;
	FolksImDetails* _tmp34_;
	GeeMultiMap* _tmp35_;
	GeeMultiMap* _tmp36_;
	const gchar* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* im_addresses;
	GeeCollection* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _im_address_it;
	GeeIterator* _tmp41_;
	gboolean _tmp42_;
	GeeIterator* _tmp43_;
	gpointer _tmp44_;
	FolksImFieldDetails* im_address;
	GeeHashMultiMap* _tmp45_;
	const gchar* _tmp46_;
	FolksImFieldDetails* _tmp47_;
	FolksPersona* _tmp48_;
	FolksPersona* _tmp49_;
	FolksWebServiceDetails* _tmp50_;
	FolksWebServiceDetails* ws_details;
	FolksWebServiceDetails* _tmp51_;
	GeeMultiMap* _tmp52_;
	GeeMultiMap* _tmp53_;
	GeeSet* _tmp54_;
	GeeSet* _tmp55_;
	GeeIterator* _tmp56_;
	GeeIterator* _tmp57_;
	GeeIterator* _web_service_it;
	GeeIterator* _tmp58_;
	gboolean _tmp59_;
	GeeIterator* _tmp60_;
	gpointer _tmp61_;
	gchar* web_service;
	FolksWebServiceDetails* _tmp62_;
	GeeMultiMap* _tmp63_;
	GeeMultiMap* _tmp64_;
	const gchar* _tmp65_;
	GeeCollection* _tmp66_;
	GeeCollection* ws_addresses;
	GeeCollection* _tmp67_;
	GeeIterator* _tmp68_;
	GeeIterator* _ws_fd_it;
	GeeIterator* _tmp69_;
	gboolean _tmp70_;
	GeeIterator* _tmp71_;
	gpointer _tmp72_;
	FolksWebServiceFieldDetails* ws_fd;
	GeeHashMultiMap* _tmp73_;
	const gchar* _tmp74_;
	FolksWebServiceFieldDetails* _tmp75_;
	FolksPersona* _tmp76_;
	FolksPersona* _tmp77_;
	GeeSet* _tmp78_;
	GeeSet* _tmp79_;
	GeeIterator* _tmp80_;
	GeeIterator* _id_it;
	GeeIterator* _tmp81_;
	gboolean _tmp82_;
	GeeIterator* _tmp83_;
	gpointer _tmp84_;
	gchar* id;
	GeeHashSet* _tmp85_;
	const gchar* _tmp86_;
	GHashFunc _tmp87_;
	GEqualFunc _tmp88_;
	GHashTable* _tmp89_;
	GHashTable* details;
	GeeHashMultiMap* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GValue _tmp93_;
	GValue im_addresses_value;
	GeeHashMultiMap* _tmp94_;
	GHashTable* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	GValue _tmp98_;
	GValue _tmp99_;
	GValue* _tmp100_;
	GeeHashMultiMap* _tmp101_;
	gint _tmp102_;
	gint _tmp103_;
	GValue _tmp104_;
	GValue web_service_addresses_value;
	GeeHashMultiMap* _tmp105_;
	GHashTable* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	GValue _tmp109_;
	GValue _tmp110_;
	GValue* _tmp111_;
	GeeHashSet* _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	GValue _tmp115_;
	GValue local_ids_value;
	GeeHashSet* _tmp116_;
	GHashTable* _tmp117_;
	const gchar* _tmp118_;
	gchar* _tmp119_;
	GValue _tmp120_;
	GValue _tmp121_;
	GValue* _tmp122_;
	FolksPersonaStore* _tmp123_;
	GHashTable* _tmp124_;
	FolksPersona* _tmp125_;
	FolksPersona* _tmp126_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	gboolean _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* personas;
	FolksIndividual* _tmp8_;
	GeeSet* _tmp9_;
	GeeSet* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _p_it;
	GeeIterator* _tmp12_;
	gboolean _tmp13_;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	FolksPersona* p;
	GeeHashSet* _tmp16_;
	FolksPersona* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _persona_it;
	GeeIterator* _tmp20_;
	gboolean _tmp21_;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	FolksPersona* persona;
	FolksPersona* _tmp24_;
	FolksPersonaStore* _tmp25_;
	FolksPersonaStore* _tmp26_;
	FolksPersonaStore* _tmp27_;
	const gchar* _tmp28_;
	FolksPersona* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	FolksPersona* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	FolksPersona* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	FolksPersonaStore* _tmp39_;
	FolksPersona* _tmp40_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	gchar* property_name;
	FolksPersona* result;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _p1_it;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	FolksPersona* p1;
	const gchar* _tmp12_;
	FolksPersona* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	FolksPersona* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GHashFunc _tmp19_;
	GEqualFunc _tmp20_;
	GHashTable* _tmp21_;
	GHashTable* details;
	FolksPersona* new_persona;
	gboolean _tmp22_;
	FolksPersonaStore* _tmp23_;
	const gchar* _tmp24_;
	FolksPersonaStore* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gboolean _tmp28_;
	FolksPersonaStore* _tmp29_;
	GHashTable* _tmp30_;
	FolksPersona* _tmp31_;
	FolksPersona* _tmp32_;
	GError* e1;
	FolksPersona* _tmp33_;
	GeeHashMap* _tmp34_;
	GeeCollection* _tmp35_;
	GeeCollection* _tmp36_;
	GeeCollection* _tmp37_;
	GeeIterator* _tmp38_;
	GeeIterator* _tmp39_;
	GeeIterator* _s_it;
	GeeIterator* _tmp40_;
	gboolean _tmp41_;
	GeeIterator* _tmp42_;
	gpointer _tmp43_;
	FolksPersonaStore* s;
	gboolean _tmp44_;
	FolksPersonaStore* _tmp45_;
	FolksPersonaStore* _tmp46_;
	const gchar* _tmp47_;
	FolksPersonaStore* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp50_;
	gint _tmp50__length1;
	gboolean _tmp51_;
	FolksPersonaStore* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	FolksPersonaStore* _tmp55_;
	GHashTable* _tmp56_;
	FolksPersona* _tmp57_;
	FolksPersona* _tmp58_;
	GError* e2;
	gboolean _tmp59_;
	FolksPersona* _tmp60_;
	FolksPersonaStore* _tmp61_;
	gboolean _tmp62_;
	const gchar* _tmp63_;
	GError* _tmp64_;
	FolksPersona* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	GError* _tmp68_;
	GeeHashSet* _tmp69_;
	GeeHashSet* linking_personas;
	GeeHashSet* _tmp70_;
	FolksPersona* _tmp71_;
	FolksIndividual* _tmp72_;
	GeeSet* _tmp73_;
	GeeSet* _tmp74_;
	GeeIterator* _tmp75_;
	GeeIterator* _p2_it;
	GeeIterator* _tmp76_;
	gboolean _tmp77_;
	GeeIterator* _tmp78_;
	gpointer _tmp79_;
	FolksPersona* p2;
	GeeHashSet* _tmp80_;
	FolksPersona* _tmp81_;
	const gchar* _tmp82_;
	GeeHashSet* _tmp83_;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT,
	FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER
};
static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug);
static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
#define FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_CONFIG_KEY "/system/folks/backends/primary_store"
FolksIndividualAggregator* folks_individual_aggregator_new (void);
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
FolksDebug* folks_debug_dup (void);
static void _folks_individual_aggregator_set_writeable_store (FolksIndividualAggregator* self, const gchar* store_config_ids);
FolksBackendStore* folks_backend_store_dup (void);
#define FOLKS_DEBUG_STATUS_LOG_DOMAIN "folks-status"
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...);
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
void folks_debug_indent (FolksDebug* self);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
const gchar* folks_individual_get_id (FolksIndividual* self);
GType folks_persona_get_type (void) G_GNUC_CONST;
GeeSet* folks_individual_get_personas (FolksIndividual* self);
gboolean folks_persona_get_is_user (FolksPersona* self);
const gchar* folks_persona_get_uid (FolksPersona* self);
const gchar* folks_persona_get_iid (FolksPersona* self);
const gchar* folks_persona_get_display_id (FolksPersona* self);
void folks_debug_unindent (FolksDebug* self);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType folks_match_result_get_type (void) G_GNUC_CONST;
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold);
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
GType folks_potential_match_get_type (void) G_GNUC_CONST;
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold);
static void _folks_individual_aggregator_add_backend_data_free (gpointer _data);
static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_);
static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* _data_);
static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
gboolean folks_backend_get_is_quiescent (FolksBackend* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean folks_persona_store_get_is_quiescent (FolksPersonaStore* self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void __lambda23_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_);
static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self);
static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, GeeMultiMap* changes, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, FolksIndividual** user, GeeHashMultiMap** individuals_changes);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _______lambda21_ (Block4Data* _data4_, const gchar* l);
static void ________lambda21__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
FolksIndividual* folks_individual_new (GeeSet* personas);
FolksIndividual* folks_individual_construct (GType object_type, GeeSet* personas);
static void _folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self, FolksPersona* persona, FolksIndividual* individual);
static void _folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void _folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self, FolksPersona* persona);
static void __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self, FolksPersona* persona);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _____lambda22_ (Block5Data* _data5_, const gchar* l);
static void ______lambda22__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
static void _folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self, FolksIndividual* individual);
FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self);
FolksIndividual* folks_persona_get_individual (FolksPersona* self);
void folks_individual_set_personas (FolksIndividual* self, GeeSet* value);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
gboolean folks_debug_get_debug_output_enabled (FolksDebug* self);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_);
static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void __lambda24_ (Block6Data* _data6_, const gchar* k, GValue* v);
static GValue* _g_value_dup (GValue* self);
static void ___lambda24__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
GType folks_web_service_field_details_get_type (void) G_GNUC_CONST;
GQuark folks_property_error_quark (void);
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
GType folks_web_service_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_web_service_details_get_web_service_addresses (FolksWebServiceDetails* self);
GType folks_local_id_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_local_id_details_get_local_ids (FolksLocalIdDetails* self);
GType folks_persona_detail_get_type (void) G_GNUC_CONST;
const gchar* folks_persona_store_detail_key (FolksPersonaDetail detail);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data);
void folks_individual_aggregator_ensure_individual_property_writeable (FolksIndividualAggregator* self, FolksIndividual* individual, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_ensure_individual_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_);
gchar** folks_persona_get_writeable_properties (FolksPersona* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar** folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self, int* result_length1);
static void folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self);
gboolean folks_individual_aggregator_get_is_quiescent (FolksIndividualAggregator* self);
FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_individual_aggregator_finalize (GObject* obj);
static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_folks_individual_aggregator_backend_available_cb (self, _sender, backend);
}


static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_folks_individual_aggregator_debug_print_status (self, _sender);
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal (or the
   * {@link IndividualAggregator.individuals_changed_detailed} signal), then
   * call {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed_detailed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GeeHashSet* _tmp8_;
	FolksDebug* _tmp9_ = NULL;
	FolksDebug* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* store_config_ids;
	const gchar* _tmp13_;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* disable_linking;
	const gchar* _tmp25_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	FolksBackendStore* _tmp37_ = NULL;
	FolksBackendStore* _tmp38_;
	GError * _inner_error_ = NULL;
	self = (FolksIndividualAggregator*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_stores);
	self->priv->_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = (GeeMap*) _tmp1_;
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = gee_map_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_link_map);
	self->priv->_link_map = _tmp7_;
	_tmp8_ = gee_hash_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_backends);
	self->priv->_backends = _tmp8_;
	_tmp9_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp9_;
	_tmp10_ = self->priv->_debug;
	g_signal_connect_object (_tmp10_, "print-status", (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self, 0);
	_tmp11_ = g_getenv ("FOLKS_WRITEABLE_STORE");
	_tmp12_ = g_strdup (_tmp11_);
	store_config_ids = _tmp12_;
	_tmp13_ = store_config_ids;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = store_config_ids;
		_folks_individual_aggregator_set_writeable_store (self, _tmp14_);
	} else {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_strdup ("eds");
		_g_free0 (self->priv->_configured_writeable_store_type_id);
		self->priv->_configured_writeable_store_type_id = _tmp15_;
		_tmp16_ = g_strdup ("system");
		_g_free0 (self->priv->_configured_writeable_store_id);
		self->priv->_configured_writeable_store_id = _tmp16_;
		{
			GConfClient* _tmp17_ = NULL;
			GConfClient* client;
			GConfClient* _tmp18_;
			GConfValue* _tmp19_ = NULL;
			GConfValue* val;
			GConfValue* _tmp20_;
			_tmp17_ = gconf_client_get_default ();
			client = _tmp17_;
			_tmp18_ = client;
			_tmp19_ = gconf_client_get (_tmp18_, FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_CONFIG_KEY, &_inner_error_);
			val = _tmp19_;
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			_tmp20_ = val;
			if (_tmp20_ != NULL) {
				GConfValue* _tmp21_;
				const gchar* _tmp22_ = NULL;
				_tmp21_ = val;
				_tmp22_ = gconf_value_get_string (_tmp21_);
				_folks_individual_aggregator_set_writeable_store (self, _tmp22_);
			}
			_gconf_value_free0 (val);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			_g_free0 (store_config_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp24_ = g_strdup (_tmp23_);
	disable_linking = _tmp24_;
	_tmp25_ = disable_linking;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		_tmp26_ = disable_linking;
		_tmp27_ = string_strip (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) (-1));
		_g_free0 (disable_linking);
		disable_linking = _tmp29_;
		_g_free0 (_tmp28_);
	}
	_tmp32_ = disable_linking;
	if (_tmp32_ == NULL) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp33_;
		_tmp33_ = disable_linking;
		_tmp31_ = g_strcmp0 (_tmp33_, "no") == 0;
	}
	_tmp34_ = _tmp31_;
	if (_tmp34_) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp35_;
		_tmp35_ = disable_linking;
		_tmp30_ = g_strcmp0 (_tmp35_, "0") == 0;
	}
	_tmp36_ = _tmp30_;
	self->priv->_linking_enabled = _tmp36_;
	_tmp37_ = folks_backend_store_dup ();
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp37_;
	_tmp38_ = self->priv->_backend_store;
	g_signal_connect_object (_tmp38_, "backend-available", (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self, 0);
	_g_free0 (disable_linking);
	_g_free0 (store_config_ids);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _folks_individual_aggregator_set_writeable_store (FolksIndividualAggregator* self, const gchar* store_config_ids) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store_config_ids != NULL);
	_tmp0_ = store_config_ids;
	_tmp1_ = string_index_of (_tmp0_, ":", 0);
	if (_tmp1_ != (-1)) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_ = NULL;
		gchar** ids;
		gint ids_length1;
		gint _ids_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = store_config_ids;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 2);
		ids = _tmp4_;
		ids_length1 = _vala_array_length (_tmp3_);
		_ids_size_ = ids_length1;
		_tmp5_ = ids;
		_tmp5__length1 = ids_length1;
		_tmp6_ = _tmp5_[0];
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->_configured_writeable_store_type_id);
		self->priv->_configured_writeable_store_type_id = _tmp7_;
		_tmp8_ = ids;
		_tmp8__length1 = ids_length1;
		_tmp9_ = _tmp8_[1];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->_configured_writeable_store_id);
		self->priv->_configured_writeable_store_id = _tmp10_;
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	} else {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = store_config_ids;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->_configured_writeable_store_type_id);
		self->priv->_configured_writeable_store_type_id = _tmp12_;
		_tmp13_ = g_strdup ("");
		_g_free0 (self->priv->_configured_writeable_store_id);
		self->priv->_configured_writeable_store_id = _tmp13_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	FolksDebug* _tmp11_;
	guint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	FolksPersonaStore* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	FolksDebug* _tmp21_;
	GeeMap* _tmp22_;
	GeeMap* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	FolksDebug* _tmp26_;
	FolksDebug* _tmp96_;
	FolksDebug* _tmp97_;
	GHashTable* _tmp98_;
	guint _tmp99_ = 0U;
	FolksDebug* _tmp100_;
	GHashTable* _tmp101_;
	GHashTableIter iter = {0};
	gchar* link_key = NULL;
	FolksIndividual* individual = NULL;
	FolksDebug* _tmp110_;
	FolksDebug* _tmp111_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "IndividualAggregator (%p)", self);
	_tmp2_ = self->priv->_linking_enabled;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = self->priv->_is_prepared;
	if (_tmp4_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp6_ = self->priv->_is_quiescent;
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("yes");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp7_;
	} else {
		guint _tmp8_;
		guint _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp8_ = self->priv->_non_quiescent_backend_count;
		_tmp9_ = self->priv->_non_quiescent_persona_store_count;
		_tmp10_ = g_strdup_printf ("no (%u backends, %u persona stores left)", _tmp8_, _tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = debug;
	_tmp12_ = ((GObject*) self)->ref_count;
	_tmp13_ = g_strdup_printf ("%u", _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_writeable_store;
	_tmp16_ = g_strdup_printf ("%p", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp1_;
	_tmp19_ = _tmp3_;
	_tmp20_ = _tmp5_;
	folks_debug_print_key_value_pairs (_tmp11_, domain, level, "Ref. count", _tmp14_, "Writeable store", _tmp17_, "Linking enabled?", _tmp18_, "Prepared?", _tmp19_, "Quiescent?", _tmp20_, NULL);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp21_ = debug;
	_tmp22_ = folks_individual_aggregator_get_individuals (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = gee_map_get_size (_tmp23_);
	_tmp25_ = _tmp24_;
	folks_debug_print_line (_tmp21_, domain, level, "%u Individuals:", (guint) _tmp25_);
	_tmp26_ = debug;
	folks_debug_indent (_tmp26_);
	{
		GeeMap* _tmp27_;
		GeeMap* _tmp28_;
		GeeCollection* _tmp29_;
		GeeCollection* _tmp30_;
		GeeCollection* _tmp31_;
		GeeIterator* _tmp32_ = NULL;
		GeeIterator* _tmp33_;
		GeeIterator* _individual_it;
		_tmp27_ = folks_individual_aggregator_get_individuals (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_map_get_values (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_individual_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			gboolean _tmp35_ = FALSE;
			GeeIterator* _tmp36_;
			gpointer _tmp37_ = NULL;
			FolksIndividual* individual;
			gchar* trust_level;
			FolksIndividual* _tmp38_;
			FolksTrustLevel _tmp39_;
			FolksTrustLevel _tmp40_;
			FolksDebug* _tmp43_;
			FolksIndividual* _tmp44_;
			const gchar* _tmp45_ = NULL;
			FolksIndividual* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			FolksDebug* _tmp49_;
			FolksIndividual* _tmp50_;
			guint _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			FolksIndividual* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			FolksDebug* _tmp59_;
			FolksIndividual* _tmp60_;
			GeeSet* _tmp61_;
			GeeSet* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			FolksDebug* _tmp65_;
			FolksDebug* _tmp95_;
			_tmp34_ = _individual_it;
			_tmp35_ = gee_iterator_next (_tmp34_);
			if (!_tmp35_) {
				break;
			}
			_tmp36_ = _individual_it;
			_tmp37_ = gee_iterator_get (_tmp36_);
			individual = (FolksIndividual*) _tmp37_;
			trust_level = NULL;
			_tmp38_ = individual;
			_tmp39_ = folks_individual_get_trust_level (_tmp38_);
			_tmp40_ = _tmp39_;
			switch (_tmp40_) {
				case FOLKS_TRUST_LEVEL_NONE:
				{
					gchar* _tmp41_;
					_tmp41_ = g_strdup ("none");
					_g_free0 (trust_level);
					trust_level = _tmp41_;
					break;
				}
				case FOLKS_TRUST_LEVEL_PERSONAS:
				{
					gchar* _tmp42_;
					_tmp42_ = g_strdup ("personas");
					_g_free0 (trust_level);
					trust_level = _tmp42_;
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_tmp43_ = debug;
			_tmp44_ = individual;
			folks_debug_print_heading (_tmp43_, domain, level, "Individual (%p)", _tmp44_);
			_tmp46_ = individual;
			_tmp47_ = folks_individual_get_is_user (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_) {
				_tmp45_ = "yes";
			} else {
				_tmp45_ = "no";
			}
			_tmp49_ = debug;
			_tmp50_ = individual;
			_tmp51_ = ((GObject*) _tmp50_)->ref_count;
			_tmp52_ = g_strdup_printf ("%u", _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = individual;
			_tmp55_ = folks_individual_get_id (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = _tmp45_;
			_tmp58_ = trust_level;
			folks_debug_print_key_value_pairs (_tmp49_, domain, level, "Ref. count", _tmp53_, "ID", _tmp56_, "User?", _tmp57_, "Trust level", _tmp58_, NULL);
			_g_free0 (_tmp53_);
			_tmp59_ = debug;
			_tmp60_ = individual;
			_tmp61_ = folks_individual_get_personas (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = gee_collection_get_size ((GeeCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			folks_debug_print_line (_tmp59_, domain, level, "%u Personas:", (guint) _tmp64_);
			_tmp65_ = debug;
			folks_debug_indent (_tmp65_);
			{
				FolksIndividual* _tmp66_;
				GeeSet* _tmp67_;
				GeeSet* _tmp68_;
				GeeIterator* _tmp69_ = NULL;
				GeeIterator* _persona_it;
				_tmp66_ = individual;
				_tmp67_ = folks_individual_get_personas (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = gee_iterable_iterator ((GeeIterable*) _tmp68_);
				_persona_it = _tmp69_;
				while (TRUE) {
					GeeIterator* _tmp70_;
					gboolean _tmp71_ = FALSE;
					GeeIterator* _tmp72_;
					gpointer _tmp73_ = NULL;
					FolksPersona* persona;
					FolksDebug* _tmp74_;
					FolksPersona* _tmp75_;
					const gchar* _tmp76_ = NULL;
					FolksPersona* _tmp77_;
					gboolean _tmp78_;
					gboolean _tmp79_;
					FolksDebug* _tmp80_;
					FolksPersona* _tmp81_;
					guint _tmp82_;
					gchar* _tmp83_ = NULL;
					gchar* _tmp84_;
					FolksPersona* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					FolksPersona* _tmp88_;
					const gchar* _tmp89_;
					const gchar* _tmp90_;
					FolksPersona* _tmp91_;
					const gchar* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					_tmp70_ = _persona_it;
					_tmp71_ = gee_iterator_next (_tmp70_);
					if (!_tmp71_) {
						break;
					}
					_tmp72_ = _persona_it;
					_tmp73_ = gee_iterator_get (_tmp72_);
					persona = (FolksPersona*) _tmp73_;
					_tmp74_ = debug;
					_tmp75_ = persona;
					folks_debug_print_heading (_tmp74_, domain, level, "Persona (%p)", _tmp75_);
					_tmp77_ = persona;
					_tmp78_ = folks_persona_get_is_user (_tmp77_);
					_tmp79_ = _tmp78_;
					if (_tmp79_) {
						_tmp76_ = "yes";
					} else {
						_tmp76_ = "no";
					}
					_tmp80_ = debug;
					_tmp81_ = persona;
					_tmp82_ = ((GObject*) _tmp81_)->ref_count;
					_tmp83_ = g_strdup_printf ("%u", _tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = persona;
					_tmp86_ = folks_persona_get_uid (_tmp85_);
					_tmp87_ = _tmp86_;
					_tmp88_ = persona;
					_tmp89_ = folks_persona_get_iid (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = persona;
					_tmp92_ = folks_persona_get_display_id (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = _tmp76_;
					folks_debug_print_key_value_pairs (_tmp80_, domain, level, "Ref. count", _tmp84_, "UID", _tmp87_, "IID", _tmp90_, "Display ID", _tmp93_, "User?", _tmp94_, NULL);
					_g_free0 (_tmp84_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp95_ = debug;
			folks_debug_unindent (_tmp95_);
			_g_free0 (trust_level);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp96_ = debug;
	folks_debug_unindent (_tmp96_);
	_tmp97_ = debug;
	_tmp98_ = self->priv->_link_map;
	_tmp99_ = g_hash_table_size (_tmp98_);
	folks_debug_print_line (_tmp97_, domain, level, "%u entries in the link map:", _tmp99_);
	_tmp100_ = debug;
	folks_debug_indent (_tmp100_);
	_tmp101_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp101_);
	while (TRUE) {
		gconstpointer _tmp102_ = NULL;
		gconstpointer _tmp103_ = NULL;
		gboolean _tmp104_ = FALSE;
		gchar* _tmp105_;
		FolksIndividual* _tmp106_;
		FolksDebug* _tmp107_;
		const gchar* _tmp108_;
		FolksIndividual* _tmp109_;
		_tmp104_ = g_hash_table_iter_next (&iter, &_tmp102_, &_tmp103_);
		_g_free0 (link_key);
		_tmp105_ = g_strdup (_tmp102_);
		link_key = _tmp105_;
		_g_object_unref0 (individual);
		_tmp106_ = _g_object_ref0 (_tmp103_);
		individual = _tmp106_;
		if (!(_tmp104_ == TRUE)) {
			break;
		}
		_tmp107_ = debug;
		_tmp108_ = link_key;
		_tmp109_ = individual;
		folks_debug_print_line (_tmp107_, domain, level, "%s → %p", _tmp108_, _tmp109_);
	}
	_tmp110_ = debug;
	folks_debug_unindent (_tmp110_);
	_tmp111_ = debug;
	folks_debug_print_line (_tmp111_, domain, level, "");
	_g_object_unref0 (individual);
	_g_free0 (link_key);
	_g_free0 (_tmp5_);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, _data_);
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	FolksIndividualAggregator* _tmp0_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal (or
   * {@link IndividualAggregator.individuals_changed_detailed} signal), or a
   * race condition could occur, with the signal being emitted before your code
   * has connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_prepare_co (_data_);
}


static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp2_) {
				_data_->_tmp3_ = _data_->self->priv->_prepare_pending;
				_data_->_tmp1_ = !_data_->_tmp3_;
			} else {
				_data_->_tmp1_ = FALSE;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			if (_data_->_tmp4_) {
				_data_->self->priv->_prepare_pending = TRUE;
				_data_->_tmp5_ = _data_->self->priv->_backend_store;
				_data_->_state_ = 1;
				folks_backend_store_load_backends (_data_->_tmp5_, folks_individual_aggregator_prepare_ready, _data_);
				return FALSE;
				_state_1:
				folks_backend_store_load_backends_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __finally14;
				}
				_data_->self->priv->_is_prepared = TRUE;
				_data_->self->priv->_prepare_pending = FALSE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
			}
		}
		__finally14:
		{
			_data_->_tmp6_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Get all matches for a given {@link Individual}.
   *
   * @param matchee the individual to find matches for
   * @param min_threshold the threshold for accepting a match
   * @return a map from matched individuals to the degree with which they match
   * `matchee` (which is guaranteed to at least equal `min_threshold`);
   * if no matches could be found, an empty map is returned
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* matches;
	FolksPotentialMatch* _tmp1_;
	FolksPotentialMatch* matchObj;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (matchee != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = folks_potential_match_new ();
	matchObj = _tmp1_;
	{
		GeeMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_;
		GeeIterator* _i_it;
		_tmp2_ = self->priv->_individuals;
		_tmp3_ = gee_map_get_values (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_i_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			FolksIndividual* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			FolksPotentialMatch* _tmp18_;
			FolksIndividual* _tmp19_;
			FolksIndividual* _tmp20_;
			FolksMatchResult _tmp21_ = 0;
			FolksMatchResult _result_;
			FolksMatchResult _tmp22_;
			FolksMatchResult _tmp23_;
			_tmp8_ = _i_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _i_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			i = (FolksIndividual*) _tmp11_;
			_tmp12_ = i;
			_tmp13_ = folks_individual_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = matchee;
			_tmp16_ = folks_individual_get_id (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp14_, _tmp17_) == 0) {
				_g_object_unref0 (i);
				continue;
			}
			_tmp18_ = matchObj;
			_tmp19_ = i;
			_tmp20_ = matchee;
			_tmp21_ = folks_potential_match_potential_match (_tmp18_, _tmp19_, _tmp20_);
			_result_ = _tmp21_;
			_tmp22_ = _result_;
			_tmp23_ = min_threshold;
			if (_tmp22_ >= _tmp23_) {
				GeeHashMap* _tmp24_;
				FolksIndividual* _tmp25_;
				FolksMatchResult _tmp26_;
				_tmp24_ = matches;
				_tmp25_ = i;
				_tmp26_ = _result_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, GINT_TO_POINTER (_tmp26_));
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	return result;
}


/**
   * Get all combinations between all {@link Individual}s.
   *
   * @param min_threshold the threshold for accepting a match
   * @return a map from each individual in the aggregator to a map of the
   * other individuals in the aggregator which can be matched with that
   * individual, mapped to the degree with which they match the original
   * individual (which is guaranteed to at least equal `min_threshold`)
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* matches;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gint _tmp5_ = 0;
	gpointer* _tmp6_ = NULL;
	FolksIndividual** _tmp7_;
	gint _tmp7__length1;
	FolksIndividual** individuals;
	gint individuals_length1;
	gint _individuals_size_;
	FolksPotentialMatch* _tmp8_;
	FolksPotentialMatch* matchObj;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = gee_map_get_values (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = gee_collection_to_array (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_g_object_unref0 (_tmp4_);
	individuals = _tmp7_;
	individuals_length1 = _tmp7__length1;
	_individuals_size_ = individuals_length1;
	_tmp8_ = folks_potential_match_new ();
	matchObj = _tmp8_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				FolksIndividual** _tmp13_;
				gint _tmp13__length1;
				FolksIndividual** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				FolksIndividual* _tmp16_;
				FolksIndividual* _tmp17_;
				FolksIndividual* a;
				GeeHashMap* _tmp18_;
				FolksIndividual* _tmp19_;
				gpointer _tmp20_ = NULL;
				GeeHashMap* matches_a;
				GeeHashMap* _tmp21_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = individuals;
				_tmp13__length1 = individuals_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = individuals;
				_tmp14__length1 = individuals_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = _g_object_ref0 (_tmp16_);
				a = _tmp17_;
				_tmp18_ = matches;
				_tmp19_ = a;
				_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
				matches_a = (GeeHashMap*) _tmp20_;
				_tmp21_ = matches_a;
				if (_tmp21_ == NULL) {
					GeeHashMap* _tmp22_;
					GeeHashMap* _tmp23_;
					FolksIndividual* _tmp24_;
					GeeHashMap* _tmp25_;
					_tmp22_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (matches_a);
					matches_a = _tmp22_;
					_tmp23_ = matches;
					_tmp24_ = a;
					_tmp25_ = matches_a;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp25_);
				}
				{
					gint _tmp26_;
					gint f;
					_tmp26_ = i;
					f = _tmp26_ + 1;
					{
						gboolean _tmp27_;
						_tmp27_ = TRUE;
						while (TRUE) {
							gboolean _tmp28_;
							gint _tmp30_;
							FolksIndividual** _tmp31_;
							gint _tmp31__length1;
							FolksIndividual** _tmp32_;
							gint _tmp32__length1;
							gint _tmp33_;
							FolksIndividual* _tmp34_;
							FolksIndividual* _tmp35_;
							FolksIndividual* b;
							GeeHashMap* _tmp36_;
							FolksIndividual* _tmp37_;
							gpointer _tmp38_ = NULL;
							GeeHashMap* matches_b;
							GeeHashMap* _tmp39_;
							FolksPotentialMatch* _tmp44_;
							FolksIndividual* _tmp45_;
							FolksIndividual* _tmp46_;
							FolksMatchResult _tmp47_ = 0;
							FolksMatchResult _result_;
							FolksMatchResult _tmp48_;
							FolksMatchResult _tmp49_;
							_tmp28_ = _tmp27_;
							if (!_tmp28_) {
								gint _tmp29_;
								_tmp29_ = f;
								f = _tmp29_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp30_ = f;
							_tmp31_ = individuals;
							_tmp31__length1 = individuals_length1;
							if (!(_tmp30_ < _tmp31__length1)) {
								break;
							}
							_tmp32_ = individuals;
							_tmp32__length1 = individuals_length1;
							_tmp33_ = f;
							_tmp34_ = _tmp32_[_tmp33_];
							_tmp35_ = _g_object_ref0 (_tmp34_);
							b = _tmp35_;
							_tmp36_ = matches;
							_tmp37_ = b;
							_tmp38_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp36_, _tmp37_);
							matches_b = (GeeHashMap*) _tmp38_;
							_tmp39_ = matches_b;
							if (_tmp39_ == NULL) {
								GeeHashMap* _tmp40_;
								GeeHashMap* _tmp41_;
								FolksIndividual* _tmp42_;
								GeeHashMap* _tmp43_;
								_tmp40_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL);
								_g_object_unref0 (matches_b);
								matches_b = _tmp40_;
								_tmp41_ = matches;
								_tmp42_ = b;
								_tmp43_ = matches_b;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, _tmp42_, _tmp43_);
							}
							_tmp44_ = matchObj;
							_tmp45_ = a;
							_tmp46_ = b;
							_tmp47_ = folks_potential_match_potential_match (_tmp44_, _tmp45_, _tmp46_);
							_result_ = _tmp47_;
							_tmp48_ = _result_;
							_tmp49_ = min_threshold;
							if (_tmp48_ >= _tmp49_) {
								GeeHashMap* _tmp50_;
								FolksIndividual* _tmp51_;
								FolksMatchResult _tmp52_;
								GeeHashMap* _tmp53_;
								FolksIndividual* _tmp54_;
								FolksMatchResult _tmp55_;
								_tmp50_ = matches_a;
								_tmp51_ = b;
								_tmp52_ = _result_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp50_, _tmp51_, GINT_TO_POINTER (_tmp52_));
								_tmp53_ = matches_b;
								_tmp54_ = a;
								_tmp55_ = _result_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp53_, _tmp54_, GINT_TO_POINTER (_tmp55_));
							}
							_g_object_unref0 (matches_b);
							_g_object_unref0 (b);
						}
					}
				}
				_g_object_unref0 (matches_a);
				_g_object_unref0 (a);
			}
		}
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	individuals = (_vala_array_free (individuals, individuals_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static void _folks_individual_aggregator_add_backend_data_free (gpointer _data) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorAddBackendData, _data_);
}


static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksBackend* _tmp1_;
	FolksBackend* _tmp2_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_individual_aggregator_add_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_individual_aggregator_add_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = backend;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->backend = _tmp2_;
	_folks_individual_aggregator_add_backend_co (_data_);
}


static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_added_cb (self, _sender, store);
}


static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_removed_cb (self, _sender, store);
}


static void __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_backend_is_quiescent_changed_cb (self, _sender, pspec);
}


static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends;
	_data_->_tmp1_ = _data_->backend;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp0_, _data_->_tmp1_);
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->_backends;
		_data_->_tmp4_ = _data_->backend;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp3_, _data_->_tmp4_);
		_data_->_tmp5_ = _data_->backend;
		g_signal_connect_object (_data_->_tmp5_, "persona-store-added", (GCallback) __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, _data_->self, 0);
		_data_->_tmp6_ = _data_->backend;
		g_signal_connect_object (_data_->_tmp6_, "persona-store-removed", (GCallback) __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, _data_->self, 0);
		_data_->_tmp7_ = _data_->backend;
		g_signal_connect_object ((GObject*) _data_->_tmp7_, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify, _data_->self, 0);
		{
			_data_->_tmp8_ = _data_->backend;
			_data_->_tmp9_ = folks_backend_get_persona_stores (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = gee_map_get_values (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_g_object_unref0 (_data_->_tmp13_);
			_data_->_persona_store_it = _data_->_tmp15_;
			while (TRUE) {
				_data_->_tmp16_ = _data_->_persona_store_it;
				_data_->_tmp17_ = FALSE;
				_data_->_tmp17_ = gee_iterator_next (_data_->_tmp16_);
				if (!_data_->_tmp17_) {
					break;
				}
				_data_->_tmp18_ = _data_->_persona_store_it;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
				_data_->persona_store = (FolksPersonaStore*) _data_->_tmp19_;
				_data_->_tmp20_ = _data_->backend;
				_data_->_tmp21_ = _data_->persona_store;
				_folks_individual_aggregator_backend_persona_store_added_cb (_data_->self, _data_->_tmp20_, _data_->_tmp21_);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	FolksBackend* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksBackend* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = backend;
	_tmp1_ = folks_backend_get_is_quiescent (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		guint _tmp3_;
		_tmp3_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp3_ + 1;
	}
	_tmp4_ = backend;
	_folks_individual_aggregator_add_backend (self, _tmp4_, NULL, NULL);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->store_id);
		_g_object_unref0 (_data2_->store);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_folks_individual_aggregator_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_is_writeable_changed_cb (self, _sender, pspec);
}


static void __folks_individual_aggregator_trust_level_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_trust_level_changed_cb (self, _sender, pspec);
}


static void __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_store_is_quiescent_changed_cb (self, _sender, pspec);
}


static void __lambda23_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_) {
	FolksIndividualAggregator * self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (_result_ != NULL);
	{
		FolksPersonaStore* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data2_->store;
		_tmp1_ = _result_;
		folks_persona_store_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Error preparing persona store '%s': %s");
		_tmp3_ = _data2_->store_id;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp2_, _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda23_ (self, source_object, res);
	block2_data_unref (self);
}


static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block2Data* _data2_;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	FolksPersonaStore* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	FolksPersonaStore* _tmp30_;
	FolksPersonaStore* _tmp31_;
	FolksPersonaStore* _tmp32_;
	FolksPersonaStore* _tmp33_;
	FolksPersonaStore* _tmp34_;
	FolksPersonaStore* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	FolksPersonaStore* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data2_->store = _tmp1_;
	_tmp2_ = _data2_->store;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data2_->store;
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _folks_individual_aggregator_get_store_full_id (self, _tmp4_, _tmp7_);
	_data2_->store_id = _tmp8_;
	_tmp9_ = _data2_->store;
	_tmp10_ = folks_persona_store_get_type_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_configured_writeable_store_type_id;
	if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		FolksPersonaStore* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp19_;
		gboolean _tmp24_;
		_tmp15_ = _data2_->store;
		_tmp16_ = folks_persona_store_get_type_id (_tmp15_);
		_tmp17_ = _tmp16_;
		if (g_strcmp0 (_tmp17_, "eds") != 0) {
			const gchar* _tmp18_;
			_tmp18_ = self->priv->_configured_writeable_store_id;
			_tmp14_ = g_strcmp0 (_tmp18_, "") == 0;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp19_ = _tmp14_;
		if (_tmp19_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp20_;
			FolksPersonaStore* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp20_ = self->priv->_configured_writeable_store_id;
			_tmp21_ = _data2_->store;
			_tmp22_ = folks_persona_store_get_id (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp13_ = g_strcmp0 (_tmp20_, _tmp23_) == 0;
		}
		_tmp24_ = _tmp13_;
		if (_tmp24_) {
			FolksPersonaStore* _tmp25_;
			FolksPersonaStore* _tmp26_;
			FolksPersonaStore* _tmp27_;
			_tmp25_ = _data2_->store;
			folks_persona_store_set_is_writeable (_tmp25_, TRUE);
			_tmp26_ = _data2_->store;
			folks_persona_store_set_trust_level (_tmp26_, FOLKS_PERSONA_STORE_TRUST_FULL);
			_tmp27_ = _data2_->store;
			self->priv->_writeable_store = _tmp27_;
			g_object_notify ((GObject*) self, "primary-store");
		}
	}
	_tmp28_ = self->priv->_stores;
	_tmp29_ = _data2_->store_id;
	_tmp30_ = _data2_->store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = _data2_->store;
	g_signal_connect_object (_tmp31_, "personas-changed", (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	_tmp32_ = _data2_->store;
	g_signal_connect_object ((GObject*) _tmp32_, "notify::is-writeable", (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self, 0);
	_tmp33_ = _data2_->store;
	g_signal_connect_object ((GObject*) _tmp33_, "notify::trust-level", (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self, 0);
	_tmp34_ = _data2_->store;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self, 0);
	_tmp35_ = _data2_->store;
	_tmp36_ = folks_persona_store_get_is_quiescent (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == FALSE) {
		guint _tmp38_;
		_tmp38_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp38_ + 1;
	}
	_tmp39_ = _data2_->store;
	folks_persona_store_prepare (_tmp39_, ___lambda23__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	guint _tmp1_ = 0U;
	FolksPersonaStore* _tmp2_;
	guint _tmp3_ = 0U;
	GQuark _tmp4_ = 0U;
	FolksPersonaStore* _tmp5_;
	guint _tmp6_ = 0U;
	GQuark _tmp7_ = 0U;
	FolksPersonaStore* _tmp8_;
	guint _tmp9_ = 0U;
	GQuark _tmp10_ = 0U;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp16_;
	FolksPersonaStore* _tmp18_;
	FolksPersonaStore* _tmp19_;
	GeeHashMap* _tmp20_;
	FolksPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	FolksPersonaStore* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	_tmp2_ = store;
	g_signal_parse_name ("notify::is-quiescent", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self);
	_tmp5_ = store;
	g_signal_parse_name ("notify::trust-level", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) __folks_individual_aggregator_trust_level_changed_cb_g_object_notify, self);
	_tmp8_ = store;
	g_signal_parse_name ("notify::is-writeable", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) __folks_individual_aggregator_is_writeable_changed_cb_g_object_notify, self);
	_tmp12_ = self->priv->_is_quiescent;
	if (_tmp12_ == FALSE) {
		FolksPersonaStore* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = store;
		_tmp14_ = folks_persona_store_get_is_quiescent (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ == FALSE;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = _tmp11_;
	if (_tmp16_) {
		guint _tmp17_;
		_tmp17_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp17_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
	_tmp18_ = self->priv->_writeable_store;
	_tmp19_ = store;
	if (_tmp18_ == _tmp19_) {
		self->priv->_writeable_store = NULL;
		g_object_notify ((GObject*) self, "primary-store");
	}
	_tmp20_ = self->priv->_stores;
	_tmp21_ = store;
	_tmp22_ = folks_persona_store_get_type_id (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = store;
	_tmp25_ = folks_persona_store_get_id (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _folks_individual_aggregator_get_store_full_id (self, _tmp23_, _tmp26_);
	_tmp28_ = _tmp27_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp20_, _tmp28_, NULL);
	_g_free0 (_tmp28_);
}


static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = type_id;
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = id;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, GeeMultiMap* changes, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _added;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _removed;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _changes;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeSet* _tmp9_;
	gboolean _tmp13_;
	gboolean _tmp20_;
	gboolean _tmp27_;
	GeeSet* _tmp34_;
	GeeSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeSet* _tmp37_;
	GeeSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeSet* _tmp40_;
	GeeSet* _tmp41_;
	const gchar* _tmp42_;
	FolksPersona* _tmp43_;
	FolksGroupDetailsChangeReason _tmp44_;
	GeeMultiMap* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_added = _tmp1_;
	_tmp2_ = removed;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_removed = _tmp3_;
	_tmp4_ = changes;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_changes = _tmp5_;
	_tmp9_ = added;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		GeeSet* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = added;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == 0;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		GeeSet* _tmp15_;
		gboolean _tmp19_;
		_tmp15_ = removed;
		if (_tmp15_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			GeeSet* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = removed;
			_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == 0;
		}
		_tmp19_ = _tmp14_;
		_tmp7_ = _tmp19_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp20_ = _tmp7_;
	if (_tmp20_) {
		gboolean _tmp21_ = FALSE;
		GeeMultiMap* _tmp22_;
		gboolean _tmp26_;
		_tmp22_ = changes;
		if (_tmp22_ == NULL) {
			_tmp21_ = TRUE;
		} else {
			GeeMultiMap* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp23_ = changes;
			_tmp24_ = gee_multi_map_get_size (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp21_ = _tmp25_ == 0;
		}
		_tmp26_ = _tmp21_;
		_tmp6_ = _tmp26_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp27_ = _tmp6_;
	if (_tmp27_) {
		_g_object_unref0 (_changes);
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	} else {
		GeeSet* _tmp28_;
		_tmp28_ = added;
		if (_tmp28_ == NULL) {
			GeeHashSet* _tmp29_;
			_tmp29_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_g_object_unref0 (_added);
			_added = (GeeSet*) _tmp29_;
		} else {
			GeeSet* _tmp30_;
			_tmp30_ = removed;
			if (_tmp30_ == NULL) {
				GeeHashSet* _tmp31_;
				_tmp31_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_g_object_unref0 (_removed);
				_removed = (GeeSet*) _tmp31_;
			} else {
				GeeMultiMap* _tmp32_;
				_tmp32_ = changes;
				if (_tmp32_ == NULL) {
					GeeHashMultiMap* _tmp33_;
					_tmp33_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL);
					_g_object_unref0 (_changes);
					_changes = (GeeMultiMap*) _tmp33_;
				}
			}
		}
	}
	_tmp34_ = _added;
	_tmp35_ = gee_set_get_read_only_view (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp38_ = _removed;
	_tmp39_ = gee_set_get_read_only_view (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp42_ = message;
	_tmp43_ = actor;
	_tmp44_ = reason;
	g_signal_emit_by_name (self, "individuals-changed", _tmp37_, _tmp41_, _tmp42_, _tmp43_, _tmp44_);
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (_tmp37_);
	_tmp45_ = _changes;
	g_signal_emit_by_name (self, "individuals-changed-detailed", _tmp45_);
	_g_object_unref0 (_changes);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}


static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	_folks_individual_aggregator_individual_removed_cb (self, _sender, replacement_individual);
}


static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	FolksIndividual* _tmp0_;
	GeeMap* _tmp1_;
	FolksIndividual* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksIndividual* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	g_signal_connect_object (_tmp0_, "removed", (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = individual;
	_tmp3_ = folks_individual_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = individual;
	gee_map_set (_tmp1_, _tmp4_, _tmp5_);
}


static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	GeeMap* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp4_;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = self->priv->_individuals;
	_tmp1_ = individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	gee_map_unset (_tmp0_, _tmp3_, NULL);
	_tmp4_ = individual;
	g_signal_parse_name ("removed", FOLKS_TYPE_INDIVIDUAL, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->candidate_inds);
		g_slice_free (Block3Data, _data3_);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static void _______lambda21_ (Block4Data* _data4_, const gchar* l) {
	Block3Data* _data3_;
	FolksIndividualAggregator * self;
	const gchar* _tmp0_;
	const gchar* prop_linking_value;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	FolksIndividual* _tmp4_;
	FolksIndividual* candidate_ind;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	FolksIndividual* _tmp7_;
	gboolean _tmp11_;
	gboolean _tmp15_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	prop_linking_value = _tmp0_;
	_tmp1_ = self->priv->_link_map;
	_tmp2_ = prop_linking_value;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((FolksIndividual*) _tmp3_);
	candidate_ind = _tmp4_;
	_tmp7_ = candidate_ind;
	if (_tmp7_ != NULL) {
		FolksIndividual* _tmp8_;
		FolksTrustLevel _tmp9_;
		FolksTrustLevel _tmp10_;
		_tmp8_ = candidate_ind;
		_tmp9_ = folks_individual_get_trust_level (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != FOLKS_TRUST_LEVEL_NONE;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		GeeHashSet* _tmp12_;
		FolksIndividual* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = _data3_->candidate_inds;
		_tmp13_ = candidate_ind;
		_tmp14_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		_tmp5_ = !_tmp14_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp15_ = _tmp5_;
	if (_tmp15_) {
		FolksIndividual* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GeeHashSet* _tmp21_;
		FolksIndividual* _tmp22_;
		_tmp16_ = candidate_ind;
		_tmp17_ = folks_individual_get_id (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _data4_->prop_name;
		_tmp20_ = prop_linking_value;
		g_debug ("    Found candidate individual '%s' by " "linkable property '%s' = '%s'.", _tmp18_, _tmp19_, _tmp20_);
		_tmp21_ = _data3_->candidate_inds;
		_tmp22_ = candidate_ind;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
	}
	_g_object_unref0 (candidate_ind);
}


static void ________lambda21__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_______lambda21_ (self, link);
}


static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, FolksIndividual** user, GeeHashMultiMap** individuals_changes) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (user != NULL);
	g_return_if_fail (individuals_changes != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _persona_it;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_persona_it = _tmp1_;
		while (TRUE) {
			Block3Data* _data3_;
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPersona* persona;
			FolksPersona* _tmp6_;
			FolksPersonaStore* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStoreTrust _tmp9_;
			FolksPersonaStoreTrust _tmp10_;
			FolksPersonaStoreTrust trust_level;
			GeeHashSet* _tmp11_;
			GeeHashSet* _tmp12_;
			GeeHashSet* final_personas;
			FolksIndividual* final_individual;
			FolksPersona* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			FolksPersona* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			FolksPersona* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp24_;
			FolksPersonaStoreTrust _tmp30_;
			FolksPersona* _tmp56_;
			FolksPersonaStore* _tmp57_;
			FolksPersonaStore* _tmp58_;
			FolksPersonaStoreTrust _tmp59_;
			FolksPersonaStoreTrust _tmp60_;
			GeeHashSet* _tmp74_;
			FolksPersona* _tmp75_;
			gboolean _tmp76_ = FALSE;
			GeeHashSet* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gboolean _tmp81_;
			GeeHashSet* _tmp95_;
			FolksIndividual* _tmp96_;
			FolksIndividual* _tmp97_;
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			FolksIndividual* _tmp100_;
			guint num_mappings_added;
			guint _tmp160_;
			FolksIndividual* _tmp163_;
			gboolean _tmp164_;
			gboolean _tmp165_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->self = g_object_ref (self);
			_tmp2_ = _persona_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				block3_data_unref (_data3_);
				_data3_ = NULL;
				break;
			}
			_tmp4_ = _persona_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			persona = (FolksPersona*) _tmp5_;
			_tmp6_ = persona;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_trust_level (_tmp8_);
			_tmp10_ = _tmp9_;
			trust_level = _tmp10_;
			_tmp11_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			_data3_->candidate_inds = _tmp11_;
			_tmp12_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
			final_personas = _tmp12_;
			final_individual = NULL;
			_tmp13_ = persona;
			_tmp14_ = folks_persona_get_uid (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = persona;
			_tmp17_ = folks_persona_get_iid (_tmp16_);
			_tmp18_ = _tmp17_;
			g_debug ("individual-aggregator.vala:738: Aggregating persona '%s' on '%s'.", _tmp15_, _tmp18_);
			_tmp20_ = persona;
			_tmp21_ = folks_persona_get_is_user (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ == TRUE) {
				FolksIndividual* _tmp23_;
				_tmp23_ = *user;
				_tmp19_ = _tmp23_ != NULL;
			} else {
				_tmp19_ = FALSE;
			}
			_tmp24_ = _tmp19_;
			if (_tmp24_) {
				FolksIndividual* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				GeeHashSet* _tmp28_;
				FolksIndividual* _tmp29_;
				_tmp25_ = *user;
				_tmp26_ = folks_individual_get_id (_tmp25_);
				_tmp27_ = _tmp26_;
				g_debug ("individual-aggregator.vala:744:     Found candidate individual '%s' as" \
" user.", _tmp27_);
				_tmp28_ = _data3_->candidate_inds;
				_tmp29_ = *user;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
			}
			_tmp30_ = trust_level;
			if (_tmp30_ != FOLKS_PERSONA_STORE_TRUST_NONE) {
				GHashTable* _tmp31_;
				FolksPersona* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gconstpointer _tmp35_ = NULL;
				FolksIndividual* _tmp36_;
				FolksIndividual* candidate_ind;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				FolksIndividual* _tmp39_;
				gboolean _tmp43_;
				gboolean _tmp47_;
				_tmp31_ = self->priv->_link_map;
				_tmp32_ = persona;
				_tmp33_ = folks_persona_get_iid (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_hash_table_lookup (_tmp31_, _tmp34_);
				_tmp36_ = _g_object_ref0 ((FolksIndividual*) _tmp35_);
				candidate_ind = _tmp36_;
				_tmp39_ = candidate_ind;
				if (_tmp39_ != NULL) {
					FolksIndividual* _tmp40_;
					FolksTrustLevel _tmp41_;
					FolksTrustLevel _tmp42_;
					_tmp40_ = candidate_ind;
					_tmp41_ = folks_individual_get_trust_level (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp38_ = _tmp42_ != FOLKS_TRUST_LEVEL_NONE;
				} else {
					_tmp38_ = FALSE;
				}
				_tmp43_ = _tmp38_;
				if (_tmp43_) {
					GeeHashSet* _tmp44_;
					FolksIndividual* _tmp45_;
					gboolean _tmp46_ = FALSE;
					_tmp44_ = _data3_->candidate_inds;
					_tmp45_ = candidate_ind;
					_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
					_tmp37_ = !_tmp46_;
				} else {
					_tmp37_ = FALSE;
				}
				_tmp47_ = _tmp37_;
				if (_tmp47_) {
					FolksIndividual* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					FolksPersona* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					GeeHashSet* _tmp54_;
					FolksIndividual* _tmp55_;
					_tmp48_ = candidate_ind;
					_tmp49_ = folks_individual_get_id (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = persona;
					_tmp52_ = folks_persona_get_iid (_tmp51_);
					_tmp53_ = _tmp52_;
					g_debug ("individual-aggregator.vala:757:     Found candidate individual '%s' by" \
" IID '%s'.", _tmp50_, _tmp53_);
					_tmp54_ = _data3_->candidate_inds;
					_tmp55_ = candidate_ind;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp55_);
				}
				_g_object_unref0 (candidate_ind);
			}
			_tmp56_ = persona;
			_tmp57_ = folks_persona_get_store (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = folks_persona_store_get_trust_level (_tmp58_);
			_tmp60_ = _tmp59_;
			if (_tmp60_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
				FolksPersona* _tmp61_;
				gchar** _tmp62_;
				gint _tmp62__length1;
				gchar** _tmp63_;
				gint _tmp63__length1;
				_tmp61_ = persona;
				_tmp62_ = folks_persona_get_linkable_properties (_tmp61_, &_tmp62__length1);
				_tmp63_ = _tmp62_;
				_tmp63__length1 = _tmp62__length1;
				{
					gchar** foo_collection = NULL;
					gint foo_collection_length1 = 0;
					gint _foo_collection_size_ = 0;
					gint foo_it = 0;
					foo_collection = _tmp63_;
					foo_collection_length1 = _tmp63__length1;
					for (foo_it = 0; foo_it < _tmp63__length1; foo_it = foo_it + 1) {
						const gchar* foo = NULL;
						foo = foo_collection[foo_it];
						{
							Block4Data* _data4_;
							const gchar* _tmp64_;
							FolksPersona* _tmp65_;
							GObjectClass* _tmp66_ = NULL;
							GObjectClass* pclass;
							GObjectClass* _tmp67_;
							const gchar* _tmp68_;
							GParamSpec* _tmp69_ = NULL;
							FolksPersona* _tmp72_;
							const gchar* _tmp73_;
							_data4_ = g_slice_new0 (Block4Data);
							_data4_->_ref_count_ = 1;
							_data4_->_data3_ = block3_data_ref (_data3_);
							_tmp64_ = foo;
							_data4_->prop_name = _tmp64_;
							_tmp65_ = persona;
							_tmp66_ = G_OBJECT_GET_CLASS ((GObject*) _tmp65_);
							pclass = _tmp66_;
							_tmp67_ = pclass;
							_tmp68_ = _data4_->prop_name;
							_tmp69_ = g_object_class_find_property (_tmp67_, _tmp68_);
							if (_tmp69_ == NULL) {
								const gchar* _tmp70_ = NULL;
								const gchar* _tmp71_;
								_tmp70_ = _ ("Unknown property '%s' in linkable property list.");
								_tmp71_ = _data4_->prop_name;
								g_warning (_tmp70_, _tmp71_);
								block4_data_unref (_data4_);
								_data4_ = NULL;
								continue;
							}
							_tmp72_ = persona;
							_tmp73_ = _data4_->prop_name;
							folks_persona_linkable_property_to_links (_tmp72_, _tmp73_, ________lambda21__folks_persona_linkable_property_callback, _data4_);
							block4_data_unref (_data4_);
							_data4_ = NULL;
						}
					}
				}
			}
			_tmp74_ = final_personas;
			_tmp75_ = persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, _tmp75_);
			_tmp77_ = _data3_->candidate_inds;
			_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_ > 0) {
				gboolean _tmp80_;
				_tmp80_ = self->priv->_linking_enabled;
				_tmp76_ = _tmp80_ == TRUE;
			} else {
				_tmp76_ = FALSE;
			}
			_tmp81_ = _tmp76_;
			if (_tmp81_) {
				{
					GeeHashSet* _tmp82_;
					GeeIterator* _tmp83_ = NULL;
					GeeIterator* _individual_it;
					_tmp82_ = _data3_->candidate_inds;
					_tmp83_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp82_);
					_individual_it = _tmp83_;
					while (TRUE) {
						GeeIterator* _tmp84_;
						gboolean _tmp85_ = FALSE;
						GeeIterator* _tmp86_;
						gpointer _tmp87_ = NULL;
						FolksIndividual* individual;
						GeeHashSet* _tmp88_;
						FolksIndividual* _tmp89_;
						GeeSet* _tmp90_;
						GeeSet* _tmp91_;
						_tmp84_ = _individual_it;
						_tmp85_ = gee_iterator_next (_tmp84_);
						if (!_tmp85_) {
							break;
						}
						_tmp86_ = _individual_it;
						_tmp87_ = gee_iterator_get (_tmp86_);
						individual = (FolksIndividual*) _tmp87_;
						_tmp88_ = final_personas;
						_tmp89_ = individual;
						_tmp90_ = folks_individual_get_personas (_tmp89_);
						_tmp91_ = _tmp90_;
						gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp88_, (GeeCollection*) _tmp91_);
						_g_object_unref0 (individual);
					}
					_g_object_unref0 (_individual_it);
				}
			} else {
				GeeHashSet* _tmp92_;
				gint _tmp93_;
				gint _tmp94_;
				_tmp92_ = _data3_->candidate_inds;
				_tmp93_ = gee_collection_get_size ((GeeCollection*) _tmp92_);
				_tmp94_ = _tmp93_;
				if (_tmp94_ > 0) {
					g_debug ("individual-aggregator.vala:821:     Linking disabled.");
				} else {
					g_debug ("individual-aggregator.vala:825:     Did not find any candidate individ" \
"uals.");
				}
			}
			_tmp95_ = final_personas;
			_tmp96_ = folks_individual_new ((GeeSet*) _tmp95_);
			_g_object_unref0 (final_individual);
			final_individual = _tmp96_;
			_tmp97_ = final_individual;
			_tmp98_ = folks_individual_get_id (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = final_individual;
			g_debug ("individual-aggregator.vala:830:     Created new individual '%s' (%p) w" \
"ith personas:", _tmp99_, _tmp100_);
			{
				GeeHashSet* _tmp101_;
				GeeIterator* _tmp102_ = NULL;
				GeeIterator* _p_it;
				_tmp101_ = final_personas;
				_tmp102_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp101_);
				_p_it = _tmp102_;
				while (TRUE) {
					GeeIterator* _tmp103_;
					gboolean _tmp104_ = FALSE;
					GeeIterator* _tmp105_;
					gpointer _tmp106_ = NULL;
					FolksPersona* p;
					FolksPersona* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					FolksPersona* _tmp110_;
					FolksPersona* _tmp111_;
					FolksIndividual* _tmp112_;
					_tmp103_ = _p_it;
					_tmp104_ = gee_iterator_next (_tmp103_);
					if (!_tmp104_) {
						break;
					}
					_tmp105_ = _p_it;
					_tmp106_ = gee_iterator_get (_tmp105_);
					p = (FolksPersona*) _tmp106_;
					_tmp107_ = p;
					_tmp108_ = folks_persona_get_uid (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = p;
					g_debug ("individual-aggregator.vala:834:         %s (%p)", _tmp109_, _tmp110_);
					_tmp111_ = p;
					_tmp112_ = final_individual;
					_folks_individual_aggregator_add_persona_to_link_map (self, _tmp111_, _tmp112_);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			num_mappings_added = (guint) 0;
			{
				GeeHashSet* _tmp113_;
				GeeIterator* _tmp114_ = NULL;
				GeeIterator* _i_it;
				_tmp113_ = _data3_->candidate_inds;
				_tmp114_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp113_);
				_i_it = _tmp114_;
				while (TRUE) {
					GeeIterator* _tmp115_;
					gboolean _tmp116_ = FALSE;
					GeeIterator* _tmp117_;
					gpointer _tmp118_ = NULL;
					FolksIndividual* i;
					GeeHashSet* _tmp119_;
					GeeHashSet* transitive_updates;
					GeeHashSet* _tmp153_;
					gint _tmp154_;
					gint _tmp155_;
					_tmp115_ = _i_it;
					_tmp116_ = gee_iterator_next (_tmp115_);
					if (!_tmp116_) {
						break;
					}
					_tmp117_ = _i_it;
					_tmp118_ = gee_iterator_get (_tmp117_);
					i = (FolksIndividual*) _tmp118_;
					_tmp119_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
					transitive_updates = _tmp119_;
					{
						GeeHashMultiMap* _tmp120_;
						GeeSet* _tmp121_ = NULL;
						GeeSet* _tmp122_;
						GeeIterator* _tmp123_ = NULL;
						GeeIterator* _tmp124_;
						GeeIterator* _k_it;
						_tmp120_ = *individuals_changes;
						_tmp121_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = gee_iterable_iterator ((GeeIterable*) _tmp122_);
						_tmp124_ = _tmp123_;
						_g_object_unref0 (_tmp122_);
						_k_it = _tmp124_;
						while (TRUE) {
							GeeIterator* _tmp125_;
							gboolean _tmp126_ = FALSE;
							GeeIterator* _tmp127_;
							gpointer _tmp128_ = NULL;
							FolksIndividual* k;
							GeeHashMultiMap* _tmp129_;
							FolksIndividual* _tmp130_;
							GeeCollection* _tmp131_ = NULL;
							GeeCollection* _tmp132_;
							FolksIndividual* _tmp133_;
							gboolean _tmp134_ = FALSE;
							gboolean _tmp135_;
							_tmp125_ = _k_it;
							_tmp126_ = gee_iterator_next (_tmp125_);
							if (!_tmp126_) {
								break;
							}
							_tmp127_ = _k_it;
							_tmp128_ = gee_iterator_get (_tmp127_);
							k = (FolksIndividual*) _tmp128_;
							_tmp129_ = *individuals_changes;
							_tmp130_ = k;
							_tmp131_ = gee_multi_map_get ((GeeMultiMap*) _tmp129_, _tmp130_);
							_tmp132_ = _tmp131_;
							_tmp133_ = i;
							_tmp134_ = gee_collection_contains (_tmp132_, _tmp133_);
							_tmp135_ = _tmp134_;
							_g_object_unref0 (_tmp132_);
							if (_tmp135_) {
								GeeHashSet* _tmp136_;
								FolksIndividual* _tmp137_;
								_tmp136_ = transitive_updates;
								_tmp137_ = k;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp136_, _tmp137_);
							}
							_g_object_unref0 (k);
						}
						_g_object_unref0 (_k_it);
					}
					{
						GeeHashSet* _tmp138_;
						GeeIterator* _tmp139_ = NULL;
						GeeIterator* _k_it;
						_tmp138_ = transitive_updates;
						_tmp139_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp138_);
						_k_it = _tmp139_;
						while (TRUE) {
							GeeIterator* _tmp140_;
							gboolean _tmp141_ = FALSE;
							GeeIterator* _tmp142_;
							gpointer _tmp143_ = NULL;
							FolksIndividual* k;
							GeeHashMultiMap* _tmp144_;
							FolksIndividual* _tmp145_;
							FolksIndividual* _tmp146_;
							gboolean _tmp147_ = FALSE;
							FolksIndividual* _tmp148_;
							_tmp140_ = _k_it;
							_tmp141_ = gee_iterator_next (_tmp140_);
							if (!_tmp141_) {
								break;
							}
							_tmp142_ = _k_it;
							_tmp143_ = gee_iterator_get (_tmp142_);
							k = (FolksIndividual*) _tmp143_;
							_tmp144_ = *individuals_changes;
							_tmp145_ = k;
							_tmp146_ = i;
							_tmp147_ = gee_multi_map_remove ((GeeMultiMap*) _tmp144_, _tmp145_, _tmp146_);
							g_assert (_tmp147_ == TRUE);
							_tmp148_ = k;
							if (_tmp148_ != NULL) {
								GeeHashMultiMap* _tmp149_;
								FolksIndividual* _tmp150_;
								FolksIndividual* _tmp151_;
								guint _tmp152_;
								_tmp149_ = *individuals_changes;
								_tmp150_ = k;
								_tmp151_ = final_individual;
								gee_multi_map_set ((GeeMultiMap*) _tmp149_, _tmp150_, _tmp151_);
								_tmp152_ = num_mappings_added;
								num_mappings_added = _tmp152_ + 1;
							}
							_g_object_unref0 (k);
						}
						_g_object_unref0 (_k_it);
					}
					_tmp153_ = transitive_updates;
					_tmp154_ = gee_collection_get_size ((GeeCollection*) _tmp153_);
					_tmp155_ = _tmp154_;
					if (_tmp155_ == 0) {
						GeeHashMultiMap* _tmp156_;
						FolksIndividual* _tmp157_;
						FolksIndividual* _tmp158_;
						guint _tmp159_;
						_tmp156_ = *individuals_changes;
						_tmp157_ = i;
						_tmp158_ = final_individual;
						gee_multi_map_set ((GeeMultiMap*) _tmp156_, _tmp157_, _tmp158_);
						_tmp159_ = num_mappings_added;
						num_mappings_added = _tmp159_ + 1;
					}
					_g_object_unref0 (transitive_updates);
					_g_object_unref0 (i);
				}
				_g_object_unref0 (_i_it);
			}
			_tmp160_ = num_mappings_added;
			if (_tmp160_ == ((guint) 0)) {
				GeeHashMultiMap* _tmp161_;
				FolksIndividual* _tmp162_;
				_tmp161_ = *individuals_changes;
				_tmp162_ = final_individual;
				gee_multi_map_set ((GeeMultiMap*) _tmp161_, NULL, _tmp162_);
			}
			_tmp163_ = final_individual;
			_tmp164_ = folks_individual_get_is_user (_tmp163_);
			_tmp165_ = _tmp164_;
			if (_tmp165_ == TRUE) {
				FolksIndividual* _tmp166_;
				FolksIndividual* _tmp167_;
				_tmp166_ = final_individual;
				_tmp167_ = _g_object_ref0 (_tmp166_);
				_g_object_unref0 (*user);
				*user = _tmp167_;
			}
			_g_object_unref0 (final_individual);
			_g_object_unref0 (final_personas);
			_g_object_unref0 (persona);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_g_object_unref0 (_persona_it);
	}
}


static void _folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* persona;
	const gchar* _tmp2_ = NULL;
	FolksPersona* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GParamSpec* _tmp6_;
	const gchar* _tmp7_;
	FolksPersona* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	FolksPersona* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GeeHashSet* _tmp15_;
	GeeHashSet* persona_set;
	FolksPersona* _tmp16_;
	FolksPersona* _tmp17_;
	FolksPersonaStore* _tmp18_;
	FolksPersonaStore* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (FOLKS_IS_PERSONA (_tmp0_) ? ((FolksPersona*) _tmp0_) : NULL);
	persona = _tmp1_;
	_tmp3_ = persona;
	_tmp4_ = folks_persona_get_is_user (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "yes";
	} else {
		_tmp2_ = "no";
	}
	_tmp6_ = pspec;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = persona;
	_tmp9_ = folks_persona_get_uid (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp2_;
	_tmp12_ = persona;
	_tmp13_ = folks_persona_get_iid (_tmp12_);
	_tmp14_ = _tmp13_;
	g_debug ("Linkable property '%s' changed for persona '%s' " "(is user: %s, IID: %s).", _tmp7_, _tmp10_, _tmp11_, _tmp14_);
	_tmp15_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	persona_set = _tmp15_;
	_tmp16_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, _tmp16_);
	_tmp17_ = persona;
	_tmp18_ = folks_persona_get_store (_tmp17_);
	_tmp19_ = _tmp18_;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp19_, (GeeSet*) persona_set, (GeeSet*) persona_set, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (persona_set);
	_g_object_unref0 (persona);
}


static void __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_linkable_property_changed_cb (self, _sender, pspec);
}


static void _folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self, FolksPersona* persona) {
	FolksPersona* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_linkable_properties (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp2_;
		prop_name_collection_length1 = _tmp2__length1;
		for (prop_name_it = 0; prop_name_it < _tmp2__length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp3_;
			gchar* prop_name = NULL;
			_tmp3_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp3_;
			{
				FolksPersona* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = persona;
				_tmp5_ = prop_name;
				_tmp6_ = g_strconcat ("notify::", _tmp5_, NULL);
				g_signal_connect_object ((GObject*) _tmp4_, _tmp6_, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self, 0);
				_g_free0 (_tmp6_);
				_g_free0 (prop_name);
			}
		}
	}
}


static void _folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self, FolksPersona* persona) {
	FolksPersona* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_linkable_properties (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp2_;
		prop_name_collection_length1 = _tmp2__length1;
		for (prop_name_it = 0; prop_name_it < _tmp2__length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp3_;
			gchar* prop_name = NULL;
			_tmp3_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp3_;
			{
				FolksPersona* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				guint _tmp7_ = 0U;
				GQuark _tmp8_ = 0U;
				_tmp4_ = persona;
				_tmp5_ = prop_name;
				_tmp6_ = g_strconcat ("notify::", _tmp5_, NULL);
				g_signal_parse_name (_tmp6_, G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
				g_signal_handlers_disconnect_matched ((GObject*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self);
				_g_free0 (_tmp6_);
				_g_free0 (prop_name);
			}
		}
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->individual);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _____lambda22_ (Block5Data* _data5_, const gchar* l) {
	FolksIndividualAggregator * self;
	const gchar* _tmp0_;
	const gchar* prop_linking_value;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	self = _data5_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	prop_linking_value = _tmp0_;
	g_debug ("individual-aggregator.vala:971:             %s", prop_linking_value);
	_tmp1_ = self->priv->_link_map;
	_tmp2_ = g_strdup (prop_linking_value);
	_tmp3_ = _data5_->individual;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	g_hash_table_replace (_tmp1_, _tmp2_, _tmp4_);
}


static void ______lambda22__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_____lambda22_ (self, link);
}


static void _folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self, FolksPersona* persona, FolksIndividual* individual) {
	Block5Data* _data5_;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_ = NULL;
	FolksPersona* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	FolksPersona* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksPersona* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FolksIndividual* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GHashTable* _tmp16_;
	FolksPersona* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	FolksIndividual* _tmp21_;
	FolksIndividual* _tmp22_;
	FolksPersona* _tmp23_;
	FolksPersonaStore* _tmp24_;
	FolksPersonaStore* _tmp25_;
	FolksPersonaStoreTrust _tmp26_;
	FolksPersonaStoreTrust _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (individual != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = individual;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data5_->individual = _tmp1_;
	_tmp3_ = persona;
	_tmp4_ = folks_persona_get_is_user (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "yes";
	} else {
		_tmp2_ = "no";
	}
	_tmp6_ = persona;
	_tmp7_ = folks_persona_get_uid (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp2_;
	_tmp10_ = persona;
	_tmp11_ = folks_persona_get_iid (_tmp10_);
	_tmp12_ = _tmp11_;
	g_debug ("individual-aggregator.vala:935: Connecting to Persona: %s (is user: %s" \
", IID: %s)", _tmp8_, _tmp9_, _tmp12_);
	_tmp13_ = _data5_->individual;
	_tmp14_ = folks_individual_get_id (_tmp13_);
	_tmp15_ = _tmp14_;
	g_debug ("individual-aggregator.vala:937:     Mapping to Individual: %s", _tmp15_);
	_tmp16_ = self->priv->_link_map;
	_tmp17_ = persona;
	_tmp18_ = folks_persona_get_iid (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = _data5_->individual;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	g_hash_table_replace (_tmp16_, _tmp20_, _tmp22_);
	_tmp23_ = persona;
	_tmp24_ = folks_persona_get_store (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = folks_persona_store_get_trust_level (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		FolksPersona* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar** _tmp30_;
		gint _tmp30__length1;
		g_debug ("individual-aggregator.vala:948:     Inserting links:");
		_tmp28_ = persona;
		_tmp29_ = folks_persona_get_linkable_properties (_tmp28_, &_tmp29__length1);
		_tmp30_ = _tmp29_;
		_tmp30__length1 = _tmp29__length1;
		{
			gchar** prop_name_collection = NULL;
			gint prop_name_collection_length1 = 0;
			gint _prop_name_collection_size_ = 0;
			gint prop_name_it = 0;
			prop_name_collection = _tmp30_;
			prop_name_collection_length1 = _tmp30__length1;
			for (prop_name_it = 0; prop_name_it < _tmp30__length1; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name = NULL;
				prop_name = prop_name_collection[prop_name_it];
				{
					const gchar* _tmp31_;
					FolksPersona* _tmp32_;
					GObjectClass* _tmp33_ = NULL;
					GObjectClass* pclass;
					GObjectClass* _tmp34_;
					const gchar* _tmp35_;
					GParamSpec* _tmp36_ = NULL;
					FolksPersona* _tmp39_;
					const gchar* _tmp40_;
					_tmp31_ = prop_name;
					g_debug ("individual-aggregator.vala:954:         %s", _tmp31_);
					_tmp32_ = persona;
					_tmp33_ = G_OBJECT_GET_CLASS ((GObject*) _tmp32_);
					pclass = _tmp33_;
					_tmp34_ = pclass;
					_tmp35_ = prop_name;
					_tmp36_ = g_object_class_find_property (_tmp34_, _tmp35_);
					if (_tmp36_ == NULL) {
						const gchar* _tmp37_ = NULL;
						const gchar* _tmp38_;
						_tmp37_ = _ ("Unknown property '%s' in linkable property list.");
						_tmp38_ = prop_name;
						g_warning (_tmp37_, _tmp38_);
						continue;
					}
					_tmp39_ = persona;
					_tmp40_ = prop_name;
					folks_persona_linkable_property_to_links (_tmp39_, _tmp40_, ______lambda22__folks_persona_linkable_property_callback, _data5_);
				}
			}
		}
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void _folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self, FolksIndividual* individual) {
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTableIter iter = {0};
	gchar* link_key = NULL;
	FolksIndividual* link_individual = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	_tmp1_ = folks_individual_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("individual-aggregator.vala:986: Removing Individual '%s' from the link" \
" map.", _tmp2_);
	_tmp3_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp3_);
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_;
		FolksIndividual* _tmp8_;
		FolksIndividual* _tmp9_;
		FolksIndividual* _tmp10_;
		_tmp6_ = g_hash_table_iter_next (&iter, &_tmp4_, &_tmp5_);
		_g_free0 (link_key);
		_tmp7_ = g_strdup (_tmp4_);
		link_key = _tmp7_;
		_g_object_unref0 (link_individual);
		_tmp8_ = _g_object_ref0 (_tmp5_);
		link_individual = _tmp8_;
		if (!(_tmp6_ == TRUE)) {
			break;
		}
		_tmp9_ = link_individual;
		_tmp10_ = individual;
		if (_tmp9_ == _tmp10_) {
			const gchar* _tmp11_;
			FolksIndividual* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			FolksIndividual* _tmp15_;
			_tmp11_ = link_key;
			_tmp12_ = link_individual;
			_tmp13_ = folks_individual_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = link_individual;
			g_debug ("individual-aggregator.vala:996:     %s → %s (%p)", _tmp11_, _tmp14_, _tmp15_);
			g_hash_table_iter_remove (&iter);
		}
	}
	_g_object_unref0 (link_individual);
	_g_free0 (link_key);
}


static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_individuals;
	GeeHashMultiMap* _tmp1_;
	GeeHashMultiMap* individuals_changes;
	GeeHashSet* _tmp2_;
	GeeHashSet* relinked_personas;
	GeeHashMap* _tmp3_;
	GeeHashMap* replaced_individuals;
	FolksIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	FolksIndividual* user;
	GeeSet* _tmp87_;
	gint _tmp88_;
	gint _tmp89_;
	GeeHashSet* _tmp108_;
	FolksIndividual* _tmp144_;
	GeeHashMultiMap* _tmp145_;
	gint _tmp146_;
	gint _tmp147_;
	GeeHashMap* _tmp189_;
	GeeMapIterator* _tmp190_ = NULL;
	GeeMapIterator* iter;
	FolksDebug* _tmp199_;
	gboolean _tmp200_;
	gboolean _tmp201_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	removed_individuals = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL);
	individuals_changes = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	relinked_personas = _tmp2_;
	_tmp3_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	replaced_individuals = _tmp3_;
	_tmp4_ = self->priv->_user;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	user = _tmp5_;
	g_debug ("individual-aggregator.vala:1021: Removing Personas:");
	{
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _persona_it;
		_tmp6_ = removed;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_persona_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp12_ = NULL;
			FolksPersona* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			FolksPersona* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			FolksPersona* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			GHashTable* _tmp23_;
			FolksPersona* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gconstpointer _tmp27_ = NULL;
			FolksIndividual* _tmp28_;
			FolksIndividual* ind;
			FolksIndividual* _tmp29_;
			FolksPersona* _tmp32_;
			_tmp8_ = _persona_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _persona_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			persona = (FolksPersona*) _tmp11_;
			_tmp13_ = persona;
			_tmp14_ = folks_persona_get_is_user (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_) {
				_tmp12_ = "yes";
			} else {
				_tmp12_ = "no";
			}
			_tmp16_ = persona;
			_tmp17_ = folks_persona_get_uid (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp12_;
			_tmp20_ = persona;
			_tmp21_ = folks_persona_get_iid (_tmp20_);
			_tmp22_ = _tmp21_;
			g_debug ("individual-aggregator.vala:1025:     %s (is user: %s, IID: %s)", _tmp18_, _tmp19_, _tmp22_);
			_tmp23_ = self->priv->_link_map;
			_tmp24_ = persona;
			_tmp25_ = folks_persona_get_iid (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_hash_table_lookup (_tmp23_, _tmp26_);
			_tmp28_ = _g_object_ref0 ((FolksIndividual*) _tmp27_);
			ind = _tmp28_;
			_tmp29_ = ind;
			if (_tmp29_ != NULL) {
				GeeHashSet* _tmp30_;
				FolksIndividual* _tmp31_;
				_tmp30_ = removed_individuals;
				_tmp31_ = ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
			}
			_tmp32_ = persona;
			_folks_individual_aggregator_disconnect_from_persona (self, _tmp32_);
			_g_object_unref0 (ind);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	g_debug ("individual-aggregator.vala:1049: Removing Individuals due to removed l" \
"inks:");
	{
		GeeHashSet* _tmp33_;
		GeeIterator* _tmp34_ = NULL;
		GeeIterator* _individual_it;
		_tmp33_ = removed_individuals;
		_tmp34_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp33_);
		_individual_it = _tmp34_;
		while (TRUE) {
			GeeIterator* _tmp35_;
			gboolean _tmp36_ = FALSE;
			GeeIterator* _tmp37_;
			gpointer _tmp38_ = NULL;
			FolksIndividual* individual;
			GeeMap* _tmp39_;
			FolksIndividual* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gboolean _tmp43_ = FALSE;
			FolksIndividual* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			FolksIndividual* _tmp65_;
			FolksIndividual* _tmp66_;
			FolksIndividual* _tmp67_;
			FolksIndividual* _tmp68_;
			_tmp35_ = _individual_it;
			_tmp36_ = gee_iterator_next (_tmp35_);
			if (!_tmp36_) {
				break;
			}
			_tmp37_ = _individual_it;
			_tmp38_ = gee_iterator_get (_tmp37_);
			individual = (FolksIndividual*) _tmp38_;
			_tmp39_ = self->priv->_individuals;
			_tmp40_ = individual;
			_tmp41_ = folks_individual_get_id (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = gee_map_has_key (_tmp39_, _tmp42_);
			if (_tmp43_ == FALSE) {
				_g_object_unref0 (individual);
				continue;
			}
			_tmp44_ = individual;
			_tmp45_ = folks_individual_get_id (_tmp44_);
			_tmp46_ = _tmp45_;
			g_debug ("individual-aggregator.vala:1056:     %s", _tmp46_);
			{
				FolksIndividual* _tmp47_;
				GeeSet* _tmp48_;
				GeeSet* _tmp49_;
				GeeIterator* _tmp50_ = NULL;
				GeeIterator* _persona_it;
				_tmp47_ = individual;
				_tmp48_ = folks_individual_get_personas (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
				_persona_it = _tmp50_;
				while (TRUE) {
					GeeIterator* _tmp51_;
					gboolean _tmp52_ = FALSE;
					GeeIterator* _tmp53_;
					gpointer _tmp54_ = NULL;
					FolksPersona* persona;
					gboolean _tmp55_ = FALSE;
					GeeSet* _tmp56_;
					FolksPersona* _tmp57_;
					gboolean _tmp58_ = FALSE;
					gboolean _tmp62_;
					GeeHashSet* _tmp63_;
					FolksPersona* _tmp64_;
					_tmp51_ = _persona_it;
					_tmp52_ = gee_iterator_next (_tmp51_);
					if (!_tmp52_) {
						break;
					}
					_tmp53_ = _persona_it;
					_tmp54_ = gee_iterator_get (_tmp53_);
					persona = (FolksPersona*) _tmp54_;
					_tmp56_ = removed;
					_tmp57_ = persona;
					_tmp58_ = gee_collection_contains ((GeeCollection*) _tmp56_, _tmp57_);
					if (_tmp58_ == TRUE) {
						_tmp55_ = TRUE;
					} else {
						GeeHashSet* _tmp59_;
						FolksPersona* _tmp60_;
						gboolean _tmp61_ = FALSE;
						_tmp59_ = relinked_personas;
						_tmp60_ = persona;
						_tmp61_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp59_, _tmp60_);
						_tmp55_ = _tmp61_ == TRUE;
					}
					_tmp62_ = _tmp55_;
					if (_tmp62_) {
						_g_object_unref0 (persona);
						continue;
					}
					_tmp63_ = relinked_personas;
					_tmp64_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp63_, _tmp64_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp65_ = user;
			_tmp66_ = individual;
			if (_tmp65_ == _tmp66_) {
				_g_object_unref0 (user);
				user = NULL;
			}
			_tmp67_ = individual;
			_folks_individual_aggregator_disconnect_from_individual (self, _tmp67_);
			_tmp68_ = individual;
			_folks_individual_aggregator_remove_individual_from_link_map (self, _tmp68_);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	g_debug ("individual-aggregator.vala:1078: Adding Personas:");
	{
		GeeSet* _tmp69_;
		GeeIterator* _tmp70_ = NULL;
		GeeIterator* _persona_it;
		_tmp69_ = added;
		_tmp70_ = gee_iterable_iterator ((GeeIterable*) _tmp69_);
		_persona_it = _tmp70_;
		while (TRUE) {
			GeeIterator* _tmp71_;
			gboolean _tmp72_ = FALSE;
			GeeIterator* _tmp73_;
			gpointer _tmp74_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp75_ = NULL;
			FolksPersona* _tmp76_;
			gboolean _tmp77_;
			gboolean _tmp78_;
			FolksPersona* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			FolksPersona* _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_;
			FolksPersona* _tmp86_;
			_tmp71_ = _persona_it;
			_tmp72_ = gee_iterator_next (_tmp71_);
			if (!_tmp72_) {
				break;
			}
			_tmp73_ = _persona_it;
			_tmp74_ = gee_iterator_get (_tmp73_);
			persona = (FolksPersona*) _tmp74_;
			_tmp76_ = persona;
			_tmp77_ = folks_persona_get_is_user (_tmp76_);
			_tmp78_ = _tmp77_;
			if (_tmp78_) {
				_tmp75_ = "yes";
			} else {
				_tmp75_ = "no";
			}
			_tmp79_ = persona;
			_tmp80_ = folks_persona_get_uid (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = _tmp75_;
			_tmp83_ = persona;
			_tmp84_ = folks_persona_get_iid (_tmp83_);
			_tmp85_ = _tmp84_;
			g_debug ("individual-aggregator.vala:1081:     %s (is user: %s, IID: %s)", _tmp81_, _tmp82_, _tmp85_);
			_tmp86_ = persona;
			_folks_individual_aggregator_connect_to_persona (self, _tmp86_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp87_ = added;
	_tmp88_ = gee_collection_get_size ((GeeCollection*) _tmp87_);
	_tmp89_ = _tmp88_;
	if (_tmp89_ > 0) {
		GeeSet* _tmp90_;
		_tmp90_ = added;
		_folks_individual_aggregator_add_personas (self, _tmp90_, &user, &individuals_changes);
	}
	g_debug ("individual-aggregator.vala:1094: Relinking Personas:");
	{
		GeeHashSet* _tmp91_;
		GeeIterator* _tmp92_ = NULL;
		GeeIterator* _persona_it;
		_tmp91_ = relinked_personas;
		_tmp92_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp91_);
		_persona_it = _tmp92_;
		while (TRUE) {
			GeeIterator* _tmp93_;
			gboolean _tmp94_ = FALSE;
			GeeIterator* _tmp95_;
			gpointer _tmp96_ = NULL;
			FolksPersona* persona;
			const gchar* _tmp97_ = NULL;
			FolksPersona* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			FolksPersona* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			const gchar* _tmp104_;
			FolksPersona* _tmp105_;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
			_tmp93_ = _persona_it;
			_tmp94_ = gee_iterator_next (_tmp93_);
			if (!_tmp94_) {
				break;
			}
			_tmp95_ = _persona_it;
			_tmp96_ = gee_iterator_get (_tmp95_);
			persona = (FolksPersona*) _tmp96_;
			_tmp98_ = persona;
			_tmp99_ = folks_persona_get_is_user (_tmp98_);
			_tmp100_ = _tmp99_;
			if (_tmp100_) {
				_tmp97_ = "yes";
			} else {
				_tmp97_ = "no";
			}
			_tmp101_ = persona;
			_tmp102_ = folks_persona_get_uid (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = _tmp97_;
			_tmp105_ = persona;
			_tmp106_ = folks_persona_get_iid (_tmp105_);
			_tmp107_ = _tmp106_;
			g_debug ("individual-aggregator.vala:1097:     %s (is user: %s, IID: %s)", _tmp103_, _tmp104_, _tmp107_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp108_ = relinked_personas;
	_folks_individual_aggregator_add_personas (self, (GeeSet*) _tmp108_, &user, &individuals_changes);
	{
		GeeHashSet* _tmp109_;
		GeeIterator* _tmp110_ = NULL;
		GeeIterator* _individual_it;
		_tmp109_ = removed_individuals;
		_tmp110_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp109_);
		_individual_it = _tmp110_;
		while (TRUE) {
			GeeIterator* _tmp111_;
			gboolean _tmp112_ = FALSE;
			GeeIterator* _tmp113_;
			gpointer _tmp114_ = NULL;
			FolksIndividual* individual;
			gboolean added_mapping;
			gboolean _tmp140_;
			FolksIndividual* _tmp143_;
			_tmp111_ = _individual_it;
			_tmp112_ = gee_iterator_next (_tmp111_);
			if (!_tmp112_) {
				break;
			}
			_tmp113_ = _individual_it;
			_tmp114_ = gee_iterator_get (_tmp113_);
			individual = (FolksIndividual*) _tmp114_;
			added_mapping = FALSE;
			{
				FolksIndividual* _tmp115_;
				GeeSet* _tmp116_;
				GeeSet* _tmp117_;
				GeeIterator* _tmp118_ = NULL;
				GeeIterator* _persona_it;
				_tmp115_ = individual;
				_tmp116_ = folks_individual_get_personas (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = gee_iterable_iterator ((GeeIterable*) _tmp117_);
				_persona_it = _tmp118_;
				while (TRUE) {
					GeeIterator* _tmp119_;
					gboolean _tmp120_ = FALSE;
					GeeIterator* _tmp121_;
					gpointer _tmp122_ = NULL;
					FolksPersona* persona;
					gboolean _tmp123_ = FALSE;
					GeeSet* _tmp124_;
					FolksPersona* _tmp125_;
					gboolean _tmp126_ = FALSE;
					gboolean _tmp130_;
					_tmp119_ = _persona_it;
					_tmp120_ = gee_iterator_next (_tmp119_);
					if (!_tmp120_) {
						break;
					}
					_tmp121_ = _persona_it;
					_tmp122_ = gee_iterator_get (_tmp121_);
					persona = (FolksPersona*) _tmp122_;
					_tmp124_ = removed;
					_tmp125_ = persona;
					_tmp126_ = gee_collection_contains ((GeeCollection*) _tmp124_, _tmp125_);
					if (!_tmp126_) {
						_tmp123_ = TRUE;
					} else {
						GeeSet* _tmp127_;
						FolksPersona* _tmp128_;
						gboolean _tmp129_ = FALSE;
						_tmp127_ = added;
						_tmp128_ = persona;
						_tmp129_ = gee_collection_contains ((GeeCollection*) _tmp127_, _tmp128_);
						_tmp123_ = _tmp129_;
					}
					_tmp130_ = _tmp123_;
					if (_tmp130_) {
						GeeHashMultiMap* _tmp131_;
						FolksPersona* _tmp132_;
						FolksIndividual* _tmp133_;
						FolksIndividual* _tmp134_;
						GeeHashMultiMap* _tmp135_;
						FolksIndividual* _tmp136_;
						FolksPersona* _tmp137_;
						FolksIndividual* _tmp138_;
						FolksIndividual* _tmp139_;
						_tmp131_ = individuals_changes;
						_tmp132_ = persona;
						_tmp133_ = folks_persona_get_individual (_tmp132_);
						_tmp134_ = _tmp133_;
						gee_multi_map_remove ((GeeMultiMap*) _tmp131_, NULL, _tmp134_);
						_tmp135_ = individuals_changes;
						_tmp136_ = individual;
						_tmp137_ = persona;
						_tmp138_ = folks_persona_get_individual (_tmp137_);
						_tmp139_ = _tmp138_;
						gee_multi_map_set ((GeeMultiMap*) _tmp135_, _tmp136_, _tmp139_);
						added_mapping = TRUE;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp140_ = added_mapping;
			if (_tmp140_ == FALSE) {
				GeeHashMultiMap* _tmp141_;
				FolksIndividual* _tmp142_;
				_tmp141_ = individuals_changes;
				_tmp142_ = individual;
				gee_multi_map_set ((GeeMultiMap*) _tmp141_, _tmp142_, NULL);
			}
			_tmp143_ = individual;
			folks_individual_set_personas (_tmp143_, NULL);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp144_ = user;
	folks_individual_aggregator_set_user (self, _tmp144_);
	_tmp145_ = individuals_changes;
	_tmp146_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp145_);
	_tmp147_ = _tmp146_;
	if (_tmp147_ > 0) {
		GeeHashSet* _tmp148_;
		GeeHashSet* added_individuals;
		GeeHashSet* _tmp186_;
		GeeHashSet* _tmp187_;
		GeeHashMultiMap* _tmp188_;
		_tmp148_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		added_individuals = _tmp148_;
		{
			GeeHashMultiMap* _tmp149_;
			GeeSet* _tmp150_ = NULL;
			GeeSet* _tmp151_;
			GeeIterator* _tmp152_ = NULL;
			GeeIterator* _tmp153_;
			GeeIterator* _old_ind_it;
			_tmp149_ = individuals_changes;
			_tmp150_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = gee_iterable_iterator ((GeeIterable*) _tmp151_);
			_tmp153_ = _tmp152_;
			_g_object_unref0 (_tmp151_);
			_old_ind_it = _tmp153_;
			while (TRUE) {
				GeeIterator* _tmp154_;
				gboolean _tmp155_ = FALSE;
				GeeIterator* _tmp156_;
				gpointer _tmp157_ = NULL;
				FolksIndividual* old_ind;
				_tmp154_ = _old_ind_it;
				_tmp155_ = gee_iterator_next (_tmp154_);
				if (!_tmp155_) {
					break;
				}
				_tmp156_ = _old_ind_it;
				_tmp157_ = gee_iterator_get (_tmp156_);
				old_ind = (FolksIndividual*) _tmp157_;
				{
					GeeHashMultiMap* _tmp158_;
					FolksIndividual* _tmp159_;
					GeeCollection* _tmp160_ = NULL;
					GeeCollection* _tmp161_;
					GeeIterator* _tmp162_ = NULL;
					GeeIterator* _tmp163_;
					GeeIterator* _new_ind_it;
					_tmp158_ = individuals_changes;
					_tmp159_ = old_ind;
					_tmp160_ = gee_multi_map_get ((GeeMultiMap*) _tmp158_, _tmp159_);
					_tmp161_ = _tmp160_;
					_tmp162_ = gee_iterable_iterator ((GeeIterable*) _tmp161_);
					_tmp163_ = _tmp162_;
					_g_object_unref0 (_tmp161_);
					_new_ind_it = _tmp163_;
					while (TRUE) {
						GeeIterator* _tmp164_;
						gboolean _tmp165_ = FALSE;
						GeeIterator* _tmp166_;
						gpointer _tmp167_ = NULL;
						FolksIndividual* new_ind;
						gboolean _tmp168_ = FALSE;
						FolksIndividual* _tmp169_;
						gboolean _tmp171_;
						FolksIndividual* _tmp172_;
						FolksIndividual* _tmp175_;
						gboolean _tmp179_ = FALSE;
						FolksIndividual* _tmp180_;
						gboolean _tmp182_;
						_tmp164_ = _new_ind_it;
						_tmp165_ = gee_iterator_next (_tmp164_);
						if (!_tmp165_) {
							break;
						}
						_tmp166_ = _new_ind_it;
						_tmp167_ = gee_iterator_get (_tmp166_);
						new_ind = (FolksIndividual*) _tmp167_;
						_tmp169_ = old_ind;
						if (_tmp169_ != NULL) {
							_tmp168_ = TRUE;
						} else {
							FolksIndividual* _tmp170_;
							_tmp170_ = new_ind;
							_tmp168_ = _tmp170_ != NULL;
						}
						_tmp171_ = _tmp168_;
						g_assert (_tmp171_);
						_tmp172_ = old_ind;
						if (_tmp172_ != NULL) {
							GeeHashSet* _tmp173_;
							FolksIndividual* _tmp174_;
							_tmp173_ = removed_individuals;
							_tmp174_ = old_ind;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp173_, _tmp174_);
						}
						_tmp175_ = new_ind;
						if (_tmp175_ != NULL) {
							GeeHashSet* _tmp176_;
							FolksIndividual* _tmp177_;
							FolksIndividual* _tmp178_;
							_tmp176_ = added_individuals;
							_tmp177_ = new_ind;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp176_, _tmp177_);
							_tmp178_ = new_ind;
							_folks_individual_aggregator_connect_to_individual (self, _tmp178_);
						}
						_tmp180_ = old_ind;
						if (_tmp180_ != NULL) {
							FolksIndividual* _tmp181_;
							_tmp181_ = new_ind;
							_tmp179_ = _tmp181_ != NULL;
						} else {
							_tmp179_ = FALSE;
						}
						_tmp182_ = _tmp179_;
						if (_tmp182_) {
							GeeHashMap* _tmp183_;
							FolksIndividual* _tmp184_;
							FolksIndividual* _tmp185_;
							_tmp183_ = replaced_individuals;
							_tmp184_ = old_ind;
							_tmp185_ = new_ind;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp183_, _tmp184_, _tmp185_);
						}
						_g_object_unref0 (new_ind);
					}
					_g_object_unref0 (_new_ind_it);
				}
				_g_object_unref0 (old_ind);
			}
			_g_object_unref0 (_old_ind_it);
		}
		_tmp186_ = added_individuals;
		_tmp187_ = removed_individuals;
		_tmp188_ = individuals_changes;
		_folks_individual_aggregator_emit_individuals_changed (self, (GeeSet*) _tmp186_, (GeeSet*) _tmp187_, (GeeMultiMap*) _tmp188_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (added_individuals);
	}
	g_debug ("individual-aggregator.vala:1170: Replacing Individuals due to linking:");
	_tmp189_ = replaced_individuals;
	_tmp190_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp189_);
	iter = _tmp190_;
	while (TRUE) {
		GeeMapIterator* _tmp191_;
		gboolean _tmp192_ = FALSE;
		GeeMapIterator* _tmp193_;
		gpointer _tmp194_ = NULL;
		FolksIndividual* _tmp195_;
		GeeMapIterator* _tmp196_;
		gpointer _tmp197_ = NULL;
		FolksIndividual* _tmp198_;
		_tmp191_ = iter;
		_tmp192_ = gee_map_iterator_next (_tmp191_);
		if (!(_tmp192_ == TRUE)) {
			break;
		}
		_tmp193_ = iter;
		_tmp194_ = gee_map_iterator_get_key (_tmp193_);
		_tmp195_ = (FolksIndividual*) _tmp194_;
		_tmp196_ = iter;
		_tmp197_ = gee_map_iterator_get_value (_tmp196_);
		_tmp198_ = (FolksIndividual*) _tmp197_;
		folks_individual_replace (_tmp195_, _tmp198_);
		_g_object_unref0 (_tmp198_);
		_g_object_unref0 (_tmp195_);
	}
	_tmp199_ = self->priv->_debug;
	_tmp200_ = folks_debug_get_debug_output_enabled (_tmp199_);
	_tmp201_ = _tmp200_;
	if (_tmp201_ == TRUE) {
		GHashTable* _tmp202_;
		GHashTableIter iter2 = {0};
		gchar* link_key = NULL;
		FolksIndividual* individual = NULL;
		_tmp202_ = self->priv->_link_map;
		g_hash_table_iter_init (&iter2, _tmp202_);
		while (TRUE) {
			gconstpointer _tmp203_ = NULL;
			gconstpointer _tmp204_ = NULL;
			gboolean _tmp205_ = FALSE;
			gchar* _tmp206_;
			FolksIndividual* _tmp207_;
			GeeMap* _tmp208_;
			FolksIndividual* _tmp209_;
			const gchar* _tmp210_;
			const gchar* _tmp211_;
			gpointer _tmp212_ = NULL;
			FolksIndividual* _tmp213_;
			FolksIndividual* _tmp214_;
			gboolean _tmp215_;
			_tmp205_ = g_hash_table_iter_next (&iter2, &_tmp203_, &_tmp204_);
			_g_free0 (link_key);
			_tmp206_ = g_strdup (_tmp203_);
			link_key = _tmp206_;
			_g_object_unref0 (individual);
			_tmp207_ = _g_object_ref0 (_tmp204_);
			individual = _tmp207_;
			if (!(_tmp205_ == TRUE)) {
				break;
			}
			_tmp208_ = self->priv->_individuals;
			_tmp209_ = individual;
			_tmp210_ = folks_individual_get_id (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = gee_map_get (_tmp208_, _tmp211_);
			_tmp213_ = (FolksIndividual*) _tmp212_;
			_tmp214_ = individual;
			_tmp215_ = _tmp213_ != _tmp214_;
			_g_object_unref0 (_tmp213_);
			if (_tmp215_) {
				const gchar* _tmp216_;
				FolksIndividual* _tmp217_;
				const gchar* _tmp218_;
				const gchar* _tmp219_;
				FolksIndividual* _tmp220_;
				FolksIndividual* _tmp221_;
				const gchar* _tmp222_;
				const gchar* _tmp223_;
				FolksIndividual* _tmp224_;
				_tmp216_ = link_key;
				_tmp217_ = individual;
				_tmp218_ = folks_individual_get_id (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = individual;
				g_warning ("Link map contains invalid mapping:\n" "    %s → %s (%p)", _tmp216_, _tmp219_, _tmp220_);
				_tmp221_ = individual;
				_tmp222_ = folks_individual_get_id (_tmp221_);
				_tmp223_ = _tmp222_;
				_tmp224_ = individual;
				g_warning ("individual-aggregator.vala:1191: Individual %s (%p) personas:", _tmp223_, _tmp224_);
				{
					FolksIndividual* _tmp225_;
					GeeSet* _tmp226_;
					GeeSet* _tmp227_;
					GeeIterator* _tmp228_ = NULL;
					GeeIterator* _p_it;
					_tmp225_ = individual;
					_tmp226_ = folks_individual_get_personas (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = gee_iterable_iterator ((GeeIterable*) _tmp227_);
					_p_it = _tmp228_;
					while (TRUE) {
						GeeIterator* _tmp229_;
						gboolean _tmp230_ = FALSE;
						GeeIterator* _tmp231_;
						gpointer _tmp232_ = NULL;
						FolksPersona* p;
						FolksPersona* _tmp233_;
						const gchar* _tmp234_;
						const gchar* _tmp235_;
						FolksPersona* _tmp236_;
						_tmp229_ = _p_it;
						_tmp230_ = gee_iterator_next (_tmp229_);
						if (!_tmp230_) {
							break;
						}
						_tmp231_ = _p_it;
						_tmp232_ = gee_iterator_get (_tmp231_);
						p = (FolksPersona*) _tmp232_;
						_tmp233_ = p;
						_tmp234_ = folks_persona_get_uid (_tmp233_);
						_tmp235_ = _tmp234_;
						_tmp236_ = p;
						g_warning ("individual-aggregator.vala:1195:     %s (%p)", _tmp235_, _tmp236_);
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
			}
		}
		_g_object_unref0 (individual);
		_g_free0 (link_key);
	}
	_g_object_unref0 (iter);
	_g_object_unref0 (user);
	_g_object_unref0 (replaced_individuals);
	_g_object_unref0 (relinked_personas);
	_g_object_unref0 (individuals_changes);
	_g_object_unref0 (removed_individuals);
}


static void _folks_individual_aggregator_is_writeable_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	GObject* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	FolksPersonaStore* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp0_));
	store = _tmp1_;
	_tmp4_ = store;
	_tmp5_ = folks_persona_store_get_is_writeable (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == TRUE) {
		FolksPersonaStore* _tmp7_;
		FolksPersonaStore* _tmp8_;
		_tmp7_ = store;
		_tmp8_ = self->priv->_writeable_store;
		_tmp3_ = _tmp7_ == _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp9_ = _tmp3_;
	if (_tmp9_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		FolksPersonaStore* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp16_;
		_tmp11_ = store;
		_tmp12_ = folks_persona_store_get_is_writeable (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == FALSE) {
			FolksPersonaStore* _tmp14_;
			FolksPersonaStore* _tmp15_;
			_tmp14_ = store;
			_tmp15_ = self->priv->_writeable_store;
			_tmp10_ = _tmp14_ != _tmp15_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp16_ = _tmp10_;
		_tmp2_ = _tmp16_;
	}
	_tmp17_ = _tmp2_;
	g_assert (_tmp17_);
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_trust_level_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	GObject* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	gboolean _tmp2_ = FALSE;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp0_));
	store = _tmp1_;
	_tmp3_ = self->priv->_writeable_store;
	if (_tmp3_ != NULL) {
		FolksPersonaStore* _tmp4_;
		FolksPersonaStore* _tmp5_;
		_tmp4_ = store;
		_tmp5_ = self->priv->_writeable_store;
		_tmp2_ = _tmp4_ == _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		FolksPersonaStore* _tmp7_;
		FolksPersonaStoreTrust _tmp8_;
		FolksPersonaStoreTrust _tmp9_;
		_tmp7_ = store;
		_tmp8_ = folks_persona_store_get_trust_level (_tmp7_);
		_tmp9_ = _tmp8_;
		g_assert (_tmp9_ == FOLKS_PERSONA_STORE_TRUST_FULL);
	} else {
		FolksPersonaStore* _tmp10_;
		FolksPersonaStoreTrust _tmp11_;
		FolksPersonaStoreTrust _tmp12_;
		_tmp10_ = store;
		_tmp11_ = folks_persona_store_get_trust_level (_tmp10_);
		_tmp12_ = _tmp11_;
		g_assert (_tmp12_ != FOLKS_PERSONA_STORE_TRUST_FULL);
	}
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_non_quiescent_persona_store_count;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp1_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}


static void _folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_non_quiescent_backend_count;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp1_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}


static void _folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_non_quiescent_backend_count;
	if (_tmp2_ == ((guint) 0)) {
		guint _tmp3_;
		_tmp3_ = self->priv->_non_quiescent_persona_store_count;
		_tmp1_ = _tmp3_ == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_is_quiescent;
		_tmp0_ = _tmp5_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}


static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	GeeMap* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_ = NULL;
	FolksIndividual* _tmp7_;
	FolksIndividual* _tmp8_;
	gboolean _tmp9_;
	FolksIndividual* _tmp10_;
	FolksIndividual* _tmp20_;
	GeeSet* _tmp21_;
	GeeSet* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	FolksIndividual* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = i;
	if (_tmp0_ == _tmp1_) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = i;
	_tmp4_ = folks_individual_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_map_get (_tmp2_, _tmp5_);
	_tmp7_ = (FolksIndividual*) _tmp6_;
	_tmp8_ = i;
	_tmp9_ = _tmp7_ != _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		return;
	}
	_tmp10_ = replacement;
	if (_tmp10_ != NULL) {
		FolksIndividual* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		FolksIndividual* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp11_ = i;
		_tmp12_ = folks_individual_get_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = replacement;
		_tmp15_ = folks_individual_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		g_debug ("individual-aggregator.vala:1264: Individual '%s' removed (replaced by " \
"'%s')", _tmp13_, _tmp16_);
	} else {
		FolksIndividual* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = i;
		_tmp18_ = folks_individual_get_id (_tmp17_);
		_tmp19_ = _tmp18_;
		g_debug ("individual-aggregator.vala:1269: Individual '%s' removed (not replaced" \
")", _tmp19_);
	}
	_tmp20_ = i;
	_tmp21_ = folks_individual_get_personas (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		GeeHashMultiMap* _tmp25_;
		GeeHashMultiMap* changes;
		GeeHashSet* _tmp26_;
		GeeHashSet* individuals;
		GeeHashSet* _tmp27_;
		FolksIndividual* _tmp28_;
		GeeHashMultiMap* _tmp29_;
		FolksIndividual* _tmp30_;
		FolksIndividual* _tmp31_;
		GeeHashSet* _tmp32_;
		GeeHashMultiMap* _tmp33_;
		_tmp25_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL);
		changes = _tmp25_;
		_tmp26_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		individuals = _tmp26_;
		_tmp27_ = individuals;
		_tmp28_ = i;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = changes;
		_tmp30_ = i;
		_tmp31_ = replacement;
		gee_multi_map_set ((GeeMultiMap*) _tmp29_, _tmp30_, _tmp31_);
		_tmp32_ = individuals;
		_tmp33_ = changes;
		_folks_individual_aggregator_emit_individuals_changed (self, NULL, (GeeSet*) _tmp32_, (GeeMultiMap*) _tmp33_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (individuals);
		_g_object_unref0 (changes);
	}
	_tmp34_ = i;
	_folks_individual_aggregator_disconnect_from_individual (self, _tmp34_);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->persona_store);
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = parent;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->parent = _tmp2_;
	_tmp3_ = persona_store;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->persona_store = _tmp4_;
	_tmp5_ = details;
	_tmp6_ = _g_hash_table_ref0 (_tmp5_);
	_data_->details = _tmp6_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the `details`
   * provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *  * message - a user-readable message to pass to the persona being added
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return `null`.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store the {@link PersonaStore} to add the persona to
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or `null` if the corresponding
   * {@link Persona} already existed. If non-`null`, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   *
   * @since 0.3.5
   */
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->persona = NULL;
	{
		_data_->_tmp0_ = _data_->details;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _folks_individual_aggregator_asv_copy (_data_->self, _data_->_tmp0_);
		_data_->details_copy = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->persona_store;
		_data_->_tmp3_ = _data_->details_copy;
		_data_->_state_ = 1;
		folks_persona_store_add_persona_from_details (_data_->_tmp2_, _data_->_tmp3_, folks_individual_aggregator_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			_g_hash_table_unref0 (_data_->details_copy);
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch16_folks_persona_store_error;
			}
			_g_hash_table_unref0 (_data_->details_copy);
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->persona);
		_data_->persona = _data_->_tmp5_;
		_g_hash_table_unref0 (_data_->details_copy);
	}
	goto __finally16;
	__catch16_folks_persona_store_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = _data_->e;
		if (g_error_matches (_data_->_tmp6_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			_data_->_tmp9_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, _data_->_tmp8_);
			_data_->_inner_error_ = _data_->_tmp9_;
			_g_error_free0 (_data_->e);
			goto __finally16;
		} else {
			_data_->_tmp10_ = _data_->persona_store;
			_data_->_tmp11_ = folks_persona_store_get_type_id (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _data_->persona_store;
			_data_->_tmp14_ = folks_persona_store_get_id (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _folks_individual_aggregator_get_store_full_id (_data_->self, _data_->_tmp12_, _data_->_tmp15_);
			_data_->full_id = _data_->_tmp16_;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _ ("Failed to add contact for persona store ID '%s': %s");
			_data_->_tmp18_ = _data_->full_id;
			_data_->_tmp19_ = _data_->e;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			_data_->_tmp21_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp20_);
			_data_->_inner_error_ = _data_->_tmp21_;
			_g_free0 (_data_->full_id);
			_g_error_free0 (_data_->e);
			goto __finally16;
		}
		_g_error_free0 (_data_->e);
	}
	__finally16:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp23_ = _data_->parent;
	if (_data_->_tmp23_ != NULL) {
		_data_->_tmp24_ = _data_->persona;
		_data_->_tmp22_ = _data_->_tmp24_ != NULL;
	} else {
		_data_->_tmp22_ = FALSE;
	}
	_data_->_tmp25_ = _data_->_tmp22_;
	if (_data_->_tmp25_) {
		_data_->_tmp26_ = _data_->parent;
		_data_->_tmp27_ = folks_individual_get_personas (_data_->_tmp26_);
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = _data_->persona;
		gee_collection_add ((GeeCollection*) _data_->_tmp28_, _data_->_tmp29_);
	}
	_data_->result = _data_->persona;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_hash_table_unref0 (_data6_->retval);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void __lambda24_ (Block6Data* _data6_, const gchar* k, GValue* v) {
	FolksIndividualAggregator * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GValue* _tmp2_;
	GValue* _tmp3_;
	self = _data6_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	_tmp2_ = v;
	_tmp3_ = __g_value_dup0 (_tmp2_);
	g_hash_table_insert (_data6_->retval, _tmp1_, _tmp3_);
}


static void ___lambda24__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda24_ (self, key, value);
}


static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block6Data* _data6_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_GValue_free0_);
	_data6_->retval = _tmp2_;
	_tmp3_ = asv;
	g_hash_table_foreach (_tmp3_, ___lambda24__gh_func, _data6_);
	_tmp4_ = _g_hash_table_ref0 (_data6_->retval);
	result = _tmp4_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, _data_);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->individual = _tmp2_;
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * @param individual the {@link Individual} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (_data_);
}


static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->personas = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->individual;
		_data_->_tmp2_ = folks_individual_get_personas (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_p_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_p_it;
			_data_->_tmp6_ = FALSE;
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
			if (!_data_->_tmp6_) {
				break;
			}
			_data_->_tmp7_ = _data_->_p_it;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->p = (FolksPersona*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->personas;
			_data_->_tmp10_ = _data_->p;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp9_, _data_->_tmp10_);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	{
		_data_->_tmp11_ = _data_->personas;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp11_);
		_data_->_persona_it = _data_->_tmp12_;
		while (TRUE) {
			_data_->_tmp13_ = _data_->_persona_it;
			_data_->_tmp14_ = FALSE;
			_data_->_tmp14_ = gee_iterator_next (_data_->_tmp13_);
			if (!_data_->_tmp14_) {
				break;
			}
			_data_->_tmp15_ = _data_->_persona_it;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
			_data_->persona = (FolksPersona*) _data_->_tmp16_;
			_data_->_tmp17_ = _data_->persona;
			_data_->_tmp18_ = folks_persona_get_store (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = _data_->persona;
			_data_->_state_ = 1;
			folks_persona_store_remove_persona (_data_->_tmp19_, _data_->_tmp20_, folks_individual_aggregator_remove_individual_ready, _data_);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->persona);
				_g_object_unref0 (_data_->_persona_it);
				_g_object_unref0 (_data_->personas);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->persona);
		}
		_g_object_unref0 (_data_->_persona_it);
	}
	_g_object_unref0 (_data_->personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, _data_);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * @param persona the {@link Persona} to remove
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (_data_);
}


static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = folks_persona_get_store (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->persona;
	_data_->_state_ = 1;
	folks_persona_store_remove_persona (_data_->_tmp2_, _data_->_tmp3_, folks_individual_aggregator_remove_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, _data_);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	FolksIndividualAggregator* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->personas = _tmp2_;
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * @param personas the {@link Persona}s to be linked
   * @since 0.5.1
   */
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (_data_);
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_writeable_store;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Can't link personas with no writeable store.");
		_data_->_tmp2_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, _data_->_tmp1_);
		_data_->_inner_error_ = _data_->_tmp2_;
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->personas;
	_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ <= 1) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->_linking_enabled;
	if (_data_->_tmp6_ == FALSE) {
		g_debug ("individual-aggregator.vala:1431: Can't link Personas: linking disabled" \
".");
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->_writeable_store;
	_data_->_tmp8_ = folks_persona_store_get_type_id (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->self->priv->_configured_writeable_store_type_id;
	g_assert (g_strcmp0 (_data_->_tmp9_, _data_->_tmp10_) == 0);
	_data_->_tmp11_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_data_->protocols_addrs_set = _data_->_tmp11_;
	_data_->_tmp12_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_data_->web_service_addrs_set = _data_->_tmp12_;
	_data_->_tmp13_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data_->local_ids = _data_->_tmp13_;
	{
		_data_->_tmp14_ = _data_->personas;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp14_);
		_data_->_persona_it = _data_->_tmp15_;
		while (TRUE) {
			_data_->_tmp16_ = _data_->_persona_it;
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = gee_iterator_next (_data_->_tmp16_);
			if (!_data_->_tmp17_) {
				break;
			}
			_data_->_tmp18_ = _data_->_persona_it;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
			_data_->persona = (FolksPersona*) _data_->_tmp19_;
			_data_->_tmp20_ = _data_->persona;
			if (FOLKS_IS_IM_DETAILS (_data_->_tmp20_)) {
				_data_->_tmp21_ = _data_->persona;
				_data_->_tmp22_ = _g_object_ref0 (FOLKS_IM_DETAILS (_data_->_tmp21_));
				_data_->im_details = _data_->_tmp22_;
				{
					_data_->_tmp23_ = _data_->im_details;
					_data_->_tmp24_ = folks_im_details_get_im_addresses (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = NULL;
					_data_->_tmp26_ = gee_multi_map_get_keys (_data_->_tmp25_);
					_data_->_tmp27_ = _data_->_tmp26_;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp27_);
					_data_->_tmp29_ = _data_->_tmp28_;
					_g_object_unref0 (_data_->_tmp27_);
					_data_->_protocol_it = _data_->_tmp29_;
					while (TRUE) {
						_data_->_tmp30_ = _data_->_protocol_it;
						_data_->_tmp31_ = FALSE;
						_data_->_tmp31_ = gee_iterator_next (_data_->_tmp30_);
						if (!_data_->_tmp31_) {
							break;
						}
						_data_->_tmp32_ = _data_->_protocol_it;
						_data_->_tmp33_ = NULL;
						_data_->_tmp33_ = gee_iterator_get (_data_->_tmp32_);
						_data_->protocol = (gchar*) _data_->_tmp33_;
						_data_->_tmp34_ = _data_->im_details;
						_data_->_tmp35_ = folks_im_details_get_im_addresses (_data_->_tmp34_);
						_data_->_tmp36_ = _data_->_tmp35_;
						_data_->_tmp37_ = _data_->protocol;
						_data_->_tmp38_ = NULL;
						_data_->_tmp38_ = gee_multi_map_get (_data_->_tmp36_, _data_->_tmp37_);
						_data_->im_addresses = _data_->_tmp38_;
						{
							_data_->_tmp39_ = _data_->im_addresses;
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp39_);
							_data_->_im_address_it = _data_->_tmp40_;
							while (TRUE) {
								_data_->_tmp41_ = _data_->_im_address_it;
								_data_->_tmp42_ = FALSE;
								_data_->_tmp42_ = gee_iterator_next (_data_->_tmp41_);
								if (!_data_->_tmp42_) {
									break;
								}
								_data_->_tmp43_ = _data_->_im_address_it;
								_data_->_tmp44_ = NULL;
								_data_->_tmp44_ = gee_iterator_get (_data_->_tmp43_);
								_data_->im_address = (FolksImFieldDetails*) _data_->_tmp44_;
								_data_->_tmp45_ = _data_->protocols_addrs_set;
								_data_->_tmp46_ = _data_->protocol;
								_data_->_tmp47_ = _data_->im_address;
								gee_multi_map_set ((GeeMultiMap*) _data_->_tmp45_, _data_->_tmp46_, _data_->_tmp47_);
								_g_object_unref0 (_data_->im_address);
							}
							_g_object_unref0 (_data_->_im_address_it);
						}
						_g_object_unref0 (_data_->im_addresses);
						_g_free0 (_data_->protocol);
					}
					_g_object_unref0 (_data_->_protocol_it);
				}
				_g_object_unref0 (_data_->im_details);
			}
			_data_->_tmp48_ = _data_->persona;
			if (FOLKS_IS_WEB_SERVICE_DETAILS (_data_->_tmp48_)) {
				_data_->_tmp49_ = _data_->persona;
				_data_->_tmp50_ = _g_object_ref0 (FOLKS_WEB_SERVICE_DETAILS (_data_->_tmp49_));
				_data_->ws_details = _data_->_tmp50_;
				{
					_data_->_tmp51_ = _data_->ws_details;
					_data_->_tmp52_ = folks_web_service_details_get_web_service_addresses (_data_->_tmp51_);
					_data_->_tmp53_ = _data_->_tmp52_;
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = gee_multi_map_get_keys (_data_->_tmp53_);
					_data_->_tmp55_ = _data_->_tmp54_;
					_data_->_tmp56_ = NULL;
					_data_->_tmp56_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp55_);
					_data_->_tmp57_ = _data_->_tmp56_;
					_g_object_unref0 (_data_->_tmp55_);
					_data_->_web_service_it = _data_->_tmp57_;
					while (TRUE) {
						_data_->_tmp58_ = _data_->_web_service_it;
						_data_->_tmp59_ = FALSE;
						_data_->_tmp59_ = gee_iterator_next (_data_->_tmp58_);
						if (!_data_->_tmp59_) {
							break;
						}
						_data_->_tmp60_ = _data_->_web_service_it;
						_data_->_tmp61_ = NULL;
						_data_->_tmp61_ = gee_iterator_get (_data_->_tmp60_);
						_data_->web_service = (gchar*) _data_->_tmp61_;
						_data_->_tmp62_ = _data_->ws_details;
						_data_->_tmp63_ = folks_web_service_details_get_web_service_addresses (_data_->_tmp62_);
						_data_->_tmp64_ = _data_->_tmp63_;
						_data_->_tmp65_ = _data_->web_service;
						_data_->_tmp66_ = NULL;
						_data_->_tmp66_ = gee_multi_map_get (_data_->_tmp64_, _data_->_tmp65_);
						_data_->ws_addresses = _data_->_tmp66_;
						{
							_data_->_tmp67_ = _data_->ws_addresses;
							_data_->_tmp68_ = NULL;
							_data_->_tmp68_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp67_);
							_data_->_ws_fd_it = _data_->_tmp68_;
							while (TRUE) {
								_data_->_tmp69_ = _data_->_ws_fd_it;
								_data_->_tmp70_ = FALSE;
								_data_->_tmp70_ = gee_iterator_next (_data_->_tmp69_);
								if (!_data_->_tmp70_) {
									break;
								}
								_data_->_tmp71_ = _data_->_ws_fd_it;
								_data_->_tmp72_ = NULL;
								_data_->_tmp72_ = gee_iterator_get (_data_->_tmp71_);
								_data_->ws_fd = (FolksWebServiceFieldDetails*) _data_->_tmp72_;
								_data_->_tmp73_ = _data_->web_service_addrs_set;
								_data_->_tmp74_ = _data_->web_service;
								_data_->_tmp75_ = _data_->ws_fd;
								gee_multi_map_set ((GeeMultiMap*) _data_->_tmp73_, _data_->_tmp74_, _data_->_tmp75_);
								_g_object_unref0 (_data_->ws_fd);
							}
							_g_object_unref0 (_data_->_ws_fd_it);
						}
						_g_object_unref0 (_data_->ws_addresses);
						_g_free0 (_data_->web_service);
					}
					_g_object_unref0 (_data_->_web_service_it);
				}
				_g_object_unref0 (_data_->ws_details);
			}
			_data_->_tmp76_ = _data_->persona;
			if (FOLKS_IS_LOCAL_ID_DETAILS (_data_->_tmp76_)) {
				{
					_data_->_tmp77_ = _data_->persona;
					_data_->_tmp78_ = folks_local_id_details_get_local_ids (FOLKS_LOCAL_ID_DETAILS (_data_->_tmp77_));
					_data_->_tmp79_ = _data_->_tmp78_;
					_data_->_tmp80_ = NULL;
					_data_->_tmp80_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp79_);
					_data_->_id_it = _data_->_tmp80_;
					while (TRUE) {
						_data_->_tmp81_ = _data_->_id_it;
						_data_->_tmp82_ = FALSE;
						_data_->_tmp82_ = gee_iterator_next (_data_->_tmp81_);
						if (!_data_->_tmp82_) {
							break;
						}
						_data_->_tmp83_ = _data_->_id_it;
						_data_->_tmp84_ = NULL;
						_data_->_tmp84_ = gee_iterator_get (_data_->_tmp83_);
						_data_->id = (gchar*) _data_->_tmp84_;
						_data_->_tmp85_ = _data_->local_ids;
						_data_->_tmp86_ = _data_->id;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp85_, _data_->_tmp86_);
						_g_free0 (_data_->id);
					}
					_g_object_unref0 (_data_->_id_it);
				}
			}
			_g_object_unref0 (_data_->persona);
		}
		_g_object_unref0 (_data_->_persona_it);
	}
	_data_->_tmp87_ = g_str_hash;
	_data_->_tmp88_ = g_str_equal;
	_data_->_tmp89_ = g_hash_table_new_full (_data_->_tmp87_, _data_->_tmp88_, _g_free0_, __vala_GValue_free0_);
	_data_->details = _data_->_tmp89_;
	_data_->_tmp90_ = _data_->protocols_addrs_set;
	_data_->_tmp91_ = gee_multi_map_get_size ((GeeMultiMap*) _data_->_tmp90_);
	_data_->_tmp92_ = _data_->_tmp91_;
	if (_data_->_tmp92_ > 0) {
		memset (&_data_->_tmp93_, 0, sizeof (GValue));
		g_value_init (&_data_->_tmp93_, GEE_TYPE_MULTI_MAP);
		_data_->im_addresses_value = _data_->_tmp93_;
		_data_->_tmp94_ = _data_->protocols_addrs_set;
		g_value_set_object (&_data_->im_addresses_value, (GObject*) _data_->_tmp94_);
		_data_->_tmp95_ = _data_->details;
		_data_->_tmp96_ = NULL;
		_data_->_tmp96_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		_data_->_tmp97_ = g_strdup (_data_->_tmp96_);
		_data_->_tmp98_ = _data_->im_addresses_value;
		_data_->_tmp99_ = _data_->_tmp98_;
		_data_->_tmp100_ = __g_value_dup0 (&_data_->_tmp99_);
		g_hash_table_insert (_data_->_tmp95_, _data_->_tmp97_, _data_->_tmp100_);
		G_IS_VALUE (&_data_->im_addresses_value) ? (g_value_unset (&_data_->im_addresses_value), NULL) : NULL;
	}
	_data_->_tmp101_ = _data_->web_service_addrs_set;
	_data_->_tmp102_ = gee_multi_map_get_size ((GeeMultiMap*) _data_->_tmp101_);
	_data_->_tmp103_ = _data_->_tmp102_;
	if (_data_->_tmp103_ > 0) {
		memset (&_data_->_tmp104_, 0, sizeof (GValue));
		g_value_init (&_data_->_tmp104_, GEE_TYPE_MULTI_MAP);
		_data_->web_service_addresses_value = _data_->_tmp104_;
		_data_->_tmp105_ = _data_->web_service_addrs_set;
		g_value_set_object (&_data_->web_service_addresses_value, (GObject*) _data_->_tmp105_);
		_data_->_tmp106_ = _data_->details;
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		_data_->_tmp108_ = g_strdup (_data_->_tmp107_);
		_data_->_tmp109_ = _data_->web_service_addresses_value;
		_data_->_tmp110_ = _data_->_tmp109_;
		_data_->_tmp111_ = __g_value_dup0 (&_data_->_tmp110_);
		g_hash_table_insert (_data_->_tmp106_, _data_->_tmp108_, _data_->_tmp111_);
		G_IS_VALUE (&_data_->web_service_addresses_value) ? (g_value_unset (&_data_->web_service_addresses_value), NULL) : NULL;
	}
	_data_->_tmp112_ = _data_->local_ids;
	_data_->_tmp113_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp112_);
	_data_->_tmp114_ = _data_->_tmp113_;
	if (_data_->_tmp114_ > 0) {
		memset (&_data_->_tmp115_, 0, sizeof (GValue));
		g_value_init (&_data_->_tmp115_, GEE_TYPE_SET);
		_data_->local_ids_value = _data_->_tmp115_;
		_data_->_tmp116_ = _data_->local_ids;
		g_value_set_object (&_data_->local_ids_value, (GObject*) _data_->_tmp116_);
		_data_->_tmp117_ = _data_->details;
		_data_->_tmp118_ = NULL;
		_data_->_tmp118_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		_data_->_tmp119_ = g_strdup (_data_->_tmp118_);
		_data_->_tmp120_ = _data_->local_ids_value;
		_data_->_tmp121_ = _data_->_tmp120_;
		_data_->_tmp122_ = __g_value_dup0 (&_data_->_tmp121_);
		g_hash_table_insert (_data_->_tmp117_, _data_->_tmp119_, _data_->_tmp122_);
		G_IS_VALUE (&_data_->local_ids_value) ? (g_value_unset (&_data_->local_ids_value), NULL) : NULL;
	}
	_data_->_tmp123_ = _data_->self->priv->_writeable_store;
	_data_->_tmp124_ = _data_->details;
	_data_->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp123_, _data_->_tmp124_, folks_individual_aggregator_link_personas_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp125_ = NULL;
	_data_->_tmp125_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp126_ = _data_->_tmp125_;
	_g_object_unref0 (_data_->_tmp126_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_hash_table_unref0 (_data_->details);
			_g_object_unref0 (_data_->local_ids);
			_g_object_unref0 (_data_->web_service_addrs_set);
			_g_object_unref0 (_data_->protocols_addrs_set);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->details);
			_g_object_unref0 (_data_->local_ids);
			_g_object_unref0 (_data_->web_service_addrs_set);
			_g_object_unref0 (_data_->protocols_addrs_set);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->local_ids);
	_g_object_unref0 (_data_->web_service_addrs_set);
	_g_object_unref0 (_data_->protocols_addrs_set);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, _data_);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->individual = _tmp2_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * @param individual the {@link Individual} to unlink
   * @since 0.1.13
   */
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}


static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_linking_enabled;
	if (_data_->_tmp0_ == FALSE) {
		_data_->_tmp1_ = _data_->individual;
		_data_->_tmp2_ = folks_individual_get_id (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		g_debug ("individual-aggregator.vala:1552: Can't unlink Individual '%s': linking" \
" disabled.", _data_->_tmp3_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->individual;
	_data_->_tmp5_ = folks_individual_get_id (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("individual-aggregator.vala:1557: Unlinking Individual '%s', deleting P" \
"ersonas:", _data_->_tmp6_);
	_data_->_tmp7_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->personas = _data_->_tmp7_;
	{
		_data_->_tmp8_ = _data_->individual;
		_data_->_tmp9_ = folks_individual_get_personas (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp10_);
		_data_->_p_it = _data_->_tmp11_;
		while (TRUE) {
			_data_->_tmp12_ = _data_->_p_it;
			_data_->_tmp13_ = FALSE;
			_data_->_tmp13_ = gee_iterator_next (_data_->_tmp12_);
			if (!_data_->_tmp13_) {
				break;
			}
			_data_->_tmp14_ = _data_->_p_it;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
			_data_->p = (FolksPersona*) _data_->_tmp15_;
			_data_->_tmp16_ = _data_->personas;
			_data_->_tmp17_ = _data_->p;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp16_, _data_->_tmp17_);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	{
		_data_->_tmp18_ = _data_->personas;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp18_);
		_data_->_persona_it = _data_->_tmp19_;
		while (TRUE) {
			_data_->_tmp20_ = _data_->_persona_it;
			_data_->_tmp21_ = FALSE;
			_data_->_tmp21_ = gee_iterator_next (_data_->_tmp20_);
			if (!_data_->_tmp21_) {
				break;
			}
			_data_->_tmp22_ = _data_->_persona_it;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
			_data_->persona = (FolksPersona*) _data_->_tmp23_;
			_data_->_tmp24_ = _data_->persona;
			_data_->_tmp25_ = folks_persona_get_store (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = _data_->self->priv->_writeable_store;
			if (_data_->_tmp26_ == _data_->_tmp27_) {
				_data_->_tmp29_ = _data_->persona;
				_data_->_tmp30_ = folks_persona_get_is_user (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				if (_data_->_tmp31_) {
					_data_->_tmp28_ = "yes";
				} else {
					_data_->_tmp28_ = "no";
				}
				_data_->_tmp32_ = _data_->persona;
				_data_->_tmp33_ = folks_persona_get_uid (_data_->_tmp32_);
				_data_->_tmp34_ = _data_->_tmp33_;
				_data_->_tmp35_ = _data_->_tmp28_;
				_data_->_tmp36_ = _data_->persona;
				_data_->_tmp37_ = folks_persona_get_iid (_data_->_tmp36_);
				_data_->_tmp38_ = _data_->_tmp37_;
				g_debug ("individual-aggregator.vala:1575:     %s (is user: %s, IID: %s)", _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp38_);
				_data_->_tmp39_ = _data_->self->priv->_writeable_store;
				_data_->_tmp40_ = _data_->persona;
				_data_->_state_ = 1;
				folks_persona_store_remove_persona (_data_->_tmp39_, _data_->_tmp40_, folks_individual_aggregator_unlink_individual_ready, _data_);
				return FALSE;
				_state_1:
				folks_persona_store_remove_persona_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->persona);
					_g_object_unref0 (_data_->_persona_it);
					_g_object_unref0 (_data_->personas);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->persona);
		}
		_g_object_unref0 (_data_->_persona_it);
	}
	_g_object_unref0 (_data_->personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData, _data_);
}


void folks_individual_aggregator_ensure_individual_property_writeable (FolksIndividualAggregator* self, FolksIndividual* individual, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	FolksIndividualAggregator* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_data_ = g_slice_new0 (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_ensure_individual_property_writeable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_ensure_individual_property_writeable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->individual = _tmp2_;
	_tmp3_ = property_name;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->property_name = _tmp4_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}


FolksPersona* folks_individual_aggregator_ensure_individual_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Ensure that the given property is writeable for the given
   * {@link Individual}.
   *
   * This makes sure that there is at least one {@link Persona} in the
   * individual which has `property_name` in its
   * {@link Persona.writeable_properties}. If no such persona exists in the
   * individual, a new one will be created and linked to the individual. (Note
   * that due to the design of the aggregator, this will result in the previous
   * individual being removed and replaced by a new one with the new persona;
   * listen to the {@link Individual.removed} signal to see the replacement.)
   *
   * It may not be possible to create a new persona which has the given property
   * as writeable. In that case, a
   * {@link IndividualAggregatorError.NO_WRITEABLE_STORE} or
   * {@link IndividualAggregatorError.PROPERTY_NOT_WRITEABLE} error will be
   * thrown.
   *
   * @param individual the individual for which `property_name` should be
   * writeable
   * @param property_name the name of the property which needs to be writeable
   * (this should be in lower case using hyphens, e.g. “web-service-addresses”)
   * @return a persona (new or existing) which has the given property as
   * writeable
   *
   * @since 0.6.2
   */
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}


static gboolean folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->individual;
	_data_->_tmp1_ = folks_individual_get_id (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->property_name;
	g_debug ("individual-aggregator.vala:1613: ensure_individual_property_writeable:" \
" %s, %s", _data_->_tmp2_, _data_->_tmp3_);
	{
		_data_->_tmp4_ = _data_->individual;
		_data_->_tmp5_ = folks_individual_get_personas (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp6_);
		_data_->_p1_it = _data_->_tmp7_;
		while (TRUE) {
			_data_->_tmp8_ = _data_->_p1_it;
			_data_->_tmp9_ = FALSE;
			_data_->_tmp9_ = gee_iterator_next (_data_->_tmp8_);
			if (!_data_->_tmp9_) {
				break;
			}
			_data_->_tmp10_ = _data_->_p1_it;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
			_data_->p1 = (FolksPersona*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->property_name;
			_data_->_tmp13_ = _data_->p1;
			_data_->_tmp14_ = folks_persona_get_writeable_properties (_data_->_tmp13_, &_data_->_tmp14__length1);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp15__length1 = _data_->_tmp14__length1;
			if (_vala_string_array_contains (_data_->_tmp15_, _data_->_tmp15__length1, _data_->_tmp12_)) {
				_data_->_tmp16_ = _data_->p1;
				_data_->_tmp17_ = folks_persona_get_uid (_data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				g_debug ("individual-aggregator.vala:1621:     Returning existing persona: %s", _data_->_tmp18_);
				_data_->result = _data_->p1;
				_g_object_unref0 (_data_->_p1_it);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->p1);
		}
		_g_object_unref0 (_data_->_p1_it);
	}
	_data_->_tmp19_ = g_str_hash;
	_data_->_tmp20_ = g_str_equal;
	_data_->_tmp21_ = g_hash_table_new_full (_data_->_tmp19_, _data_->_tmp20_, _g_free0_, __vala_GValue_free0_);
	_data_->details = _data_->_tmp21_;
	_data_->new_persona = NULL;
	_data_->_tmp23_ = _data_->self->priv->_writeable_store;
	if (_data_->_tmp23_ != NULL) {
		_data_->_tmp24_ = _data_->property_name;
		_data_->_tmp25_ = _data_->self->priv->_writeable_store;
		_data_->_tmp26_ = folks_persona_store_get_always_writeable_properties (_data_->_tmp25_, &_data_->_tmp26__length1);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp27__length1 = _data_->_tmp26__length1;
		_data_->_tmp22_ = _vala_string_array_contains (_data_->_tmp27_, _data_->_tmp27__length1, _data_->_tmp24_);
	} else {
		_data_->_tmp22_ = FALSE;
	}
	_data_->_tmp28_ = _data_->_tmp22_;
	if (_data_->_tmp28_) {
		{
			g_debug ("individual-aggregator.vala:1637:     Using writeable store");
			_data_->_tmp29_ = _data_->self->priv->_writeable_store;
			_data_->_tmp30_ = _data_->details;
			_data_->_state_ = 1;
			folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp29_, _data_->_tmp30_, folks_individual_aggregator_ensure_individual_property_writeable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp32_ = _data_->_tmp31_;
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch17_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = _data_->_tmp32_;
		}
		goto __finally17;
		__catch17_folks_individual_aggregator_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = NULL;
			_g_error_free0 (_data_->e1);
		}
		__finally17:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp33_ = _data_->new_persona;
	if (_data_->_tmp33_ == NULL) {
		{
			_data_->_tmp34_ = _data_->self->priv->_stores;
			_data_->_tmp35_ = gee_map_get_values ((GeeMap*) _data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = _data_->_tmp36_;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp37_);
			_data_->_tmp39_ = _data_->_tmp38_;
			_g_object_unref0 (_data_->_tmp37_);
			_data_->_s_it = _data_->_tmp39_;
			while (TRUE) {
				_data_->_tmp40_ = _data_->_s_it;
				_data_->_tmp41_ = FALSE;
				_data_->_tmp41_ = gee_iterator_next (_data_->_tmp40_);
				if (!_data_->_tmp41_) {
					break;
				}
				_data_->_tmp42_ = _data_->_s_it;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = gee_iterator_get (_data_->_tmp42_);
				_data_->s = (FolksPersonaStore*) _data_->_tmp43_;
				_data_->_tmp45_ = _data_->s;
				_data_->_tmp46_ = _data_->self->priv->_writeable_store;
				if (_data_->_tmp45_ == _data_->_tmp46_) {
					_data_->_tmp44_ = TRUE;
				} else {
					_data_->_tmp47_ = _data_->property_name;
					_data_->_tmp48_ = _data_->s;
					_data_->_tmp49_ = folks_persona_store_get_always_writeable_properties (_data_->_tmp48_, &_data_->_tmp49__length1);
					_data_->_tmp50_ = _data_->_tmp49_;
					_data_->_tmp50__length1 = _data_->_tmp49__length1;
					_data_->_tmp44_ = !_vala_string_array_contains (_data_->_tmp50_, _data_->_tmp50__length1, _data_->_tmp47_);
				}
				_data_->_tmp51_ = _data_->_tmp44_;
				if (_data_->_tmp51_) {
					_g_object_unref0 (_data_->s);
					continue;
				}
				{
					_data_->_tmp52_ = _data_->s;
					_data_->_tmp53_ = folks_persona_store_get_id (_data_->_tmp52_);
					_data_->_tmp54_ = _data_->_tmp53_;
					g_debug ("individual-aggregator.vala:1661:     Using store %s", _data_->_tmp54_);
					_data_->_tmp55_ = _data_->s;
					_data_->_tmp56_ = _data_->details;
					_data_->_state_ = 2;
					folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp55_, _data_->_tmp56_, folks_individual_aggregator_ensure_individual_property_writeable_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp57_ = NULL;
					_data_->_tmp57_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					_data_->_tmp58_ = _data_->_tmp57_;
					if (_data_->_inner_error_ != NULL) {
						if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
							goto __catch18_folks_individual_aggregator_error;
						}
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = _data_->_tmp58_;
				}
				goto __finally18;
				__catch18_folks_individual_aggregator_error:
				{
					_data_->e2 = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = NULL;
					_g_error_free0 (_data_->e2);
					_g_object_unref0 (_data_->s);
					continue;
				}
				__finally18:
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->s);
			}
			_g_object_unref0 (_data_->_s_it);
		}
	}
	_data_->_tmp60_ = _data_->new_persona;
	if (_data_->_tmp60_ == NULL) {
		_data_->_tmp61_ = _data_->self->priv->_writeable_store;
		_data_->_tmp59_ = _data_->_tmp61_ == NULL;
	} else {
		_data_->_tmp59_ = FALSE;
	}
	_data_->_tmp62_ = _data_->_tmp59_;
	if (_data_->_tmp62_) {
		_data_->_tmp63_ = NULL;
		_data_->_tmp63_ = _ ("Can't add personas with no writeable store.");
		_data_->_tmp64_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE, _data_->_tmp63_);
		_data_->_inner_error_ = _data_->_tmp64_;
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	} else {
		_data_->_tmp65_ = _data_->new_persona;
		if (_data_->_tmp65_ == NULL) {
			_data_->_tmp66_ = NULL;
			_data_->_tmp66_ = _ ("Can't write to requested property (“%s”) of the writeable store.");
			_data_->_tmp67_ = _data_->property_name;
			_data_->_tmp68_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, _data_->_tmp66_, _data_->_tmp67_);
			_data_->_inner_error_ = _data_->_tmp68_;
			if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp69_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->linking_personas = _data_->_tmp69_;
	_data_->_tmp70_ = _data_->linking_personas;
	_data_->_tmp71_ = _data_->new_persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp70_, _data_->_tmp71_);
	{
		_data_->_tmp72_ = _data_->individual;
		_data_->_tmp73_ = folks_individual_get_personas (_data_->_tmp72_);
		_data_->_tmp74_ = _data_->_tmp73_;
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp74_);
		_data_->_p2_it = _data_->_tmp75_;
		while (TRUE) {
			_data_->_tmp76_ = _data_->_p2_it;
			_data_->_tmp77_ = FALSE;
			_data_->_tmp77_ = gee_iterator_next (_data_->_tmp76_);
			if (!_data_->_tmp77_) {
				break;
			}
			_data_->_tmp78_ = _data_->_p2_it;
			_data_->_tmp79_ = NULL;
			_data_->_tmp79_ = gee_iterator_get (_data_->_tmp78_);
			_data_->p2 = (FolksPersona*) _data_->_tmp79_;
			_data_->_tmp80_ = _data_->linking_personas;
			_data_->_tmp81_ = _data_->p2;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp80_, _data_->_tmp81_);
			_g_object_unref0 (_data_->p2);
		}
		_g_object_unref0 (_data_->_p2_it);
	}
	_data_->_tmp82_ = _data_->property_name;
	g_debug ("individual-aggregator.vala:1696:     Linking personas to ensure %s pro" \
"perty is writeable.", _data_->_tmp82_);
	_data_->_tmp83_ = _data_->linking_personas;
	_data_->_state_ = 3;
	folks_individual_aggregator_link_personas (_data_->self, (GeeSet*) _data_->_tmp83_, folks_individual_aggregator_ensure_individual_property_writeable_ready, _data_);
	return FALSE;
	_state_3:
	folks_individual_aggregator_link_personas_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->linking_personas);
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->linking_personas);
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->new_persona;
	_g_object_unref0 (_data_->linking_personas);
	_g_hash_table_unref0 (_data_->details);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->linking_personas);
	_g_object_unref0 (_data_->new_persona);
	_g_hash_table_unref0 (_data_->details);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


gboolean folks_individual_aggregator_get_is_quiescent (FolksIndividualAggregator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self) {
	FolksPersonaStore* result;
	FolksPersonaStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_writeable_store;
	result = _tmp0_;
	return result;
}


GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individuals_ro;
	result = _tmp0_;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value) {
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp1_;
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = gee_map_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp4_;
	g_object_notify ((GObject *) self, "individuals");
}


FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self) {
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}


static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value) {
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_user);
	self->priv->_user = _tmp1_;
	g_object_notify ((GObject *) self, "user");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the aggregator has reached a quiescent state. This will happen at
	   * some point after {@link IndividualAggregator.prepare} has successfully
	   * completed for the aggregator. An aggregator is in a quiescent state when
	   * all the {@link PersonaStore}s listed by its backends have reached a
	   * quiescent state.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link IndividualAggregator.is_prepared} has changed to `true`.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Our configured primary (writeable) store.
	   *
	   * Which one to use is decided (in order or precedence)
	   * by:
	   *
	   * - the FOLKS_WRITEABLE_STORE env var (mostly for debugging)
	   * - the GConf key set in _FOLKS_CONFIG_KEY (system set store)
	   * - going with the `key-file` or `eds` store as the fall-back option
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE, g_param_spec_object ("primary-store", "primary-store", "primary-store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A map from {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_object ("individuals", "individuals", "individuals", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user: the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER, g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * If more information about the relationships between {@link Individual}s
	   * which have been linked and unlinked is needed, consider connecting to
	   * {@link IndividualAggregator.individuals_changed_detailed} instead, which is
	   * emitted at the same time as this signal.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been added
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This is emitted at the same time as
	   * {@link IndividualAggregator.individuals_changed}, but includes more
	   * information about the relationships between {@link Individual}s which have
	   * been linked and unlinked.
	   *
	   * Individuals which have been linked will be listed in the multi-map as
	   * mappings from the old individuals to the single new individual which
	   * replaces them (i.e. each of the old individuals will map to the same new
	   * individual). This new individual is the one which will be specified as the
	   * `replacement_individual` in the {@link Individual.removed} signal for the
	   * old individuals.
	   *
	   * Individuals which have been unlinked will be listed in the multi-map as
	   * a mapping from the unlinked individual to a set of one or more individuals
	   * which replace it.
	   *
	   * Individuals which have been added will be listed in the multi-map as a
	   * mapping from `null` to the set of added individuals. If `null` doesn't
	   * map to anything, no individuals have been added to the aggregator.
	   *
	   * Individuals which have been removed will be listed in the multi-map as
	   * mappings from the removed individual to `null`.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a mapping of old {@link Individual}s to new
	   * {@link Individual}s for the individuals which have changed in the
	   * aggregator
	   *
	   * @since 0.6.2
	   */
	g_signal_new ("individuals_changed_detailed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MULTI_MAP);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
	self->priv->_writeable_store = NULL;
	self->priv->_linking_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_non_quiescent_persona_store_count = (guint) 0;
	self->priv->_non_quiescent_backend_count = (guint) 0;
	self->priv->_is_quiescent = FALSE;
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	FolksBackendStore* _tmp0_;
	guint _tmp1_ = 0U;
	FolksDebug* _tmp2_;
	guint _tmp3_ = 0U;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (obj);
	_tmp0_ = self->priv->_backend_store;
	g_signal_parse_name ("backend-available", FOLKS_TYPE_BACKEND_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = NULL;
	_tmp2_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_stores);
	_g_object_unref0 (self->priv->_backends);
	_g_hash_table_unref0 (self->priv->_link_map);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_debug);
	_g_free0 (self->priv->_configured_writeable_store_type_id);
	_g_free0 (self->priv->_configured_writeable_store_id);
	_g_object_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_quiescent (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE:
		g_value_set_object (value, folks_individual_aggregator_get_primary_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_object (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = FOLKS_INDIVIDUAL_AGGREGATOR (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



