from GConfBackend import GConfBackend


_CONFIG_LOCATION = "/apps/gdesklets"


#
# Class for managing configuration.
#
class ConfigManager:

    def __init__(self):

        self.__cache = {}
        self.__backend = GConfBackend(_CONFIG_LOCATION)
        self.__backend.add_observer(self.__on_observe_backend)



    #
    # Observer function for the backend.
    #
    def __on_observe_backend(self, src, cmd, *args):

        if (cmd == src.OBS_UPDATE):
            key, value = args
            config_id, k = key

            if (not self.__cache.has_key(config_id)):
                self.__cache[config_id] = {}
            self.__cache[config_id][k] = value
    


    def set(self, config_id, key, value):

        self.__backend.set(config_id, key, value)



    def get(self, config_id, key):

        # TODO: correct caching (do we need caching?)

        #if (self.__cache.has_key(config_id)):
        #    print "cache", self.__cache
        #    return self.__cache[config_id].get(key, "")
        #else:
        #    print "new"
        return self.__backend.get(config_id, key)



    def watch(self, config_id, key, handler):

        self.__backend.watch(config_id, key, handler)



    def clear(self, config_id):

        self.__backend.clear(config_id)
