#
# Registry for DataTargets. To add a new target just add an appropriate entry
# to _REGISTRY.
#



#
# Registry for DataTargets. Each target requires an entry in this list.
# The entry format is a tuple consisting of:
#
#  * name         The name of the target to be used in .display files
#  * classname    The name of the class (the module has to be of the same name)
#
_REGISTRY = [
    ("alignment", "TargetAlignment"),
    ("array", "TargetArray"),
    ("canvas", "TargetCanvas"),
    ("gauge", "TargetGauge"),
    ("group", "TargetGroup"),
    ("image", "TargetImage"),
    ("label", "TargetLabel"),
    ("popup", "TargetPopup")
    ]



_targets = {}



#
# Returns the class for the given target name.
#
def get_target_class(name):

    return _targets.get(name)



#
# Returns the names of the targets without their own ID.
#
def no_ids(): return _no_ids[:]



# initialize the registry
for name, clssname in _REGISTRY:
    try:
        module = __import__("display." + clssname, None, None, [clssname])
        clss = getattr(module, clssname)
        _targets[name] = clss

    # ignore errors
    except KeyError:
        print "Error loading target", name
