from main import HOME, NAME
from factory.DisplayFactory import DisplayFactory
from config.ConfigManager import ConfigManager
from utils import singleton
from utils import dialog

from main import _

import os
import gtk


class Starter:

    def __init__(self):

        # the set of open displays
        self.__open_displays = {}

        self.__factory = singleton.get(DisplayFactory)
        self.__config = singleton.get(ConfigManager)


        self.__config.watch("main", "displays", self.__on_watch)

        # make sure we have a valid configuration
        displays = self.__config.get("main", "displays")

        # welcome new users
        if (not displays): self.__first_run()



    #
    # Welcomes new users and sets up the configuration base.
    #
    def __first_run(self):

        name = "<i>" + NAME + "</i>"
        dialog.info(_("Welcome to %(name)s<i>!</i>") % vars(),
                    _("It looks like you are running %(name)s for the first "
                      "time.\n"
                      "\n"
                      "You can add new displays by launching them in your "
                      "file manager.\n"
                      "\n"
                      "<b>Have fun,</b>\n"
                      "  <i>the %(name)s developers</i>") % vars())
        
        self.__config.set("main", "displays", "")



    #
    # Reacts on observer messages from the display.
    #
    def __on_display_action(self, src, cmd, *args):

        if (cmd == src.OBS_CLOSE):
            id = args[0]
            self.__remove_display(id)
            del src

        elif (cmd == src.OBS_RESTART):
            id = args[0]
            self.__restart_display(id)
            del src
            
        #end if



    #
    # Reacts on changes in the list of displays.
    #
    def __on_watch(self, key, value):

        self.__update_display_set(value)



    #
    # Updates display set. Added displays that are not running will be started.
    #
    def __update_display_set(self, displays):

        parts = displays.split(",")
        for p in parts:
            if (not p): continue
            
            id, path = p.split(":")
            if (not self.__open_displays.has_key(id)):
                self.__open_displays[id] = 1
                dsp = self.__create_display(id, path)
                    
                if (dsp): dsp.add_observer(self.__on_display_action)
            #end if
        #end for

        
        


    #
    # Creates and returns a new display from the given data, or None in case
    # of an error.
    #
    def __create_display(self, id, path):

        try:
            fd = open(path, "r")
        except:
            dialog.warning(_("Could not open display file '%(path)s'")
                           % vars(),
                           _("The display file could not be opened because "
                             "the file was not readable."))
            self.__remove_display(id)
            return None
        
        data = fd.read()
        fd.close()

        oldcwd = os.getcwd()
        dir = os.path.dirname(path)

        os.chdir(dir)
        display = self.__factory.create_display(id, data)
        #os.chdir(oldcwd)

        if (not display):
            dialog.warning(_("Invalid display file '%(path)s'") % vars(),
                           _("The display file contains invalid data and "
                             "could not be loaded."))
            self.__remove_display(id)

        return display



    #
    # Removes the given display.
    #
    def __remove_display(self, id):

        print "closing", id
        if (self.__open_displays.has_key(id)): del self.__open_displays[id]
        import gc; gc.collect()
        
        # remove closed display from the list of displays
        displays = self.__config.get("main", "displays").split(",")
        newdisplays = []
        for d in displays:
            if (not d): continue
            did, path = d.split(":")
            if (id != did): newdisplays.append(d)
        #end for

        self.__config.set("main", "displays", ",".join(newdisplays))



    #
    # Restarts the given display.
    #
    def __restart_display(self, id):

        print "restarting", id
        if (self.__open_displays.has_key(id)): del self.__open_displays[id]
        displays = self.__config.get("main", "displays")
        self.__update_display_set(displays)



    #
    # Starts up all displays.
    #
    def start_displays(self):

        displays = self.__config.get("main", "displays")
        self.__on_watch(None, displays)
