/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "popup-commands.h"
#include "galeon-shell.h"

static GaleonWindow *
get_window_from_popup (GaleonEmbedPopup *popup)
{
	return GALEON_WINDOW (g_object_get_data(G_OBJECT(popup), "GaleonWindow"));
}

void popup_cmd_new_window (BonoboUIComponent *uic, 
			   GaleonEmbedPopup *popup, 
			   const char* verbname)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	const GValue *value;

	tab = galeon_window_get_active_tab (get_window_from_popup (popup));
	
	info = galeon_embed_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "link", &value);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);
}

void popup_cmd_new_tab (BonoboUIComponent *uic, 
			GaleonEmbedPopup *popup, 
			const char* verbname)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	GaleonWindow *window;
	const GValue *value;

	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);
	
	info = galeon_embed_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "link", &value);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);
}

void popup_cmd_image_in_new_tab (BonoboUIComponent *uic, 
			         GaleonEmbedPopup *popup, 
			         const char* verbname)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	GaleonWindow *window;
	const GValue *value;

	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);
	
	info = galeon_embed_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "image", &value);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);
}

void popup_cmd_image_in_new_window (BonoboUIComponent *uic, 
			 	    GaleonEmbedPopup *popup, 
				    const char* verbname)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	const GValue *value;

	tab = galeon_window_get_active_tab (get_window_from_popup (popup));
	
	info = galeon_embed_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "image", &value);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);
}

void popup_cmd_add_bookmark (BonoboUIComponent *uic, 
			     GaleonEmbedPopup *popup, 
			     const char* verbname)
{
	GaleonEmbedEvent *info = galeon_embed_popup_get_event (popup);
	const GValue *link_title;
	const GValue *link;
	const char *title;
	const char *location;
	GbBookmarkSet *set;
	GbSite *b;

	galeon_embed_event_get_property (info, "link", &link);
	galeon_embed_event_get_property (info, "link_title", &link_title);
	
	title = g_value_get_string (link_title);
	location = g_value_get_string (link);

	g_return_if_fail (location);
	
	if (!title || !title[0])
	{
		title = location;
	}

	set = galeon_shell_get_bookmark_set (galeon_shell);
	g_return_if_fail (set);

	b = gb_site_new (set, title, location);
	gb_bookmark_set_add_default (set, GB_BOOKMARK (b));
	
}

void popup_cmd_frame_in_new_tab (BonoboUIComponent *uic, 
			         GaleonEmbedPopup *popup, 
			         const char* verbname)
{
	GaleonTab *tab;
	GaleonWindow *window;
	GaleonEmbed *embed;
	char *location;
	
	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);

	tab = galeon_window_get_active_tab (window);

	embed = galeon_window_get_active_embed (window);
	
	galeon_embed_get_location (embed, FALSE, FALSE, &location);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      location, 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);

	g_free (location);
}

void popup_cmd_frame_in_new_window (BonoboUIComponent *uic, 
			 	    GaleonEmbedPopup *popup, 
				    const char* verbname)
{
	GaleonTab *tab;
	GaleonEmbed *embed;
	GaleonWindow *window;
	char *location;
	
	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);

	embed = galeon_window_get_active_embed (window);
	
	galeon_embed_get_location (embed, FALSE, FALSE, &location);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      location, 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);

	g_free (location);	
}

void popup_cmd_add_frame_bookmark (BonoboUIComponent *uic, 
			 	   GaleonEmbedPopup *popup, 
			           const char* verbname)
{
	/* FIXME implement */
}

void popup_cmd_view_source (BonoboUIComponent *uic, 
			    GaleonEmbedPopup *popup, 
			    const char* verbname)
{
	/* FIXME implement */
}
