// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gconfmm/entry.h>
#include <gconfmm/private/entry_p.h>

// -*- Mode: C++; c-basic-offset: 4  -*-
/* $Id: entry.ccg,v 1.3 2002/11/26 19:58:13 murrayc Exp $ */

/* entry.ccg
 *
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gnome 
{
namespace Conf 
{

Entry::Entry(const Glib::ustring& key, const Value& val)
{
  gobject_ = gconf_entry_new(key.c_str(), const_cast<GConfValue*>(val.gobj()));
}

// There is no gconf_entry_copy, so we provide one...
GConfEntry* Entry::entry_copy(const GConfEntry* entry)
{
  if(entry == 0)
    return 0;

  GConfEntry* retval = gconf_entry_new(gconf_entry_get_key(entry), gconf_entry_get_value(entry) );

  gconf_entry_set_schema_name(retval, gconf_entry_get_schema_name(entry) );
  gconf_entry_set_is_default(retval, gconf_entry_get_is_default(entry) );
  gconf_entry_set_is_writable(retval, gconf_entry_get_is_writable(entry) );
  return retval;
}

Value Entry::get_value() const
{
  return Value(gconf_entry_get_value(gobj()), true);
}
  
} /* namespace Conf */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Conf::Entry wrap(GConfEntry* object, bool take_copy /* = false */)
{
  return Gnome::Conf::Entry(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Conf
{


Entry::Entry()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Entry::Entry(const Entry& src)
:
  gobject_ ((src.gobject_) ? entry_copy(src.gobject_) : 0)
{}

Entry::Entry(GConfEntry* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = entry_copy(castitem);
    else
      gobject_ = 0;
  }
}

Entry& Entry::operator=(const Entry& src)
{
  GConfEntry *const new_gobject = (src.gobject_) ? entry_copy(src.gobject_) : 0;

  if(gobject_)
    gconf_entry_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

Entry::~Entry()
{
  if(gobject_)
    gconf_entry_free(gobject_);
}

GConfEntry* Entry::gobj_copy() const
{
  return entry_copy(gobject_);
}

void Entry::set_value(const Value& val)
{
  gconf_entry_set_value(gobj(), (val).gobj());
}

void Entry::set_schema_name(const Glib::ustring& val)
{
  gconf_entry_set_schema_name(gobj(), val.c_str());
}

void Entry::set_is_default(bool is_default)
{
  gconf_entry_set_is_default(gobj(), static_cast<int>(is_default));
}

void Entry::set_is_writable(bool is_writable)
{
  gconf_entry_set_is_writable(gobj(), static_cast<int>(is_writable));
}

Glib::ustring Entry::get_schema_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gconf_entry_get_schema_name(const_cast<GConfEntry*>(gobj())));
}

Glib::ustring Entry::get_key() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gconf_entry_get_key(const_cast<GConfEntry*>(gobj())));
}

bool Entry::get_is_default() const
{
  return gconf_entry_get_is_default(const_cast<GConfEntry*>(gobj()));
}

bool Entry::get_is_writable() const
{
  return gconf_entry_get_is_writable(const_cast<GConfEntry*>(gobj()));
}


} // namespace Conf

} // namespace Gnome


