/* gcp-c-backend.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-c-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <clang-c/Index.h>
#include <gee.h>
#include <gio/gio.h>


#define GCP_TYPE_BACKEND (gcp_backend_get_type ())
#define GCP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND, GcpBackend))
#define GCP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND, GcpBackendClass))
#define GCP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND))
#define GCP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND))
#define GCP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND, GcpBackendClass))

typedef struct _GcpBackend GcpBackend;
typedef struct _GcpBackendClass GcpBackendClass;
typedef struct _GcpBackendPrivate GcpBackendPrivate;

#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;

#define GCP_C_TYPE_BACKEND (gcp_c_backend_get_type ())
#define GCP_C_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_BACKEND, GcpCBackend))
#define GCP_C_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_BACKEND, GcpCBackendClass))
#define GCP_C_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_BACKEND))
#define GCP_C_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_BACKEND))
#define GCP_C_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_BACKEND, GcpCBackendClass))

typedef struct _GcpCBackend GcpCBackend;
typedef struct _GcpCBackendClass GcpCBackendClass;
typedef struct _GcpCBackendPrivate GcpCBackendPrivate;

#define GCP_C_TYPE_COMPILE_ARGS (gcp_c_compile_args_get_type ())
#define GCP_C_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgs))
#define GCP_C_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))
#define GCP_C_IS_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_IS_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_COMPILE_ARGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))

typedef struct _GcpCCompileArgs GcpCCompileArgs;
typedef struct _GcpCCompileArgsClass GcpCCompileArgsClass;

#define GCP_C_TYPE_DOCUMENT (gcp_c_document_get_type ())
#define GCP_C_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocument))
#define GCP_C_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))
#define GCP_C_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_DOCUMENT))
#define GCP_C_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_DOCUMENT))
#define GCP_C_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))

typedef struct _GcpCDocument GcpCDocument;
typedef struct _GcpCDocumentClass GcpCDocumentClass;
#define _clang_disposeIndex0(var) ((var == NULL) ? NULL : (var = (clang_disposeIndex (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_C_TYPE_TRANSLATION_UNIT (gcp_c_translation_unit_get_type ())
#define GCP_C_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnit))
#define GCP_C_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))
#define GCP_C_IS_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_IS_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_TRANSLATION_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))

typedef struct _GcpCTranslationUnit GcpCTranslationUnit;
typedef struct _GcpCTranslationUnitClass GcpCTranslationUnitClass;

#define GCP_TYPE_UNSAVED_FILE (gcp_unsaved_file_get_type ())
typedef struct _GcpUnsavedFile GcpUnsavedFile;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcpBackend {
	GObject parent_instance;
	GcpBackendPrivate * priv;
};

struct _GcpBackendClass {
	GObjectClass parent_class;
	GcpDocument* (*create_document) (GcpBackend* self, GeditDocument* document);
	void (*destroy_document) (GcpBackend* self, GcpDocument* document);
	void (*unregister) (GcpBackend* self, GcpDocument* document);
	void (*on_document_changed) (GcpBackend* self, GcpDocument* doc);
	gchar** (*get_supported_languages) (GcpBackend* self, int* result_length1);
};

struct _GcpCBackend {
	GcpBackend parent_instance;
	GcpCBackendPrivate * priv;
};

struct _GcpCBackendClass {
	GcpBackendClass parent_class;
};

struct _GcpCBackendPrivate {
	void* d_index;
	GcpCCompileArgs* d_compileArgs;
	GeeHashMap* d_documentMap;
	guint d_changedId;
};

struct _GcpUnsavedFile {
	gchar* filename;
	gchar* contents;
	gulong length;
};


static gpointer gcp_c_backend_parent_class = NULL;
static gchar** gcp_c_backend_s_langs;
static gint gcp_c_backend_s_langs_length1;
static gchar** gcp_c_backend_s_langs = NULL;
static gint gcp_c_backend_s_langs_length1 = 0;
static gint _gcp_c_backend_s_langs_size_ = 0;
static GType gcp_c_backend_type_id = 0;

GType gcp_backend_get_type (void) G_GNUC_CONST;
GType gcp_backend_register_type (GTypeModule * module);
GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
GType gcp_c_backend_get_type (void) G_GNUC_CONST;
GType gcp_c_backend_register_type (GTypeModule * module);
GType gcp_c_compile_args_get_type (void) G_GNUC_CONST;
GType gcp_c_compile_args_register_type (GTypeModule * module);
GType gcp_c_document_get_type (void) G_GNUC_CONST;
GType gcp_c_document_register_type (GTypeModule * module);
#define GCP_C_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_TYPE_BACKEND, GcpCBackendPrivate))
enum  {
	GCP_C_BACKEND_DUMMY_PROPERTY,
	GCP_C_BACKEND_INDEX,
	GCP_C_BACKEND_SUPPORTED_LANGUAGES
};
GcpCBackend* gcp_c_backend_new (void);
GcpCBackend* gcp_c_backend_construct (GType object_type);
GcpBackend* gcp_backend_construct (GType object_type);
GcpCCompileArgs* gcp_c_compile_args_new (void);
GcpCCompileArgs* gcp_c_compile_args_construct (GType object_type);
static void gcp_c_backend_on_arguments_changed (GcpCBackend* self, GFile* file);
static void _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed (GcpCCompileArgs* _sender, GFile* file, gpointer self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static void gcp_c_backend_map_document (GcpCBackend* self, GFile* file, GcpCDocument* doc);
static void gcp_c_backend_unmap_document (GcpCBackend* self, GFile* file, GcpCDocument* doc);
static GcpDocument* gcp_c_backend_real_create_document (GcpBackend* base, GeditDocument* document);
GcpCDocument* gcp_c_document_new (GeditDocument* document);
GcpCDocument* gcp_c_document_construct (GType object_type, GeditDocument* document);
GFile* gcp_document_get_location (GcpDocument* self);
void gcp_c_compile_args_monitor (GcpCCompileArgs* self, GFile* file);
static void gcp_c_backend_on_location_changed (GcpCBackend* self, GcpDocument* document, GFile* previous_location);
static void _gcp_c_backend_on_location_changed_gcp_document_location_changed (GcpDocument* _sender, GFile* previous_location, gpointer self);
static void gcp_c_backend_real_destroy_document (GcpBackend* base, GcpDocument* document);
void gcp_c_compile_args_remove_monitor (GcpCCompileArgs* self, GFile* file);
void gcp_backend_destroy_document (GcpBackend* self, GcpDocument* document);
static void gcp_c_backend_parse (GcpCBackend* self, GcpCDocument* doc, gchar** args, int args_length1);
gpointer gcp_c_translation_unit_ref (gpointer instance);
void gcp_c_translation_unit_unref (gpointer instance);
GParamSpec* gcp_c_param_spec_translation_unit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_c_value_set_translation_unit (GValue* value, gpointer v_object);
void gcp_c_value_take_translation_unit (GValue* value, gpointer v_object);
gpointer gcp_c_value_get_translation_unit (const GValue* value);
GType gcp_c_translation_unit_get_type (void) G_GNUC_CONST;
GType gcp_c_translation_unit_register_type (GTypeModule * module);
GcpCTranslationUnit* gcp_c_document_get_translation_unit (GcpCDocument* self);
GType gcp_unsaved_file_get_type (void) G_GNUC_CONST;
GcpUnsavedFile* gcp_unsaved_file_dup (const GcpUnsavedFile* self);
void gcp_unsaved_file_free (GcpUnsavedFile* self);
void gcp_unsaved_file_copy (const GcpUnsavedFile* self, GcpUnsavedFile* dest);
void gcp_unsaved_file_destroy (GcpUnsavedFile* self);
void gcp_c_translation_unit_parse (GcpCTranslationUnit* self, const void* idx, const gchar* source, gchar** args, int args_length1, GcpUnsavedFile* unsaved, int unsaved_length1);
static GcpUnsavedFile* gcp_c_backend_get_unsaved_files (GcpCBackend* self, int* result_length1);
static void _vala_GcpUnsavedFile_array_free (GcpUnsavedFile* array, gint array_length);
void gcp_document_set_tainted (GcpDocument* self, gboolean value);
static void gcp_c_backend_reparse (GcpCBackend* self);
GeeList* gcp_backend_get_documents (GcpBackend* self);
gboolean gcp_document_get_tainted (GcpDocument* self);
void gcp_c_translation_unit_reparse (GcpCTranslationUnit* self, GcpUnsavedFile* unsaved, int unsaved_length1);
gchar** gcp_c_compile_args_get (GcpCCompileArgs* self, GFile* file, int* result_length1);
static void gcp_c_backend_real_on_document_changed (GcpBackend* base, GcpDocument* doc);
void gcp_backend_on_document_changed (GcpBackend* self, GcpDocument* doc);
void gcp_c_translation_unit_set_tainted (GcpCTranslationUnit* self, gboolean value);
static gboolean _lambda10_ (GcpCBackend* self);
static gboolean __lambda10__gsource_func (gpointer self);
const void* gcp_c_backend_get_index (GcpCBackend* self);
const gchar* gcp_document_get_text (GcpDocument* self);
void gcp_unsaved_file_init (GcpUnsavedFile *self, const gchar* f, const gchar* c);
static void gcp_c_backend_finalize (GObject* obj);
gchar** gcp_backend_get_supported_languages (GcpBackend* self, int* result_length1);
static void _vala_gcp_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed (GcpCCompileArgs* _sender, GFile* file, gpointer self) {
	gcp_c_backend_on_arguments_changed (self, file);
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


GcpCBackend* gcp_c_backend_construct (GType object_type) {
	GcpCBackend * self = NULL;
	void* _tmp0_ = NULL;
	GcpCCompileArgs* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	self = (GcpCBackend*) gcp_backend_construct (object_type);
	_tmp0_ = clang_createIndex (TRUE, FALSE);
	_clang_disposeIndex0 (self->priv->d_index);
	self->priv->d_index = _tmp0_;
	_tmp1_ = gcp_c_compile_args_new ();
	_g_object_unref0 (self->priv->d_compileArgs);
	self->priv->d_compileArgs = _tmp1_;
	g_signal_connect_object (self->priv->d_compileArgs, "arguments-changed", (GCallback) _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed, self, 0);
	_tmp2_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
	_g_object_unref0 (self->priv->d_documentMap);
	self->priv->d_documentMap = _tmp2_;
	self->priv->d_changedId = (guint) 0;
	return self;
}


GcpCBackend* gcp_c_backend_new (void) {
	return gcp_c_backend_construct (GCP_C_TYPE_BACKEND);
}


static void gcp_c_backend_map_document (GcpCBackend* self, GFile* file, GcpCDocument* doc) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_documentMap, file);
	if (!_tmp0_) {
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* r;
		_tmp1_ = gee_linked_list_new (GCP_C_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		r = _tmp1_;
		gee_abstract_collection_add ((GeeAbstractCollection*) r, doc);
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_documentMap, file, r);
		_g_object_unref0 (r);
	} else {
		gpointer _tmp2_ = NULL;
		GeeLinkedList* r;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_documentMap, file);
		r = (GeeLinkedList*) _tmp2_;
		gee_abstract_collection_add ((GeeAbstractCollection*) r, doc);
		_g_object_unref0 (r);
	}
}


static void gcp_c_backend_unmap_document (GcpCBackend* self, GFile* file, GcpCDocument* doc) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_documentMap, file);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		GeeLinkedList* r;
		gint _tmp2_;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_documentMap, file);
		r = (GeeLinkedList*) _tmp1_;
		gee_abstract_collection_remove ((GeeAbstractCollection*) r, doc);
		_tmp2_ = gee_collection_get_size ((GeeCollection*) r);
		if (_tmp2_ == 0) {
			gee_abstract_map_unset ((GeeAbstractMap*) self->priv->d_documentMap, file, NULL);
		}
		_g_object_unref0 (r);
	}
}


static void _gcp_c_backend_on_location_changed_gcp_document_location_changed (GcpDocument* _sender, GFile* previous_location, gpointer self) {
	gcp_c_backend_on_location_changed (self, _sender, previous_location);
}


static GcpDocument* gcp_c_backend_real_create_document (GcpBackend* base, GeditDocument* document) {
	GcpCBackend * self;
	GcpDocument* result = NULL;
	GcpCDocument* _tmp0_ = NULL;
	GcpCDocument* doc;
	GFile* _tmp1_ = NULL;
	self = (GcpCBackend*) base;
	g_return_val_if_fail (document != NULL, NULL);
	_tmp0_ = gcp_c_document_new (document);
	doc = _tmp0_;
	_tmp1_ = gcp_document_get_location ((GcpDocument*) doc);
	if (_tmp1_ != NULL) {
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		_tmp2_ = gcp_document_get_location ((GcpDocument*) doc);
		gcp_c_backend_map_document (self, _tmp2_, doc);
		_tmp3_ = gcp_document_get_location ((GcpDocument*) doc);
		gcp_c_compile_args_monitor (self->priv->d_compileArgs, _tmp3_);
	}
	g_signal_connect_object ((GcpDocument*) doc, "location-changed", (GCallback) _gcp_c_backend_on_location_changed_gcp_document_location_changed, self, 0);
	result = (GcpDocument*) doc;
	return result;
}


static void gcp_c_backend_real_destroy_document (GcpBackend* base, GcpDocument* document) {
	GcpCBackend * self;
	GFile* _tmp0_ = NULL;
	self = (GcpCBackend*) base;
	g_return_if_fail (document != NULL);
	_tmp0_ = gcp_document_get_location (document);
	if (_tmp0_ != NULL) {
		GFile* _tmp1_ = NULL;
		GcpDocument* _tmp2_;
		GFile* _tmp3_ = NULL;
		_tmp1_ = gcp_document_get_location (document);
		_tmp2_ = document;
		gcp_c_backend_unmap_document (self, _tmp1_, GCP_C_IS_DOCUMENT (_tmp2_) ? ((GcpCDocument*) _tmp2_) : NULL);
		_tmp3_ = gcp_document_get_location (document);
		gcp_c_compile_args_remove_monitor (self->priv->d_compileArgs, _tmp3_);
	}
	GCP_BACKEND_CLASS (gcp_c_backend_parent_class)->destroy_document (GCP_BACKEND (self), document);
}


static void gcp_c_backend_on_location_changed (GcpCBackend* self, GcpDocument* document, GFile* previous_location) {
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document != NULL);
	if (previous_location != NULL) {
		GcpDocument* _tmp0_;
		_tmp0_ = document;
		gcp_c_backend_unmap_document (self, previous_location, GCP_C_IS_DOCUMENT (_tmp0_) ? ((GcpCDocument*) _tmp0_) : NULL);
		gcp_c_compile_args_remove_monitor (self->priv->d_compileArgs, previous_location);
	}
	_tmp1_ = gcp_document_get_location (document);
	if (_tmp1_ != NULL) {
		GFile* _tmp2_ = NULL;
		GcpDocument* _tmp3_;
		GFile* _tmp4_ = NULL;
		_tmp2_ = gcp_document_get_location (document);
		_tmp3_ = document;
		gcp_c_backend_map_document (self, _tmp2_, GCP_C_IS_DOCUMENT (_tmp3_) ? ((GcpCDocument*) _tmp3_) : NULL);
		_tmp4_ = gcp_document_get_location (document);
		gcp_c_compile_args_monitor (self->priv->d_compileArgs, _tmp4_);
	}
}


static void _vala_GcpUnsavedFile_array_free (GcpUnsavedFile* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gcp_unsaved_file_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void gcp_c_backend_parse (GcpCBackend* self, GcpCDocument* doc, gchar** args, int args_length1) {
	GcpCTranslationUnit* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GcpUnsavedFile* _tmp4_ = NULL;
	gint _tmp5_;
	GcpUnsavedFile* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = gcp_c_document_get_translation_unit (doc);
	_tmp1_ = gcp_document_get_location ((GcpDocument*) doc);
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gcp_c_backend_get_unsaved_files (self, &_tmp5_);
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp5_;
	gcp_c_translation_unit_parse (_tmp0_, self->priv->d_index, _tmp3_, args, args_length1, _tmp6_, _tmp5_);
	_tmp6_ = (_vala_GcpUnsavedFile_array_free (_tmp6_, _tmp6__length1), NULL);
	_g_free0 (_tmp3_);
	gcp_document_set_tainted ((GcpDocument*) doc, FALSE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gcp_c_backend_reparse (GcpCBackend* self) {
	GcpUnsavedFile* _tmp0_ = NULL;
	gint _tmp1_;
	GcpUnsavedFile* uf;
	gint uf_length1;
	gint _uf_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcp_c_backend_get_unsaved_files (self, &_tmp1_);
	uf = _tmp0_;
	uf_length1 = _tmp1_;
	_uf_size_ = _tmp1_;
	{
		GeeList* _tmp2_ = NULL;
		GeeList* _doc_list;
		gint _tmp3_;
		gint _doc_size;
		gint _doc_index;
		_tmp2_ = gcp_backend_get_documents ((GcpBackend*) self);
		_doc_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _doc_list);
		_doc_size = _tmp3_;
		_doc_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			GcpDocument* doc;
			gboolean _tmp5_;
			GcpDocument* _tmp6_;
			GcpCDocument* _tmp7_;
			GcpCDocument* d;
			GcpCTranslationUnit* _tmp8_ = NULL;
			_doc_index = _doc_index + 1;
			if (!(_doc_index < _doc_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_doc_list, _doc_index);
			doc = (GcpDocument*) _tmp4_;
			_tmp5_ = gcp_document_get_tainted (doc);
			if (!_tmp5_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp6_ = doc;
			_tmp7_ = _g_object_ref0 (GCP_C_IS_DOCUMENT (_tmp6_) ? ((GcpCDocument*) _tmp6_) : NULL);
			d = _tmp7_;
			_tmp8_ = gcp_c_document_get_translation_unit (d);
			gcp_c_translation_unit_reparse (_tmp8_, uf, uf_length1);
			gcp_document_set_tainted ((GcpDocument*) d, FALSE);
			_g_object_unref0 (d);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	uf = (_vala_GcpUnsavedFile_array_free (uf, uf_length1), NULL);
}


static void gcp_c_backend_on_arguments_changed (GcpCBackend* self, GFile* file) {
	gboolean _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_documentMap, file);
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = gcp_c_compile_args_get (self->priv->d_compileArgs, file, &_tmp1_);
	args = _tmp2_;
	args_length1 = _tmp1_;
	_args_size_ = _tmp1_;
	if (args == NULL) {
		gchar** _tmp3_ = NULL;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp3_;
		args_length1 = 0;
		_args_size_ = 0;
	}
	{
		gpointer _tmp4_ = NULL;
		GeeLinkedList* _doc_list;
		gint _tmp5_;
		gint _doc_size;
		gint _doc_index;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_documentMap, file);
		_doc_list = (GeeLinkedList*) _tmp4_;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _doc_list);
		_doc_size = _tmp5_;
		_doc_index = -1;
		while (TRUE) {
			gpointer _tmp6_ = NULL;
			GcpCDocument* doc;
			_doc_index = _doc_index + 1;
			if (!(_doc_index < _doc_size)) {
				break;
			}
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _doc_list, _doc_index);
			doc = (GcpCDocument*) _tmp6_;
			gcp_c_backend_parse (self, doc, args, args_length1);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean _lambda10_ (GcpCBackend* self) {
	gboolean result = FALSE;
	self->priv->d_changedId = (guint) 0;
	gcp_c_backend_reparse (self);
	result = FALSE;
	return result;
}


static gboolean __lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda10_ (self);
	return result;
}


static void gcp_c_backend_real_on_document_changed (GcpBackend* base, GcpDocument* doc) {
	GcpCBackend * self;
	GcpDocument* _tmp0_;
	GcpCDocument* _tmp1_;
	GcpCDocument* d;
	GcpCTranslationUnit* _tmp2_ = NULL;
	guint _tmp3_;
	self = (GcpCBackend*) base;
	g_return_if_fail (doc != NULL);
	GCP_BACKEND_CLASS (gcp_c_backend_parent_class)->on_document_changed (GCP_BACKEND (self), doc);
	_tmp0_ = doc;
	_tmp1_ = _g_object_ref0 (GCP_C_IS_DOCUMENT (_tmp0_) ? ((GcpCDocument*) _tmp0_) : NULL);
	d = _tmp1_;
	_tmp2_ = gcp_c_document_get_translation_unit (d);
	gcp_c_translation_unit_set_tainted (_tmp2_, TRUE);
	if (self->priv->d_changedId != 0) {
		g_source_remove (self->priv->d_changedId);
	}
	_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, __lambda10__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->d_changedId = _tmp3_;
	_g_object_unref0 (d);
}


const void* gcp_c_backend_get_index (GcpCBackend* self) {
	const void* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_index;
	return result;
}


static gchar** gcp_c_backend_real_get_supported_languages (GcpBackend* base, int* result_length1) {
	gchar** result;
	GcpCBackend* self;
	gchar** _tmp0_;
	self = (GcpCBackend*) base;
	_tmp0_ = gcp_c_backend_s_langs;
	*result_length1 = gcp_c_backend_s_langs_length1;
	result = _tmp0_;
	return result;
}


static GcpUnsavedFile* gcp_c_backend_get_unsaved_files (GcpCBackend* self, int* result_length1) {
	GcpUnsavedFile* result;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* docs;
	gint _tmp7_;
	GcpUnsavedFile* _tmp8_ = NULL;
	GcpUnsavedFile* ret;
	gint ret_length1;
	gint _ret_size_;
	GcpUnsavedFile* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GCP_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	docs = _tmp0_;
	{
		GeeList* _tmp1_ = NULL;
		GeeList* _doc_list;
		gint _tmp2_;
		gint _doc_size;
		gint _doc_index;
		_tmp1_ = gcp_backend_get_documents ((GcpBackend*) self);
		_doc_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _doc_list);
		_doc_size = _tmp2_;
		_doc_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			GcpDocument* doc;
			gboolean _tmp4_ = FALSE;
			GFile* _tmp5_ = NULL;
			_doc_index = _doc_index + 1;
			if (!(_doc_index < _doc_size)) {
				break;
			}
			_tmp3_ = gee_list_get (_doc_list, _doc_index);
			doc = (GcpDocument*) _tmp3_;
			_tmp5_ = gcp_document_get_location (doc);
			if (_tmp5_ != NULL) {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = gcp_document_get_text (doc);
				_tmp4_ = _tmp6_ != NULL;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gee_abstract_collection_add ((GeeAbstractCollection*) docs, doc);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) docs);
	_tmp8_ = g_new0 (GcpUnsavedFile, _tmp7_);
	ret = _tmp8_;
	ret_length1 = _tmp7_;
	_ret_size_ = _tmp7_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				GcpDocument* _tmp11_;
				GFile* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gpointer _tmp15_ = NULL;
				GcpDocument* _tmp16_;
				const gchar* _tmp17_ = NULL;
				GcpUnsavedFile _tmp18_ = {0};
				GcpUnsavedFile _tmp19_ = {0};
				GcpUnsavedFile _tmp20_;
				if (!_tmp9_) {
					i = i + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < ret_length1)) {
					break;
				}
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) docs, i);
				_tmp11_ = (GcpDocument*) _tmp10_;
				_tmp12_ = gcp_document_get_location (_tmp11_);
				_tmp13_ = g_file_get_path (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) docs, i);
				_tmp16_ = (GcpDocument*) _tmp15_;
				_tmp17_ = gcp_document_get_text (_tmp16_);
				gcp_unsaved_file_init (&_tmp18_, _tmp14_, _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				gcp_unsaved_file_destroy (&ret[i]);
				ret[i] = _tmp20_;
				_g_object_unref0 (_tmp16_);
				_g_free0 (_tmp14_);
				_g_object_unref0 (_tmp11_);
			}
		}
	}
	_tmp21_ = ret;
	*result_length1 = ret_length1;
	result = _tmp21_;
	_g_object_unref0 (docs);
	return result;
}


static void gcp_c_backend_class_init (GcpCBackendClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gcp_c_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpCBackendPrivate));
	GCP_BACKEND_CLASS (klass)->create_document = gcp_c_backend_real_create_document;
	GCP_BACKEND_CLASS (klass)->destroy_document = gcp_c_backend_real_destroy_document;
	GCP_BACKEND_CLASS (klass)->on_document_changed = gcp_c_backend_real_on_document_changed;
	GCP_BACKEND_CLASS (klass)->get_supported_languages = gcp_c_backend_real_get_supported_languages;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_c_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_c_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_C_BACKEND_INDEX, g_param_spec_pointer ("index", "index", "index", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_C_BACKEND_SUPPORTED_LANGUAGES, "supported-languages");
	_tmp0_ = g_strdup ("c");
	_tmp1_ = g_strdup ("cpp");
	_tmp2_ = g_strdup ("chdr");
	_tmp3_ = g_strdup ("objc");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	gcp_c_backend_s_langs = (_vala_array_free (gcp_c_backend_s_langs, gcp_c_backend_s_langs_length1, (GDestroyNotify) g_free), NULL);
	gcp_c_backend_s_langs = _tmp4_;
	gcp_c_backend_s_langs_length1 = 4;
	_gcp_c_backend_s_langs_size_ = 4;
}


static void gcp_c_backend_instance_init (GcpCBackend * self) {
	self->priv = GCP_C_BACKEND_GET_PRIVATE (self);
}


static void gcp_c_backend_finalize (GObject* obj) {
	GcpCBackend * self;
	self = GCP_C_BACKEND (obj);
	_clang_disposeIndex0 (self->priv->d_index);
	_g_object_unref0 (self->priv->d_compileArgs);
	_g_object_unref0 (self->priv->d_documentMap);
	G_OBJECT_CLASS (gcp_c_backend_parent_class)->finalize (obj);
}


GType gcp_c_backend_get_type (void) {
	return gcp_c_backend_type_id;
}


GType gcp_c_backend_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpCBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCBackend), 0, (GInstanceInitFunc) gcp_c_backend_instance_init, NULL };
	gcp_c_backend_type_id = g_type_module_register_type (module, GCP_TYPE_BACKEND, "GcpCBackend", &g_define_type_info, 0);
	return gcp_c_backend_type_id;
}


static void _vala_gcp_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpCBackend * self;
	int length;
	self = GCP_C_BACKEND (object);
	switch (property_id) {
		case GCP_C_BACKEND_INDEX:
		g_value_set_pointer (value, gcp_c_backend_get_index (self));
		break;
		case GCP_C_BACKEND_SUPPORTED_LANGUAGES:
		g_value_set_boxed (value, gcp_backend_get_supported_languages ((GcpBackend*) self, &length));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



