/*-*- java -*-*/

#include <glib.h>
#include <glib-object.h>
#include <gegl.h>
#include <babl/babl.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_BUFFER (test_buffer_get_type ())
#define TEST_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_BUFFER, TestBuffer))
#define TEST_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_BUFFER, TestBufferClass))
#define IS_TEST_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_BUFFER))
#define IS_TEST_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_BUFFER))
#define TEST_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_BUFFER, TestBufferClass))

typedef struct _TestBuffer TestBuffer;
typedef struct _TestBufferClass TestBufferClass;
typedef struct _TestBufferPrivate TestBufferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecTestBuffer ParamSpecTestBuffer;

struct _TestBuffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestBufferPrivate * priv;
};

struct _TestBufferClass {
	GTypeClass parent_class;
	void (*finalize) (TestBuffer *self);
};

struct _ParamSpecTestBuffer {
	GParamSpec parent_instance;
};


static gpointer test_buffer_parent_class = NULL;

gpointer test_buffer_ref (gpointer instance);
void test_buffer_unref (gpointer instance);
GParamSpec* param_spec_test_buffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_buffer (GValue* value, gpointer v_object);
gpointer value_get_test_buffer (const GValue* value);
GType test_buffer_get_type (void);
enum  {
	TEST_BUFFER_DUMMY_PROPERTY
};
static gint test_buffer_main (char** args, int args_length1);
TestBuffer* test_buffer_new (void);
TestBuffer* test_buffer_construct (GType object_type);
static void test_buffer_finalize (TestBuffer* obj);



static gint test_buffer_main (char** args, int args_length1) {
	gint result;
	GeglRectangle rect = {0};
	GeglRectangle sub_rect = {0};
	GeglBuffer* test0;
	GeglBuffer* test1;
	Babl* fmt;
	GeglRectangle _tmp0_ = {0};
	GeglRectangle _tmp1_ = {0};
	GeglBuffer* _tmp2_;
	GeglBuffer* _tmp3_;
	GeglBuffer* _tmp4_;
	GeglBuffer* _tmp5_;
	GeglBuffer* _tmp6_;
	test0 = NULL;
	test1 = NULL;
	fmt = NULL;
	gegl_init (&args_length1, &args);
	rect = (memset (&_tmp0_, 0, sizeof (GeglRectangle)), _tmp0_);
	sub_rect = (memset (&_tmp1_, 0, sizeof (GeglRectangle)), _tmp1_);
	gegl_rectangle_set (&rect, 0, 0, (guint) 512, (guint) 128);
	gegl_rectangle_set (&sub_rect, 128, 32, (guint) 256, (guint) 64);
	fmt = babl_format ("RGBA u8");
	test0 = (_tmp2_ = gegl_buffer_new (&rect, fmt), _g_object_unref0 (test0), _tmp2_);
	test1 = (_tmp3_ = gegl_buffer_dup (test0), _g_object_unref0 (test1), _tmp3_);
	test1 = (_tmp4_ = gegl_buffer_create_sub_buffer (test0, &sub_rect), _g_object_unref0 (test1), _tmp4_);
	test1 = (_tmp5_ = NULL, _g_object_unref0 (test1), _tmp5_);
	test0 = (_tmp6_ = NULL, _g_object_unref0 (test0), _tmp6_);
	gegl_exit ();
	result = 0;
	_g_object_unref0 (test0);
	_g_object_unref0 (test1);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return test_buffer_main (argv, argc);
}


TestBuffer* test_buffer_construct (GType object_type) {
	TestBuffer* self;
	self = (TestBuffer*) g_type_create_instance (object_type);
	return self;
}


TestBuffer* test_buffer_new (void) {
	return test_buffer_construct (TYPE_TEST_BUFFER);
}


static void value_test_buffer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_buffer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_buffer_unref (value->data[0].v_pointer);
	}
}


static void value_test_buffer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_buffer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_buffer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_buffer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestBuffer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_buffer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_buffer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestBuffer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_buffer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_buffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestBuffer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_BUFFER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_buffer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_BUFFER), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_buffer (GValue* value, gpointer v_object) {
	TestBuffer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_BUFFER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_BUFFER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_buffer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_buffer_unref (old);
	}
}


static void test_buffer_class_init (TestBufferClass * klass) {
	test_buffer_parent_class = g_type_class_peek_parent (klass);
	TEST_BUFFER_CLASS (klass)->finalize = test_buffer_finalize;
}


static void test_buffer_instance_init (TestBuffer * self) {
	self->ref_count = 1;
}


static void test_buffer_finalize (TestBuffer* obj) {
	TestBuffer * self;
	self = TEST_BUFFER (obj);
}


GType test_buffer_get_type (void) {
	static GType test_buffer_type_id = 0;
	if (test_buffer_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_test_buffer_init, value_test_buffer_free_value, value_test_buffer_copy_value, value_test_buffer_peek_pointer, "p", value_test_buffer_collect_value, "p", value_test_buffer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestBuffer), 0, (GInstanceInitFunc) test_buffer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		test_buffer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestBuffer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return test_buffer_type_id;
}


gpointer test_buffer_ref (gpointer instance) {
	TestBuffer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_buffer_unref (gpointer instance) {
	TestBuffer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_BUFFER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




