// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GEGLMM_NODE_H
#define _GEGLMM_NODE_H


#include <glibmm.h>

/* libgeglmm - a C++ wrapper for libgegl
 *
 * (c) 2008-2009 Hubert Figuiere
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.
 */

#include <babl/babl.h>

#include <glibmm/object.h>
#include <glibmm/value.h>

#include <geglmm/rectangle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GeglNode GeglNode;
typedef struct _GeglNodeClass GeglNodeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gegl
{ class Node_Class; } // namespace Gegl
namespace Gegl
{

class Processor;
class Operation;

/** @addtogroup geglmmEnums Enums and Flags */

/**
 * @ingroup geglmmEnums
 * @par Bitwise operators:
 * <tt>%BlitFlags operator|(BlitFlags, BlitFlags)</tt><br>
 * <tt>%BlitFlags operator&(BlitFlags, BlitFlags)</tt><br>
 * <tt>%BlitFlags operator^(BlitFlags, BlitFlags)</tt><br>
 * <tt>%BlitFlags operator~(BlitFlags)</tt><br>
 * <tt>%BlitFlags& operator|=(BlitFlags&, BlitFlags)</tt><br>
 * <tt>%BlitFlags& operator&=(BlitFlags&, BlitFlags)</tt><br>
 * <tt>%BlitFlags& operator^=(BlitFlags&, BlitFlags)</tt><br>
 */
enum BlitFlags
{
  BLIT_DEFAULT = 0,
  BLIT_CACHE = 1 << 0,
  BLIT_DIRTY = 1 << 1
};

/** @ingroup geglmmEnums */
inline BlitFlags operator|(BlitFlags lhs, BlitFlags rhs)
  { return static_cast<BlitFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup geglmmEnums */
inline BlitFlags operator&(BlitFlags lhs, BlitFlags rhs)
  { return static_cast<BlitFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup geglmmEnums */
inline BlitFlags operator^(BlitFlags lhs, BlitFlags rhs)
  { return static_cast<BlitFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup geglmmEnums */
inline BlitFlags operator~(BlitFlags flags)
  { return static_cast<BlitFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup geglmmEnums */
inline BlitFlags& operator|=(BlitFlags& lhs, BlitFlags rhs)
  { return (lhs = static_cast<BlitFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup geglmmEnums */
inline BlitFlags& operator&=(BlitFlags& lhs, BlitFlags rhs)
  { return (lhs = static_cast<BlitFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup geglmmEnums */
inline BlitFlags& operator^=(BlitFlags& lhs, BlitFlags rhs)
  { return (lhs = static_cast<BlitFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class Node
	: public Glib::Object
{
	
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Node CppObjectType;
  typedef Node_Class CppClassType;
  typedef GeglNode BaseObjectType;
  typedef GeglNodeClass BaseClassType;

private:  friend class Node_Class;
  static CppClassType node_class_;

private:
  // noncopyable
  Node(const Node&);
  Node& operator=(const Node&);

protected:
  explicit Node(const Glib::ConstructParams& construct_params);
  explicit Node(GeglNode* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Node();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GeglNode*       gobj()       { return reinterpret_cast<GeglNode*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GeglNode* gobj() const { return reinterpret_cast<GeglNode*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GeglNode* gobj_copy();

private:

protected:
	Node();

public:
	
  static Glib::RefPtr<Node> create();


public:
	/** create a new_child
	 * @param first_property_name 
	 */
    Glib::RefPtr<Node> new_child(const Glib::ustring & first_property_name, const Glib::ustring & first_value);
	

  bool connect_from(const Glib::ustring & input_pad_name, const Glib::RefPtr<Node> & source, const Glib::ustring & output_pad_name);
	
  bool connect_to(const Glib::ustring & output_pad_name, const Glib::RefPtr<Node> & sink, const Glib::ustring & input_pad_name);

    /** link the object to a sink. Return the %sink. */
    Glib::RefPtr<Node> link(const Glib::RefPtr<Node> & sink);
    
	
//	_WRAP_METHOD(void link_many(const Glib::RefPtr<Node> & first_sink, ...) G_GNUC_NULL_TERMINATED, gegl_node_link_many)

	
  bool disconnect(const Glib::ustring & input_pad);
	
	
  void set(const Glib::ustring & first_property_name, ...) G_GNUC_NULL_TERMINATED;
  void get(const Glib::ustring & first_property_name, ...) G_GNUC_NULL_TERMINATED;

	
  void blit(double scale, const Rectangle &roi, const Babl * format, void * destination_buf, int rowstride, BlitFlags flags);
	
  void process();

  
  Glib::RefPtr<Node> add_child(const Glib::RefPtr<Node> & child);
  
  Glib::RefPtr<Node> remove_child(const Glib::RefPtr<Node> & child);

	
  Glib::RefPtr<Node> get_parent();
	
  Glib::RefPtr<const Node> get_parent() const;

	
  Glib::RefPtr<Node> detect(int x, int y);
	
  Glib::RefPtr<const Node> detect(int x, int y) const;

	
  GParamSpec* find_property(const Glib::ustring & property_name);
	
  Rectangle get_bounding_box() const;

//TODO: Use the appropriate SListHandle ownership, and add a const version:
	
  Glib::SListHandle< Glib::RefPtr<Node> > get_children();

	
  int get_consumers(const Glib::ustring & output_pad, GeglNode    ***nodes, const gchar ***pads) const;

	
  Glib::RefPtr<Node> get_input_proxy(const Glib::ustring & pad_name);
	
  Glib::RefPtr<const Node> get_input_proxy(const Glib::ustring & pad_name) const;

	
  Glib::RefPtr<Node> get_output_proxy(const Glib::ustring & pad_name);
	
  Glib::RefPtr<const Node> get_output_proxy(const Glib::ustring & pad_name) const;

	
  Glib::ustring get_operation() const;

	// implemented by hand
	//	_WRAP_METHOD(Glib::RefPtr<Node> get_producer(const Glib::ustring & input_pad_name, Glib::ustring * output_pad_name), gegl_node_get_producer)
//TODO: Use a & instead of a * and add an override witout the output_pad_name:
	
	Glib::RefPtr<Node> get_producer(const Glib::ustring & input_pad_name, Glib::ustring * output_pad_name) const;

	
  Glib::RefPtr<Node> create_child(const Glib::ustring & operation);


	template <class T>
	Node & set(const Glib::ustring & _property_name, const T & value);
	template <class T>
	Node & get(const Glib::ustring & _property_name, T & value);

	
  static Glib::RefPtr<Node> new_from_xml(const Glib::ustring & xmldata, const Glib::ustring & path_root);
	
  static Glib::RefPtr<Node> new_from_file(const Glib::ustring & path);
	
  Glib::ustring to_xml(const Glib::ustring & path_root) const;

	
  Glib::RefPtr<Processor> new_processor(const Rectangle & rectangle);

	// Properties.
	#ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GeglOperation instance.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Operation> > property_gegl_operation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GeglOperation instance.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Operation> > property_gegl_operation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of associated GeglOperation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_operation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of associated GeglOperation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_operation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

	#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the node.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the node.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%invalidated(const Rectangle & r)</tt>
   */

  Glib::SignalProxy1< void,const Rectangle & > signal_invalidated();

	
  /**
   * @par Prototype:
   * <tt>void on_my_%computed(const Rectangle & r)</tt>
   */

  Glib::SignalProxy1< void,const Rectangle & > signal_computed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

template <class T>
Node & Node::set(const Glib::ustring & _property_name, const T & value)
{
	Glib::Value<T> v;
	v.init(Glib::Value<T>::value_type());
	v.set(value);
	gegl_node_set_property(gobj(), _property_name.c_str(), v.gobj());
	return *this;
}

template <class T>
Node & Node::get(const Glib::ustring & _property_name, T & value)
{
	Glib::Value<T> v;
	v.init(Glib::Value<T>::value_type());
	gegl_node_get_property(gobj(), _property_name.c_str(), v.gobj());
	value = v.get();
	return *this;
}


}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gegl::Node
   */
  Glib::RefPtr<Gegl::Node> wrap(GeglNode* object, bool take_copy = false);
}


#endif /* _GEGLMM_NODE_H */

