
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <geglmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "buffer.h"
#include "color.h"
#include "curve.h"
#include "matrix3.h"
#include "node.h"
#include "operation.h"
#include "path.h"
#include "processor.h"
#include "rectangle.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gegl_buffer_get_type(void);
GType gegl_color_get_type(void);
GType gegl_curve_get_type(void);
GType gegl_node_get_type(void);
GType gegl_operation_get_type(void);
GType gegl_operation_area_filter_get_type(void);
GType gegl_operation_composer_get_type(void);
GType gegl_operation_filter_get_type(void);
GType gegl_operation_meta_get_type(void);
GType gegl_operation_point_composer_get_type(void);
GType gegl_operation_point_filter_get_type(void);
GType gegl_operation_sink_get_type(void);
GType gegl_operation_source_get_type(void);
GType gegl_path_get_type(void);
GType gegl_processor_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gegl {  class Buffer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Color_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Curve_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Node_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Operation_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationAreaFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationComposer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationMeta_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationPointComposer_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationPointFilter_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationSink_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class OperationSource_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Path_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }
namespace Gegl {  class Processor_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Gegl { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gegl_buffer_get_type(), &Gegl::Buffer_Class::wrap_new);
  Glib::wrap_register(gegl_color_get_type(), &Gegl::Color_Class::wrap_new);
  Glib::wrap_register(gegl_curve_get_type(), &Gegl::Curve_Class::wrap_new);
  Glib::wrap_register(gegl_node_get_type(), &Gegl::Node_Class::wrap_new);
  Glib::wrap_register(gegl_operation_get_type(), &Gegl::Operation_Class::wrap_new);
  Glib::wrap_register(gegl_operation_area_filter_get_type(), &Gegl::OperationAreaFilter_Class::wrap_new);
  Glib::wrap_register(gegl_operation_composer_get_type(), &Gegl::OperationComposer_Class::wrap_new);
  Glib::wrap_register(gegl_operation_filter_get_type(), &Gegl::OperationFilter_Class::wrap_new);
  Glib::wrap_register(gegl_operation_meta_get_type(), &Gegl::OperationMeta_Class::wrap_new);
  Glib::wrap_register(gegl_operation_point_composer_get_type(), &Gegl::OperationPointComposer_Class::wrap_new);
  Glib::wrap_register(gegl_operation_point_filter_get_type(), &Gegl::OperationPointFilter_Class::wrap_new);
  Glib::wrap_register(gegl_operation_sink_get_type(), &Gegl::OperationSink_Class::wrap_new);
  Glib::wrap_register(gegl_operation_source_get_type(), &Gegl::OperationSource_Class::wrap_new);
  Glib::wrap_register(gegl_path_get_type(), &Gegl::Path_Class::wrap_new);
  Glib::wrap_register(gegl_processor_get_type(), &Gegl::Processor_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gegl::Buffer::get_type();
  Gegl::Color::get_type();
  Gegl::Curve::get_type();
  Gegl::Node::get_type();
  Gegl::Operation::get_type();
  Gegl::OperationAreaFilter::get_type();
  Gegl::OperationComposer::get_type();
  Gegl::OperationFilter::get_type();
  Gegl::OperationMeta::get_type();
  Gegl::OperationPointComposer::get_type();
  Gegl::OperationPointFilter::get_type();
  Gegl::OperationSink::get_type();
  Gegl::OperationSource::get_type();
  Gegl::Path::get_type();
  Gegl::Processor::get_type();

} // wrap_init()

} //Gegl


