/* gIDE
 * Copyright (C) 2000 Dave Camp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef GIDE_DOCUMENT_MANAGER_OBJ_H
#define GIDE_DOCUMENT_MANAGER_OBJ_H

#include <bonobo.h>

BEGIN_GNOME_DECLS

typedef struct _GideDocumentManagerObj      GideDocumentManagerObj;
typedef struct _GideDocumentManagerObjClass GideDocumentManagerObjClass;
typedef struct _GideDocumentManagerObjPriv  GideDocumentManagerObjPriv;

struct _GideDocumentManager;

#define GIDE_DOCUMENT_MANAGER_OBJ_TYPE        (gide_document_manager_obj_get_type ())
#define GIDE_DOCUMENT_MANAGER_OBJ(o)          (GTK_CHECK_CAST ((o), GIDE_DOCUMENT_MANAGER_OBJ_TYPE, GideDocumentManagerObj))
#define GIDE_DOCUMENT_MANAGER_OBJ_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GIDE_DOCUMENT_MANAGER_OBJ_TYPE, GideDocumentManagerObjClass))
#define GIDE_IS_DOCUMENT_MANAGER_OBJ(o)       (GTK_CHECK_TYPE ((o), GIDE_DOCUMENT_MANAGER_OBJ_TYPE))
#define GIDE_IS_DOCUMENT_MANAGER_OBJ_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GIDE_DOCUMENT_MANAGER_OBJ_TYPE))

struct _GideDocumentManagerObj {
	BonoboObject parent;
	
	struct _GideDocumentManager *dm;

	GideDocumentManagerObjPriv *priv;
};

struct _GideDocumentManagerObjClass {
	BonoboObjectClass parent_class;
};
GtkType                 gide_document_manager_obj_get_type (void);
GideDocumentManagerObj *gide_document_manager_obj_new      (struct _GideDocumentManager *dm);

END_GNOME_DECLS
#endif
