/* gIDE
 * 
 * Copyright (C) 2001 Dave Camp <dave@ximian.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */


#ifndef __GIDE_DOCUMENT_OBJ_H__
#define __GIDE_DOCUMENT_OBJ_H__

#include <bonobo/bonobo-xobject.h>
#include <bonobo/bonobo-event-source.h>
#include <libgide/libgide.h>

BEGIN_GNOME_DECLS

#define GIDE_DOCUMENT_OBJ_TYPE                (gide_document_obj_get_gtk_type ())
#define GIDE_DOCUMENT_OBJ(o)                  (GTK_CHECK_CAST ((o), GIDE_DOCUMENT_OBJ_TYPE, GideDocumentObj))
#define GIDE_DOCUMENT_OBJ_CLASS(k)            (GTK_CHECK_CLASS_CAST((k), GIDE_DOCUMENT_OBJ_TYPE, GideDocumentObjClass))
#define GIDE_IS_DOCUMENT_OBJ(o)               (GTK_CHECK_TYPE ((o), GIDE_DOCUMENT_OBJ_TYPE))
#define GIDE_IS_DOCUMENT_OBJ_CLASS(k)         (GTK_CHECK_CLASS_TYPE ((k), GIDE_DOCUMENT_OBJ_TYPE))

typedef struct _GideDocumentObj      GideDocumentObj;

struct _GideDocumentObj {
	BonoboXObject parent;
	struct _GideDocument *doc;
};

typedef struct {
	BonoboXObjectClass parent;
	POA_GNOME_Development_Environment_Document__epv epv;
} GideDocumentObjClass;

GtkType          gide_document_obj_get_gtk_type (void);
GideDocumentObj *gide_document_obj_new          (struct _GideDocument *gide_doc);
GideDocumentObj *gide_document_obj_construct    (GideDocumentObj *doc,
						 struct _GideDocument *gide_doc);

END_GNOME_DECLS

#endif
