// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/appinfo.h>
#include <giomm/private/appinfo_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>

namespace Gio
{

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<AppInfo>
AppInfo::create_from_commandline(const std::string& commandline,
                                 const std::string& application_name,
                                 AppInfoCreateFlags flags)
#else
Glib::RefPtr<AppInfo>
AppInfo::create_from_commandline(const std::string& commandline,
                                 const std::string& application_name,
                                 AppInfoCreateFlags flags,
                                 std::auto_ptr<Glib::Error>& error)
#endif // GLIBMM_EXCEPTIONS_ENABLED
{
  GAppInfo* capp_info = 0;
  GError* gerror = 0;

  capp_info = g_app_info_create_from_commandline(commandline.c_str(),
                                                 application_name.c_str(),
                                                 static_cast<GAppInfoCreateFlags>(flags),
                                                 &gerror);

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if (gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if (error)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return Glib::wrap(capp_info);
}

Glib::ListHandle< Glib::RefPtr<AppInfo> > AppInfo::get_all()
{
  return Glib::ListHandle< Glib::RefPtr<AppInfo> >(g_app_info_get_all(), Glib::OWNERSHIP_SHALLOW);
}

Glib::ListHandle< Glib::RefPtr<AppInfo> > AppInfo::get_all_for_type(const std::string& content_type)
{
  return Glib::ListHandle< Glib::RefPtr<AppInfo> >(
    g_app_info_get_all_for_type(content_type.c_str()), Glib::OWNERSHIP_SHALLOW);
}

Glib::RefPtr<AppInfo> AppInfo::get_default_for_type(const std::string& content_type,
                                                    bool must_support_uris)
{
  GAppInfo* cinfo = 0;
  cinfo = g_app_info_get_default_for_type(content_type.c_str(),
                                          static_cast<gboolean>(must_support_uris));
  return Glib::wrap(cinfo);
}

Glib::RefPtr<AppInfo> AppInfo::get_default_for_uri_scheme(const std::string& uri_scheme)
{
  GAppInfo* cinfo = 0;
  cinfo = g_app_info_get_default_for_uri_scheme(uri_scheme.c_str());
  return Glib::wrap(cinfo);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::AppLaunchContext> wrap(GAppLaunchContext* object, bool take_copy)
{
  return Glib::RefPtr<Gio::AppLaunchContext>( dynamic_cast<Gio::AppLaunchContext*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& AppLaunchContext_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &AppLaunchContext_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_app_launch_context_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void AppLaunchContext_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* AppLaunchContext_Class::wrap_new(GObject* object)
{
  return new AppLaunchContext((GAppLaunchContext*)object);
}


/* The implementation: */

GAppLaunchContext* AppLaunchContext::gobj_copy()
{
  reference();
  return gobj();
}

AppLaunchContext::AppLaunchContext(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

AppLaunchContext::AppLaunchContext(GAppLaunchContext* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

AppLaunchContext::~AppLaunchContext()
{}


AppLaunchContext::CppClassType AppLaunchContext::applaunchcontext_class_; // initialize static member

GType AppLaunchContext::get_type()
{
  return applaunchcontext_class_.init().get_type();
}

GType AppLaunchContext::get_base_type()
{
  return g_app_launch_context_get_type();
}


AppLaunchContext::AppLaunchContext()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(applaunchcontext_class_.init()))
{
  

}

Glib::RefPtr<AppLaunchContext> AppLaunchContext::create()
{
  return Glib::RefPtr<AppLaunchContext>( new AppLaunchContext() );
}
std::string AppLaunchContext::get_display(const Glib::RefPtr<AppInfo>& info, const Glib::ListHandle<std::string>& files)
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_app_launch_context_get_display(gobj(), Glib::unwrap(info), files.data()));
}

std::string AppLaunchContext::get_startup_notify_id(const Glib::RefPtr<AppInfo>& info, const Glib::ListHandle<std::string>& files)
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_app_launch_context_get_startup_notify_id(gobj(), Glib::unwrap(info), files.data()));
}

void AppLaunchContext::launch_failed(const std::string& startup_notify_id)
{
g_app_launch_context_launch_failed(gobj(), startup_notify_id.c_str()); 
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


namespace Glib
{

Glib::RefPtr<Gio::AppInfo> wrap(GAppInfo* object, bool take_copy)
{
  return Glib::RefPtr<Gio::AppInfo>( dynamic_cast<Gio::AppInfo*> (Glib::wrap_auto_interface<Gio::AppInfo> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gio
{


/* The *_Class implementation: */

const Glib::Interface_Class& AppInfo_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &AppInfo_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = g_app_info_get_type();
  }

  return *this;
}

void AppInfo_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->dup = &dup_vfunc_callback;
  klass->equal = &equal_vfunc_callback;
  klass->get_id = &get_id_vfunc_callback;
  klass->get_name = &get_name_vfunc_callback;
  klass->get_description = &get_description_vfunc_callback;
  klass->get_executable = &get_executable_vfunc_callback;
  klass->get_icon = &get_icon_vfunc_callback;
  klass->launch = &launch_vfunc_callback;
  klass->supports_uris = &supports_uris_vfunc_callback;
  klass->supports_files = &supports_files_vfunc_callback;
  klass->launch_uris = &launch_uris_vfunc_callback;
  klass->should_show = &should_show_vfunc_callback;
  klass->set_as_default_for_type = &set_as_default_for_type_vfunc_callback;
  klass->set_as_default_for_extension = &set_as_default_for_extension_vfunc_callback;
  klass->add_supports_type = &add_supports_type_vfunc_callback;
  klass->can_remove_supports_type = &can_remove_supports_type_vfunc_callback;
  klass->remove_supports_type = &remove_supports_type_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
GAppInfo* AppInfo_Class::dup_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->dup_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->dup)
    return (*base->dup)(self);


  typedef GAppInfo* RType;
  return RType();
}
gboolean AppInfo_Class::equal_vfunc_callback(GAppInfo* self, GAppInfo* appinfo2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->equal_vfunc(Glib::wrap(appinfo2)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->equal)
    return (*base->equal)(self, appinfo2);


  typedef gboolean RType;
  return RType();
}
const char* AppInfo_Class::get_id_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_id_vfunc().c_str();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_id)
    return (*base->get_id)(self);


  typedef const char* RType;
  return RType();
}
const char* AppInfo_Class::get_name_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_name_vfunc().c_str();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_name)
    return (*base->get_name)(self);


  typedef const char* RType;
  return RType();
}
const char* AppInfo_Class::get_description_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_description_vfunc().c_str();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_description)
    return (*base->get_description)(self);


  typedef const char* RType;
  return RType();
}
const char* AppInfo_Class::get_executable_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_executable_vfunc().c_str();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_executable)
    return (*base->get_executable)(self);


  typedef const char* RType;
  return RType();
}
GIcon* AppInfo_Class::get_icon_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_icon_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_icon)
    return (*base->get_icon)(self);


  typedef GIcon* RType;
  return RType();
}
gboolean AppInfo_Class::launch_vfunc_callback(GAppInfo* self, GList* filenames, GAppLaunchContext* launch_context, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->launch_vfunc(Glib::ListHandle<std::string>(filenames, Glib::OWNERSHIP_NONE)
, Glib::wrap(launch_context)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->launch)
    return (*base->launch)(self, filenames, launch_context, error);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::supports_uris_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->supports_uris_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->supports_uris)
    return (*base->supports_uris)(self);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::supports_files_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->supports_files_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->supports_files)
    return (*base->supports_files)(self);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::launch_uris_vfunc_callback(GAppInfo* self, GList* uris, GAppLaunchContext* launch_context, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->launch_uris_vfunc(Glib::ListHandle<std::string>(uris, Glib::OWNERSHIP_NONE)
, Glib::wrap(launch_context)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->launch_uris)
    return (*base->launch_uris)(self, uris, launch_context, error);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::should_show_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->should_show_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->should_show)
    return (*base->should_show)(self);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::set_as_default_for_type_vfunc_callback(GAppInfo* self, const char* content_type, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->set_as_default_for_type_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(content_type)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_as_default_for_type)
    return (*base->set_as_default_for_type)(self, content_type, error);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::set_as_default_for_extension_vfunc_callback(GAppInfo* self, const char* extension, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->set_as_default_for_extension_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(extension)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_as_default_for_extension)
    return (*base->set_as_default_for_extension)(self, extension, error);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::add_supports_type_vfunc_callback(GAppInfo* self, const char* content_type, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->add_supports_type_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(content_type)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->add_supports_type)
    return (*base->add_supports_type)(self, content_type, error);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::can_remove_supports_type_vfunc_callback(GAppInfo* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->can_remove_supports_type_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->can_remove_supports_type)
    return (*base->can_remove_supports_type)(self);


  typedef gboolean RType;
  return RType();
}
gboolean AppInfo_Class::remove_supports_type_vfunc_callback(GAppInfo* self, const char* content_type, GError** error)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->remove_supports_type_vfunc(Glib::convert_const_gchar_ptr_to_stdstring(content_type)
, error));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->remove_supports_type)
    return (*base->remove_supports_type)(self, content_type, error);


  typedef gboolean RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* AppInfo_Class::wrap_new(GObject* object)
{
  return new AppInfo((GAppInfo*)(object));
}


/* The implementation: */

AppInfo::AppInfo()
:
  Glib::Interface(appinfo_class_.init())
{}

AppInfo::AppInfo(GAppInfo* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

AppInfo::AppInfo(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

AppInfo::~AppInfo()
{}

// static
void AppInfo::add_interface(GType gtype_implementer)
{
  appinfo_class_.init().add_interface(gtype_implementer);
}

AppInfo::CppClassType AppInfo::appinfo_class_; // initialize static member

GType AppInfo::get_type()
{
  return appinfo_class_.init().get_type();
}

GType AppInfo::get_base_type()
{
  return g_app_info_get_type();
}

bool AppInfo::equal(const Glib::RefPtr<AppInfo>& other) const
{
  return g_app_info_equal(const_cast<GAppInfo*>(gobj()), Glib::unwrap(other));
}

std::string AppInfo::get_id() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_app_info_get_id(const_cast<GAppInfo*>(gobj())));
}

std::string AppInfo::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_app_info_get_name(const_cast<GAppInfo*>(gobj())));
}

std::string AppInfo::get_description() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_app_info_get_description(const_cast<GAppInfo*>(gobj())));
}

std::string AppInfo::get_executable() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_app_info_get_executable(const_cast<GAppInfo*>(gobj())));
}

Glib::RefPtr<Icon> AppInfo::get_icon()
{

  Glib::RefPtr<Icon> retvalue = Glib::wrap(g_app_info_get_icon(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

const Glib::RefPtr<const Icon> AppInfo::get_icon() const
{
  return const_cast<AppInfo*>(this)->get_icon();
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::launch(const Glib::ListHandle<std::string>& files, const Glib::RefPtr<AppLaunchContext>& launch_context)
#else
bool AppInfo::launch(const Glib::ListHandle<std::string>& files, const Glib::RefPtr<AppLaunchContext>& launch_context, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_launch(gobj(), files.data(), Glib::unwrap(launch_context), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool AppInfo::supports_uris() const
{
  return g_app_info_supports_uris(const_cast<GAppInfo*>(gobj()));
}

bool AppInfo::supports_files() const
{
  return g_app_info_supports_files(const_cast<GAppInfo*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::launch_uris(const Glib::ListHandle<std::string>& uris, GAppLaunchContext* launch_context)
#else
bool AppInfo::launch_uris(const Glib::ListHandle<std::string>& uris, GAppLaunchContext* launch_context, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_launch_uris(gobj(), uris.data(), launch_context, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool AppInfo::should_show() const
{
  return g_app_info_should_show(const_cast<GAppInfo*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::set_as_default_for_type(const std::string& content_type)
#else
bool AppInfo::set_as_default_for_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_set_as_default_for_type(gobj(), content_type.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::set_as_default_for_extension(const std::string& extension)
#else
bool AppInfo::set_as_default_for_extension(const std::string& extension, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_set_as_default_for_extension(gobj(), extension.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::add_supports_type(const std::string& content_type)
#else
bool AppInfo::add_supports_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_add_supports_type(gobj(), content_type.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool AppInfo::can_remove_supports_type() const
{
  return g_app_info_can_remove_supports_type(const_cast<GAppInfo*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool AppInfo::remove_supports_type(const std::string& content_type)
#else
bool AppInfo::remove_supports_type(const std::string& content_type, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_app_info_remove_supports_type(gobj(), content_type.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
Glib::RefPtr<AppInfo> Gio::AppInfo::dup_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->dup)
    return Glib::wrap((*base->dup)(gobj()));

  typedef Glib::RefPtr<AppInfo> RType;
  return RType();
}
bool Gio::AppInfo::equal_vfunc(const Glib::RefPtr<AppInfo>& appinfo2) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->equal)
    return (*base->equal)(gobj(),Glib::unwrap(appinfo2));

  typedef bool RType;
  return RType();
}
std::string Gio::AppInfo::get_id_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_id)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_id)(const_cast<GAppInfo*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::AppInfo::get_name_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_name)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_name)(const_cast<GAppInfo*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::AppInfo::get_description_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_description)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_description)(const_cast<GAppInfo*>(gobj())));

  typedef std::string RType;
  return RType();
}
std::string Gio::AppInfo::get_executable_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_executable)
    return Glib::convert_const_gchar_ptr_to_stdstring((*base->get_executable)(const_cast<GAppInfo*>(gobj())));

  typedef std::string RType;
  return RType();
}
Glib::RefPtr<Icon> Gio::AppInfo::get_icon_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_icon)
    return Glib::wrap((*base->get_icon)(const_cast<GAppInfo*>(gobj())));

  typedef Glib::RefPtr<Icon> RType;
  return RType();
}
bool Gio::AppInfo::launch_vfunc(const Glib::ListHandle<std::string>& filenames, const Glib::RefPtr<AppLaunchContext>& launch_context, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->launch)
    return (*base->launch)(gobj(),filenames.data(),Glib::unwrap(launch_context),error);

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::supports_uris_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->supports_uris)
    return (*base->supports_uris)(const_cast<GAppInfo*>(gobj()));

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::supports_files_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->supports_files)
    return (*base->supports_files)(const_cast<GAppInfo*>(gobj()));

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::launch_uris_vfunc(const Glib::ListHandle<std::string>& uris, const Glib::RefPtr<AppLaunchContext>& launch_context, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->launch_uris)
    return (*base->launch_uris)(gobj(),uris.data(),Glib::unwrap(launch_context),error);

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::should_show_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->should_show)
    return (*base->should_show)(const_cast<GAppInfo*>(gobj()));

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::set_as_default_for_type_vfunc(const std::string& content_type, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_as_default_for_type)
    return (*base->set_as_default_for_type)(gobj(),content_type.c_str(),error);

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::set_as_default_for_extension_vfunc(const std::string& extension, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_as_default_for_extension)
    return (*base->set_as_default_for_extension)(gobj(),extension.c_str(),error);

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::add_supports_type_vfunc(const std::string& content_type, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->add_supports_type)
    return (*base->add_supports_type)(gobj(),content_type.c_str(),error);

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::can_remove_supports_type_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->can_remove_supports_type)
    return (*base->can_remove_supports_type)(const_cast<GAppInfo*>(gobj()));

  typedef bool RType;
  return RType();
}
bool Gio::AppInfo::remove_supports_type_vfunc(const std::string& content_type, GError** error) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->remove_supports_type)
    return (*base->remove_supports_type)(gobj(),content_type.c_str(),error);

  typedef bool RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


