// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/dbusconnection.h>
#include <giomm/private/dbusconnection_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/dbusauthobserver.h>
#include "slot_async.h"

namespace Gio
{

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init();
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init();
}

void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  // Create the connection, taking an extra reference without returning it.
  // The extra reference is taken so the connection is not destroyed when it
  // goes out of scope.  The finished connection will be returned in the slot
  // by calling create_finish().
  Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid, observer,
    slot, cancellable, flags))->reference();
}

void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  // Create the connection, taking an extra reference without returning it.
  // The extra reference is taken so the connection is not destroyed when it
  // goes out of scope.  The finished connection will be returned in the slot
  // by calling create_finish().
  Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid, observer,
    slot, flags))->reference();
}

Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    observer, cancellable, flags));
}

Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    observer, flags));
}

void DBusConnection::create_for_address(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  // Create the connection, taking an extra reference without returning it.
  // The extra reference is taken so the connection is not destroyed when it
  // goes out of scope.  The finished connection will be returned in the slot
  // by calling create_finish().
  Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer, slot,
    cancellable, flags))->reference();
}

void DBusConnection::create_for_address(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  // Create the connection, taking an extra reference without returning it.
  // The extra reference is taken so the connection is not destroyed when it
  // goes out of scope.  The finished connection will be returned in the slot
  // by calling create_finish().
  Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer, slot,
    flags))->reference();
}

Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer,
    cancellable, flags));
}

Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer,
    flags));
}

void DBusConnection::get(BusType bus_type, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

void DBusConnection::get(BusType bus_type, const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), 0, &SignalProxy_async_callback,
    slot_copy);
}

void DBusConnection::close()
{
  g_dbus_connection_close(gobj(), 0, 0, 0);
}

void DBusConnection::close(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(gobj(),
                    Glib::unwrap(cancellable),
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::close(const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(gobj(),
                    0,
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::close_sync()
{
  GError* gerror = 0;
  g_dbus_connection_close_sync(gobj(), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void DBusConnection::flush()
{
  g_dbus_connection_flush(gobj(), 0, 0, 0);
}

void DBusConnection::flush(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(gobj(),
                    Glib::unwrap(cancellable),
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::flush(const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(gobj(),
                    0,
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::flush_sync()
{
  GError* gerror = 0;
  g_dbus_connection_flush_sync(gobj(), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void DBusConnection::send_message_with_reply(const Glib::RefPtr<DBusMessage>& message, int timeout_msec,const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
                                      static_cast<GDBusSendMessageFlags>(message->get_flags()),
                                      timeout_msec, &out_serial,
                                      Glib::unwrap(cancellable), &SignalProxy_async_callback,
                                      slot_copy);
  message->set_serial(out_serial);
}

void DBusConnection::send_message_with_reply(const Glib::RefPtr<DBusMessage>& message, int timeout_msec,const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
                                      static_cast<GDBusSendMessageFlags>(message->get_flags()),
                                      timeout_msec, &out_serial,
                                      0, &SignalProxy_async_callback,
                                      slot_copy);
  message->set_serial(out_serial);
}

void DBusConnection::call(
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const SlotAsyncReady&                 slot,
  const Glib::RefPtr<Cancellable>&      cancellable,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

// Non-cancellable version.
void DBusConnection::call(
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const SlotAsyncReady&                 slot,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec, 0,
    &SignalProxy_async_callback, slot_copy);
}

void DBusConnection::call_finish(
  Glib::VariantBase&                    output,
  const Glib::RefPtr<AsyncResult>&      res
)
{
  GError* gerror = 0;
  GVariant* const gvariant =
    g_dbus_connection_call_finish(gobj(), Glib::unwrap(res), &gerror);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  output.init(gvariant); // No need for extra ref.
}

void DBusConnection::call_sync(
  Glib::VariantBase&                    output,
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const Glib::RefPtr<Cancellable>&      cancellable,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  GError* gerror = 0;

  GVariant* const gvariant =
    g_dbus_connection_call_sync(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec,
    Glib::unwrap(cancellable), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  output.init(gvariant); // No need to take extra reference.
}

// Non-cancellable version.
void DBusConnection::call_sync(
  Glib::VariantBase&                    output,
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  GError* gerror = 0;

  GVariant* const gvariant =
    g_dbus_connection_call_sync(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec, 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  output.init(gvariant); // No need to take extra reference.
}

void DBusConnection::emit_singal(
  const Glib::ustring&                object_path,
  const Glib::ustring&                interface_name,
  const Glib::ustring&                signal_name,
  const Glib::ustring&                destination_bus_name,
  const Glib::VariantBase&            parameters
)
{
  GError* gerror = 0;

  g_dbus_connection_emit_signal(gobj(),
    destination_bus_name.c_str(), object_path.c_str(), interface_name.c_str(),
    signal_name.c_str(), const_cast<GVariant*>(parameters.gobj()), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::BusType>::value_type()
{
  return g_bus_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::DBusConnection> wrap(GDBusConnection* object, bool take_copy)
{
  return Glib::RefPtr<Gio::DBusConnection>( dynamic_cast<Gio::DBusConnection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& DBusConnection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &DBusConnection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_dbus_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());
  AsyncInitable::add_interface(get_type());

  }

  return *this;
}


void DBusConnection_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* DBusConnection_Class::wrap_new(GObject* object)
{
  return new DBusConnection((GDBusConnection*)object);
}


/* The implementation: */

GDBusConnection* DBusConnection::gobj_copy()
{
  reference();
  return gobj();
}

DBusConnection::DBusConnection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

DBusConnection::DBusConnection(GDBusConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


DBusConnection::~DBusConnection()
{}


DBusConnection::CppClassType DBusConnection::dbusconnection_class_; // initialize static member

GType DBusConnection::get_type()
{
  return dbusconnection_class_.init().get_type();
}


GType DBusConnection::get_base_type()
{
  return g_dbus_connection_get_type();
}


Glib::RefPtr<DBusConnection> DBusConnection::get_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_bus_get_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DBusConnection> DBusConnection::create_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_dbus_connection_new_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_dbus_connection_new_for_address_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


bool DBusConnection::close_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_close_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::close_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_dbus_connection_close_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);


}

bool DBusConnection::flush_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_flush_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::flush_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_dbus_connection_flush_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);


}

bool DBusConnection::send_message(const Glib::RefPtr<DBusMessage>& message, DBusSendMessageFlags flags, guint32* out_serial)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_send_message(gobj(), Glib::unwrap(message), ((GDBusSendMessageFlags)(flags)), (out_serial), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<DBusMessage> DBusConnection::send_message_with_reply_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusMessage> retvalue = Glib::wrap(g_dbus_connection_send_message_with_reply_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::start_message_processing()
{
g_dbus_connection_start_message_processing(gobj()); 
}

bool DBusConnection::is_closed() const
{
  return g_dbus_connection_is_closed(const_cast<GDBusConnection*>(gobj()));
}

Glib::RefPtr<IOStream> DBusConnection::get_stream()
{

  Glib::RefPtr<IOStream> retvalue = Glib::wrap(g_dbus_connection_get_stream(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const IOStream> DBusConnection::get_stream() const
{
  return const_cast<DBusConnection*>(this)->get_stream();
}

Glib::ustring DBusConnection::get_guid() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_dbus_connection_get_guid(const_cast<GDBusConnection*>(gobj())));
}

Glib::ustring DBusConnection::get_unique_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_dbus_connection_get_unique_name(const_cast<GDBusConnection*>(gobj())));
}

Glib::RefPtr<Credentials> DBusConnection::get_peer_credentials()
{

  Glib::RefPtr<Credentials> retvalue = Glib::wrap(g_dbus_connection_get_peer_credentials(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Credentials> DBusConnection::get_peer_credentials() const
{
  return const_cast<DBusConnection*>(this)->get_peer_credentials();
}

bool DBusConnection::get_exit_on_close() const
{
  return g_dbus_connection_get_exit_on_close(const_cast<GDBusConnection*>(gobj()));
}

void DBusConnection::set_exit_on_close(bool exit_on_close)
{
g_dbus_connection_set_exit_on_close(gobj(), static_cast<int>(exit_on_close)); 
}

DBusCapabilityFlags DBusConnection::get_capabilities() const
{
  return ((DBusCapabilityFlags)(g_dbus_connection_get_capabilities(const_cast<GDBusConnection*>(gobj()))));
}


} // namespace Gio


