/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h" // GLOM_ENABLE_CLIENT_ONLY
#include "appstate.h"


namespace Glom
{

AppState::AppState()
#ifdef GLOM_ENABLE_CLIENT_ONLY
: m_userlevel(USERLEVEL_OPERATOR)
#else
: m_userlevel(USERLEVEL_DEVELOPER)
#endif
{
}

AppState::~AppState()
{

}

AppState::userlevels AppState::get_userlevel() const
{
  return m_userlevel;
}

void AppState::set_userlevel(userlevels value)
{
  //Make sure that developer mode is never possible in client-only mode:
  #ifdef GLOM_ENABLE_CLIENT_ONLY
  value = USERLEVEL_OPERATOR;
  #endif //GLOM_ENABLE_CLIENT_ONLY

  if(m_userlevel != value)
  {
    m_userlevel = value;

    //Tell the UI to respond accordingly:
    m_signal_userlevel_changed.emit(value);
  }
}

AppState::type_signal_userlevel_changed AppState::signal_userlevel_changed()
{
  return m_signal_userlevel_changed;
}

void AppState::emit_userlevel_changed()
{
   m_signal_userlevel_changed.emit(m_userlevel);
}

} //namespace Glom

