# Note that this is NOT a relocatable package
%define ver      2.0.3
%define prefix   /usr

Summary: MIME library
Name: gmime
Version: %ver
Release: 1
Copyright: GPL
Group: Development/Libraries
URL: http://www.xtorshun.org/gmime/

Source: http://www.xtorshun.org/gmime/sources/gmime-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

Requires: glib2 >= 2.0.0

%description
GMime is a set of utilities for parsing and creating messages using
the Multipurpose Internet Mail Extension (MIME)

%prep
%setup

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCHFLAG %{config_opts}
fi
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
make

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install


# rename to prevent conflict with uu* utils from sharutils

mv $RPM_BUILD_ROOT%{prefix}/bin/uuencode $RPM_BUILD_ROOT%{prefix}/bin/gmime-uuencode
mv $RPM_BUILD_ROOT%{prefix}/bin/uudecode $RPM_BUILD_ROOT%{prefix}/bin/gmime-uudecode

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc doc/html/* AUTHORS ChangeLog NEWS README COPYING TODO
%{prefix}/bin/*
%{prefix}/lib/*.sh
%{prefix}/lib/libgmime*
%{prefix}/lib/pkgconfig/*
%{prefix}/include/gmime-2.0/gmime/*.h
%{_datadir}/gtk-doc/html/*/*

%changelog
* Wed Dec  9 2002 Benjamin Lee <benjamin.lee@aspectdata.com>
- fixed sharutils conflict with uudecode and uuencode.
- removed duplicate libgmime inclusion in %files.

* Wed Dec  4 2002 Benjamin Lee <benjamin.lee@aspectdata.com>
- fixed files for gtk-doc, pkconfig, and includes.

* Sat Mar 24 2001 Leland Elie <lelie@airmail.net>
- created spec file.
