/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Jeffrey Stedfast <fejj@ximian.com>
 *
 *  Copyright 2000-2002 Ximian, Inc. (www.ximian.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __GMIME_H__
#define __GMIME_H__

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#include <glib.h>
#include <gmime/gmime-error.h>
#include <gmime/gmime-charset.h>
#include <gmime/gmime-iconv.h>
#include <gmime/gmime-iconv-utils.h>
#include <gmime/gmime-param.h>
#include <gmime/gmime-content-type.h>
#include <gmime/gmime-disposition.h>
#include <gmime/gmime-data-wrapper.h>
#include <gmime/gmime-object.h>
#include <gmime/gmime-part.h>
#include <gmime/gmime-multipart.h>
#include <gmime/gmime-multipart-encrypted.h>
#include <gmime/gmime-multipart-signed.h>
#include <gmime/gmime-message.h>
#include <gmime/gmime-message-part.h>
#include <gmime/gmime-message-partial.h>
#include <gmime/internet-address.h>
#include <gmime/gmime-parser.h>
#include <gmime/gmime-utils.h>
#include <gmime/gmime-host-utils.h>
#include <gmime/gmime-stream.h>
#include <gmime/gmime-stream-buffer.h>
#include <gmime/gmime-stream-cat.h>
#include <gmime/gmime-stream-file.h>
#include <gmime/gmime-stream-filter.h>
#include <gmime/gmime-stream-fs.h>
#include <gmime/gmime-stream-mem.h>
#include <gmime/gmime-stream-mmap.h>
#include <gmime/gmime-stream-null.h>
#include <gmime/gmime-filter.h>
#include <gmime/gmime-filter-basic.h>
#include <gmime/gmime-filter-best.h>
#include <gmime/gmime-filter-charset.h>
#include <gmime/gmime-filter-crlf.h>
#include <gmime/gmime-filter-enriched.h>
#include <gmime/gmime-filter-from.h>
#include <gmime/gmime-filter-gzip.h>
#include <gmime/gmime-filter-html.h>
#include <gmime/gmime-filter-md5.h>
#include <gmime/gmime-filter-strip.h>
#include <gmime/gmime-filter-windows.h>
#include <gmime/gmime-filter-yenc.h>
#include <gmime/gmime-session.h>
#include <gmime/gmime-cipher-context.h>
#include <gmime/gmime-gpg-context.h>

/* GMIME version */
static const guint gmime_major_version = 2;
static const guint gmime_minor_version = 1;
static const guint gmime_micro_version = 5;
static const guint gmime_interface_age = 0;
static const guint gmime_binary_age    = 0;

#define GMIME_CHECK_VERSION(major,minor,micro)    \
    (2 > (major) || \
     (2 == (major) && 1 > (minor)) || \
     (2 == (major) && 1 == (minor) && \
      5 >= (micro)))


/**
 * GMIME_INIT_FLAG_UTF8:
 *
 * Initialization flag to enable UTF-8 interfaces throughout GMime.
 *
 * Note: this flag is really a no-op and remains only for backward
 * compatablity. Interfaces will be UTF-8 whether this flag is used or
 * not.
 **/
#define GMIME_INIT_FLAG_UTF8  (1 << 0)

void g_mime_init (guint32 flags);
void g_mime_shutdown (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GMIME_H__ */
