/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gbf_project-tree.c
 *
 * Copyright (C) 2000-2001 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#include <libgnomevfs/gnome-vfs-mime.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <libgnomevfs/gnome-vfs-utils.h>

#include "bfoldo.xpm"
#include "file_h.xpm"
#include "file_c.xpm"
#include "file_unknown.xpm"
#include "file_cpp.xpm"
#include "program.xpm"
#include "shared.xpm"
#include "static.xpm"

#include "images.h"

GdkPixbuf *
image_for_folder (void) 
{
	static GdkPixbuf *pixbuf = NULL;

	if (!pixbuf)
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char **)bfoldo_xpm);
	
	return pixbuf;
}

GdkPixbuf *
image_for_filename (const char *name)
{
	static GHashTable *icons = NULL;
	GdkPixbuf *pixbuf;
	const char *mime, *icon;

	if (!icons) {
		icons = g_hash_table_new (g_str_hash, g_str_equal);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)file_h_xpm);
		g_hash_table_insert (icons, g_strdup ("text/x-h"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)file_c_xpm);
		g_hash_table_insert (icons, g_strdup ("text/x-c"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)file_cpp_xpm);
		g_hash_table_insert (icons, g_strdup ("text/x-c++"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)file_unknown_xpm);
		g_hash_table_insert (icons, g_strdup ("unknown"), pixbuf);
	}
	
	mime = gnome_vfs_mime_type_from_name (name);
	if (mime) {
		pixbuf = g_hash_table_lookup (icons, mime);
		if (pixbuf)
			return pixbuf;
			
		icon = gnome_vfs_mime_get_icon (mime);
		if (icon) {
			char *path = gnome_vfs_icon_path_from_filename (icon);
			if (path) {
				GdkPixbuf *temp;

				temp = gdk_pixbuf_new_from_file (path);
				pixbuf = gdk_pixbuf_scale_simple (temp, 16, 16, GDK_INTERP_TILES);
				gdk_pixbuf_unref (temp);
				g_hash_table_insert (icons, g_strdup (mime), pixbuf);
				g_free (path);
				return pixbuf;
			}
		}
	}
		
	return g_hash_table_lookup (icons, "unknown");
}

GdkPixbuf *
image_for_type (const char *name)
{
	static GHashTable *icons = NULL;
	GdkPixbuf *pixbuf;

	if (!icons) {
		icons = g_hash_table_new (g_str_hash, g_str_equal);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)program_xpm);
		g_hash_table_insert (icons, g_strdup ("program"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)shared_xpm);
		g_hash_table_insert (icons, g_strdup ("shared"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)static_xpm);
		g_hash_table_insert (icons, g_strdup ("static"), pixbuf);
		pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)file_unknown_xpm);
		g_hash_table_insert (icons, g_strdup ("unknown"), pixbuf);
	}

	pixbuf = g_hash_table_lookup (icons, name);
	if (pixbuf)
		return pixbuf;
	
	return g_hash_table_lookup (icons, "unknown");
}


