/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 1999-2000 Dave Camp <campd@oit.edu>
 *                         Martin Baulig <martin@home-of-linux.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#ifndef __GBF_CLIENT_CLIENT_H__
#define __GBF_CLIENT_CLIENT_H__

#include <bonobo.h>
#include "gnome-build.h"

BEGIN_GNOME_DECLS

#define GBF_PROJECT_CLIENT_TYPE		(gbf_project_client_get_type ())
#define GBF_PROJECT_CLIENT(o)		(GTK_CHECK_CAST ((o), GBF_PROJECT_CLIENT_TYPE, GbfProjectClient))
#define GBF_PROJECT_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_CAST((k), GBF_PROJECT_CLIENT_TYPE, GbfProjectClientClass))
#define IS_GBF_PROJECT_CLIENT(o)		(GTK_CHECK_TYPE ((o), GBF_PROJECT_CLIENT_TYPE))
#define IS_GBF_PROJECT_CLIENT_CLASS(k)	(GTK_CHECK_CLASS_TYPE ((k), GBF_PROJECT_CLIENT_TYPE))

typedef GNOME_Development_Project    GBF_Project;
typedef GNOME_Development_BuildType  GBF_BuildType;
typedef GNOME_Development_Source     GBF_Source;
typedef GNOME_Development_SourceList GBF_SourceList;
typedef GNOME_Development_Target     GBF_Target;
typedef GNOME_Development_TargetList GBF_TargetList;
typedef GNOME_Development_BuildError GBF_BuildError;

typedef struct _GbfProjectClient        GbfProjectClient;
typedef struct _GbfProjectClientPrivate GbfProjectClientPrivate;
typedef struct _GbfProjectClientClass   GbfProjectClientClass;

typedef enum {
    GBF_PROJECT_CLIENT_OK,
    GBF_PROJECT_CLIENT_BAD_PARAMS,
    GBF_PROJECT_CLIENT_DOESNT_EXIST,
    GBF_PROJECT_CLIENT_MALFORMED,
} GbfProjectClientResult;


struct _GbfProjectClient {
    GtkObject parent;
    
    CORBA_Object objref;
    GbfProjectClientPrivate *priv;
};

struct _GbfProjectClientClass {
    GtkObjectClass parent_class;
    
    void (*project_loaded) (GbfProjectClient *);
    void (*build_started) (GbfProjectClient *);
    void (*build_error) (GbfProjectClient *);
    void (*build_ended) (GbfProjectClient *);
};

GtkType gbf_project_client_get_type (void);

GbfProjectClient *gbf_project_client_new (const char *iid);
GbfProjectClient *gbf_project_client_new_from_corba (GBF_Project project);
GbfProjectClient *gbf_project_client_new_for_path  (const char *path);

GbfProjectClientResult gbf_project_client_load (GbfProjectClient *prj,
                                                 const char *path);
GbfProjectClientResult gbf_project_client_build (GbfProjectClient *prj,
                                                 GBF_BuildType type);
GbfProjectClientResult gbf_project_client_get_project_root (GbfProjectClient *prj, 
                                                            CORBA_char **ret);

GbfProjectClientResult gbf_project_client_get_targets (GbfProjectClient *prj,
                                                       GBF_TargetList **targets);
GbfProjectClientResult gbf_project_client_get_targets_of_source (GbfProjectClient *prj,
                                                                 GBF_Source *source,
                                                                 GBF_TargetList **targets);

GbfProjectClientResult gbf_project_client_add_target (GbfProjectClient *prj,
                                                      GBF_Target *target);
GbfProjectClientResult gbf_project_client_remove_target (GbfProjectClient *prj,
                                                         GBF_Target *target);

GbfProjectClientResult gbf_project_client_get_sources (GbfProjectClient *prj,
                                                       GBF_SourceList **sources);
GbfProjectClientResult gbf_project_client_get_target_sources (GbfProjectClient *prj,
                                                              GBF_Target *target,
                                                              GBF_SourceList **sources);
GbfProjectClientResult gbf_project_client_add_target_source (GbfProjectClient *prj,
                                                             GBF_Target *target,
                                                             GBF_Source *source);
GbfProjectClientResult gbf_project_client_remove_target_source (GbfProjectClient *prj,
                                                                GBF_Target *target,
                                                                GBF_Source *source);

END_GNOME_DECLS

#endif
