/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* engine-null.h
 *
 * Copyright (C) 2001  JP Rosevear.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _ENGINE_NULL_H_
#define _ENGINE_NULL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "engine.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define ENGINE_TYPE_NULL			(engine_null_get_type ())
#define ENGINE_NULL(obj)			(GTK_CHECK_CAST ((obj), ENGINE_TYPE_NULL, EngineNull))
#define ENGINE_NULL_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), ENGINE_TYPE_NULL, EngineNullClass))
#define ENGINE_IS_NULL(obj)			(GTK_CHECK_TYPE ((obj), ENGINE_TYPE_NULL))
#define ENGINE_IS_NULL_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), ENGINE_TYPE_NULL))


typedef struct _EngineNull        EngineNull;
typedef struct _EngineNullPrivate EngineNullPrivate;
typedef struct _EngineNullClass   EngineNullClass;

struct _EngineNull {
	Engine parent;

	EngineFillMenu fill_menu;
	EngineMove     move;

	EngineNullPrivate *priv;
};

struct _EngineNullClass {
	EngineClass parent_class;
};


GtkType    engine_null_get_type (void);
GtkObject *engine_null_new      (void);

void engine_null_set_fill_menu (EngineNull *engine, EngineFillMenu fill_menu);
void engine_null_set_move (EngineNull *engine, EngineMove move);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _ENGINE_NULL_H_ */
