/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gnome.h>
#include "timer.h"

/* Class signals */
enum {
	EXPIRED_SIGNAL,
	LAST_SIGNAL
};
static gint timer_signals[LAST_SIGNAL] = { 0 };

/* Prototypes */
static void timer_class_init (TimerClass *klass);
static void timer_init (Timer *timer);
static void timer_cb(gpointer data);

guint 
timer_get_type (void) 
{
	static guint timer_type = 0;

         if (!timer_type) {
           GtkTypeInfo timer_info = {
               "Timer",
               sizeof (Timer),
               sizeof (TimerClass),
               (GtkClassInitFunc) timer_class_init,
               (GtkObjectInitFunc) timer_init,
               (GtkArgSetFunc) NULL,
               (GtkArgGetFunc) NULL
             };
             timer_type = gtk_type_unique (gtk_label_get_type (), &timer_info);
           }

         return timer_type;
}

static void 
timer_class_init (TimerClass *klass) 
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) klass;

	timer_signals[EXPIRED_SIGNAL] =
		gtk_signal_new ("expired",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (TimerClass, expired),
				gtk_marshal_NONE__NONE, GTK_TYPE_NONE, 0);

}

static void 
timer_init (Timer *timer) 
{
	timer->sec = 0;
	timer->handlerid = -1;

	gtk_label_set_text(GTK_LABEL(timer),_("0:00"));
}

GtkWidget *
timer_new (gint secs) 
{
	GtkWidget *timer;

	timer = GTK_WIDGET(gtk_type_new(timer_get_type()));
	timer_set(TIMER(timer), secs);	

	return timer;
}

gint 
timer_get (Timer *timer) 
{
	return timer->sec;
}

void 
timer_set (Timer *timer, gint secs) 
{
	char t[10];
	char s;

	timer->sec = secs;
	if (timer->sec < 0)
		s = '-';
	else
		s = ' ';		
	sprintf (t, "%c%d:%.2d", s, abs (timer->sec/60), abs (timer->sec%60));
	gtk_label_set_text (GTK_LABEL (timer), t);
}

void 
timer_start (Timer *timer) 
{
	if (timer->handlerid != -1) return;

	timer->handlerid = gtk_timeout_add (1000, (GtkFunction) timer_cb, 
					    timer);
}

void 
timer_stop (Timer *timer) 
{
	if (timer->handlerid == -1) return;

	gtk_timeout_remove (timer->handlerid);
	timer->handlerid = -1;
}

static void 
timer_cb (gpointer data) 
{
	Timer *timer;

	timer = (Timer *)data;
	timer->sec--;
	timer_set(timer, timer->sec);

	if (timer->sec == 0)
		gtk_signal_emit (GTK_OBJECT (timer),
				 timer_signals[EXPIRED_SIGNAL]);
}

