/* contacts-utils.c generated by valac 0.13.0.32-acab5, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <folks/folks-telepathy.h>
#include <folks/folks.h>
#include <telepathy-glib/telepathy-glib.h>
#include <gee.h>


#define CONTACTS_TYPE_UTILS (contacts_utils_get_type ())
#define CONTACTS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_UTILS, ContactsUtils))
#define CONTACTS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_UTILS, ContactsUtilsClass))
#define CONTACTS_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_UTILS))
#define CONTACTS_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_UTILS))
#define CONTACTS_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_UTILS, ContactsUtilsClass))

typedef struct _ContactsUtils ContactsUtils;
typedef struct _ContactsUtilsClass ContactsUtilsClass;
typedef struct _ContactsUtilsPrivate ContactsUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ContactsUtils {
	GObject parent_instance;
	ContactsUtilsPrivate * priv;
};

struct _ContactsUtilsClass {
	GObjectClass parent_class;
};


static gpointer contacts_utils_parent_class = NULL;

GType contacts_utils_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_UTILS_DUMMY_PROPERTY
};
void contacts_utils_compose_mail (const gchar* email);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label);
void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting);
ContactsUtils* contacts_utils_new (void);
ContactsUtils* contacts_utils_construct (GType object_type);


void contacts_utils_compose_mail (const gchar* email) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (email != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_uri_escape_string (email, "@", FALSE);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat ("mailto:", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		gtk_show_uri (NULL, _tmp3_, (guint32) 0, &_inner_error_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id) {
	TpfPersona* _tmp0_ = NULL;
	TpfPersona* im_persona;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_;
	TpAccount* _tmp3_ = NULL;
	TpAccount* _tmp4_;
	TpAccount* account;
	GHashTable* _tmp5_ = NULL;
	GHashTable* request_dict;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	GValue* _tmp8_ = NULL;
	TpAccountChannelRequest* _tmp9_ = NULL;
	TpAccountChannelRequest* request;
	g_return_if_fail (contact != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = contacts_contact_find_im_persona (contact, protocol, id);
	im_persona = _tmp0_;
	_tmp1_ = folks_persona_get_store ((FolksPersona*) im_persona);
	_tmp2_ = _tmp1_;
	_tmp3_ = tpf_persona_store_get_account (TPF_IS_PERSONA_STORE (_tmp2_) ? ((TpfPersonaStore*) _tmp2_) : NULL);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	account = _tmp4_;
	_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, __vala_GValue_free0_);
	request_dict = _tmp5_;
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp6_);
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_INT);
	g_value_set_int (_tmp7_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp7_);
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_STRING);
	g_value_set_string (_tmp8_, id);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp8_);
	_tmp9_ = tp_account_channel_request_new (account, request_dict, G_MAXINT64);
	request = _tmp9_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Chat", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
	_g_object_unref0 (account);
	_g_object_unref0 (im_persona);
}


gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection) {
	gpointer result = NULL;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* i;
	gboolean _tmp1_;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
	i = _tmp0_;
	_tmp1_ = gee_iterator_next (i);
	if (_tmp1_) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_iterator_get (i);
		result = _tmp2_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label) {
	GtkMenuItem* result = NULL;
	GtkMenuItem* _tmp0_ = NULL;
	GtkMenuItem* mi;
	g_return_val_if_fail (menu != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (label);
	mi = g_object_ref_sink (_tmp0_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	result = mi;
	return result;
}


void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting) {
	gint y = 0;
	gint h = 0;
	gint start;
	GList* _tmp0_ = NULL;
	g_return_if_fail (grid != NULL);
	g_return_if_fail (widget != NULL);
	gtk_container_child_get ((GtkContainer*) grid, widget, "top-attach", &y, "height", &h, NULL);
	start = y + h;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) grid);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				gtk_container_child_get ((GtkContainer*) grid, child, "top-attach", &y, "height", &h, NULL);
				if (y >= start) {
					gtk_container_child_set ((GtkContainer*) grid, child, "top-attach", y + 1, NULL);
				} else {
					gboolean _tmp1_ = FALSE;
					if ((y + h) > start) {
						_tmp1_ = expand_intersecting;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						gtk_container_child_set ((GtkContainer*) grid, child, "height", h + 1, NULL);
					}
				}
			}
		}
		_g_list_free0 (child_collection);
	}
}


ContactsUtils* contacts_utils_construct (GType object_type) {
	ContactsUtils * self = NULL;
	self = (ContactsUtils*) g_object_new (object_type, NULL);
	return self;
}


ContactsUtils* contacts_utils_new (void) {
	return contacts_utils_construct (CONTACTS_TYPE_UTILS);
}


static void contacts_utils_class_init (ContactsUtilsClass * klass) {
	contacts_utils_parent_class = g_type_class_peek_parent (klass);
}


static void contacts_utils_instance_init (ContactsUtils * self) {
}


GType contacts_utils_get_type (void) {
	static volatile gsize contacts_utils_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUtils), 0, (GInstanceInitFunc) contacts_utils_instance_init, NULL };
		GType contacts_utils_type_id;
		contacts_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsUtils", &g_define_type_info, 0);
		g_once_init_leave (&contacts_utils_type_id__volatile, contacts_utils_type_id);
	}
	return contacts_utils_type_id__volatile;
}



