/* GNOME-DB Monikers
 * Copyrigth (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <bonobo/bonobo-i18n.h>
#include <bonobo/bonobo-shlib-factory.h>
#include "gnome-db-monikers.h"

static BonoboObject *
moniker_factory (BonoboGenericFactory *this,
		 const char *object_id,
		 void *data)
{
	g_return_val_if_fail (object_id != NULL, NULL);

	if (!strcmp (object_id, "OAFIID:GNOME_Database_Moniker")) {
		return BONOBO_OBJECT (
			bonobo_moniker_simple_new (
				"database:", moniker_database_resolve));
	}
	else
                gda_log_error (_("Failing to manufacture a '%s'"), object_id);

	return NULL;
}

BONOBO_ACTIVATION_SHLIB_FACTORY ("OAFIID:GNOME_Database_MonikerFactory",
                                 "Bonobo database moniker",
                                 moniker_factory, NULL);
