# Copyright (C) 1999 Dave Camp <campd@oit.edu>
#  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#  

BEGIN {
    print "/* This file is autogenerated from marshaller.in - DO NOT EDIT! */";
    print "#ifndef _GDB_MARSHALL_H_";
    print "#define _GDB_MARSHALL_H_";
    print "\n#include <glib.h>";
    print "#include <stdarg.h>";
    print "\n";
    print "typedef void (*GdbSignalMarshaller)(void (*handler)(),";
    print "                                    gpointer data,";
    print "                                    va_list list);\n";
}
/^[^#]/{
    printf "void GDB_SIGNAL_MARSHALLER";
    i = 1;
    varnames[0] = 0;
    for (i = 1; i <= NF; i++) {
        varid = $i;
        varid = toupper (varid);
        gsub (/\*/, "PTR", varid);
        printf ("_%s", varid);
        varnames[i] = "v" i"";
    }
    print " (void (*handler)(), gpointer data, va_list list);";
}
END {
    print "\n#endif";
}


