
#include <src/Satellite/SatelliteChannel.h>




struct _DVBSatelliteChannelPrivate {
	char* _Polarization;
	guint _SymbolRate;
	gint _DiseqcSource;
};

#define DVB_SATELLITE_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SATELLITE_CHANNEL, DVBSatelliteChannelPrivate))
enum  {
	DVB_SATELLITE_CHANNEL_DUMMY_PROPERTY,
	DVB_SATELLITE_CHANNEL_POLARIZATION,
	DVB_SATELLITE_CHANNEL_SYMBOL_RATE,
	DVB_SATELLITE_CHANNEL_DISEQC_SOURCE
};
static gboolean dvb_satellite_channel_real_is_valid (DVBChannel* base);
static void dvb_satellite_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
static char* dvb_satellite_channel_real_to_string (DVBChannel* base);
static gpointer dvb_satellite_channel_parent_class = NULL;
static void dvb_satellite_channel_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean dvb_satellite_channel_real_is_valid (DVBChannel* base) {
	DVBSatelliteChannel * self;
	gboolean _tmp0;
	gboolean _tmp1;
	self = (DVBSatelliteChannel*) base;
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (DVB_CHANNEL_CLASS (dvb_satellite_channel_parent_class)->is_valid (DVB_CHANNEL (self))) {
		_tmp1 = self->priv->_SymbolRate != 0;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		gboolean _tmp2;
		_tmp2 = FALSE;
		if (_vala_strcmp0 (self->priv->_Polarization, "v") == 0) {
			_tmp2 = TRUE;
		} else {
			_tmp2 = _vala_strcmp0 (self->priv->_Polarization, "h") == 0;
		}
		_tmp0 = (_tmp2);
	} else {
		_tmp0 = FALSE;
	}
	return (_tmp0);
}


static void dvb_satellite_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBSatelliteChannel * self;
	self = (DVBSatelliteChannel*) base;
	g_return_if_fail (source != NULL);
	g_object_set ((GObject*) source, "frequency", dvb_channel_get_Frequency ((DVBChannel*) self), NULL);
	g_object_set ((GObject*) source, "polarity", self->priv->_Polarization, NULL);
	g_object_set ((GObject*) source, "symbol-rate", self->priv->_SymbolRate, NULL);
	g_object_set ((GObject*) source, "diseqc-source", self->priv->_DiseqcSource, NULL);
}


static char* dvb_satellite_channel_real_to_string (DVBChannel* base) {
	DVBSatelliteChannel * self;
	char* _tmp0;
	char* _tmp1;
	self = (DVBSatelliteChannel*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s:%u:%s:%d:%u:%u:%s:%u", dvb_channel_get_Name (DVB_CHANNEL (self)), dvb_channel_get_Frequency (DVB_CHANNEL (self)), self->priv->_Polarization, self->priv->_DiseqcSource, self->priv->_SymbolRate, dvb_channel_get_VideoPID (DVB_CHANNEL (self)), _tmp0 = dvb_channel_get_audio_pids_string (DVB_CHANNEL (self)), dvb_channel_get_Sid (DVB_CHANNEL (self))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


DVBSatelliteChannel* dvb_satellite_channel_construct (GType object_type) {
	DVBSatelliteChannel * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBSatelliteChannel* dvb_satellite_channel_new (void) {
	return dvb_satellite_channel_construct (DVB_TYPE_SATELLITE_CHANNEL);
}


const char* dvb_satellite_channel_get_Polarization (DVBSatelliteChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Polarization;
}


void dvb_satellite_channel_set_Polarization (DVBSatelliteChannel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Polarization = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL), _tmp2);
	g_object_notify ((GObject *) self, "Polarization");
}


guint dvb_satellite_channel_get_SymbolRate (DVBSatelliteChannel* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_SymbolRate;
}


void dvb_satellite_channel_set_SymbolRate (DVBSatelliteChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_SymbolRate = value;
	g_object_notify ((GObject *) self, "SymbolRate");
}


gint dvb_satellite_channel_get_DiseqcSource (DVBSatelliteChannel* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_DiseqcSource;
}


void dvb_satellite_channel_set_DiseqcSource (DVBSatelliteChannel* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_DiseqcSource = value;
	g_object_notify ((GObject *) self, "DiseqcSource");
}


static void dvb_satellite_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSatelliteChannel * self;
	gpointer boxed;
	self = DVB_SATELLITE_CHANNEL (object);
	switch (property_id) {
		case DVB_SATELLITE_CHANNEL_POLARIZATION:
		g_value_set_string (value, dvb_satellite_channel_get_Polarization (self));
		break;
		case DVB_SATELLITE_CHANNEL_SYMBOL_RATE:
		g_value_set_uint (value, dvb_satellite_channel_get_SymbolRate (self));
		break;
		case DVB_SATELLITE_CHANNEL_DISEQC_SOURCE:
		g_value_set_int (value, dvb_satellite_channel_get_DiseqcSource (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_satellite_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSatelliteChannel * self;
	self = DVB_SATELLITE_CHANNEL (object);
	switch (property_id) {
		case DVB_SATELLITE_CHANNEL_POLARIZATION:
		dvb_satellite_channel_set_Polarization (self, g_value_get_string (value));
		break;
		case DVB_SATELLITE_CHANNEL_SYMBOL_RATE:
		dvb_satellite_channel_set_SymbolRate (self, g_value_get_uint (value));
		break;
		case DVB_SATELLITE_CHANNEL_DISEQC_SOURCE:
		dvb_satellite_channel_set_DiseqcSource (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_satellite_channel_class_init (DVBSatelliteChannelClass * klass) {
	dvb_satellite_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSatelliteChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_satellite_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_satellite_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_satellite_channel_finalize;
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_satellite_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_satellite_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_satellite_channel_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_SYMBOL_RATE, g_param_spec_uint ("SymbolRate", "SymbolRate", "SymbolRate", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SATELLITE_CHANNEL_DISEQC_SOURCE, g_param_spec_int ("DiseqcSource", "DiseqcSource", "DiseqcSource", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_satellite_channel_instance_init (DVBSatelliteChannel * self) {
	self->priv = DVB_SATELLITE_CHANNEL_GET_PRIVATE (self);
}


static void dvb_satellite_channel_finalize (GObject* obj) {
	DVBSatelliteChannel * self;
	self = DVB_SATELLITE_CHANNEL (obj);
	self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL);
	G_OBJECT_CLASS (dvb_satellite_channel_parent_class)->finalize (obj);
}


GType dvb_satellite_channel_get_type (void) {
	static GType dvb_satellite_channel_type_id = 0;
	if (dvb_satellite_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteChannel), 0, (GInstanceInitFunc) dvb_satellite_channel_instance_init, NULL };
		dvb_satellite_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBSatelliteChannel", &g_define_type_info, 0);
	}
	return dvb_satellite_channel_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




