/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>


#define TYPE_MEDIA_CONTAINER1 (media_container1_get_type ())
#define MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1))
#define IS_MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER1))
#define MEDIA_CONTAINER1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1Iface))

typedef struct _MediaContainer1 MediaContainer1;
typedef struct _MediaContainer1Iface MediaContainer1Iface;

#define TYPE_MEDIA_OBJECT1 (media_object1_get_type ())
#define MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT1, MediaObject1))
#define IS_MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT1))
#define MEDIA_OBJECT1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT1, MediaObject1Iface))

typedef struct _MediaObject1 MediaObject1;
typedef struct _MediaObject1Iface MediaObject1Iface;

#define DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER (dvb_device_groups_media_container_get_type ())
#define DVB_DEVICE_GROUPS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBDeviceGroupsMediaContainer))
#define DVB_DEVICE_GROUPS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBDeviceGroupsMediaContainerClass))
#define DVB_IS_DEVICE_GROUPS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER))
#define DVB_IS_DEVICE_GROUPS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER))
#define DVB_DEVICE_GROUPS_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBDeviceGroupsMediaContainerClass))

typedef struct _DVBDeviceGroupsMediaContainer DVBDeviceGroupsMediaContainer;
typedef struct _DVBDeviceGroupsMediaContainerClass DVBDeviceGroupsMediaContainerClass;
typedef struct _DVBDeviceGroupsMediaContainerPrivate DVBDeviceGroupsMediaContainerPrivate;

#define DVB_TYPE_CHANNELS_MEDIA_CONTAINER (dvb_channels_media_container_get_type ())
#define DVB_CHANNELS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNELS_MEDIA_CONTAINER, DVBChannelsMediaContainer))
#define DVB_CHANNELS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNELS_MEDIA_CONTAINER, DVBChannelsMediaContainerClass))
#define DVB_IS_CHANNELS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNELS_MEDIA_CONTAINER))
#define DVB_IS_CHANNELS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNELS_MEDIA_CONTAINER))
#define DVB_CHANNELS_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNELS_MEDIA_CONTAINER, DVBChannelsMediaContainerClass))

typedef struct _DVBChannelsMediaContainer DVBChannelsMediaContainer;
typedef struct _DVBChannelsMediaContainerClass DVBChannelsMediaContainerClass;

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;
typedef struct _DVBChannelsMediaContainerPrivate DVBChannelsMediaContainerPrivate;

#define DVB_TYPE_CHANNEL_MEDIA_ITEM (dvb_channel_media_item_get_type ())
#define DVB_CHANNEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_MEDIA_ITEM, DVBChannelMediaItem))
#define DVB_CHANNEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_MEDIA_ITEM, DVBChannelMediaItemClass))
#define DVB_IS_CHANNEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_MEDIA_ITEM))
#define DVB_IS_CHANNEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_MEDIA_ITEM))
#define DVB_CHANNEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_MEDIA_ITEM, DVBChannelMediaItemClass))

typedef struct _DVBChannelMediaItem DVBChannelMediaItem;
typedef struct _DVBChannelMediaItemClass DVBChannelMediaItemClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define TYPE_MEDIA_ITEM1 (media_item1_get_type ())
#define MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM1, MediaItem1))
#define IS_MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM1))
#define MEDIA_ITEM1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM1, MediaItem1Iface))

typedef struct _MediaItem1 MediaItem1;
typedef struct _MediaItem1Iface MediaItem1Iface;
typedef struct _DVBChannelMediaItemPrivate DVBChannelMediaItemPrivate;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _MediaContainer1Iface {
	GTypeInterface parent_iface;
	char** (*get_Items) (MediaContainer1* self, int* result_length1);
	guint (*get_ItemCount) (MediaContainer1* self);
	char** (*get_Containers) (MediaContainer1* self, int* result_length1);
	guint (*get_ContainerCount) (MediaContainer1* self);
};

struct _MediaObject1Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject1* self);
	char* (*get_DisplayName) (MediaObject1* self);
};

/**
     * Holds all device groups
     *
     * It only contains containers only and no items
     */
struct _DVBDeviceGroupsMediaContainer {
	GObject parent_instance;
	DVBDeviceGroupsMediaContainerPrivate * priv;
};

struct _DVBDeviceGroupsMediaContainerClass {
	GObjectClass parent_class;
};

struct _DVBDeviceGroupsMediaContainerPrivate {
	GeeHashMap* containers;
	char* path;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	char** (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, int* result_length1);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1);
	char* (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const char* channels_conf, const char* recordings_dir, const char* name);
	char* (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self);
};

/**
     * Holds a list of channels for a single device group
     *
     * It only contains items only and no containers
     */
struct _DVBChannelsMediaContainer {
	GObject parent_instance;
	DVBChannelsMediaContainerPrivate * priv;
	char* parent;
};

struct _DVBChannelsMediaContainerClass {
	GObjectClass parent_class;
};

struct _DVBChannelsMediaContainerPrivate {
	DVBDeviceGroup* _device_group;
	GeeHashMap* items;
};

struct _MediaItem1Iface {
	GTypeInterface parent_iface;
	char** (*get_URLs) (MediaItem1* self, int* result_length1);
	char* (*get_MIMEType) (MediaItem1* self);
	char* (*get_Type) (MediaItem1* self);
};

/**
     * Holds a single channel
     */
struct _DVBChannelMediaItem {
	GObject parent_instance;
	DVBChannelMediaItemPrivate * priv;
};

struct _DVBChannelMediaItemClass {
	GObjectClass parent_class;
};

struct _DVBChannelMediaItemPrivate {
	DVBChannel* _channel;
	char* parent;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_device_groups_media_container_parent_class = NULL;
static MediaContainer1Iface* dvb_device_groups_media_container_media_container1_parent_iface = NULL;
static MediaObject1Iface* dvb_device_groups_media_container_media_object1_parent_iface = NULL;
static gpointer dvb_channels_media_container_parent_class = NULL;
static MediaContainer1Iface* dvb_channels_media_container_media_container1_parent_iface = NULL;
static MediaObject1Iface* dvb_channels_media_container_media_object1_parent_iface = NULL;
static gpointer dvb_channel_media_item_parent_class = NULL;
static MediaItem1Iface* dvb_channel_media_item_media_item1_parent_iface = NULL;
static MediaObject1Iface* dvb_channel_media_item_media_object1_parent_iface = NULL;
extern DVBDeviceGroupsMediaContainer* dvb_rygel_service_root_container;
DVBDeviceGroupsMediaContainer* dvb_rygel_service_root_container = NULL;

#define DVB_SERVICE_NAME "org.gnome.UPnP.MediaServer1.DVBDaemon"
#define DVB_ROOT_PATH "/org/gnome/UPnP/MediaServer1/DVBDaemon"
#define DVB_GROUP_PATH "/org/gnome/UPnP/MediaServer1/DVBDaemon/Group%u"
#define DVB_CHANNEL_PATH DVB_GROUP_PATH "/Channel%u"
GType media_container1_get_type (void);
GType media_object1_get_type (void);
GType dvb_device_groups_media_container_get_type (void);
GType dvb_channels_media_container_get_type (void);
#define DVB_DEVICE_GROUPS_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBDeviceGroupsMediaContainerPrivate))
enum  {
	DVB_DEVICE_GROUPS_MEDIA_CONTAINER_DUMMY_PROPERTY,
	DVB_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT,
	DVB_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME,
	DVB_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT,
	DVB_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT
};
GType dvb_manager_get_type (void);
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void);
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static void dvb_device_groups_media_container_create_service (DVBDeviceGroupsMediaContainer* self, DVBDeviceGroup* devgroup);
void dvb_device_groups_media_container_create_container_services (DVBDeviceGroupsMediaContainer* self);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DBusGConnection* dvb_utils_get_dbus_connection (void);
DVBChannelsMediaContainer* dvb_channels_media_container_new (DVBDeviceGroup* devgroup, const char* parent);
DVBChannelsMediaContainer* dvb_channels_media_container_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent);
char* dvb_channels_media_container_get_Path (DVBChannelsMediaContainer* self);
void dvb_channels_media_container_create_item_services (DVBChannelsMediaContainer* self);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
static void dvb_device_groups_media_container_on_device_added (DVBDeviceGroupsMediaContainer* self, guint group_id);
static void dvb_device_groups_media_container_on_device_removed (DVBDeviceGroupsMediaContainer* self, guint group_id);
DVBDeviceGroupsMediaContainer* dvb_device_groups_media_container_new (void);
DVBDeviceGroupsMediaContainer* dvb_device_groups_media_container_construct (GType object_type);
GType dvb_id_bus_manager_get_type (void);
static void _dvb_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void _dvb_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self);
static GObject * dvb_device_groups_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_device_groups_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_device_groups_media_container_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_device_groups_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_device_groups_media_container_introspect (DVBDeviceGroupsMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static void dvb_device_groups_media_container_finalize (GObject* obj);
static void dvb_device_groups_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType dvb_channel_media_item_get_type (void);
#define DVB_CHANNELS_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNELS_MEDIA_CONTAINER, DVBChannelsMediaContainerPrivate))
enum  {
	DVB_CHANNELS_MEDIA_CONTAINER_DUMMY_PROPERTY,
	DVB_CHANNELS_MEDIA_CONTAINER_DEVICE_GROUP,
	DVB_CHANNELS_MEDIA_CONTAINER_PATH,
	DVB_CHANNELS_MEDIA_CONTAINER_PARENT,
	DVB_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME,
	DVB_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT,
	DVB_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT
};
static void dvb_channels_media_container_set_device_group (DVBChannelsMediaContainer* self, DVBDeviceGroup* value);
DVBDeviceGroup* dvb_channels_media_container_get_device_group (DVBChannelsMediaContainer* self);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void);
void dvb_channels_media_container_create_service (DVBChannelsMediaContainer* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBChannelMediaItem* dvb_channel_media_item_new (DVBChannel* channel, const char* parent);
DVBChannelMediaItem* dvb_channel_media_item_construct (GType object_type, DVBChannel* channel, const char* parent);
char* dvb_channel_media_item_get_Path (DVBChannelMediaItem* self);
const char* dvb_device_group_get_Name (DVBDeviceGroup* self);
static GObject * dvb_channels_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_channels_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_channels_media_container_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_channels_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_channels_media_container_introspect (DVBChannelsMediaContainer* self, DBusConnection* connection, DBusMessage* message);
static void dvb_channels_media_container_finalize (GObject* obj);
static void dvb_channels_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_channels_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_item1_get_type (void);
#define DVB_CHANNEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_MEDIA_ITEM, DVBChannelMediaItemPrivate))
enum  {
	DVB_CHANNEL_MEDIA_ITEM_DUMMY_PROPERTY,
	DVB_CHANNEL_MEDIA_ITEM_CHANNEL,
	DVB_CHANNEL_MEDIA_ITEM_PATH,
	DVB_CHANNEL_MEDIA_ITEM_PARENT,
	DVB_CHANNEL_MEDIA_ITEM_DISPLAY_NAME,
	DVB_CHANNEL_MEDIA_ITEM_MIME_TYPE,
	DVB_CHANNEL_MEDIA_ITEM_TYPE
};
static void dvb_channel_media_item_set_channel (DVBChannelMediaItem* self, DVBChannel* value);
DVBChannel* dvb_channel_media_item_get_channel (DVBChannelMediaItem* self);
guint dvb_channel_get_GroupId (DVBChannel* self);
const char* dvb_channel_get_Name (DVBChannel* self);
char* dvb_channel_get_URL (DVBChannel* self);
void dvb_channel_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_channel_media_item_dbus_unregister (DBusConnection* connection, void* user_data);
DBusHandlerResult dvb_channel_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusMessage* _dbus_dvb_channel_media_item_introspect (DVBChannelMediaItem* self, DBusConnection* connection, DBusMessage* message);
static void dvb_channel_media_item_finalize (GObject* obj);
static void dvb_channel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_channel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
guint _dynamic_RequestName1 (DBusGProxy* self, const char* param1, guint param2, GError** error);
char* media_object1_get_Parent (MediaObject1* self);
gboolean dvb_rygel_service_start_rygel_services (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_device_groups_media_container_dbus_path_vtable = {_dvb_device_groups_media_container_dbus_unregister, dvb_device_groups_media_container_dbus_message};
static const _DBusObjectVTable _dvb_device_groups_media_container_dbus_vtable = {dvb_device_groups_media_container_dbus_register_object};
static const DBusObjectPathVTable _dvb_channels_media_container_dbus_path_vtable = {_dvb_channels_media_container_dbus_unregister, dvb_channels_media_container_dbus_message};
static const _DBusObjectVTable _dvb_channels_media_container_dbus_vtable = {dvb_channels_media_container_dbus_register_object};
static const DBusObjectPathVTable _dvb_channel_media_item_dbus_path_vtable = {_dvb_channel_media_item_dbus_unregister, dvb_channel_media_item_dbus_message};
static const _DBusObjectVTable _dvb_channel_media_item_dbus_vtable = {dvb_channel_media_item_dbus_register_object};


void dvb_device_groups_media_container_create_container_services (DVBDeviceGroupsMediaContainer* self) {
	DVBManager* _tmp0_;
	DVBManager* manager;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	manager = (_tmp0_ = dvb_manager_get_instance (), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	{
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _devgroup_it;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		_devgroup_it = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) (_tmp1_ = dvb_manager_get_device_groups (manager))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_object_unref (_tmp1_), NULL)), _tmp2_);
		while (TRUE) {
			DVBDeviceGroup* devgroup;
			if (!gee_iterator_next (_devgroup_it)) {
				break;
			}
			devgroup = (DVBDeviceGroup*) gee_iterator_get (_devgroup_it);
			dvb_device_groups_media_container_create_service (self, devgroup);
			(devgroup == NULL) ? NULL : (devgroup = (g_object_unref (devgroup), NULL));
		}
		(_devgroup_it == NULL) ? NULL : (_devgroup_it = (g_object_unref (_devgroup_it), NULL));
	}
	(manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL));
}


static void dvb_device_groups_media_container_create_service (DVBDeviceGroupsMediaContainer* self, DVBDeviceGroup* devgroup) {
	DBusGConnection* conn;
	DVBChannelsMediaContainer* devgroup_container;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devgroup != NULL);
	g_debug ("Services.vala:59: Creating container for device group %u", dvb_device_group_get_Id (devgroup));
	conn = dvb_utils_get_dbus_connection ();
	if (conn == NULL) {
		g_critical ("Services.vala:63: Could not get DBus connection");
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		return;
	}
	devgroup_container = dvb_channels_media_container_new (devgroup, self->priv->path);
	_tmp0_ = NULL;
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp0_ = dvb_channels_media_container_get_Path (devgroup_container), (GObject*) devgroup_container);
	_tmp0_ = (g_free (_tmp0_), NULL);
	dvb_channels_media_container_create_item_services (devgroup_container);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (dvb_device_group_get_Id (devgroup)), devgroup_container);
	(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
	(devgroup_container == NULL) ? NULL : (devgroup_container = (g_object_unref (devgroup_container), NULL));
}


static void dvb_device_groups_media_container_on_device_added (DVBDeviceGroupsMediaContainer* self, guint group_id) {
	DVBManager* _tmp0_;
	DVBManager* manager;
	DVBDeviceGroup* devgroup;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	manager = (_tmp0_ = dvb_manager_get_instance (), (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	devgroup = dvb_manager_get_device_group_if_exists (manager, group_id);
	dvb_device_groups_media_container_create_service (self, devgroup);
	g_signal_emit_by_name ((MediaContainer1*) self, "updated");
	(manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL));
	(devgroup == NULL) ? NULL : (devgroup = (g_object_unref (devgroup), NULL));
}


static void dvb_device_groups_media_container_on_device_removed (DVBDeviceGroupsMediaContainer* self, guint group_id) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_remove ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (group_id), NULL);
	g_signal_emit_by_name ((MediaContainer1*) self, "updated");
}


/**
     * Holds all device groups
     *
     * It only contains containers only and no items
     */
DVBDeviceGroupsMediaContainer* dvb_device_groups_media_container_construct (GType object_type) {
	DVBDeviceGroupsMediaContainer * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBDeviceGroupsMediaContainer* dvb_device_groups_media_container_new (void) {
	return dvb_device_groups_media_container_construct (DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER);
}


static char* dvb_device_groups_media_container_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBDeviceGroupsMediaContainer* self;
	const char* _tmp0_;
	self = (DVBDeviceGroupsMediaContainer*) base;
	/* root container => ref to itsself*/
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->path, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static char* dvb_device_groups_media_container_real_get_DisplayName (MediaObject1* base) {
	char* result;
	DVBDeviceGroupsMediaContainer* self;
	self = (DVBDeviceGroupsMediaContainer*) base;
	result = g_strdup ("@REALNAME@'s TV on @HOSTNAME@");
	return result;
}


static char** dvb_device_groups_media_container_real_get_Items (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBDeviceGroupsMediaContainer* self;
	char** _tmp0_;
	self = (DVBDeviceGroupsMediaContainer*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = g_new0 (char*, 0 + 1), *result_length1 = 0, _tmp0_);
	return result;
}


static guint dvb_device_groups_media_container_real_get_ItemCount (MediaContainer1* base) {
	guint result;
	DVBDeviceGroupsMediaContainer* self;
	self = (DVBDeviceGroupsMediaContainer*) base;
	result = (guint) 0;
	return result;
}


static char** dvb_device_groups_media_container_real_get_Containers (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBDeviceGroupsMediaContainer* self;
	char** _tmp1_;
	gint paths_size;
	gint paths_length1;
	gint _tmp0_;
	char** paths;
	gint i;
	char** _tmp6_;
	self = (DVBDeviceGroupsMediaContainer*) base;
	_tmp1_ = NULL;
	paths = (_tmp1_ = g_new0 (char*, (_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->containers)) + 1), paths_length1 = _tmp0_, paths_size = paths_length1, _tmp1_);
	i = 0;
	{
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _container_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_container_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) self->priv->containers))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_object_unref (_tmp2_), NULL)), _tmp3_);
		while (TRUE) {
			DVBChannelsMediaContainer* container;
			char* _tmp5_;
			char* _tmp4_;
			if (!gee_iterator_next (_container_it)) {
				break;
			}
			container = (DVBChannelsMediaContainer*) gee_iterator_get (_container_it);
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			paths[i] = (_tmp5_ = g_strdup (_tmp4_ = dvb_channels_media_container_get_Path (container)), paths[i] = (g_free (paths[i]), NULL), _tmp5_);
			_tmp4_ = (g_free (_tmp4_), NULL);
			i++;
			(container == NULL) ? NULL : (container = (g_object_unref (container), NULL));
		}
		(_container_it == NULL) ? NULL : (_container_it = (g_object_unref (_container_it), NULL));
	}
	_tmp6_ = NULL;
	result = (_tmp6_ = paths, *result_length1 = paths_length1, _tmp6_);
	return result;
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
}


static guint dvb_device_groups_media_container_real_get_ContainerCount (MediaContainer1* base) {
	guint result;
	DVBDeviceGroupsMediaContainer* self;
	self = (DVBDeviceGroupsMediaContainer*) base;
	result = (guint) gee_map_get_size ((GeeMap*) self->priv->containers);
	return result;
}


static void _dvb_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_device_groups_media_container_on_device_added (self, group_id);
}


static void _dvb_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_device_groups_media_container_on_device_removed (self, group_id);
}


static GObject * dvb_device_groups_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBDeviceGroupsMediaContainerClass * klass;
	GObjectClass * parent_class;
	DVBDeviceGroupsMediaContainer * self;
	klass = DVB_DEVICE_GROUPS_MEDIA_CONTAINER_CLASS (g_type_class_peek (DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_DEVICE_GROUPS_MEDIA_CONTAINER (obj);
	{
		GeeHashMap* _tmp0_;
		DVBManager* _tmp1_;
		DVBManager* manager;
		char* _tmp2_;
		_tmp0_ = NULL;
		self->priv->containers = (_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNELS_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->containers == NULL) ? NULL : (self->priv->containers = (g_object_unref (self->priv->containers), NULL)), _tmp0_);
		_tmp1_ = NULL;
		manager = (_tmp1_ = dvb_manager_get_instance (), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
		g_signal_connect_object ((DVBIDBusManager*) manager, "group-added", (GCallback) _dvb_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added, self, 0);
		g_signal_connect_object ((DVBIDBusManager*) manager, "group-removed", (GCallback) _dvb_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed, self, 0);
		_tmp2_ = NULL;
		self->priv->path = (_tmp2_ = g_strdup (DVB_ROOT_PATH), self->priv->path = (g_free (self->priv->path), NULL), _tmp2_);
		(manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL));
	}
	return obj;
}


void _dvb_device_groups_media_container_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_device_groups_media_container_introspect (DVBDeviceGroupsMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_device_groups_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_device_groups_media_container_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_container1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_device_groups_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_device_groups_media_container_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


static void dvb_device_groups_media_container_class_init (DVBDeviceGroupsMediaContainerClass * klass) {
	dvb_device_groups_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDeviceGroupsMediaContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_device_groups_media_container_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_device_groups_media_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_groups_media_container_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT, "ContainerCount");
	g_type_set_qdata (DVB_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_device_groups_media_container_dbus_vtable));
}


static void dvb_device_groups_media_container_media_container1_interface_init (MediaContainer1Iface * iface) {
	dvb_device_groups_media_container_media_container1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Items = dvb_device_groups_media_container_real_get_Items;
	iface->get_ItemCount = dvb_device_groups_media_container_real_get_ItemCount;
	iface->get_Containers = dvb_device_groups_media_container_real_get_Containers;
	iface->get_ContainerCount = dvb_device_groups_media_container_real_get_ContainerCount;
}


static void dvb_device_groups_media_container_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_device_groups_media_container_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_device_groups_media_container_real_get_Parent;
	iface->get_DisplayName = dvb_device_groups_media_container_real_get_DisplayName;
}


static void dvb_device_groups_media_container_instance_init (DVBDeviceGroupsMediaContainer * self) {
	self->priv = DVB_DEVICE_GROUPS_MEDIA_CONTAINER_GET_PRIVATE (self);
}


static void dvb_device_groups_media_container_finalize (GObject* obj) {
	DVBDeviceGroupsMediaContainer * self;
	self = DVB_DEVICE_GROUPS_MEDIA_CONTAINER (obj);
	(self->priv->containers == NULL) ? NULL : (self->priv->containers = (g_object_unref (self->priv->containers), NULL));
	self->priv->path = (g_free (self->priv->path), NULL);
	G_OBJECT_CLASS (dvb_device_groups_media_container_parent_class)->finalize (obj);
}


GType dvb_device_groups_media_container_get_type (void) {
	static GType dvb_device_groups_media_container_type_id = 0;
	if (dvb_device_groups_media_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceGroupsMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_groups_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDeviceGroupsMediaContainer), 0, (GInstanceInitFunc) dvb_device_groups_media_container_instance_init, NULL };
		static const GInterfaceInfo media_container1_info = { (GInterfaceInitFunc) dvb_device_groups_media_container_media_container1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_device_groups_media_container_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_device_groups_media_container_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDeviceGroupsMediaContainer", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_device_groups_media_container_type_id, TYPE_MEDIA_CONTAINER1, &media_container1_info);
		g_type_add_interface_static (dvb_device_groups_media_container_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
	}
	return dvb_device_groups_media_container_type_id;
}


static void dvb_device_groups_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDeviceGroupsMediaContainer * self;
	gpointer boxed;
	self = DVB_DEVICE_GROUPS_MEDIA_CONTAINER (object);
	switch (property_id) {
		case DVB_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT:
		g_value_set_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME:
		g_value_set_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT:
		g_value_set_uint (value, media_container1_get_ItemCount ((MediaContainer1*) self));
		break;
		case DVB_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT:
		g_value_set_uint (value, media_container1_get_ContainerCount ((MediaContainer1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelsMediaContainer* dvb_channels_media_container_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent) {
	GParameter * __params;
	GParameter * __params_it;
	DVBChannelsMediaContainer * self;
	char* _tmp1_;
	const char* _tmp0_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "device-group";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE_GROUP);
	g_value_set_object (&__params_it->value, devgroup);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->parent = (_tmp1_ = (_tmp0_ = parent, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->parent = (g_free (self->parent), NULL), _tmp1_);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBChannelsMediaContainer* dvb_channels_media_container_new (DVBDeviceGroup* devgroup, const char* parent) {
	return dvb_channels_media_container_construct (DVB_TYPE_CHANNELS_MEDIA_CONTAINER, devgroup, parent);
}


void dvb_channels_media_container_create_item_services (DVBChannelsMediaContainer* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _channel_it;
		_channel_it = gee_iterable_iterator ((GeeIterable*) dvb_device_group_get_Channels (self->priv->_device_group));
		while (TRUE) {
			DVBChannel* channel;
			if (!gee_iterator_next (_channel_it)) {
				break;
			}
			channel = (DVBChannel*) gee_iterator_get (_channel_it);
			dvb_channels_media_container_create_service (self, channel);
			(channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL));
		}
		(_channel_it == NULL) ? NULL : (_channel_it = (g_object_unref (_channel_it), NULL));
	}
}


void dvb_channels_media_container_create_service (DVBChannelsMediaContainer* self, DVBChannel* channel) {
	DBusGConnection* conn;
	char* _tmp1_;
	char* _tmp0_;
	DVBChannelMediaItem* _tmp2_;
	DVBChannelMediaItem* channel_item;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_debug ("Services.vala:168: Creating container for channel %u", dvb_channel_get_Sid (channel));
	conn = dvb_utils_get_dbus_connection ();
	if (conn == NULL) {
		g_critical ("Services.vala:172: Could not get DBus connection");
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		return;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	channel_item = (_tmp2_ = dvb_channel_media_item_new (channel, _tmp1_ = g_strdup (_tmp0_ = dvb_channels_media_container_get_Path (self))), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp3_ = dvb_channel_media_item_get_Path (channel_item), (GObject*) channel_item);
	_tmp3_ = (g_free (_tmp3_), NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->items, GUINT_TO_POINTER (dvb_channel_get_Sid (channel)), channel_item);
	(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
	(channel_item == NULL) ? NULL : (channel_item = (g_object_unref (channel_item), NULL));
}


DVBDeviceGroup* dvb_channels_media_container_get_device_group (DVBChannelsMediaContainer* self) {
	DVBDeviceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_device_group;
	return result;
}


static void dvb_channels_media_container_set_device_group (DVBChannelsMediaContainer* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp1_;
	DVBDeviceGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_device_group = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_device_group == NULL) ? NULL : (self->priv->_device_group = (g_object_unref (self->priv->_device_group), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "device-group");
}


char* dvb_channels_media_container_get_Path (DVBChannelsMediaContainer* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf (DVB_GROUP_PATH, dvb_device_group_get_Id (self->priv->_device_group));
	return result;
}


static char* dvb_channels_media_container_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBChannelsMediaContainer* self;
	const char* _tmp0_;
	self = (DVBChannelsMediaContainer*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = self->parent, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static char* dvb_channels_media_container_real_get_DisplayName (MediaObject1* base) {
	char* result;
	DVBChannelsMediaContainer* self;
	const char* _tmp0_;
	self = (DVBChannelsMediaContainer*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = dvb_device_group_get_Name (self->priv->_device_group), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static char** dvb_channels_media_container_real_get_Items (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBChannelsMediaContainer* self;
	char** _tmp1_;
	gint paths_size;
	gint paths_length1;
	gint _tmp0_;
	char** paths;
	gint i;
	char** _tmp6_;
	self = (DVBChannelsMediaContainer*) base;
	_tmp1_ = NULL;
	paths = (_tmp1_ = g_new0 (char*, (_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->items)) + 1), paths_length1 = _tmp0_, paths_size = paths_length1, _tmp1_);
	i = 0;
	{
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _item_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_item_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) self->priv->items))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_object_unref (_tmp2_), NULL)), _tmp3_);
		while (TRUE) {
			DVBChannelMediaItem* item;
			char* _tmp5_;
			char* _tmp4_;
			if (!gee_iterator_next (_item_it)) {
				break;
			}
			item = (DVBChannelMediaItem*) gee_iterator_get (_item_it);
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			paths[i] = (_tmp5_ = g_strdup (_tmp4_ = dvb_channel_media_item_get_Path (item)), paths[i] = (g_free (paths[i]), NULL), _tmp5_);
			_tmp4_ = (g_free (_tmp4_), NULL);
			i++;
			(item == NULL) ? NULL : (item = (g_object_unref (item), NULL));
		}
		(_item_it == NULL) ? NULL : (_item_it = (g_object_unref (_item_it), NULL));
	}
	_tmp6_ = NULL;
	result = (_tmp6_ = paths, *result_length1 = paths_length1, _tmp6_);
	return result;
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
}


static guint dvb_channels_media_container_real_get_ItemCount (MediaContainer1* base) {
	guint result;
	DVBChannelsMediaContainer* self;
	self = (DVBChannelsMediaContainer*) base;
	result = (guint) gee_map_get_size ((GeeMap*) self->priv->items);
	return result;
}


static char** dvb_channels_media_container_real_get_Containers (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBChannelsMediaContainer* self;
	char** _tmp0_;
	self = (DVBChannelsMediaContainer*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = g_new0 (char*, 0 + 1), *result_length1 = 0, _tmp0_);
	return result;
}


static guint dvb_channels_media_container_real_get_ContainerCount (MediaContainer1* base) {
	guint result;
	DVBChannelsMediaContainer* self;
	self = (DVBChannelsMediaContainer*) base;
	result = (guint) 0;
	return result;
}


static GObject * dvb_channels_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBChannelsMediaContainerClass * klass;
	GObjectClass * parent_class;
	DVBChannelsMediaContainer * self;
	klass = DVB_CHANNELS_MEDIA_CONTAINER_CLASS (g_type_class_peek (DVB_TYPE_CHANNELS_MEDIA_CONTAINER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNELS_MEDIA_CONTAINER (obj);
	{
		GeeHashMap* _tmp3_;
		_tmp3_ = NULL;
		self->priv->items = (_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNEL_MEDIA_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL)), _tmp3_);
	}
	return obj;
}


void _dvb_channels_media_container_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_channels_media_container_introspect (DVBChannelsMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_channels_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_channels_media_container_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_container1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_channels_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_channels_media_container_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


static void dvb_channels_media_container_class_init (DVBChannelsMediaContainerClass * klass) {
	dvb_channels_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelsMediaContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channels_media_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channels_media_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channels_media_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channels_media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_DEVICE_GROUP, g_param_spec_object ("device-group", "device-group", "device-group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_PATH, g_param_spec_string ("Path", "Path", "Path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT, "ContainerCount");
	g_type_set_qdata (DVB_TYPE_CHANNELS_MEDIA_CONTAINER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_channels_media_container_dbus_vtable));
}


static void dvb_channels_media_container_media_container1_interface_init (MediaContainer1Iface * iface) {
	dvb_channels_media_container_media_container1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Items = dvb_channels_media_container_real_get_Items;
	iface->get_ItemCount = dvb_channels_media_container_real_get_ItemCount;
	iface->get_Containers = dvb_channels_media_container_real_get_Containers;
	iface->get_ContainerCount = dvb_channels_media_container_real_get_ContainerCount;
}


static void dvb_channels_media_container_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_channels_media_container_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_channels_media_container_real_get_Parent;
	iface->get_DisplayName = dvb_channels_media_container_real_get_DisplayName;
}


static void dvb_channels_media_container_instance_init (DVBChannelsMediaContainer * self) {
	self->priv = DVB_CHANNELS_MEDIA_CONTAINER_GET_PRIVATE (self);
}


static void dvb_channels_media_container_finalize (GObject* obj) {
	DVBChannelsMediaContainer * self;
	self = DVB_CHANNELS_MEDIA_CONTAINER (obj);
	(self->priv->_device_group == NULL) ? NULL : (self->priv->_device_group = (g_object_unref (self->priv->_device_group), NULL));
	self->parent = (g_free (self->parent), NULL);
	(self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL));
	G_OBJECT_CLASS (dvb_channels_media_container_parent_class)->finalize (obj);
}


GType dvb_channels_media_container_get_type (void) {
	static GType dvb_channels_media_container_type_id = 0;
	if (dvb_channels_media_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelsMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channels_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelsMediaContainer), 0, (GInstanceInitFunc) dvb_channels_media_container_instance_init, NULL };
		static const GInterfaceInfo media_container1_info = { (GInterfaceInitFunc) dvb_channels_media_container_media_container1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_channels_media_container_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_channels_media_container_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelsMediaContainer", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channels_media_container_type_id, TYPE_MEDIA_CONTAINER1, &media_container1_info);
		g_type_add_interface_static (dvb_channels_media_container_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
	}
	return dvb_channels_media_container_type_id;
}


static void dvb_channels_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelsMediaContainer * self;
	gpointer boxed;
	self = DVB_CHANNELS_MEDIA_CONTAINER (object);
	switch (property_id) {
		case DVB_CHANNELS_MEDIA_CONTAINER_DEVICE_GROUP:
		g_value_set_object (value, dvb_channels_media_container_get_device_group (self));
		break;
		case DVB_CHANNELS_MEDIA_CONTAINER_PATH:
		g_value_set_string (value, dvb_channels_media_container_get_Path (self));
		break;
		case DVB_CHANNELS_MEDIA_CONTAINER_PARENT:
		g_value_set_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME:
		g_value_set_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT:
		g_value_set_uint (value, media_container1_get_ItemCount ((MediaContainer1*) self));
		break;
		case DVB_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT:
		g_value_set_uint (value, media_container1_get_ContainerCount ((MediaContainer1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channels_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelsMediaContainer * self;
	self = DVB_CHANNELS_MEDIA_CONTAINER (object);
	switch (property_id) {
		case DVB_CHANNELS_MEDIA_CONTAINER_DEVICE_GROUP:
		dvb_channels_media_container_set_device_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelMediaItem* dvb_channel_media_item_construct (GType object_type, DVBChannel* channel, const char* parent) {
	GParameter * __params;
	GParameter * __params_it;
	DVBChannelMediaItem * self;
	char* _tmp1_;
	const char* _tmp0_;
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "channel";
	g_value_init (&__params_it->value, DVB_TYPE_CHANNEL);
	g_value_set_object (&__params_it->value, channel);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->parent = (_tmp1_ = (_tmp0_ = parent, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->parent = (g_free (self->priv->parent), NULL), _tmp1_);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBChannelMediaItem* dvb_channel_media_item_new (DVBChannel* channel, const char* parent) {
	return dvb_channel_media_item_construct (DVB_TYPE_CHANNEL_MEDIA_ITEM, channel, parent);
}


DVBChannel* dvb_channel_media_item_get_channel (DVBChannelMediaItem* self) {
	DVBChannel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channel;
	return result;
}


static void dvb_channel_media_item_set_channel (DVBChannelMediaItem* self, DVBChannel* value) {
	DVBChannel* _tmp1_;
	DVBChannel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_channel = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_channel == NULL) ? NULL : (self->priv->_channel = (g_object_unref (self->priv->_channel), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "channel");
}


char* dvb_channel_media_item_get_Path (DVBChannelMediaItem* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf (DVB_CHANNEL_PATH, dvb_channel_get_GroupId (self->priv->_channel), dvb_channel_get_Sid (self->priv->_channel));
	return result;
}


static char* dvb_channel_media_item_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBChannelMediaItem* self;
	const char* _tmp0_;
	self = (DVBChannelMediaItem*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->parent, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static char* dvb_channel_media_item_real_get_DisplayName (MediaObject1* base) {
	char* result;
	DVBChannelMediaItem* self;
	const char* _tmp0_;
	self = (DVBChannelMediaItem*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = dvb_channel_get_Name (self->priv->_channel), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static char** dvb_channel_media_item_real_get_URLs (MediaItem1* base, int* result_length1) {
	char** result;
	DVBChannelMediaItem* self;
	char** _tmp0_;
	char** _tmp1_;
	self = (DVBChannelMediaItem*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = dvb_channel_get_URL (self->priv->_channel), _tmp0_), *result_length1 = 1, _tmp1_);
	return result;
}


static char* dvb_channel_media_item_real_get_MIMEType (MediaItem1* base) {
	char* result;
	DVBChannelMediaItem* self;
	self = (DVBChannelMediaItem*) base;
	result = g_strdup ("video/mpeg");
	return result;
}


static char* dvb_channel_media_item_real_get_Type (MediaItem1* base) {
	char* result;
	DVBChannelMediaItem* self;
	self = (DVBChannelMediaItem*) base;
	result = g_strdup ("video");
	return result;
}


void _dvb_channel_media_item_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_channel_media_item_introspect (DVBChannelMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem1\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult dvb_channel_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_channel_media_item_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_item1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_channel_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_channel_media_item_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_item1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


static void dvb_channel_media_item_class_init (DVBChannelMediaItemClass * klass) {
	dvb_channel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelMediaItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_PATH, g_param_spec_string ("Path", "Path", "Path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_MIME_TYPE, "MIMEType");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_MEDIA_ITEM_TYPE, "Type");
	g_type_set_qdata (DVB_TYPE_CHANNEL_MEDIA_ITEM, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_channel_media_item_dbus_vtable));
}


static void dvb_channel_media_item_media_item1_interface_init (MediaItem1Iface * iface) {
	dvb_channel_media_item_media_item1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_URLs = dvb_channel_media_item_real_get_URLs;
	iface->get_MIMEType = dvb_channel_media_item_real_get_MIMEType;
	iface->get_Type = dvb_channel_media_item_real_get_Type;
}


static void dvb_channel_media_item_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_channel_media_item_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_channel_media_item_real_get_Parent;
	iface->get_DisplayName = dvb_channel_media_item_real_get_DisplayName;
}


static void dvb_channel_media_item_instance_init (DVBChannelMediaItem * self) {
	self->priv = DVB_CHANNEL_MEDIA_ITEM_GET_PRIVATE (self);
}


static void dvb_channel_media_item_finalize (GObject* obj) {
	DVBChannelMediaItem * self;
	self = DVB_CHANNEL_MEDIA_ITEM (obj);
	(self->priv->_channel == NULL) ? NULL : (self->priv->_channel = (g_object_unref (self->priv->_channel), NULL));
	self->priv->parent = (g_free (self->priv->parent), NULL);
	G_OBJECT_CLASS (dvb_channel_media_item_parent_class)->finalize (obj);
}


GType dvb_channel_media_item_get_type (void) {
	static GType dvb_channel_media_item_type_id = 0;
	if (dvb_channel_media_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelMediaItem), 0, (GInstanceInitFunc) dvb_channel_media_item_instance_init, NULL };
		static const GInterfaceInfo media_item1_info = { (GInterfaceInitFunc) dvb_channel_media_item_media_item1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_channel_media_item_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_channel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelMediaItem", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channel_media_item_type_id, TYPE_MEDIA_ITEM1, &media_item1_info);
		g_type_add_interface_static (dvb_channel_media_item_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
	}
	return dvb_channel_media_item_type_id;
}


static void dvb_channel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelMediaItem * self;
	gpointer boxed;
	self = DVB_CHANNEL_MEDIA_ITEM (object);
	switch (property_id) {
		case DVB_CHANNEL_MEDIA_ITEM_CHANNEL:
		g_value_set_object (value, dvb_channel_media_item_get_channel (self));
		break;
		case DVB_CHANNEL_MEDIA_ITEM_PATH:
		g_value_set_string (value, dvb_channel_media_item_get_Path (self));
		break;
		case DVB_CHANNEL_MEDIA_ITEM_PARENT:
		g_value_set_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_CHANNEL_MEDIA_ITEM_DISPLAY_NAME:
		g_value_set_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_CHANNEL_MEDIA_ITEM_MIME_TYPE:
		g_value_set_string (value, media_item1_get_MIMEType ((MediaItem1*) self));
		break;
		case DVB_CHANNEL_MEDIA_ITEM_TYPE:
		g_value_set_string (value, media_item1_get_Type ((MediaItem1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelMediaItem * self;
	self = DVB_CHANNEL_MEDIA_ITEM (object);
	switch (property_id) {
		case DVB_CHANNEL_MEDIA_ITEM_CHANNEL:
		dvb_channel_media_item_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


guint _dynamic_RequestName1 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


gboolean dvb_rygel_service_start_rygel_services (void) {
	gboolean result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch43_g_error;
			goto __finally43;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		/* try to register service in session bus*/
		request_name_result = _dynamic_RequestName1 (bus, DVB_SERVICE_NAME, (guint) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
			(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
			goto __catch43_g_error;
			goto __finally43;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			DVBDeviceGroupsMediaContainer* _tmp0_;
			char* _tmp1_;
			g_message ("Services.vala:297: Creating new Rygel MediaServer D-Bus service");
			_tmp0_ = NULL;
			dvb_rygel_service_root_container = (_tmp0_ = dvb_device_groups_media_container_new (), (dvb_rygel_service_root_container == NULL) ? NULL : (dvb_rygel_service_root_container = (g_object_unref (dvb_rygel_service_root_container), NULL)), _tmp0_);
			dvb_device_groups_media_container_create_container_services (dvb_rygel_service_root_container);
			_tmp1_ = NULL;
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), (const char*) (_tmp1_ = media_object1_get_Parent ((MediaObject1*) dvb_rygel_service_root_container)), (GObject*) dvb_rygel_service_root_container);
			_tmp1_ = (g_free (_tmp1_), NULL);
		} else {
			g_warning ("Services.vala:306: Rygel MediaServer D-Bus service is already running");
			result = FALSE;
			(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
			(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
			return result;
		}
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("Services.vala:311: Oops %s", e->message);
			result = FALSE;
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			return result;
		}
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




