/* ScannedItem.c generated by valac 0.12.0, the Vala compiler
 * generated from ScannedItem.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;
typedef struct _DVBScannedItemPrivate DVBScannedItemPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBScannedSatteliteItemPrivate DVBScannedSatteliteItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBScannedItem {
	GObject parent_instance;
	DVBScannedItemPrivate * priv;
};

struct _DVBScannedItemClass {
	GObjectClass parent_class;
};

struct _DVBScannedItemPrivate {
	guint _Frequency;
};

struct _DVBScannedSatteliteItem {
	DVBScannedItem parent_instance;
	DVBScannedSatteliteItemPrivate * priv;
};

struct _DVBScannedSatteliteItemClass {
	DVBScannedItemClass parent_class;
};

struct _DVBScannedSatteliteItemPrivate {
	gchar* _Polarization;
};


static gpointer dvb_scanned_item_parent_class = NULL;
static DVBLoggingLogger* dvb_scanned_item_log;
static DVBLoggingLogger* dvb_scanned_item_log = NULL;
static gpointer dvb_scanned_sattelite_item_parent_class = NULL;

GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
#define DVB_SCANNED_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_ITEM, DVBScannedItemPrivate))
enum  {
	DVB_SCANNED_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_ITEM_FREQUENCY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SCANNED_ITEM_PRIME 31
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
guint dvb_scanned_item_hash (DVBScannedItem* o);
GType dvb_scanned_sattelite_item_get_type (void) G_GNUC_CONST;
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
const gchar* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value);
static void dvb_scanned_item_finalize (GObject* obj);
static void _vala_dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemPrivate))
enum  {
	DVB_SCANNED_SATTELITE_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_SATTELITE_ITEM_POLARIZATION
};
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const gchar* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const gchar* polarization);
static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const gchar* value);
static void dvb_scanned_sattelite_item_finalize (GObject* obj);
static void _vala_dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency) {
	DVBScannedItem * self = NULL;
	self = (DVBScannedItem*) g_object_new (object_type, "Frequency", frequency, NULL);
	return self;
}


DVBScannedItem* dvb_scanned_item_new (guint frequency) {
	return dvb_scanned_item_construct (DVB_TYPE_SCANNED_ITEM, frequency);
}


guint dvb_scanned_item_hash (DVBScannedItem* o) {
	guint result = 0U;
	guint hashval = 0U;
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o)) {
		const gchar* _tmp0_ = NULL;
		guint _tmp1_;
		_tmp0_ = dvb_scanned_sattelite_item_get_Polarization (DVB_SCANNED_SATTELITE_ITEM (o));
		_tmp1_ = g_str_hash (_tmp0_);
		hashval = ((2 * DVB_SCANNED_ITEM_PRIME) + (DVB_SCANNED_ITEM_PRIME * o->priv->_Frequency)) + _tmp1_;
	} else {
		if (DVB_IS_SCANNED_ITEM (o)) {
			hashval = o->priv->_Frequency;
		} else {
			hashval = (guint) 0;
		}
	}
	result = hashval;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	const gchar* _tmp2_ = NULL;
	GType _tmp3_;
	const gchar* _tmp4_ = NULL;
	if (o1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = o2 == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) o1);
	_tmp2_ = g_type_name (_tmp1_);
	_tmp3_ = G_TYPE_FROM_INSTANCE ((GObject*) o2);
	_tmp4_ = g_type_name (_tmp3_);
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		result = FALSE;
		return result;
	}
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o1)) {
		DVBScannedSatteliteItem* _tmp5_;
		DVBScannedSatteliteItem* item1;
		DVBScannedSatteliteItem* _tmp6_;
		DVBScannedSatteliteItem* item2;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = _g_object_ref0 (DVB_SCANNED_SATTELITE_ITEM (o1));
		item1 = _tmp5_;
		_tmp6_ = _g_object_ref0 (DVB_SCANNED_SATTELITE_ITEM (o2));
		item2 = _tmp6_;
		if (DVB_SCANNED_ITEM (item1)->priv->_Frequency == DVB_SCANNED_ITEM (item2)->priv->_Frequency) {
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = dvb_scanned_sattelite_item_get_Polarization (item1);
			_tmp9_ = dvb_scanned_sattelite_item_get_Polarization (item2);
			_tmp7_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		_g_object_unref0 (item2);
		_g_object_unref0 (item1);
		return result;
	} else {
		if (DVB_IS_SCANNED_ITEM (o1)) {
			DVBScannedItem* _tmp10_;
			DVBScannedItem* item1;
			DVBScannedItem* _tmp11_;
			DVBScannedItem* item2;
			_tmp10_ = _g_object_ref0 (DVB_SCANNED_ITEM (o1));
			item1 = _tmp10_;
			_tmp11_ = _g_object_ref0 (DVB_SCANNED_ITEM (o2));
			item2 = _tmp11_;
			result = item1->priv->_Frequency == item2->priv->_Frequency;
			_g_object_unref0 (item2);
			_g_object_unref0 (item1);
			return result;
		} else {
			dvb_logging_logger_error (dvb_scanned_item_log, "ScannedItem.vala:71: Don't comparing ScannedItem instances");
			result = FALSE;
			return result;
		}
	}
}


guint dvb_scanned_item_get_Frequency (DVBScannedItem* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Frequency;
	return result;
}


static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frequency = value;
	g_object_notify ((GObject *) self, "Frequency");
}


static void dvb_scanned_item_class_init (DVBScannedItemClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_scanned_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanned_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanned_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_ITEM_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_scanned_item_log = _tmp1_;
}


static void dvb_scanned_item_instance_init (DVBScannedItem * self) {
	self->priv = DVB_SCANNED_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_item_finalize (GObject* obj) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (obj);
	G_OBJECT_CLASS (dvb_scanned_item_parent_class)->finalize (obj);
}


/**
     * This class represents a frequency and possibly other parameters
     * that are necessary to mark a frequency as scanned
     */
GType dvb_scanned_item_get_type (void) {
	static volatile gsize dvb_scanned_item_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanned_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedItem), 0, (GInstanceInitFunc) dvb_scanned_item_instance_init, NULL };
		GType dvb_scanned_item_type_id;
		dvb_scanned_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScannedItem", &g_define_type_info, 0);
		g_once_init_leave (&dvb_scanned_item_type_id__volatile, dvb_scanned_item_type_id);
	}
	return dvb_scanned_item_type_id__volatile;
}


static void _vala_dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		g_value_set_uint (value, dvb_scanned_item_get_Frequency (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		dvb_scanned_item_set_Frequency (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const gchar* polarization) {
	DVBScannedSatteliteItem * self = NULL;
	g_return_val_if_fail (polarization != NULL, NULL);
	self = (DVBScannedSatteliteItem*) g_object_new (object_type, "Frequency", frequency, "Polarization", polarization, NULL);
	return self;
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const gchar* polarization) {
	return dvb_scanned_sattelite_item_construct (DVB_TYPE_SCANNED_SATTELITE_ITEM, frequency, polarization);
}


const gchar* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Polarization;
	return result;
}


static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_Polarization);
	self->priv->_Polarization = _tmp0_;
	g_object_notify ((GObject *) self, "Polarization");
}


static void dvb_scanned_sattelite_item_class_init (DVBScannedSatteliteItemClass * klass) {
	dvb_scanned_sattelite_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedSatteliteItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanned_sattelite_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanned_sattelite_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_sattelite_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_SATTELITE_ITEM_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_sattelite_item_instance_init (DVBScannedSatteliteItem * self) {
	self->priv = DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_sattelite_item_finalize (GObject* obj) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (obj);
	_g_free0 (self->priv->_Polarization);
	G_OBJECT_CLASS (dvb_scanned_sattelite_item_parent_class)->finalize (obj);
}


GType dvb_scanned_sattelite_item_get_type (void) {
	static volatile gsize dvb_scanned_sattelite_item_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanned_sattelite_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedSatteliteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_sattelite_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedSatteliteItem), 0, (GInstanceInitFunc) dvb_scanned_sattelite_item_instance_init, NULL };
		GType dvb_scanned_sattelite_item_type_id;
		dvb_scanned_sattelite_item_type_id = g_type_register_static (DVB_TYPE_SCANNED_ITEM, "DVBScannedSatteliteItem", &g_define_type_info, 0);
		g_once_init_leave (&dvb_scanned_sattelite_item_type_id__volatile, dvb_scanned_sattelite_item_type_id);
	}
	return dvb_scanned_sattelite_item_type_id__volatile;
}


static void _vala_dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		g_value_set_string (value, dvb_scanned_sattelite_item_get_Polarization (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		dvb_scanned_sattelite_item_set_Polarization (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



