/* AisleRiot - draw.h
 * Copyright (C) 1998 Jonathan Blandford <jrb@mit.edu>
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef DRAW_H
#define DRAW_H

#include "slot.h"

/* The size of the drawing area. */
extern int window_width;
extern int window_height;

/* The size of a card. */
extern int card_width;
extern int card_height;

void rescale_cards (void);
void set_geometry (double new_width, double new_height);
void draw_cards( void );
void take_snapshot( void );
void refresh_screen( void );
void set_hilite (hslot_type hslot);

#endif
