/* file-destination.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <libgnome/gnome-i18n.h>
#include "file-destination.h"

static void fd_class_init (FileDestinationClass *klass);
static void fd_init (FileDestination *gd, FileDestinationClass *klass);
static void fd_finalize (GObject *object);
static const GParamSpecPool *fd_get_parameters (GenericDestination *gd);

static GObjectClass *parent_class = NULL;

static void
fd_class_init (FileDestinationClass *klass)
{
	GObjectClass *object_class;
	GenericDestinationClass *destination_class;

	parent_class = g_type_class_peek_parent (klass);

	object_class = G_OBJECT_CLASS (klass);
	object_class->finalize = fd_finalize;

	destination_class = GENERIC_DESTINATION_CLASS (klass);
	destination_class->get_parameters = fd_get_parameters;
}

static void
fd_init (FileDestination *gd, FileDestinationClass *klass)
{
}

static void
fd_finalize (GObject *object)
{
	parent_class->finalize;
}

GType
file_destination_get_type (void)
{
	static GType type = 0;
                                                                                                  
        if (type == 0) {
                static GTypeInfo info = {
                        sizeof (FileDestinationClass),
                        (GBaseInitFunc) NULL,
                        (GBaseFinalizeFunc) NULL,
                        (GClassInitFunc) fd_class_init,
                        NULL, NULL,
                        sizeof (FileDestination),
                        0,
                        (GInstanceInitFunc) fd_init
                };
		type = g_type_register_static (generic_destination_get_type (), "FileDestination", &info, 0);
        }

        return type;
}

GenericDestination *
file_destination_new (void)
{
	FileDestination *fd;

	fd = g_object_new (file_destination_get_type (), NULL);
	return (GenericDestination *) fd;
}

static const GParamSpecPool *
fd_get_parameters (GenericDestination *gd)
{
	static GParamSpecPool *params = NULL;
	GParamSpec *spec;
	FileDestination *fd = (FileDestination *) gd;

	if (params != NULL)
		return (const GParamSpecPool *) params;

	params = g_param_spec_pool_new (FALSE);

	/* 'FILENAME' parameter */
	spec = g_param_spec_string (_("FILENAME"), NULL, NULL, "", G_PARAM_PRIVATE);
	g_param_spec_pool_insert (params, spec, file_destination_get_type ());

	spec = g_param_spec_boolean (_("COMPRESS"), NULL, NULL, FALSE, G_PARAM_PRIVATE);
	g_param_spec_pool_insert (params, spec, file_destination_get_type ());

	return (const GParamSpecPool *) params;
}
