/* gnome-netinfo - A GUI Interface for network utilities
 * Copyright (C) 2002, 2003 by German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __NETINFO__
#define __NETINFO__

#define NETINFO_FOREACH_FUNC(a)  (NetinfoForeachFunc) a

typedef void (*NetinfoForeachFunc) (gpointer * netinfo, gchar * line, gint len,
				    gpointer user_data);

typedef struct _Netinfo Netinfo;

struct _Netinfo {
	GtkWidget *host;
	GtkWidget *count;
	GtkWidget *output;
	GtkWidget *limited;
	GtkWidget *button;
	GtkWidget *sensitive;
	GtkWidget *routing;
	GtkWidget *protocol;
	GtkWidget *multicast;
	gboolean running;
	gint child_pid;
	gint pipe_out;
	gint pipe_err;
	gchar **command_line;
	gchar *label_run;
	gchar *label_stop;
	NetinfoForeachFunc process_line;
	GCallback button_callback;
	/* extra definitios for ping */
	GtkWidget *min;
	GtkWidget *max;
	GtkWidget *avg;
	GtkWidget *packets_received;
	GtkWidget *packets_loss;
};

enum {
	INACTIVE = FALSE,
	ACTIVE = TRUE
};

#endif  /* __NETINFO__ */

/* Generic functions */
void netinfo_process_command (Netinfo * netinfo);
void netinfo_stop_process_command (Netinfo * netinfo);
void netinfo_text_buffer_insert (Netinfo * netinfo);

gushort netinfo_get_count (Netinfo * netinfo);
const gchar * netinfo_get_host (Netinfo * netinfo);
void netinfo_toggle_button (Netinfo * netinfo);
void netinfo_toggle_state (Netinfo * netinfo, gboolean state,
		   gpointer user_data);
