/*
 *
 * gnomescan-device.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanner
 * @short_description: An object representating a device
 *
 * This object gathers all meta-informations about a devices. It also
 * contains device specific option. Application should use such object
 * only for device listing or for special device configuration
 * tools. Use #GnomeScanContext to configure a scan not a device.
 */

#ifndef GNOME_SCANNER_H
#define	GNOME_SCANNER_H

#include <glib.h>
#include <glib-object.h>
#include "gnomescantypes.h"
#include "gnomescanutils.h"
#include "gnomescanneroption.h"

#define	GNOME_TYPE_SCANNER			(gnome_scanner_get_type ())
#define	GNOME_SCANNER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCANNER, GnomeScanner))
#define GNOME_SCANNER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCANNER, GnomeScannerClass))
#define GNOME_IS_SCANNER(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCANNER))
#define GNOME_IS_SCANNER_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCANNER))
#define GNOME_SCANNER_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCANNER, GnomeScannerClass))

typedef struct _GnomeScanner			GnomeScanner;
typedef struct _GnomeScannerClass		GnomeScannerClass;

struct _GnomeScanner {
  GObject		    	parent;

  /*< public >*/
  const gchar*	       		vendor;
  const gchar*			product;
  GnomeScannerType		type;
  GnomeScanGeometry*		geometry;
  GValueArray*			sources;
  GValueArray*			colorspaces;
  GValueArray*			depths;
  GnomeScanRange*		resolution_range;
  GValueArray*			resolution_enum;
  GHashTable*			options;
};

struct _GnomeScannerClass {
  GObjectClass			parent;

  /* SIGNALS */
};

enum {
  GNOME_SCANNER_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scanner_get_type			(void);

/* Methods */
/* void			gnome_scanner_destroy 			(GnomeScanner *scanner); */

void			gnome_scanner_foreach_options		(GnomeScanner *scanner,
								 GHFunc func,
								 gpointer data);

GnomeScannerOption*	gnome_scanner_find_option		(GnomeScanner *scanner,
								 const gchar *name);


/* Properties */
gpointer		gnome_scanner_get_id 			(GnomeScanner *scanner);
const gchar*		gnome_scanner_get_vendor		(GnomeScanner *scanner);
const gchar*		gnome_scanner_get_product		(GnomeScanner *scanner);
GnomeScannerType	gnome_scanner_get_scanner_type		(GnomeScanner *scanner);
GValueArray*		gnome_scanner_get_sources		(GnomeScanner *scanner);
GValueArray*		gnome_scanner_get_colorspaces		(GnomeScanner *scanner);
GValueArray*		gnome_scanner_get_depths		(GnomeScanner *scanner);
GnomeScanGeometry*	gnome_scanner_get_geometry		(GnomeScanner *scanner);
GnomeScanRange*		gnome_scanner_get_resolution_range	(GnomeScanner *scanner);
GValueArray*		gnome_scanner_get_resolution_enum 	(GnomeScanner *scanner);
#endif /* ! GNOME_SCANNER_H */
