/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <gnome-scan-module.h>
#include "gsfile-backend.h"
#include "gsfile-scanner.h"

static GnomeScanBackendClass* parent_class = NULL;

void	gsfb_probe_scanners (GnomeScanBackend *backend);

GS_DEFINE_MODULE_TYPE (GSFileBackend, gsfile_backend, GNOME_TYPE_SCAN_BACKEND);

static void
gsfile_backend_init (GSFileBackend *object)
{
	/* TODO: Add initialization code here */
}

static void
gsfile_backend_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gsfile_backend_class_init (GSFileBackendClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GnomeScanBackendClass *backend_class = GNOME_SCAN_BACKEND_CLASS (klass);
	parent_class = GNOME_SCAN_BACKEND_CLASS (g_type_class_peek_parent (klass));
	
	backend_class->probe_scanners = gsfb_probe_scanners;

	object_class->finalize = gsfile_backend_finalize;
}

void
gsfb_probe_scanners (GnomeScanBackend *backend)
{
	GnomeScanner *scanner;
	scanner = gsfile_scanner_new ();
	gnome_scan_backend_add_scanner (backend, scanner);
	g_object_unref (scanner);
}
