/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_MODULE_H__
#define __GNOME_SCAN_MODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_MODULE (gnome_scan_module_get_type ())
#define GNOME_SCAN_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModule))
#define GNOME_SCAN_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))
#define GNOME_SCAN_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE))
#define GNOME_SCAN_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE, GnomeScanModuleClass))

typedef struct _GnomeScanModule GnomeScanModule;
typedef struct _GnomeScanModuleClass GnomeScanModuleClass;
typedef struct _GnomeScanModulePrivate GnomeScanModulePrivate;
typedef void (*GnomeScanModuleInitFunc) (GnomeScanModule* module, void* user_data);
typedef void (*GnomeScanModuleFinalizeFunc) (void* user_data);

/**
 * SECTION: gnome-scan-module
 * @short_description: Module loading and initialization
 *
 * A module represent the library opened with #GModule where are
 * stored a list of #GObjects.
 **/
struct _GnomeScanModule {
	GTypeModule parent_instance;
	GnomeScanModulePrivate * priv;
};

struct _GnomeScanModuleClass {
	GTypeModuleClass parent_class;
};


GnomeScanModule* gnome_scan_module_construct (GType object_type, const char* filename);
GnomeScanModule* gnome_scan_module_new (const char* filename);
const char* gnome_scan_module_get_filename (GnomeScanModule* self);
void gnome_scan_module_set_filename (GnomeScanModule* self, const char* value);
GType gnome_scan_module_get_type (void);


G_END_DECLS

#endif
