/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define FLEGITA_TYPE_FORMAT_COLUMNS (flegita_format_columns_get_type ())

#define FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET (flegita_output_filename_widget_get_type ())
#define FLEGITA_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidget))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))

typedef struct _FlegitaOutputFilenameWidget FlegitaOutputFilenameWidget;
typedef struct _FlegitaOutputFilenameWidgetClass FlegitaOutputFilenameWidgetClass;
typedef struct _FlegitaOutputFilenameWidgetPrivate FlegitaOutputFilenameWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define FLEGITA_TYPE_OPTION_OUTPUT_FILENAME (flegita_option_output_filename_get_type ())
#define FLEGITA_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilename))
#define FLEGITA_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))

typedef struct _FlegitaOptionOutputFilename FlegitaOptionOutputFilename;
typedef struct _FlegitaOptionOutputFilenameClass FlegitaOptionOutputFilenameClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	FLEGITA_FORMAT_COLUMNS_ICON,
	FLEGITA_FORMAT_COLUMNS_SUFFIX,
	FLEGITA_FORMAT_COLUMNS_N
} FlegitaFormatColumns;

struct _FlegitaOutputFilenameWidget {
	GnomeScanOptionWidget parent_instance;
	FlegitaOutputFilenameWidgetPrivate * priv;
};

struct _FlegitaOutputFilenameWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _FlegitaOutputFilenameWidgetPrivate {
	GtkEntry* entry;
	GtkFileChooser* filechooser;
	GtkListStore* formats;
	GtkComboBox* combobox;
	GHashTable* format_paths;
	gboolean inhibit;
};


static gpointer flegita_output_filename_widget_parent_class = NULL;

GType flegita_format_columns_get_type (void);
GType flegita_output_filename_widget_get_type (void);
#define FLEGITA_OUTPUT_FILENAME_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetPrivate))
enum  {
	FLEGITA_OUTPUT_FILENAME_WIDGET_DUMMY_PROPERTY
};
GType flegita_option_output_filename_get_type (void);
void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value);
static void flegita_output_filename_widget_update_filename (FlegitaOutputFilenameWidget* self);
const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self);
static void flegita_output_filename_widget_parse_filename (FlegitaOutputFilenameWidget* self);
FlegitaOutputFilenameWidget* flegita_output_filename_widget_new (void);
FlegitaOutputFilenameWidget* flegita_output_filename_widget_construct (GType object_type);
static void _flegita_output_filename_widget_parse_filename_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self);
GSList* flegita_option_output_filename_list_formats (FlegitaOptionOutputFilename* self);
static void _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static void _flegita_output_filename_widget_update_filename_gtk_editable_changed (GtkEntry* _sender, gpointer self);
static void _flegita_output_filename_widget_update_filename_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static GObject * flegita_output_filename_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void flegita_output_filename_widget_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);




GType flegita_format_columns_get_type (void) {
	static GType flegita_format_columns_type_id = 0;
	if (G_UNLIKELY (flegita_format_columns_type_id == 0)) {
		static const GEnumValue values[] = {{FLEGITA_FORMAT_COLUMNS_ICON, "FLEGITA_FORMAT_COLUMNS_ICON", "icon"}, {FLEGITA_FORMAT_COLUMNS_SUFFIX, "FLEGITA_FORMAT_COLUMNS_SUFFIX", "suffix"}, {FLEGITA_FORMAT_COLUMNS_N, "FLEGITA_FORMAT_COLUMNS_N", "n"}, {0, NULL, NULL}};
		flegita_format_columns_type_id = g_enum_register_static ("FlegitaFormatColumns", values);
	}
	return flegita_format_columns_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void flegita_output_filename_widget_update_filename (FlegitaOutputFilenameWidget* self) {
	GnomeScanOption* _tmp0_;
	FlegitaOptionOutputFilename* option;
	char* suffix;
	GtkTreeIter iter = {0};
	gboolean format_selected;
	char* _tmp2_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->inhibit) {
		return;
	}
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), FLEGITA_IS_OPTION_OUTPUT_FILENAME (_tmp0_) ? ((FlegitaOptionOutputFilename*) _tmp0_) : NULL));
	suffix = NULL;
	format_selected = gtk_combo_box_get_active_iter (self->priv->combobox, &iter);
	g_return_if_fail (format_selected);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->formats, &iter, FLEGITA_FORMAT_COLUMNS_SUFFIX, &suffix, -1);
	self->priv->inhibit = TRUE;
	flegita_option_output_filename_set_value (option, _tmp2_ = g_strdup_printf ("%s%c%s.%s", _tmp1_ = gtk_file_chooser_get_filename (self->priv->filechooser), (gint) G_DIR_SEPARATOR, gtk_entry_get_text (self->priv->entry), suffix));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	self->priv->inhibit = FALSE;
	_g_object_unref0 (option);
	_g_free0 (suffix);
}


static void flegita_output_filename_widget_parse_filename (FlegitaOutputFilenameWidget* self) {
	GtkTreeIter iter = {0};
	GnomeScanOption* _tmp0_;
	FlegitaOptionOutputFilename* option;
	char* filename;
	gboolean _tmp1_;
	char* _tmp2_;
	char* basename;
	char* suffix;
	char* path_string;
	char** _tmp4_;
	gint parts_size;
	gint parts_length1;
	char** _tmp3_;
	char** parts;
	g_return_if_fail (self != NULL);
	if (self->priv->inhibit) {
		return;
	}
	self->priv->inhibit = TRUE;
	option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), FLEGITA_IS_OPTION_OUTPUT_FILENAME (_tmp0_) ? ((FlegitaOptionOutputFilename*) _tmp0_) : NULL));
	filename = g_strdup (flegita_option_output_filename_get_value (option));
	_tmp1_ = FALSE;
	if (filename == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_utf8_strlen (filename, -1) == 0;
	}
	if (_tmp1_) {
		_g_object_unref0 (option);
		_g_free0 (filename);
		return;
	}
	gtk_file_chooser_set_current_folder (self->priv->filechooser, _tmp2_ = g_path_get_dirname (filename));
	_g_free0 (_tmp2_);
	basename = g_path_get_basename (filename);
	suffix = g_strdup (g_utf8_strrchr (basename, (gssize) (-1), (gunichar) '.'));
	if (suffix == NULL) {
		g_warning ("flegita-option-widgets.vala:129: unable to parse suffix in %s", basename);
		_g_object_unref0 (option);
		_g_free0 (filename);
		_g_free0 (basename);
		_g_free0 (suffix);
		return;
	}
	path_string = g_strdup ((const char*) g_hash_table_lookup (self->priv->format_paths, suffix));
	if (!gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->formats, &iter, path_string)) {
		g_warning ("flegita-option-widgets.vala:135: Invalid %s suffix", suffix);
		_g_object_unref0 (option);
		_g_free0 (filename);
		_g_free0 (basename);
		_g_free0 (suffix);
		_g_free0 (path_string);
		return;
	}
	gtk_combo_box_set_active_iter (self->priv->combobox, &iter);
	parts = (_tmp4_ = _tmp3_ = g_strsplit (basename, suffix, -1), parts_length1 = _vala_array_length (_tmp3_), parts_size = parts_length1, _tmp4_);
	gtk_entry_set_text (self->priv->entry, parts[0]);
	while (TRUE) {
		if (!gdk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
	self->priv->inhibit = FALSE;
	_g_object_unref0 (option);
	_g_free0 (filename);
	_g_free0 (basename);
	_g_free0 (suffix);
	_g_free0 (path_string);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


FlegitaOutputFilenameWidget* flegita_output_filename_widget_construct (GType object_type) {
	FlegitaOutputFilenameWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


FlegitaOutputFilenameWidget* flegita_output_filename_widget_new (void) {
	return flegita_output_filename_widget_construct (FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET);
}


static void _flegita_output_filename_widget_parse_filename_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self) {
	flegita_output_filename_widget_parse_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_editable_changed (GtkEntry* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static GObject * flegita_output_filename_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	FlegitaOutputFilenameWidgetClass * klass;
	GObjectClass * parent_class;
	FlegitaOutputFilenameWidget * self;
	klass = FLEGITA_OUTPUT_FILENAME_WIDGET_CLASS (g_type_class_peek (FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FLEGITA_OUTPUT_FILENAME_WIDGET (obj);
	{
		GtkCellRenderer* renderer;
		FlegitaOptionOutputFilename* option;
		GtkTreeIter iter = {0};
		GtkBox* box;
		GtkFileChooser* _tmp0_;
		GtkEntry* _tmp1_;
		GtkListStore* _tmp2_;
		GHashTable* _tmp3_;
		GtkComboBox* _tmp4_;
		GtkCellRenderer* _tmp5_;
		GtkCellRenderer* _tmp6_;
		renderer = NULL;
		option = _g_object_ref0 (FLEGITA_OPTION_OUTPUT_FILENAME (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self)));
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, TRUE);
		gnome_scan_option_widget_set_expand ((GnomeScanOptionWidget*) self, FALSE);
		g_signal_connect_object ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), "notify::value", (GCallback) _flegita_output_filename_widget_parse_filename_g_object_notify, self, 0);
		box = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
		self->priv->filechooser = (_tmp0_ = (GtkFileChooser*) g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Select output directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), _g_object_unref0 (self->priv->filechooser), _tmp0_);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->filechooser, TRUE, TRUE, (guint) 0);
		self->priv->entry = (_tmp1_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry), _tmp1_);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->entry, TRUE, TRUE, (guint) 0);
		self->priv->formats = (_tmp2_ = gtk_list_store_new ((gint) FLEGITA_FORMAT_COLUMNS_N, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->formats), _tmp2_);
		self->priv->format_paths = (_tmp3_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->format_paths), _tmp3_);
		{
			GSList* format_collection;
			GSList* format_it;
			format_collection = flegita_option_output_filename_list_formats (option);
			for (format_it = format_collection; format_it != NULL; format_it = format_it->next) {
				GnomeScanFormat* format;
				format = _g_object_ref0 ((GnomeScanFormat*) format_it->data);
				{
					GtkTreePath* path;
					gtk_list_store_append (self->priv->formats, &iter);
					gtk_list_store_set (self->priv->formats, &iter, FLEGITA_FORMAT_COLUMNS_ICON, format->icon_name, FLEGITA_FORMAT_COLUMNS_SUFFIX, format->suffixes[0], -1);
					path = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->formats, &iter);
					g_hash_table_insert (self->priv->format_paths, g_strdup_printf (".%s", format->suffixes[0]), g_strdup (gtk_tree_path_to_string (path)));
					_g_object_unref0 (format);
					_gtk_tree_path_free0 (path);
				}
			}
		}
		self->priv->combobox = (_tmp4_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->formats)), _g_object_unref0 (self->priv->combobox), _tmp4_);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->combobox, FALSE, FALSE, (guint) 0);
		renderer = (_tmp5_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (renderer), _tmp5_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox, renderer, FALSE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox, renderer, "icon-name", FLEGITA_FORMAT_COLUMNS_ICON, NULL);
		renderer = (_tmp6_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp6_);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox, renderer, TRUE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox, renderer, "text", FLEGITA_FORMAT_COLUMNS_SUFFIX, NULL);
		g_signal_connect_object (self->priv->filechooser, "selection-changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed, self, 0);
		g_signal_connect_object ((GtkEditable*) self->priv->entry, "changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_editable_changed, self, 0);
		g_signal_connect_object (self->priv->combobox, "changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_combo_box_changed, self, 0);
		flegita_output_filename_widget_parse_filename (self);
		_g_object_unref0 (renderer);
		_g_object_unref0 (option);
		_g_object_unref0 (box);
	}
	return obj;
}


static void flegita_output_filename_widget_class_init (FlegitaOutputFilenameWidgetClass * klass) {
	flegita_output_filename_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaOutputFilenameWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = flegita_output_filename_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = flegita_output_filename_widget_finalize;
}


static void flegita_output_filename_widget_instance_init (FlegitaOutputFilenameWidget * self) {
	self->priv = FLEGITA_OUTPUT_FILENAME_WIDGET_GET_PRIVATE (self);
	self->priv->inhibit = FALSE;
}


static void flegita_output_filename_widget_finalize (GObject* obj) {
	FlegitaOutputFilenameWidget * self;
	self = FLEGITA_OUTPUT_FILENAME_WIDGET (obj);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->filechooser);
	_g_object_unref0 (self->priv->formats);
	_g_object_unref0 (self->priv->combobox);
	_g_hash_table_unref0 (self->priv->format_paths);
	G_OBJECT_CLASS (flegita_output_filename_widget_parent_class)->finalize (obj);
}


GType flegita_output_filename_widget_get_type (void) {
	static GType flegita_output_filename_widget_type_id = 0;
	if (flegita_output_filename_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaOutputFilenameWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_output_filename_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaOutputFilenameWidget), 0, (GInstanceInitFunc) flegita_output_filename_widget_instance_init, NULL };
		flegita_output_filename_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "FlegitaOutputFilenameWidget", &g_define_type_info, 0);
	}
	return flegita_output_filename_widget_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




