/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan.h>
#include <stdlib.h>
#include <string.h>


#define FLEGITA_TYPE_OPTION_OUTPUT_FILENAME (flegita_option_output_filename_get_type ())
#define FLEGITA_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilename))
#define FLEGITA_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))

typedef struct _FlegitaOptionOutputFilename FlegitaOptionOutputFilename;
typedef struct _FlegitaOptionOutputFilenameClass FlegitaOptionOutputFilenameClass;
typedef struct _FlegitaOptionOutputFilenamePrivate FlegitaOptionOutputFilenamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _FlegitaOptionOutputFilename {
	GnomeScanOption parent_instance;
	FlegitaOptionOutputFilenamePrivate * priv;
};

struct _FlegitaOptionOutputFilenameClass {
	GnomeScanOptionClass parent_class;
};

struct _FlegitaOptionOutputFilenamePrivate {
	char* _value;
	char* directory;
	char* filename;
	GnomeScanFormat* format;
	GSList* formats;
};


static gpointer flegita_option_output_filename_parent_class = NULL;

GType flegita_option_output_filename_get_type (void);
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenamePrivate))
enum  {
	FLEGITA_OPTION_OUTPUT_FILENAME_DUMMY_PROPERTY,
	FLEGITA_OPTION_OUTPUT_FILENAME_VALUE
};
FlegitaOptionOutputFilename* flegita_option_output_filename_new (const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
FlegitaOptionOutputFilename* flegita_option_output_filename_construct (GType object_type, const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
static void flegita_option_output_filename_update_value (FlegitaOptionOutputFilename* self);
void flegita_option_output_filename_install_format (FlegitaOptionOutputFilename* self, GnomeScanFormat* format);
GSList* flegita_option_output_filename_list_formats (FlegitaOptionOutputFilename* self);
void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value);
const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self);
static void flegita_option_output_filename_finalize (GObject* obj);
static void flegita_option_output_filename_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void flegita_option_output_filename_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



FlegitaOptionOutputFilename* flegita_option_output_filename_construct (GType object_type, const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint) {
	GParameter * __params;
	GParameter * __params_it;
	FlegitaOptionOutputFilename * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (desc != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	__params_it->name = "name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, name);
	__params_it++;
	__params_it->name = "title";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, title);
	__params_it++;
	__params_it->name = "desc";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, desc);
	__params_it++;
	__params_it->name = "domain";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, domain);
	__params_it++;
	__params_it->name = "group";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, group);
	__params_it++;
	__params_it->name = "hint";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_OPTION_HINT);
	g_value_set_enum (&__params_it->value, hint);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


FlegitaOptionOutputFilename* flegita_option_output_filename_new (const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint) {
	return flegita_option_output_filename_construct (FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, name, title, desc, domain, group, hint);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void flegita_option_output_filename_install_format (FlegitaOptionOutputFilename* self, GnomeScanFormat* format) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (format != NULL);
	self->priv->formats = g_slist_append (self->priv->formats, format);
	if (self->priv->format == NULL) {
		GnomeScanFormat* _tmp0_;
		self->priv->format = (_tmp0_ = _g_object_ref0 ((GnomeScanFormat*) g_slist_nth_data (self->priv->formats, (guint) 0)), _g_object_unref0 (self->priv->format), _tmp0_);
		flegita_option_output_filename_update_value (self);
	}
}


GSList* flegita_option_output_filename_list_formats (FlegitaOptionOutputFilename* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->formats;
	return result;
}


static void flegita_option_output_filename_update_value (FlegitaOptionOutputFilename* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (self->priv->directory != NULL) {
		_tmp1_ = self->priv->filename != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->format != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		flegita_option_output_filename_set_value (self, _tmp2_ = g_strconcat (self->priv->directory, G_DIR_SEPARATOR_S, self->priv->filename, ".", self->priv->format->suffixes[0], NULL));
		_g_free0 (_tmp2_);
	} else {
		flegita_option_output_filename_set_value (self, NULL);
	}
}


const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_value;
	return result;
}


void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_value = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_value), _tmp0_);
	g_object_notify ((GObject *) self, "value");
}


static void flegita_option_output_filename_class_init (FlegitaOptionOutputFilenameClass * klass) {
	flegita_option_output_filename_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaOptionOutputFilenamePrivate));
	G_OBJECT_CLASS (klass)->get_property = flegita_option_output_filename_get_property;
	G_OBJECT_CLASS (klass)->set_property = flegita_option_output_filename_set_property;
	G_OBJECT_CLASS (klass)->finalize = flegita_option_output_filename_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FLEGITA_OPTION_OUTPUT_FILENAME_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void flegita_option_output_filename_instance_init (FlegitaOptionOutputFilename * self) {
	self->priv = FLEGITA_OPTION_OUTPUT_FILENAME_GET_PRIVATE (self);
	self->priv->format = NULL;
}


static void flegita_option_output_filename_finalize (GObject* obj) {
	FlegitaOptionOutputFilename * self;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (obj);
	_g_free0 (self->priv->_value);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->filename);
	_g_object_unref0 (self->priv->format);
	_g_slist_free0 (self->priv->formats);
	G_OBJECT_CLASS (flegita_option_output_filename_parent_class)->finalize (obj);
}


GType flegita_option_output_filename_get_type (void) {
	static GType flegita_option_output_filename_type_id = 0;
	if (flegita_option_output_filename_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaOptionOutputFilenameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_option_output_filename_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaOptionOutputFilename), 0, (GInstanceInitFunc) flegita_option_output_filename_instance_init, NULL };
		flegita_option_output_filename_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION, "FlegitaOptionOutputFilename", &g_define_type_info, 0);
	}
	return flegita_option_output_filename_type_id;
}


static void flegita_option_output_filename_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FlegitaOptionOutputFilename * self;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (object);
	switch (property_id) {
		case FLEGITA_OPTION_OUTPUT_FILENAME_VALUE:
		g_value_set_string (value, flegita_option_output_filename_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void flegita_option_output_filename_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FlegitaOptionOutputFilename * self;
	self = FLEGITA_OPTION_OUTPUT_FILENAME (object);
	switch (property_id) {
		case FLEGITA_OPTION_OUTPUT_FILENAME_VALUE:
		flegita_option_output_filename_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




